(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     23402,        510]
NotebookOptionsPosition[     22025,        480]
NotebookOutlinePosition[     22394,        496]
CellTagsIndexPosition[     22351,        493]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"REPLICATION", " ", "OF", " ", "FIGURE", " ", "1"}], "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{"ro", ",", "sigma", ",", "eta", ",", "MeanSEforFFH"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Distribution", " ", "of", " ", "lying", " ", "costs"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F", "[", 
     RowBox[{"x_", ",", "sigma_"}], "]"}], ":=", 
    RowBox[{"CDF", "[", 
     RowBox[{
      RowBox[{"TruncatedDistribution", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "Infinity"}], "}"}], ",", 
        RowBox[{"NormalDistribution", "[", 
         RowBox[{"0", ",", "sigma"}], "]"}]}], "]"}], ",", "x"}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Highest", " ", "report"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"K", ":=", "5"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"x_L", " ", "function"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xL", "[", "ro_", "]"}], ":=", 
     RowBox[{"Ceiling", "[", "ro", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Theta", " ", "function"}], ",", " ", 
     RowBox[{"see", " ", "equation", " ", 
      RowBox[{"(", "27", ")"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"theta", "[", 
     RowBox[{"ro_", ",", "eta_", ",", "sigma_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"F", "[", 
        RowBox[{
         RowBox[{"ro", "-", "y"}], ",", "sigma"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "0", ",", 
         RowBox[{
          RowBox[{"xL", "[", "ro", "]"}], "-", "1"}]}], "}"}]}], "]"}], "-", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "ro"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"eta", "-", "x", "+", "ro"}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"xL", "[", "ro", "]"}], ",", "K"}], "}"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "Probability", " ", "of", " ", "observing", " ", "report", " ", "x"}], 
     ",", " ", 
     RowBox[{"see", " ", "Proposition", " ", "2"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ProbRep", "[", 
      RowBox[{"x_", ",", "ro_", ",", "eta_", ",", "sigma_"}], "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"x", "\[GreaterEqual]", 
        RowBox[{"xL", "[", "ro", "]"}]}], ",", 
       RowBox[{"eta", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"K", "+", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"eta", "-", "x", "+", "ro"}], ")"}]}], ")"}]}], ",", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"K", "+", "1"}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"F", "[", 
           RowBox[{
            RowBox[{"ro", "-", "x"}], ",", "sigma"}], "]"}]}], ")"}]}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "Mean", " ", "squared", " ", "error", " ", "with", " ", "respect", " ", 
      "to", " ", "the", " ", "experimental", " ", "data", " ", "in", " ", 
      "Fischbacher", " ", "and", " ", "F\[ODoubleDot]llmi"}], "-", 
     RowBox[{"Heusi", " ", "2013"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MeanSEforFFH", "[", 
      RowBox[{"ro_", ",", "eta_", ",", "sigma_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRep", "[", 
             RowBox[{"0", ",", "ro", ",", "eta", ",", "sigma"}], "]"}], "*", 
            "100"}], "-", "6.43"}], ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRep", "[", 
             RowBox[{"1", ",", "ro", ",", "eta", ",", "sigma"}], "]"}], "*", 
            "100"}], "-", "7.20"}], ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRep", "[", 
             RowBox[{"2", ",", "ro", ",", "eta", ",", "sigma"}], "]"}], "*", 
            "100"}], "-", "11.57"}], ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRep", "[", 
             RowBox[{"3", ",", "ro", ",", "eta", ",", "sigma"}], "]"}], "*", 
            "100"}], "-", "12.60"}], ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRep", "[", 
             RowBox[{"4", ",", "ro", ",", "eta", ",", "sigma"}], "]"}], "*", 
            "100"}], "-", "27.25"}], ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRep", "[", 
             RowBox[{"5", ",", "ro", ",", "eta", ",", "sigma"}], "]"}], "*", 
            "100"}], "-", "34.96"}], ")"}], "^", "2"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"K", "+", "1"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Minimizing", " ", "the", " ", "mean", " ", "squared", " ", "error", " ", 
     "with", " ", "respect", " ", "to", " ", "eta", " ", "and", " ", "sigma", 
     " ", "subject", " ", "to", " ", "equilibrium", " ", "conditions"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"NMinimize", "[", 
    RowBox[{
     RowBox[{"{", " ", 
      RowBox[{
       RowBox[{"MeanSEforFFH", "[", 
        RowBox[{"ro", ",", "eta", ",", "sigma"}], "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"theta", "[", 
          RowBox[{"ro", ",", "eta", ",", "sigma"}], "]"}], "\[Equal]", "0"}], 
        "  ", "&&", " ", 
        RowBox[{
         RowBox[{"Max", "[", 
          RowBox[{"0", ",", 
           RowBox[{"K", "-", "eta"}]}], "]"}], "<", "ro", "<", "K"}], "   ", "&&",
         " ", 
        RowBox[{"sigma", ">", "0"}], "  ", "&&", " ", 
        RowBox[{"eta", ">", "0"}]}]}], " ", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"eta", ",", "sigma", ",", "ro"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6653218905473633`*^9, 3.665322139759886*^9}, {
   3.6653221923859386`*^9, 3.6653223420429335`*^9}, {3.6653224318717318`*^9, 
   3.665322439081876*^9}, {3.6653225492410793`*^9, 3.665322566823431*^9}, {
   3.6653228446309905`*^9, 3.665322856452227*^9}, {3.6653229045491896`*^9, 
   3.665322911129321*^9}, {3.665322972730554*^9, 3.665323003834178*^9}, 
   3.6653230545081916`*^9, {3.6653233051012077`*^9, 3.6653233171284504`*^9}, {
   3.6653233587722836`*^9, 3.665323471444538*^9}, {3.665323555598222*^9, 
   3.665323673180974*^9}, {3.6653237116957445`*^9, 3.665323711755746*^9}, {
   3.665323753108573*^9, 3.665323759058692*^9}, {3.665377462360238*^9, 
   3.6653774794465294`*^9}, {3.6653776312023864`*^9, 
   3.6653776397899446`*^9}, {3.6653776759243307`*^9, 
   3.6653777443114915`*^9}, {3.665378141798388*^9, 3.665378222400388*^9}, {
   3.6653783273953876`*^9, 3.665378354386388*^9}, {3.6653783933073883`*^9, 
   3.665378448451388*^9}, {3.665378480010388*^9, 3.665378484632388*^9}, {
   3.665380030084114*^9, 3.665380082731315*^9}, {3.6653801250756083`*^9, 
   3.6653801405319695`*^9}, {3.6653801810509644`*^9, 
   3.6653801835837107`*^9}, {3.665381106544634*^9, 3.6653811099599752`*^9}, {
   3.665381864911468*^9, 3.6653818815171285`*^9}, {3.6653831080268097`*^9, 
   3.66538315496481*^9}, {3.66538319977281*^9, 3.66538319995581*^9}, {
   3.6653834216101365`*^9, 3.6653834485828333`*^9}, {3.665383487388714*^9, 
   3.6653834879157662`*^9}, {3.7269152108855906`*^9, 3.7269152734052167`*^9}, 
   3.7269154338478255`*^9, {3.726915495230441*^9, 3.72691554193091*^9}, {
   3.7571418437996626`*^9, 3.7571418453930397`*^9}, {3.757143098524267*^9, 
   3.757143102400547*^9}, {3.757143143075894*^9, 3.7571431722505655`*^9}, {
   3.757162414169341*^9, 3.757162636298018*^9}, {3.7571627657332444`*^9, 
   3.757162801683863*^9}, {3.757162859924965*^9, 3.7571628751046324`*^9}, {
   3.7571629091905046`*^9, 3.7571630511895733`*^9}, {3.7571630894856987`*^9, 
   3.757163128092335*^9}, {3.7571729628756495`*^9, 3.757172975582226*^9}, {
   3.757173125741542*^9, 3.7571731890252004`*^9}, {3.7571732330956135`*^9, 
   3.7571732845597677`*^9}, {3.757173315518761*^9, 3.7571733414899263`*^9}, {
   3.7571733916560197`*^9, 3.7571734382667556`*^9}, {3.757173473505392*^9, 
   3.7571734736617594`*^9}, {3.757176257456459*^9, 3.7571763519806366`*^9}, {
   3.757176469796834*^9, 3.7571767286633067`*^9}, {3.7571767843903694`*^9, 
   3.757176792609517*^9}, {3.75717689194084*^9, 3.757176966243521*^9}, {
   3.7571772873305397`*^9, 3.7571773276123066`*^9}, {3.75717737211786*^9, 
   3.7571774126881323`*^9}, 3.757177450617428*^9, {3.757177495179057*^9, 
   3.7571775654239745`*^9}, {3.7571778004932604`*^9, 
   3.7571778112767396`*^9}, {3.7571778608146286`*^9, 3.7571779479774895`*^9}, 
   3.7571779826864576`*^9, {3.757180185774725*^9, 3.757180225464513*^9}, {
   3.7571802730797462`*^9, 3.7571803420585346`*^9}, {3.757228838463196*^9, 
   3.757228950840367*^9}, {3.7572290062128677`*^9, 3.7572291664013815`*^9}, 
   3.7572336136245327`*^9, {3.757235610936805*^9, 3.757235610983451*^9}, {
   3.757235880931776*^9, 3.757235886814126*^9}, {3.7572406933218036`*^9, 
   3.7572406959461937`*^9}, 3.757242812516966*^9, {3.7572429714209166`*^9, 
   3.7572429769849772`*^9}, {3.757243071527697*^9, 3.757243078808973*^9}, {
   3.7572432198232126`*^9, 3.7572432399330654`*^9}, {3.757425781494478*^9, 
   3.75742582598638*^9}, {3.7574262520728416`*^9, 3.757426283202374*^9}, {
   3.7574263137353363`*^9, 3.7574263937137012`*^9}, {3.7574264349231057`*^9, 
   3.757426437360051*^9}, 3.7574265154845276`*^9, {3.7574272267659135`*^9, 
   3.7574272406269093`*^9}, {3.757427328437193*^9, 3.757427329374473*^9}, {
   3.7574282482267866`*^9, 3.7574282717596183`*^9}, {3.7574289395599856`*^9, 
   3.757428940062538*^9}, {3.7577013696455193`*^9, 3.7577014245222635`*^9}, {
   3.7577023825509567`*^9, 3.7577023969502816`*^9}, {3.7577026959570093`*^9, 
   3.7577027009233713`*^9}, {3.7577031817323313`*^9, 3.757703220463866*^9}, {
   3.757703256452093*^9, 3.7577032947780724`*^9}, {3.7577386188486176`*^9, 
   3.7577387207299747`*^9}, {3.7577392275644436`*^9, 
   3.7577392942383723`*^9}, {3.757739339939869*^9, 3.7577394691650767`*^9}, {
   3.757739510433728*^9, 3.757739526713958*^9}, {3.757739685895583*^9, 
   3.757739906893816*^9}, {3.757739941869347*^9, 3.757739964928715*^9}, {
   3.7577401831982527`*^9, 3.7577401904100027`*^9}, 3.757740230862501*^9, {
   3.7577595925950146`*^9, 3.757759607248576*^9}, {3.757760536774869*^9, 
   3.757760543651063*^9}, {3.7578348411393237`*^9, 3.7578348447790923`*^9}, {
   3.7579128098496685`*^9, 3.757912810474723*^9}, 
   3.757913246317918*^9},ExpressionUUID->"28347174-7e21-416a-a5c0-\
c724345c8955"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6.789872246973035`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"eta", "\[Rule]", "3.6485956627745706`"}], ",", 
     RowBox[{"sigma", "\[Rule]", "2.960732676827353`"}], ",", 
     RowBox[{"ro", "\[Rule]", "3.0503965436772322`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.757738704219612*^9, 3.757738721889777*^9}, 
   3.7577393060254326`*^9, 3.7577393483193016`*^9, {3.7577393885829964`*^9, 
   3.75773940896702*^9}, {3.7577394530442367`*^9, 3.7577395327461777`*^9}, {
   3.7577399379324512`*^9, 3.757739958263641*^9}, 3.757740236973212*^9, 
   3.7577467269554663`*^9, 3.757760550017502*^9, 3.7578327069510813`*^9, 
   3.757912752130722*^9, 
   3.7579132525241747`*^9},ExpressionUUID->"28af4d7c-44bc-40b3-a3be-\
2baafcb157f3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Substituting", " ", "the", " ", "obtained", " ", "parameter", " ", 
    "values"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"K", "=", "5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eta", "=", "3.6486"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sigma", "=", "2.96073"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ro", "=", "3.0504"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Predicted", " ", "value", " ", "of", " ", "xL"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Predicted value of xL is \>\"", ",", 
     RowBox[{"xL", "[", "ro", "]"}], ",", "\"\<.\>\""}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Calculating", " ", "the", " ", "resulting", " ", "theoretical", " ", 
     "reporting", " ", "frequencies"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\<Predicted reporting frequencies:\>\"", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"x", "=", "0"}], ",", 
     RowBox[{"x", "\[LessEqual]", "K"}], ",", 
     RowBox[{"x", "++"}], ",", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<x=\>\"", ",", "x", ",", "\"\<: \>\"", ",", 
       RowBox[{"ProbRep", "[", 
        RowBox[{"x", ",", "ro", ",", "eta", ",", "sigma"}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.757175960644486*^9, 3.757175969861082*^9}, {
   3.7571760047831745`*^9, 3.757176067687707*^9}, {3.7571761255251875`*^9, 
   3.7571761325435543`*^9}, {3.757177999174612*^9, 3.7571780556748457`*^9}, {
   3.757229243437893*^9, 3.757229269292219*^9}, {3.7572294420877876`*^9, 
   3.7572294502496743`*^9}, {3.757233587547154*^9, 3.757233591563642*^9}, {
   3.757233636453559*^9, 3.757233636671023*^9}, {3.757235634624962*^9, 
   3.7572356490465264`*^9}, {3.75742583759653*^9, 3.757425859593972*^9}, {
   3.7574265512798758`*^9, 3.7574265573894033`*^9}, {3.7574265887991085`*^9, 
   3.757426616484433*^9}, {3.7574269166646905`*^9, 3.757426921437611*^9}, {
   3.757427354267539*^9, 3.757427355173608*^9}, {3.757427403597926*^9, 
   3.7574274061619635`*^9}, 3.757703301624444*^9, {3.7577400070709*^9, 
   3.757740047802717*^9}, {3.7577468256873093`*^9, 3.7577469669197893`*^9}, {
   3.7577607732022734`*^9, 3.757760779485186*^9}, {3.757835059024583*^9, 
   3.7578350640098195`*^9}, {3.7579127413649*^9, 
   3.757912744256392*^9}},ExpressionUUID->"419f1477-f039-4a21-a944-\
46119bf88240"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Predicted value of xL is \"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["Predicted value of xL is ", 4, "."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7571759581736193`*^9, 3.7571759883579235`*^9}, 
   3.757176103349305*^9, 3.7571761333869705`*^9, 3.7571780609821873`*^9, 
   3.7572292721506968`*^9, 3.7572335923552895`*^9, 3.7572336254505234`*^9, 
   3.7572337816905365`*^9, 3.7572356503741217`*^9, 3.757426617608968*^9, 
   3.7577033545541615`*^9, {3.7577400185265737`*^9, 3.757740023726155*^9}, 
   3.757740054621729*^9, 3.757746821641573*^9, {3.7577469273176184`*^9, 
   3.757746968842802*^9}, 3.7577605740525837`*^9, 3.7578327129203405`*^9, 
   3.7579127552411613`*^9},ExpressionUUID->"59860c83-84f5-4efe-bcab-\
4738014f999e"],

Cell[BoxData["\<\"Predicted reporting frequencies:\"\>"], "Print",
 CellChangeTimes->{{3.7571759581736193`*^9, 3.7571759883579235`*^9}, 
   3.757176103349305*^9, 3.7571761333869705`*^9, 3.7571780609821873`*^9, 
   3.7572292721506968`*^9, 3.7572335923552895`*^9, 3.7572336254505234`*^9, 
   3.7572337816905365`*^9, 3.7572356503741217`*^9, 3.757426617608968*^9, 
   3.7577033545541615`*^9, {3.7577400185265737`*^9, 3.757740023726155*^9}, 
   3.757740054621729*^9, 3.757746821641573*^9, {3.7577469273176184`*^9, 
   3.757746968842802*^9}, 3.7577605740525837`*^9, 3.7578327129203405`*^9, 
   3.7579127552411613`*^9},ExpressionUUID->"4e8e6e80-1928-4a2c-9fb9-\
6bd1a48e74bf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.05047925967897067`"}],
  SequenceForm["x=", 0, ": ", 0.05047925967897067],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7571759581736193`*^9, 3.7571759883579235`*^9}, 
   3.757176103349305*^9, 3.7571761333869705`*^9, 3.7571780609821873`*^9, 
   3.7572292721506968`*^9, 3.7572335923552895`*^9, 3.7572336254505234`*^9, 
   3.7572337816905365`*^9, 3.7572356503741217`*^9, 3.757426617608968*^9, 
   3.7577033545541615`*^9, {3.7577400185265737`*^9, 3.757740023726155*^9}, 
   3.757740054621729*^9, 3.757746821641573*^9, {3.7577469273176184`*^9, 
   3.757746968842802*^9}, 3.7577605740525837`*^9, 3.7578327129203405`*^9, 
   3.7579127552567854`*^9},ExpressionUUID->"726920fd-b837-49e6-a768-\
9c6bcd31d34d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.08143389235820189`"}],
  SequenceForm["x=", 1, ": ", 0.08143389235820189],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7571759581736193`*^9, 3.7571759883579235`*^9}, 
   3.757176103349305*^9, 3.7571761333869705`*^9, 3.7571780609821873`*^9, 
   3.7572292721506968`*^9, 3.7572335923552895`*^9, 3.7572336254505234`*^9, 
   3.7572337816905365`*^9, 3.7572356503741217`*^9, 3.757426617608968*^9, 
   3.7577033545541615`*^9, {3.7577400185265737`*^9, 3.757740023726155*^9}, 
   3.757740054621729*^9, 3.757746821641573*^9, {3.7577469273176184`*^9, 
   3.757746968842802*^9}, 3.7577605740525837`*^9, 3.7578327129203405`*^9, 
   3.7579127552567854`*^9},ExpressionUUID->"59468fa4-6bfd-49bc-a75f-\
8f02fc80d871"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.12045939729983786`"}],
  SequenceForm["x=", 2, ": ", 0.12045939729983786`],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7571759581736193`*^9, 3.7571759883579235`*^9}, 
   3.757176103349305*^9, 3.7571761333869705`*^9, 3.7571780609821873`*^9, 
   3.7572292721506968`*^9, 3.7572335923552895`*^9, 3.7572336254505234`*^9, 
   3.7572337816905365`*^9, 3.7572356503741217`*^9, 3.757426617608968*^9, 
   3.7577033545541615`*^9, {3.7577400185265737`*^9, 3.757740023726155*^9}, 
   3.757740054621729*^9, 3.757746821641573*^9, {3.7577469273176184`*^9, 
   3.757746968842802*^9}, 3.7577605740525837`*^9, 3.7578327129203405`*^9, 
   3.7579127552567854`*^9},ExpressionUUID->"762c3f42-51ea-43f9-bb56-\
a1c80c5ce216"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.16440306727289727`"}],
  SequenceForm["x=", 3, ": ", 0.16440306727289727`],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7571759581736193`*^9, 3.7571759883579235`*^9}, 
   3.757176103349305*^9, 3.7571761333869705`*^9, 3.7571780609821873`*^9, 
   3.7572292721506968`*^9, 3.7572335923552895`*^9, 3.7572336254505234`*^9, 
   3.7572337816905365`*^9, 3.7572356503741217`*^9, 3.757426617608968*^9, 
   3.7577033545541615`*^9, {3.7577400185265737`*^9, 3.757740023726155*^9}, 
   3.757740054621729*^9, 3.757746821641573*^9, {3.7577469273176184`*^9, 
   3.757746968842802*^9}, 3.7577605740525837`*^9, 3.7578327129203405`*^9, 
   3.7579127552567854`*^9},ExpressionUUID->"0f7ca69d-30de-4045-87ec-\
98d34ff51064"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.22530566876620972`"}],
  SequenceForm["x=", 4, ": ", 0.22530566876620972`],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7571759581736193`*^9, 3.7571759883579235`*^9}, 
   3.757176103349305*^9, 3.7571761333869705`*^9, 3.7571780609821873`*^9, 
   3.7572292721506968`*^9, 3.7572335923552895`*^9, 3.7572336254505234`*^9, 
   3.7572337816905365`*^9, 3.7572356503741217`*^9, 3.757426617608968*^9, 
   3.7577033545541615`*^9, {3.7577400185265737`*^9, 3.757740023726155*^9}, 
   3.757740054621729*^9, 3.757746821641573*^9, {3.7577469273176184`*^9, 
   3.757746968842802*^9}, 3.7577605740525837`*^9, 3.7578327129203405`*^9, 
   3.7579127552567854`*^9},ExpressionUUID->"3a8babec-dbac-446c-90aa-\
5e82e769e2cd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.3579164214243673`"}],
  SequenceForm["x=", 5, ": ", 0.3579164214243673],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7571759581736193`*^9, 3.7571759883579235`*^9}, 
   3.757176103349305*^9, 3.7571761333869705`*^9, 3.7571780609821873`*^9, 
   3.7572292721506968`*^9, 3.7572335923552895`*^9, 3.7572336254505234`*^9, 
   3.7572337816905365`*^9, 3.7572356503741217`*^9, 3.757426617608968*^9, 
   3.7577033545541615`*^9, {3.7577400185265737`*^9, 3.757740023726155*^9}, 
   3.757740054621729*^9, 3.757746821641573*^9, {3.7577469273176184`*^9, 
   3.757746968842802*^9}, 3.7577605740525837`*^9, 3.7578327129203405`*^9, 
   3.7579127552567854`*^9},ExpressionUUID->"49a50447-d5ca-44d4-8c0d-\
cc147148a1aa"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1908, 944},
WindowMargins->{{199, Automatic}, {521, Automatic}},
Magnification->2.,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 11321, 246, 1295, "Input",ExpressionUUID->"28347174-7e21-416a-a5c0-c724345c8955"],
Cell[11904, 270, 786, 16, 128, "Output",ExpressionUUID->"28af4d7c-44bc-40b3-a3be-2baafcb157f3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12727, 291, 2574, 54, 543, "Input",ExpressionUUID->"419f1477-f039-4a21-a944-46119bf88240"],
Cell[CellGroupData[{
Cell[15326, 349, 832, 14, 44, "Print",ExpressionUUID->"59860c83-84f5-4efe-bcab-4738014f999e"],
Cell[16161, 365, 669, 9, 44, "Print",ExpressionUUID->"4e8e6e80-1928-4a2c-9fb9-6bd1a48e74bf"],
Cell[16833, 376, 858, 15, 44, "Print",ExpressionUUID->"726920fd-b837-49e6-a768-9c6bcd31d34d"],
Cell[17694, 393, 858, 15, 44, "Print",ExpressionUUID->"59468fa4-6bfd-49bc-a75f-8f02fc80d871"],
Cell[18555, 410, 859, 15, 44, "Print",ExpressionUUID->"762c3f42-51ea-43f9-bb56-a1c80c5ce216"],
Cell[19417, 427, 859, 15, 44, "Print",ExpressionUUID->"0f7ca69d-30de-4045-87ec-98d34ff51064"],
Cell[20279, 444, 859, 15, 44, "Print",ExpressionUUID->"3a8babec-dbac-446c-90aa-5e82e769e2cd"],
Cell[21141, 461, 856, 15, 44, "Print",ExpressionUUID->"49a50447-d5ca-44d4-8c0d-cc147148a1aa"]
}, Open  ]]
}, Open  ]]
}
]
*)

