(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     26244,        598]
NotebookOptionsPosition[     24488,        564]
NotebookOutlinePosition[     24857,        580]
CellTagsIndexPosition[     24814,        577]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"REPLICATION", " ", "OF", " ", "FIGURE", " ", "3", "b"}], "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{"ro", ",", "sigma", ",", "eta"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Distribution", " ", "of", " ", "lying", " ", "costs"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F", "[", 
     RowBox[{"x_", ",", "sigma_"}], "]"}], ":=", 
    RowBox[{"CDF", "[", 
     RowBox[{
      RowBox[{"TruncatedDistribution", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "Infinity"}], "}"}], ",", 
        RowBox[{"NormalDistribution", "[", 
         RowBox[{"0", ",", "sigma"}], "]"}]}], "]"}], ",", "x"}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Highest", " ", "report", " ", 
     RowBox[{"(", 
      RowBox[{"see", " ", 
       RowBox[{"ReadMe", ".", "pdf"}]}], ")"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"K", ":=", "9"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"x_L", " ", "function"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xL", "[", "ro_", "]"}], ":=", 
     RowBox[{"Ceiling", "[", "ro", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Theta", " ", "function"}], ",", " ", 
     RowBox[{"see", " ", "equation", " ", 
      RowBox[{"(", "27", ")"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"theta", "[", 
     RowBox[{"ro_", ",", "eta_", ",", "sigma_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"F", "[", 
        RowBox[{
         RowBox[{"ro", "-", "y"}], ",", "sigma"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "0", ",", 
         RowBox[{
          RowBox[{"xL", "[", "ro", "]"}], "-", "1"}]}], "}"}]}], "]"}], "-", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "ro"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"eta", "-", "x", "+", "ro"}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"xL", "[", "ro", "]"}], ",", "K"}], "}"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "Probability", " ", "of", " ", "observing", " ", "report", " ", "x"}], 
     ",", " ", 
     RowBox[{"see", " ", "Proposition", " ", "2"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ProbRep", "[", 
      RowBox[{"x_", ",", "ro_", ",", "eta_", ",", "sigma_"}], "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"x", "\[GreaterEqual]", 
        RowBox[{"xL", "[", "ro", "]"}]}], ",", 
       RowBox[{"eta", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"K", "+", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"eta", "-", "x", "+", "ro"}], ")"}]}], ")"}]}], ",", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"K", "+", "1"}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"F", "[", 
           RowBox[{
            RowBox[{"ro", "-", "x"}], ",", "sigma"}], "]"}]}], ")"}]}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "Mean", " ", "squared", " ", "error", " ", "with", " ", "respect", " ", 
      "to", " ", "the", " ", "experimental", " ", "data", " ", "in", " ", 
      "Gneezy"}], ",", " ", 
     RowBox[{"Kajackaite", " ", "and", " ", "Sobel", " ", "2018"}], ",", " ", 
     RowBox[{"observed", " ", "treatment"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MeanSEforGKSb", "[", 
      RowBox[{"ro_", ",", "eta_", ",", "sigma_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRep", "[", 
             RowBox[{"0", ",", "ro", ",", "eta", ",", "sigma"}], "]"}], "*", 
            "100"}], "-", "5.13"}], ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRep", "[", 
             RowBox[{"1", ",", "ro", ",", "eta", ",", "sigma"}], "]"}], "*", 
            "100"}], "-", "6.15"}], ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRep", "[", 
             RowBox[{"2", ",", "ro", ",", "eta", ",", "sigma"}], "]"}], "*", 
            "100"}], "-", "5.90"}], ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRep", "[", 
             RowBox[{"3", ",", "ro", ",", "eta", ",", "sigma"}], "]"}], "*", 
            "100"}], "-", "4.36"}], ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRep", "[", 
             RowBox[{"4", ",", "ro", ",", "eta", ",", "sigma"}], "]"}], "*", 
            "100"}], "-", "8.97"}], ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRep", "[", 
             RowBox[{"5", ",", "ro", ",", "eta", ",", "sigma"}], "]"}], "*", 
            "100"}], "-", "7.18"}], ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRep", "[", 
             RowBox[{"6", ",", "ro", ",", "eta", ",", "sigma"}], "]"}], "*", 
            "100"}], "-", "10.00"}], ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRep", "[", 
             RowBox[{"7", ",", "ro", ",", "eta", ",", "sigma"}], "]"}], "*", 
            "100"}], "-", "8.97"}], ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRep", "[", 
             RowBox[{"8", ",", "ro", ",", "eta", ",", "sigma"}], "]"}], "*", 
            "100"}], "-", "13.59"}], ")"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"ProbRep", "[", 
             RowBox[{"9", ",", "ro", ",", "eta", ",", "sigma"}], "]"}], "*", 
            "100"}], "-", "29.74"}], ")"}], "^", "2"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"K", "+", "1"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Minimizing", " ", "the", " ", "mean", " ", "squared", " ", "error", " ", 
     "with", " ", "respect", " ", "to", " ", "eta", " ", "and", " ", "sigma", 
     " ", "subject", " ", "to", " ", "equilibrium", " ", "conditions"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"NMinimize", "[", 
    RowBox[{
     RowBox[{"{", " ", 
      RowBox[{
       RowBox[{"MeanSEforGKSb", "[", 
        RowBox[{"ro", ",", "eta", ",", "sigma"}], "]"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"theta", "[", 
          RowBox[{"ro", ",", "eta", ",", "sigma"}], "]"}], "\[Equal]", "0"}], 
        "  ", "&&", " ", 
        RowBox[{
         RowBox[{"Max", "[", 
          RowBox[{"0", ",", 
           RowBox[{"K", "-", "eta"}]}], "]"}], "<", "ro", "<", "K"}], "   ", "&&",
         " ", 
        RowBox[{"sigma", ">", "0"}], "  ", "&&", " ", 
        RowBox[{"eta", ">", "0"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"eta", ",", "sigma", ",", "ro"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6653218905473633`*^9, 3.665322139759886*^9}, {
   3.6653221923859386`*^9, 3.6653223420429335`*^9}, {3.6653224318717318`*^9, 
   3.665322439081876*^9}, {3.6653225492410793`*^9, 3.665322566823431*^9}, {
   3.6653228446309905`*^9, 3.665322856452227*^9}, {3.6653229045491896`*^9, 
   3.665322911129321*^9}, {3.665322972730554*^9, 3.665323003834178*^9}, 
   3.6653230545081916`*^9, {3.6653233051012077`*^9, 3.6653233171284504`*^9}, {
   3.6653233587722836`*^9, 3.665323471444538*^9}, {3.665323555598222*^9, 
   3.665323673180974*^9}, {3.6653237116957445`*^9, 3.665323711755746*^9}, {
   3.665323753108573*^9, 3.665323759058692*^9}, {3.665377462360238*^9, 
   3.6653774794465294`*^9}, {3.6653776312023864`*^9, 
   3.6653776397899446`*^9}, {3.6653776759243307`*^9, 
   3.6653777443114915`*^9}, {3.665378141798388*^9, 3.665378222400388*^9}, {
   3.6653783273953876`*^9, 3.665378354386388*^9}, {3.6653783933073883`*^9, 
   3.665378448451388*^9}, {3.665378480010388*^9, 3.665378484632388*^9}, {
   3.665380030084114*^9, 3.665380082731315*^9}, {3.6653801250756083`*^9, 
   3.6653801405319695`*^9}, {3.6653801810509644`*^9, 
   3.6653801835837107`*^9}, {3.665381106544634*^9, 3.6653811099599752`*^9}, {
   3.665381864911468*^9, 3.6653818815171285`*^9}, {3.6653831080268097`*^9, 
   3.66538315496481*^9}, {3.66538319977281*^9, 3.66538319995581*^9}, {
   3.6653834216101365`*^9, 3.6653834485828333`*^9}, {3.665383487388714*^9, 
   3.6653834879157662`*^9}, {3.7269152108855906`*^9, 3.7269152734052167`*^9}, 
   3.7269154338478255`*^9, {3.726915495230441*^9, 3.72691554193091*^9}, {
   3.7571418437996626`*^9, 3.7571418453930397`*^9}, {3.757143098524267*^9, 
   3.757143102400547*^9}, {3.757143143075894*^9, 3.7571431722505655`*^9}, {
   3.757162414169341*^9, 3.757162636298018*^9}, {3.7571627657332444`*^9, 
   3.757162801683863*^9}, {3.757162859924965*^9, 3.7571628751046324`*^9}, {
   3.7571629091905046`*^9, 3.7571630511895733`*^9}, {3.7571630894856987`*^9, 
   3.757163128092335*^9}, {3.7571729628756495`*^9, 3.757172975582226*^9}, {
   3.757173125741542*^9, 3.7571731890252004`*^9}, {3.7571732330956135`*^9, 
   3.7571732845597677`*^9}, {3.757173315518761*^9, 3.7571733414899263`*^9}, {
   3.7571733916560197`*^9, 3.7571734382667556`*^9}, {3.757173473505392*^9, 
   3.7571734736617594`*^9}, {3.757176257456459*^9, 3.7571763519806366`*^9}, {
   3.757176469796834*^9, 3.7571767286633067`*^9}, {3.7571767843903694`*^9, 
   3.757176792609517*^9}, {3.75717689194084*^9, 3.757176966243521*^9}, {
   3.7571772873305397`*^9, 3.7571773276123066`*^9}, {3.75717737211786*^9, 
   3.7571774126881323`*^9}, 3.757177450617428*^9, {3.757177495179057*^9, 
   3.7571775654239745`*^9}, {3.7571778004932604`*^9, 
   3.7571778112767396`*^9}, {3.7571778608146286`*^9, 3.7571779479774895`*^9}, 
   3.7571779826864576`*^9, {3.757180185774725*^9, 3.757180225464513*^9}, {
   3.7571802730797462`*^9, 3.7571803420585346`*^9}, {3.757180589550248*^9, 
   3.757180625012718*^9}, 3.7571807723890305`*^9, {3.7571808655769444`*^9, 
   3.757180918225562*^9}, {3.7571809508652897`*^9, 3.757180978577965*^9}, {
   3.757228295186898*^9, 3.757228295288265*^9}, {3.757229519868849*^9, 
   3.757229549967732*^9}, {3.7572296374036164`*^9, 3.7572296402026987`*^9}, {
   3.757229683896452*^9, 3.7572297498898673`*^9}, 3.757229799203117*^9, {
   3.75723006807353*^9, 3.757230094787221*^9}, {3.757233286292882*^9, 
   3.757233302765727*^9}, {3.757233416124798*^9, 3.757233473579174*^9}, {
   3.7572340390290174`*^9, 3.757234088778042*^9}, {3.757234285639983*^9, 
   3.7572343036066685`*^9}, 3.757234412640359*^9, {3.7572344442575507`*^9, 
   3.757234453754656*^9}, {3.757234820352021*^9, 3.75723501060151*^9}, 
   3.7572350732985363`*^9, {3.7572352060461617`*^9, 3.7572352936930313`*^9}, {
   3.757235375310073*^9, 3.7572354879859223`*^9}, {3.7572359505881014`*^9, 
   3.7572359716373005`*^9}, {3.75724326298242*^9, 3.757243292874465*^9}, {
   3.7574271136210885`*^9, 3.7574271509211707`*^9}, {3.757427216686474*^9, 
   3.7574272829991426`*^9}, {3.7574273195314045`*^9, 
   3.7574273231401615`*^9}, {3.7574274786158543`*^9, 
   3.7574274807803307`*^9}, {3.7574279934433765`*^9, 
   3.7574280482010336`*^9}, {3.757428112683385*^9, 3.757428158565394*^9}, {
   3.757523942886593*^9, 3.7575239439799023`*^9}, {3.757681384846794*^9, 
   3.7576814617756815`*^9}, 3.7577014486419597`*^9, {3.7577025275032725`*^9, 
   3.7577025375203004`*^9}, {3.757702614509473*^9, 3.757702621667048*^9}, {
   3.757703371070364*^9, 3.7577034355085073`*^9}, {3.7577401731093893`*^9, 
   3.7577401738570595`*^9}, {3.757740255483855*^9, 3.7577403992169113`*^9}, {
   3.757740601875983*^9, 3.757740653584732*^9}, {3.757760677827434*^9, 
   3.75776068063914*^9}, {3.7578327435633173`*^9, 3.7578327436416245`*^9}, {
   3.757834910264389*^9, 3.757834931795049*^9}, {3.75785522018878*^9, 
   3.757855221091961*^9}, 3.757913284224535*^9, {3.7579133583594723`*^9, 
   3.7579133590024395`*^9}},ExpressionUUID->"c25ecb60-4974-4ee8-94f2-\
5d543a640601"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.1387109122215993`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"eta", "\[Rule]", "2.4537395994348232`"}], ",", 
     RowBox[{"sigma", "\[Rule]", "10.182735956613604`"}], ",", 
     RowBox[{"ro", "\[Rule]", "7.372320988245079`"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.7577404444556108`*^9, 3.757740720645957*^9, 
  3.7577606948137465`*^9, 3.7578329731042457`*^9, 3.757912851192976*^9, 
  3.75791329212895*^9, 
  3.7579134349887104`*^9},ExpressionUUID->"7e80d533-cecd-45d8-b40d-\
7602057710ee"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Substituting", " ", "the", " ", "obtained", " ", "parameter", " ", 
    "values"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"K", "=", "9"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eta", "=", "2.45374"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sigma", "=", "10.1827"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ro", "=", "7.37232"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Predicted", " ", "value", " ", "of", " ", "xL", " ", "in", " ", "terms", 
     " ", "of", " ", "experimental", " ", "reports"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Predicted value of xL (in terms of experimental reports) is \>\"", 
     ",", 
     RowBox[{
      RowBox[{"xL", "[", "ro", "]"}], "+", "1"}], ",", "\"\<.\>\""}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Calculating", " ", "the", " ", "resulting", " ", "theoretical", " ", 
     "reporting", " ", "frequencies"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\<Predicted reporting frequencies:\>\"", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"x", "=", "0"}], ",", 
     RowBox[{"x", "\[LessEqual]", "K"}], ",", 
     RowBox[{"x", "++"}], ",", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<x=\>\"", ",", 
       RowBox[{"x", "+", "1"}], ",", "\"\<: \>\"", ",", 
       RowBox[{"ProbRep", "[", 
        RowBox[{"x", ",", "ro", ",", "eta", ",", "sigma"}], "]"}]}], "]"}]}], 
    "]"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.757175960644486*^9, 3.757175969861082*^9}, {
   3.7571760047831745`*^9, 3.757176067687707*^9}, {3.7571761255251875`*^9, 
   3.7571761325435543`*^9}, {3.757177999174612*^9, 3.7571780556748457`*^9}, 
   3.7571811199408092`*^9, {3.7572335425948915`*^9, 3.7572335765610037`*^9}, {
   3.7572336507671895`*^9, 3.757233650923356*^9}, {3.7572337236561813`*^9, 
   3.7572337472649426`*^9}, {3.75723382238162*^9, 3.7572338340098124`*^9}, {
   3.7572344728477864`*^9, 3.7572345101247945`*^9}, {3.7572355271712418`*^9, 
   3.757235542829871*^9}, {3.757427369376009*^9, 3.7574274374622283`*^9}, {
   3.7576815650668306`*^9, 3.757681574027092*^9}, 3.757701732741351*^9, 
   3.7577034426065817`*^9, {3.757740471004182*^9, 3.757740502246937*^9}, {
   3.7577406818803205`*^9, 3.7577406889820986`*^9}, {3.7577407282653008`*^9, 
   3.757740741799796*^9}, {3.757747006423748*^9, 3.757747046582534*^9}, {
   3.75776070564298*^9, 3.7577607244148207`*^9}, 3.7578350865757637`*^9, 
   3.7579128361937833`*^9},ExpressionUUID->"164cf34e-a77e-47e4-80ed-\
776d98f575d7"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Predicted value of xL (in terms of experimental reports) is \"\
\>", "\[InvisibleSpace]", "9", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Predicted value of xL (in terms of experimental reports) is ", 9, "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7572338348219686`*^9, 3.757234512407129*^9, 3.7572355438450055`*^9, 
   3.7574274382901864`*^9, 3.7577405030560627`*^9, {3.757740738021264*^9, 
   3.7577407423832784`*^9}, {3.757747034876829*^9, 3.757747048315919*^9}, 
   3.7578329928944893`*^9, {3.7579128407087727`*^9, 3.757912855254845*^9}, 
   3.7579134381910963`*^9},ExpressionUUID->"46ea0ed1-b582-4ab4-b1c8-\
a59ac658b255"],

Cell[BoxData["\<\"Predicted reporting frequencies:\"\>"], "Print",
 CellChangeTimes->{
  3.7572338348219686`*^9, 3.757234512407129*^9, 3.7572355438450055`*^9, 
   3.7574274382901864`*^9, 3.7577405030560627`*^9, {3.757740738021264*^9, 
   3.7577407423832784`*^9}, {3.757747034876829*^9, 3.757747048315919*^9}, 
   3.7578329928944893`*^9, {3.7579128407087727`*^9, 3.757912855254845*^9}, 
   3.757913438206731*^9},ExpressionUUID->"2625c596-7815-424f-824f-\
4bb8486f575e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.04690630099157492`"}],
  SequenceForm["x=", 1, ": ", 0.04690630099157492],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7572338348219686`*^9, 3.757234512407129*^9, 3.7572355438450055`*^9, 
   3.7574274382901864`*^9, 3.7577405030560627`*^9, {3.757740738021264*^9, 
   3.7577407423832784`*^9}, {3.757747034876829*^9, 3.757747048315919*^9}, 
   3.7578329928944893`*^9, {3.7579128407087727`*^9, 3.757912855254845*^9}, 
   3.757913438206731*^9},ExpressionUUID->"ed7bc0a7-6f33-4a14-a1d2-\
aa26ef6587bf"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.05314470118561368`"}],
  SequenceForm["x=", 2, ": ", 0.05314470118561368],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7572338348219686`*^9, 3.757234512407129*^9, 3.7572355438450055`*^9, 
   3.7574274382901864`*^9, 3.7577405030560627`*^9, {3.757740738021264*^9, 
   3.7577407423832784`*^9}, {3.757747034876829*^9, 3.757747048315919*^9}, 
   3.7578329928944893`*^9, {3.7579128407087727`*^9, 3.757912855254845*^9}, 
   3.757913438206731*^9},ExpressionUUID->"5ff0947b-751d-4c37-9740-\
71bf8af7c1f7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.05977819371433146`"}],
  SequenceForm["x=", 3, ": ", 0.05977819371433146],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7572338348219686`*^9, 3.757234512407129*^9, 3.7572355438450055`*^9, 
   3.7574274382901864`*^9, 3.7577405030560627`*^9, {3.757740738021264*^9, 
   3.7577407423832784`*^9}, {3.757747034876829*^9, 3.757747048315919*^9}, 
   3.7578329928944893`*^9, {3.7579128407087727`*^9, 3.757912855254845*^9}, 
   3.757913438206731*^9},ExpressionUUID->"6cc34788-0bb3-41a1-bef9-\
27c042d5acb9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.0667641541705055`"}],
  SequenceForm["x=", 4, ": ", 0.0667641541705055],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7572338348219686`*^9, 3.757234512407129*^9, 3.7572355438450055`*^9, 
   3.7574274382901864`*^9, 3.7577405030560627`*^9, {3.757740738021264*^9, 
   3.7577407423832784`*^9}, {3.757747034876829*^9, 3.757747048315919*^9}, 
   3.7578329928944893`*^9, {3.7579128407087727`*^9, 3.757912855254845*^9}, 
   3.757913438206731*^9},ExpressionUUID->"927b722a-3b81-485a-955b-\
7939f4bcf2d8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.07405075313131278`"}],
  SequenceForm["x=", 5, ": ", 0.07405075313131278],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7572338348219686`*^9, 3.757234512407129*^9, 3.7572355438450055`*^9, 
   3.7574274382901864`*^9, 3.7577405030560627`*^9, {3.757740738021264*^9, 
   3.7577407423832784`*^9}, {3.757747034876829*^9, 3.757747048315919*^9}, 
   3.7578329928944893`*^9, {3.7579128407087727`*^9, 3.757912855254845*^9}, 
   3.757913438206731*^9},ExpressionUUID->"0fdc3fbd-8352-49a6-899e-\
e5ea92aa24e3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.08157804018212018`"}],
  SequenceForm["x=", 6, ": ", 0.08157804018212018],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7572338348219686`*^9, 3.757234512407129*^9, 3.7572355438450055`*^9, 
   3.7574274382901864`*^9, 3.7577405030560627`*^9, {3.757740738021264*^9, 
   3.7577407423832784`*^9}, {3.757747034876829*^9, 3.757747048315919*^9}, 
   3.7578329928944893`*^9, {3.7579128407087727`*^9, 3.757912855254845*^9}, 
   3.757913438206731*^9},ExpressionUUID->"7bfd35bd-09af-4f41-a092-\
2b535cef9d60"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.08927939184223559`"}],
  SequenceForm["x=", 7, ": ", 0.08927939184223559],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7572338348219686`*^9, 3.757234512407129*^9, 3.7572355438450055`*^9, 
   3.7574274382901864`*^9, 3.7577405030560627`*^9, {3.757740738021264*^9, 
   3.7577407423832784`*^9}, {3.757747034876829*^9, 3.757747048315919*^9}, 
   3.7578329928944893`*^9, {3.7579128407087727`*^9, 3.757912855254845*^9}, 
   3.757913438206731*^9},ExpressionUUID->"7ace0965-2a7c-4bf1-a0cb-\
5ecaff7edb5b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "8", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.09708326671748736`"}],
  SequenceForm["x=", 8, ": ", 0.09708326671748736],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7572338348219686`*^9, 3.757234512407129*^9, 3.7572355438450055`*^9, 
   3.7574274382901864`*^9, 3.7577405030560627`*^9, {3.757740738021264*^9, 
   3.7577407423832784`*^9}, {3.757747034876829*^9, 3.757747048315919*^9}, 
   3.7578329928944893`*^9, {3.7579128407087727`*^9, 3.757912855254845*^9}, 
   3.757913438206731*^9},ExpressionUUID->"3c89f805-ee9d-4c26-8a82-\
46906ed77ddc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "9", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.13437345979869225`"}],
  SequenceForm["x=", 9, ": ", 0.13437345979869225`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7572338348219686`*^9, 3.757234512407129*^9, 3.7572355438450055`*^9, 
   3.7574274382901864`*^9, 3.7577405030560627`*^9, {3.757740738021264*^9, 
   3.7577407423832784`*^9}, {3.757747034876829*^9, 3.757747048315919*^9}, 
   3.7578329928944893`*^9, {3.7579128407087727`*^9, 3.757912855254845*^9}, 
   3.757913438222348*^9},ExpressionUUID->"bd23036f-db49-47d2-a6f5-\
650730f399d5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x=\"\>", "\[InvisibleSpace]", "10", 
   "\[InvisibleSpace]", "\<\": \"\>", "\[InvisibleSpace]", 
   "0.29704137713967504`"}],
  SequenceForm["x=", 10, ": ", 0.29704137713967504`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.7572338348219686`*^9, 3.757234512407129*^9, 3.7572355438450055`*^9, 
   3.7574274382901864`*^9, 3.7577405030560627`*^9, {3.757740738021264*^9, 
   3.7577407423832784`*^9}, {3.757747034876829*^9, 3.757747048315919*^9}, 
   3.7578329928944893`*^9, {3.7579128407087727`*^9, 3.757912855254845*^9}, 
   3.757913438222348*^9},ExpressionUUID->"97666432-c1ff-4b58-93e6-\
708795305745"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1646, 944},
WindowMargins->{{Automatic, 147}, {Automatic, 219}},
Magnification->2.,
FrontEndVersion->"11.2 for Microsoft Windows (64-bit) (September 10, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 12735, 283, 1552, "Input",ExpressionUUID->"c25ecb60-4974-4ee8-94f2-5d543a640601"],
Cell[13318, 307, 556, 13, 90, "Output",ExpressionUUID->"7e80d533-cecd-45d8-b40d-7602057710ee"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13911, 325, 2747, 59, 611, "Input",ExpressionUUID->"164cf34e-a77e-47e4-80ed-776d98f575d7"],
Cell[CellGroupData[{
Cell[16683, 388, 704, 13, 44, "Print",ExpressionUUID->"46ea0ed1-b582-4ab4-b1c8-a59ac658b255"],
Cell[17390, 403, 468, 7, 44, "Print",ExpressionUUID->"2625c596-7815-424f-824f-4bb8486f575e"],
Cell[17861, 412, 657, 13, 44, "Print",ExpressionUUID->"ed7bc0a7-6f33-4a14-a1d2-aa26ef6587bf"],
Cell[18521, 427, 657, 13, 44, "Print",ExpressionUUID->"5ff0947b-751d-4c37-9740-71bf8af7c1f7"],
Cell[19181, 442, 657, 13, 44, "Print",ExpressionUUID->"6cc34788-0bb3-41a1-bef9-27c042d5acb9"],
Cell[19841, 457, 655, 13, 44, "Print",ExpressionUUID->"927b722a-3b81-485a-955b-7939f4bcf2d8"],
Cell[20499, 472, 657, 13, 44, "Print",ExpressionUUID->"0fdc3fbd-8352-49a6-899e-e5ea92aa24e3"],
Cell[21159, 487, 657, 13, 44, "Print",ExpressionUUID->"7bfd35bd-09af-4f41-a092-2b535cef9d60"],
Cell[21819, 502, 657, 13, 44, "Print",ExpressionUUID->"7ace0965-2a7c-4bf1-a0cb-5ecaff7edb5b"],
Cell[22479, 517, 657, 13, 44, "Print",ExpressionUUID->"3c89f805-ee9d-4c26-8a82-46906ed77ddc"],
Cell[23139, 532, 658, 13, 44, "Print",ExpressionUUID->"bd23036f-db49-47d2-a6f5-650730f399d5"],
Cell[23800, 547, 660, 13, 44, "Print",ExpressionUUID->"97666432-c1ff-4b58-93e6-708795305745"]
}, Open  ]]
}, Open  ]]
}
]
*)

