

* Characterize BCBSFL Commercial Market Shares in January 2012

* County-Level Enrollment Data are from Decision Resources Group (DRG) vendor


* Set Directory

cd "~/Dropbox/Vanderbilt/Research/Florida Project/Data/FL_enrollment_data/bcbs" 




use Jan2012_planenroll , clear						// raw data from DRG Excel spreadsheets converted to Stata readable format //

codebook County					

tab MCOName					

browse if MCOName=="BCBS Florida"	

sort County Company 

browse if MCOName=="BCBS Florida" 		

keep if CompanyID <.

browse if Company=="BCBS Florida"		

tab Company								




sort County Company

by County: egen tot_lives = total(TotalBook)

sum tot_lives , d

browse County Company TotalBook tot_lives if Company=="BCBS Florida"

gen bcbs_prcnt_2012 = (TotalBook/tot_lives)*100 if Company=="BCBS Florida"

sum bcbs_prcnt_2012 , d




keep if Company=="BCBS Florida"
gen bcbs_lives_2012 = TotalBook
gen tot_lives_2012 = tot_lives

xtile quart_2012 = bcbs_prcnt_2012, nq(4)
xtile terc_2012  = bcbs_prcnt_2012, nq(3)



* Create Merge Variable (numeric county codes from Workforce survey)

gen new_County = strtrim(County)

tab new_County

gen cnty_mrg = 0									// no value matches to this //

replace cnty_mrg = 11 if new_County=="Alachua"
replace cnty_mrg = 12 if new_County=="Baker"
replace cnty_mrg = 13 if new_County=="Bay"
replace cnty_mrg = 14 if new_County=="Bradford"
replace cnty_mrg = 15 if new_County=="Brevard"
replace cnty_mrg = 16 if new_County=="Broward"
replace cnty_mrg = 17 if new_County=="Calhoun"
replace cnty_mrg = 18 if new_County=="Charlotte"
replace cnty_mrg = 19 if new_County=="Citrus"
replace cnty_mrg = 20 if new_County=="Clay"
replace cnty_mrg = 21 if new_County=="Collier"
replace cnty_mrg = 22 if new_County=="Columbia"
replace cnty_mrg = 23 if new_County=="Miami-Dade"
replace cnty_mrg = 24 if new_County=="DeSoto"

replace cnty_mrg = 25 if new_County=="Dixie"
replace cnty_mrg = 26 if new_County=="Duval"
replace cnty_mrg = 27 if new_County=="Escambia"
replace cnty_mrg = 28 if new_County=="Flagler"
replace cnty_mrg = 29 if new_County=="Franklin"
replace cnty_mrg = 30 if new_County=="Gadsden"
replace cnty_mrg = 31 if new_County=="Gilchrist"
replace cnty_mrg = 32 if new_County=="Glades"
replace cnty_mrg = 33 if new_County=="Gulf"
replace cnty_mrg = 34 if new_County=="Hamilton"
replace cnty_mrg = 35 if new_County=="Hardee"
replace cnty_mrg = 36 if new_County=="Hendry"
replace cnty_mrg = 37 if new_County=="Hernando"
replace cnty_mrg = 38 if new_County=="Highlands"

replace cnty_mrg = 39 if new_County=="Hillsborough"
replace cnty_mrg = 40 if new_County=="Holmes"
replace cnty_mrg = 41 if new_County=="Indian River"
replace cnty_mrg = 42 if new_County=="Jackson"
replace cnty_mrg = 43 if new_County=="Jefferson"
replace cnty_mrg = 44 if new_County=="Lafayette"
replace cnty_mrg = 45 if new_County=="Lake"
replace cnty_mrg = 46 if new_County=="Lee"
replace cnty_mrg = 47 if new_County=="Leon"
replace cnty_mrg = 48 if new_County=="Levy"
replace cnty_mrg = 49 if new_County=="Liberty"
replace cnty_mrg = 50 if new_County=="Madison"
replace cnty_mrg = 51 if new_County=="Manatee"
replace cnty_mrg = 52 if new_County=="Marion"

replace cnty_mrg = 53 if new_County=="Martin"
replace cnty_mrg = 54 if new_County=="Monroe"
replace cnty_mrg = 55 if new_County=="Nassau"
replace cnty_mrg = 56 if new_County=="Okaloosa"
replace cnty_mrg = 57 if new_County=="Okeechobee"
replace cnty_mrg = 58 if new_County=="Orange"
replace cnty_mrg = 59 if new_County=="Osceola"
replace cnty_mrg = 60 if new_County=="Palm Beach"
replace cnty_mrg = 61 if new_County=="Pasco"
replace cnty_mrg = 62 if new_County=="Pinellas"
replace cnty_mrg = 63 if new_County=="Polk"
replace cnty_mrg = 64 if new_County=="Putnam"
replace cnty_mrg = 65 if new_County=="St. Johns"
replace cnty_mrg = 66 if new_County=="St. Lucie"

replace cnty_mrg = 67 if new_County=="Santa Rosa"
replace cnty_mrg = 68 if new_County=="Sarasota"
replace cnty_mrg = 69 if new_County=="Seminole"
replace cnty_mrg = 70 if new_County=="Sumter"
replace cnty_mrg = 71 if new_County=="Suwannee"
replace cnty_mrg = 72 if new_County=="Taylor"
replace cnty_mrg = 73 if new_County=="Union"
replace cnty_mrg = 74 if new_County=="Volusia"
replace cnty_mrg = 75 if new_County=="Wakulla"
replace cnty_mrg = 76 if new_County=="Walton"
replace cnty_mrg = 77 if new_County=="Washington"

drop new_County

saveold bcbs_mrkt_share_2 , replace



