## ======================================
## Figure 6: Average values of m and v over ZIP against time.
## ======================================

  rm(list=ls())
  
  #Assume base R is running
  my.wd <- getSrcDirectory(function(x){x})
  
  #Check for errors
  if(grepl("error", tolower(class(my.wd)[1])) | my.wd==""){
    #Try to access working directory through R Studio API
    my.wd <- tryCatch(dirname(rstudioapi::getActiveDocumentContext()$path),
                      error = function(e) e)
    
  }
  
  #Set working directory
  setwd(my.wd)

## ======================================
## Read in data
## ======================================
  
  #Hospitalizations
  hosp.zip3.qtr.1983.2009 <- read.csv("../Data/hosp_zip3_quarter_1983_2009.csv", stringsAsFactors = FALSE)

## ==========================
## Prep data for plot
## ==========================  

  #Subset data for plotting to LA zips 1995-1999
  plot.dta <- subset(hosp.zip3.qtr.1983.2009, prop.la > 0 & year%in%1995:1999)
  
  #Aggregate m and v by quarter
  plot.agg <- aggregate(cbind(m,v)~year.qtr+year, data = plot.dta, FUN = mean)
  
  #Numeric quarter variable
  plot.agg$year.qtr.num <- as.numeric(as.factor(plot.agg$year.qtr))

## ==========================
## Output: plot
## ==========================  
  
  #Code for plot
  par(mfrow = c(1,1), mar=c(2.5,2.5,3,2.5), mgp=c(1.25,0.3,0), tcl=-0.3)

  plot(plot.agg$year.qtr.num, plot.agg$m, type = "l", ylab = "Proportion", xlab = "Time", lwd = 1.5, xaxt='n',
       main = "Enactment",col="darkgrey")
  lines(plot.agg$year.qtr.num, plot.agg$v,  lwd = 1.5, lty=5)
  which.lab <- c("1995-1","1997-1","1999-1")
  my.lab <- c("1995","1997","1999")
  axis(side=1, at = plot.agg$year.qtr.num[plot.agg$year.qtr%in%which.lab],
       labels=my.lab)
  text(x = 19, y = 0.20, label = "v")
      text(x = 19, y = 0.63, label = "m",col = "darkgrey")

