function main(rr)

% HELP: This function can be used to estimate all specifications reported in
% Hortacsu, Luco, Puller, and Zhu (2019). The function takes a vector of
% integers as input. These integers are used to randomize the initial point
% from which estimation will start. The integers were obtained using Halton
% sequences and are stored in Initial_points_whole_sample.txt
% Each vector in Initial_points_whole_sample.txt is a five element row
% vector. Depending on the specification, different elements of a vector
% are used to initialize estimation. This is explained below when
% specifying the specification to be estimated.

%% load data
format longG
dat = dlmread('full_pqs.csv',',');
dat2 = dlmread('totdemand_mcprice.csv',',');
dat3 = dlmread('mcosts.csv',',');
dat4 = dlmread('firm_size_new.csv',',');

time = dat(:,1); % auction ID
p = dat(:,2); % price
qinc = dat(:,3); % quantity
bidderid = dat(:,4); % bidder ID

time2 = dat2(:,1); % auction ID
totdem = dat2(:,2); % total demand
mcp = dat2(:,3); % market clearing price
time3 = dat3(:,1); % auction ID
mc_unit = dat3(:,2); % marginal cost (p)
mc_inc_q = dat3(:,4); % incremental marginal cost (q)
qse_id = dat3(:,3); % bidder ID

id = dat4(:,1);
firm_size_all = dat4(:,2);

mc_firm = dat3(:,5); % marginal cost after incremental. Used to look at capacity


%% set parameters
hbid = 50;  % smoothing parameter for residual demand
K = 20;  % # of types in the auctions

% Hard code the bidders that go into the CH to avoid mistakes. Do not
% change this!
bidders_CH = [4,5,19,27,6,15,29,24,23,8,16,9];
nbidders_CH = length(bidders_CH);

% find auctions consist of all bidders in CH
aucvec = unique(time);
aucvec = [aucvec(1:25);aucvec(28:100);aucvec(116:119);aucvec(121:139);aucvec(143:end)];
aucvec_use = [];
for i1=1:length(aucvec)
    bidderidauc = bidderid(find(time==aucvec(i1)));
    biddervec = unique(bidderidauc);
    ext_pqs = sum(ismember(biddervec,bidders_CH));
    
    qse_idauc = qse_id(find(time3==aucvec(i1)));
    qsevec = unique(qse_idauc);
    ext_mc = sum(ismember(qsevec,bidders_CH));
    
    if ext_pqs==nbidders_CH && ext_mc==nbidders_CH
        aucvec_use=[aucvec_use;aucvec(i1)];
    else
        aucvec_use=aucvec_use;
    end
end
n_aucs_use = length(aucvec_use);

% Keep auctions with complete data
qcont_mat_all = see_contract(aucvec_use,n_aucs_use,bidders_CH,time,time3,p,qinc,bidderid,mc_unit,mc_inc_q,qse_id);

aucvec_use1 = [];
[a,b] = size(qcont_mat_all);
for i = 1:a
    measure = sum(find(qcont_mat_all(i,2:end)==-1e+06));
    if measure==0
        aucvec_use1=[aucvec_use1;qcont_mat_all(i,1)];
    else
        aucvec_use1=aucvec_use1;
    end
end
n_aucs_use1 = length(aucvec_use1);

%% find fringe bids 
time_pq_fringe=fringe_dat(aucvec_use1,n_aucs_use1,bidders_CH,time,p,qinc,bidderid);
time4 = time_pq_fringe(:,1);
p_fringe_all = time_pq_fringe(:,3);
q_fringe_all = time_pq_fringe(:,4);

%% find contract position
qcont_mat_all = see_contract(aucvec_use1,n_aucs_use1,bidders_CH,time,time3,p,qinc,bidderid,mc_unit,mc_inc_q,qse_id);
time5 = qcont_mat_all(:,1);
qcont_mat = qcont_mat_all(:,2:end);

%% Define covariates that go into estimation and set initial value of the parameters

firm_size = find_firm_size_CH(id,firm_size_all,bidders_CH);
% Rescale
firm_size = firm_size/2600;

% Specification 1: Baseline (comment the rest if estimating baseline)
X = firm_size;
x0=[rr(1) rr(2)];

% Specification 2: Size and Size2
% firm_size_2 = firm_size.^2;
% X = [firm_size; firm_size_2];
% x0=[rr(1) rr(2) rr(3)]

% Specification 3: Merchant
% merchant = [1 1 0 1 1 0 1 1 1 0 1 1];
% X = [firm_size; merchant];
% x0=[rr(1) rr(2)]

% Specification 4: AAU
% aau = [1 1 1 0 0 0 0 0 0 0 1 1];
% X = [firm_size; aau];
% x0=[rr(1) rr(2) rr(3)]

% Specification 5: Econ, Business, Finance
% efb = [1 1 1 1 0 0 0 1 1 0 1 0];
% X = [firm_size; efb];
% x0=[rr(1) rr(2) rr(3)]

% Specification 6: Econ
% econ = [1 1 0 0 0 0 0 0 0 0 1 0];
% X = [firm_size; econ];
% x0=[rr(1) rr(2) rr(3)]

% Specification 7: Learning (note, this one uses a different objective
% function)

% month=aucvec_use1;
% for i2 = 1:length(month)
%     if 3518.25<aucvec_use1(i2) && aucvec_use1(i2)<=6118.25 % 9/5/2001-9/30/2001
%         index=1;
%     elseif 6118.25<aucvec_use1(i2) && aucvec_use1(i2)<=9218.25 % 10/1/2001-10/31/2001
%         index=2;
%     elseif 9218.25<aucvec_use1(i2) && aucvec_use1(i2)<=12218.25 % 11/1/2001-11/30/2001
%         index=3;
%     elseif 12218.25<aucvec_use1(i2) && aucvec_use1(i2)<=15318.25 % 12/1/2001-12/31/2001
%         index=4;
%     elseif 15318.25<aucvec_use1(i2) && aucvec_use1(i2)<=18418.25 % 1/1/2002-1/31/2002
%         index=5;
%     elseif 18418.25<aucvec_use1(i2) && aucvec_use1(i2)<=21218.25 % 2/1/2002-2/29/2002
%         index=6;
%     elseif 21218.25<aucvec_use1(i2) && aucvec_use1(i2)<=24318.25 % 3/1/2002-3/31/2002
%         index=7;
%     elseif 27318.25<aucvec_use1(i2) && aucvec_use1(i2)<=30418.25 % 5/1/2002-5/31/2002
%         index=9;
%     elseif 30418.25<aucvec_use1(i2) && aucvec_use1(i2)<=33418.25 % 6/1/2002-6/30/2002
%         index=10;
%     elseif 33418.25<aucvec_use1(i2) && aucvec_use1(i2)<=36518.25 % 7/1/2002-7/31/2002
%         index=11;
%     elseif 36518.25<aucvec_use1(i2) && aucvec_use1(i2)<=39618.25 % 8/1/2002-8/31/2002
%         index=12;
%     elseif 39618.25<aucvec_use1(i2) && aucvec_use1(i2)<=42618.25 % 9/1/2002-9/30/2002
%         index=13;
%     elseif 42618.25<aucvec_use1(i2) && aucvec_use1(i2)<=45718.25 % 10/1/2002-10/31/2002
%         index=14;
%     elseif 45718.25<aucvec_use1(i2) && aucvec_use1(i2)<=48718.25 % 11/1/2002-11/30/2002
%         index=15;
%     elseif 48718.25<aucvec_use1(i2) && aucvec_use1(i2)<=51818.25 % 12/1/2002-12/31/2002
%         index=16;
%     else
%         index=17; % 51818.25<aucvec_use1(i2)<=54918.25 % 1/1/2003-1/31/2003
%     end
%         month(i2)=index;
% end
% 
% weekind=floor(aucvec_use1/1000);
% week=weekind/max(weekind);
% 
% X = [firm_size; week];
% 
% x0=[rr(1) rr(2) rr(3)]

% For estimation leaving out the outage period, uncomment the following
% lines as we need to drop observations between 42818.25 and 48418.25

% aucvec_use2 = aucvec_use1;
% for i1=1:length(aucvec_use1)
%     if aucvec_use2(i1)>=42818.25 && aucvec_use2(i1)<=48418.25
%         aucvec_use2(i1)=0;
%     end
% end
% 
% aucvec_use2(aucvec_use2==0)=[];
% n_aucs_use2 = length(aucvec_use2);
% 
% qcont_mat_all = see_contract(aucvec_use2,n_aucs_use2,bidders_CH,time,time3,p,qinc,bidderid,mc_unit,mc_inc_q,qse_id);


%% Define triangular distribution to weight prices
pd1 = makedist('Triangular','a',1,'b',41,'c',81);

px = 1:1:81;
pdf1 = pdf(pd1,px)';

% Multiply each price point by the triangular probability before adding
% over them
PDF=repmat(pdf1,1,K+1,nbidders_CH,n_aucs_use1);

options = optimset('Display','iter','MaxIter',50000,'MaxFunEvals',500000,'TolFun',1e-10,'TolX',1e-7);

% Use this for the first six specifications
[param,func] = fminsearch(@(gamma) dif_mcp_sT(gamma,aucvec_use1,time,time2,time3,time4,...
     time5,mc_unit,mc_inc_q,qse_id,p,qinc,bidderid,p_fringe_all,q_fringe_all,...
     nbidders_CH,bidders_CH,qcont_mat,hbid,K,X,mcp,n_aucs_use1,PDF),x0,options);

% Use this for the last specification
% [param,func] = fminsearch(@(gamma) dif_mcp_sTweek(gamma,aucvec_use1,time,time2,time3,time4,...
%      time5,mc_unit,mc_inc_q,qse_id,p,qinc,bidderid,p_fringe_all,q_fringe_all,...
%      nbidders_CH,bidders_CH,qcont_mat,hbid,K,X,mcp,n_aucs_use1,PDF,week),x0,options);

% Need to name file according to specification 
spec = 1; % baseline=1, size and size2 = 2, etc.
filename = ['spec_' num2str(spec) 'obj_' num2str(func) '.txt'];
output=[func param];

dlmwrite(filename,output,'delimiter','\t','precision','%.6f')

end

