function main_sample_sel(rr)

% HELP: This function performs the sample selection exercise described in
% the Online Appendix. The function takes a vector of integers as input and
% performs estimation looping over the firms that can be added to the CH,
% and drops one of the incumbent firms each time (leaving always 12 firms
% in the CH).

%% load data
format longG
dat = dlmread('full_pqs.csv',',');
dat2 = dlmread('totdemand_mcprice.csv',',');
dat3 = dlmread('mcosts.csv',',');
dat4 = dlmread('firm_size_new.csv',',');

time = dat(:,1); % auction ID
p = dat(:,2); % price
qinc = dat(:,3); % quantity
bidderid = dat(:,4); % bidder ID

time2 = dat2(:,1); % auction ID
totdem = dat2(:,2); % total demand
mcp = dat2(:,3); % market clearing price
time3 = dat3(:,1); % auction ID
mc_unit = dat3(:,2); % marginal cost (p)
mc_inc_q = dat3(:,4); % incremental marginal cost (q)
qse_id = dat3(:,3); % bidder ID

id = dat4(:,1);
firm_size_all = dat4(:,2);

mc_firm = dat3(:,5); % marginal cost after incremental. Used to look at capacity


%% set parameters
hbid = 50;  % smoothing parameter for residual demand
K = 20;  % # of types in the auctions

all_bidders = unique(bidderid);
all_bidders(all_bidders==4) =[];
all_bidders(all_bidders==5) =[];
all_bidders(all_bidders==19) =[];
all_bidders(all_bidders==27) =[];
all_bidders(all_bidders==6) =[];
all_bidders(all_bidders==15) =[];
all_bidders(all_bidders==29) =[];
all_bidders(all_bidders==24) =[];
all_bidders(all_bidders==23) =[];
all_bidders(all_bidders==8) =[];
all_bidders(all_bidders==16) =[];
all_bidders(all_bidders==19) =[];

N_auctions = zeros(length(all_bidders),3);
for k = 1:length(all_bidders)
    bidders_CH = [all_bidders(k),4,5,19,27,6,15,29,24,23,8,16,9];
    nbidders_CH = length(bidders_CH);
    
    aucvec = unique(time);
    aucvec = [aucvec(1:25);aucvec(28:100);aucvec(116:119);aucvec(121:139);aucvec(143:end)];
    aucvec_use = [];
    for i1=1:length(aucvec)
        bidderidauc = bidderid(find(time==aucvec(i1)));
        biddervec = unique(bidderidauc);
        ext_pqs = sum(ismember(biddervec,bidders_CH));
        
        qse_idauc = qse_id(find(time3==aucvec(i1)));
        qsevec = unique(qse_idauc);
        ext_mc = sum(ismember(qsevec,bidders_CH));
        
        if ext_pqs==nbidders_CH && ext_mc==nbidders_CH
            aucvec_use=[aucvec_use;aucvec(i1)];
        else
            aucvec_use=aucvec_use;
        end
    end
    n_aucs_use = length(aucvec_use);
    
    qcont_mat_all = see_contract(aucvec_use,n_aucs_use,bidders_CH,time,time3,p,qinc,bidderid,mc_unit,mc_inc_q,qse_id);
    aucvec_use1 = [];
    [a,b] = size(qcont_mat_all);
    for i = 1:a
        measure = sum(find(qcont_mat_all(i,2:end)==-1e+06));
        if measure==0
            aucvec_use1=[aucvec_use1;qcont_mat_all(i,1)];
        else
            aucvec_use1=aucvec_use1;
        end
    end
    n_aucs_use1 = length(aucvec_use1);
    N_auctions(k,1) = all_bidders(k);
    N_auctions(k,2) = n_aucs_use;
    N_auctions(k,3) = n_aucs_use1;
end


%% find fringe bids
time_pq_fringe=fringe_dat(aucvec_use1,n_aucs_use1,bidders_CH,time,p,qinc,bidderid);
time4 = time_pq_fringe(:,1);
p_fringe_all = time_pq_fringe(:,3);
q_fringe_all = time_pq_fringe(:,4);

%% find contract position
qcont_mat_all = see_contract(aucvec_use1,n_aucs_use1,bidders_CH,time,time3,p,qinc,bidderid,mc_unit,mc_inc_q,qse_id);
time5 = qcont_mat_all(:,1);
qcont_mat = qcont_mat_all(:,2:end);

%% covariates and values
firm_size = find_firm_size_CH(id,firm_size_all,bidders_CH);
X = firm_size;
x0=[rr(1) rr(2)];

%% Define triangular distribution to weight prices
pd1 = makedist('Triangular','a',1,'b',41,'c',81);

px = 1:1:81;
pdf1 = pdf(pd1,px)';

% Multiply each price point by the triangular probability before adding
% over them
PDF=repmat(pdf1,1,K+1,nbidders_CH,n_aucs_use1);

options = optimset('Display','iter','MaxIter',50000,'MaxFunEvals',500000,'TolFun',1e-10,'TolX',1e-7);

[param,func] = fminsearch(@(gamma) dif_mcp_sT(gamma,aucvec_use1,time,time2,time3,time4,...
    time5,mc_unit,mc_inc_q,qse_id,p,qinc,bidderid,p_fringe_all,q_fringe_all,...
    nbidders_CH,bidders_CH,qcont_mat,hbid,K,X,mcp,n_aucs_use1,PDF),x0,options);

filename = ['in_out_' num2str(rr(0)) '_' num2str(rr(1)) '.txt'];
output=[func param];

dlmwrite(filename,output,'delimiter','\t','precision','%.6f')
end

