function output=merger_s_draw_allbidders(id1,id2,side,R,type_sim)
% This function computes all counterfactual output for a merger between
% firm id1 and id2. id1 corresponds to the high iq firm and id2 is a row vector
% corresponds to the (relatively) low iq firms. ("side=1"==choose
% auctions on the INC side; "side=2"==choose those on the DEC side;
% "side=0"==all auctions)
%-------------------------------------------------------------------------%
%                        (1) Set Model Primitives                         %
%-------------------------------------------------------------------------%
format shortG                                                             %
bidders_CH = [4,5,19,27,6,15,29,24,23,8,16,9];                            %
gamma = [-0.726 14.594];
mergefirms=[id1,id2];
bidders_CH_merger=find_firms_merger(bidders_CH,mergefirms);
K=20;                                                                          %
%-------------------------------------------------------------------------%
%                            (2) Load Data                                %
%-------------------------------------------------------------------------%
%
dat = dlmread('full_pqs.csv',',');                           %
dat2 = dlmread('totdemand_mcprice.csv',',');                     %
dat3 = dlmread('mcosts.csv',',');                  %
dat4 = dlmread('firm_size_new.csv',',');                                  %
dat5 = dlmread('qcall_allbidders_merger.csv');
%
time_allo = dat5(:,1);
id_allo = dat5(:,2);
qcall_allo = dat5(:,3:end);

time_pq = dat(:,1);                                                       % auction IDs in bids data
p = dat(:,2);                                                             % price unit of bids
qinc = dat(:,3);                                                          % incremental bids
bidderid = dat(:,4);                                                      % firm IDs in the bids data
qcum = dat(:,5);                                                          % cumulative bids
%
time_dem = dat2(:,1);                                                     % auction IDs in total demand and market clearing price data set
totdem = dat2(:,2);                                                       % total demand
mktcp = dat2(:,3);                                                        % actual market clearing price
%
time_mc = dat3(:,1);                                                      % auction IDs in MC data
mc_unit = dat3(:,2);                                                      % price unit in marginal cost
mc_cum = dat3(:,5);                                                       % cumlative marginal cost
mc_inc_q = dat3(:,4);                                                     % incremental marginal cost
qse_id = dat3(:,3);                                                       % firm IDs in the MC data
%
sizeid = dat4(:,1);                                                       % firm ID for firm size
firm_size_all = dat4(:,2);                                                % firm size
%
%-------------------------------------------------------------------------%
%              (3) Find the Auctions That Are Studied                     %
%-------------------------------------------------------------------------%
%
aucvec = unique(time_pq);                                                 %
aucvec = [aucvec(1:25);aucvec(28:100);aucvec(116:119);aucvec(121:139);... %
    aucvec(143:end)];                                                     %
%
aucvec_use=find_auc_CH(bidders_CH,aucvec,time_pq,bidderid,time_mc,qse_id);%
%
aucvec_use=find_auc_QC(aucvec_use,bidders_CH,time_pq,time_mc,p,qinc,...   %
    bidderid,mc_unit,mc_inc_q,qse_id);                                    %
aucvec_use=[aucvec_use(1:67);aucvec_use(69:88);aucvec_use(90:end)];       %
%
aucvec_use=find_DEC_INC_ALL(side,aucvec_use,time_dem,totdem);             % "side=1"==choose INC side;"side=2"==choose DEC side;
% "side=0"==all auctions
%-------------------------------------------------------------------------%
%                  (4) Simulate Firm Bids After Merger                    %
%-------------------------------------------------------------------------%
%
[X, X_merger]=find_X_Xnew_merger_s(bidders_CH,bidders_CH_merger,...       % covariate matrix (X) after Merger
    sizeid,firm_size_all);                                                %
%
time_pq_fringe=fringe_dat(aucvec_use,bidders_CH,time_pq,p,qinc,bidderid); % find fringe firm bids
time_fringe = time_pq_fringe(:,1);                                        % auction ID for fringe data
p_fringe_all = time_pq_fringe(:,3);                                       % price unit of fringe bids
q_fringe_all = time_pq_fringe(:,4);                                       % fringe bids% find mc after merger
%
[time_id_mc_mat,time_id_mc_org_mat,dat_ahead,dat_ahead_merger]=mc_merger_ahead(aucvec_use,time_mc,mc_unit,mc_inc_q,mc_cum,...   %
    qse_id,mergefirms);

time_ahead_merger = dat_ahead_merger(:,1);
id_ahead_merger = dat_ahead_merger(:,2);
q_ahead_merger = dat_ahead_merger(:,3);
%
time_mc_merger = time_id_mc_mat(:,1);                                     % auction ID in the MC data after merger
mc_unit_merger = time_id_mc_mat(:,3);                                     % price unit of marginal cost in MC data after merger
mc_inc_merger = time_id_mc_mat(:,4);                                      % incremental marginal cost in MC data after merger
mc_cum_merger = time_id_mc_mat(:,5);                                      % cumulative marginal cost in MC data after merger
qseid_merger = time_id_mc_mat(:,2);                                       % firm ID in the MC data after merger

time_mc_merger_org = time_id_mc_org_mat(:,1);                             % auction ID in the original MC data after merger
mc_unit_merger_org = time_id_mc_org_mat(:,3);                             % price unit of original marginal cost in MC data after merger
mc_inc_merger_org = time_id_mc_org_mat(:,4);                              % incremental original marginal cost in MC data after merger
qseid_merger_org = time_id_mc_org_mat(:,2);                               % firm ID in the original MC data after merger

qcont_mat_all = see_contract(aucvec_use,bidders_CH,time_pq,time_mc,...    % find contract position before merger
    p,qinc,bidderid,mc_unit,mc_inc_q,qse_id);                             %
time_qcont = qcont_mat_all(:,1);                                          % IDs of auctions in the contract position data set
qcont_mat = qcont_mat_all(:,2:end);                                       % qcont_mat(13,4) contract position of the 4th bidder in CH at auction #13
%

qcont_mat_merger=find_qcon_merger(qcont_mat_all,bidders_CH,mergefirms);   % find contract position after merger
time_qcont_merger=qcont_mat_merger(:,1);                                  %
qcont_merger_mat=qcont_mat_merger(:,2:end);                               %
%
[time_id_bids_merger_mat,n_pgrid] = find_bids_pre_draw(gamma,aucvec_use,time_dem,...     % bids after merger
    mktcp,time_mc_merger,time_fringe,time_qcont_merger,mc_unit_merger,... %
    mc_inc_merger,qseid_merger,p_fringe_all,q_fringe_all,...              %
    bidders_CH_merger,qcont_merger_mat,X_merger,K);                       %
%
time_merger = time_id_bids_merger_mat(:,1);                               % auction ID in the bids data set after merger
p_merger = time_id_bids_merger_mat(:,3);                                  % bids price unit in the bids data set after merger
qinc_merger = time_id_bids_merger_mat(:,4:4+K);                           % incremental bids in the bids data set after merger
qcum_merger = time_id_bids_merger_mat(:,5+K:end);                         % cumulative bids in the bids data set after merger
bidderid_merger = time_id_bids_merger_mat(:,2);                           % bidder ID in the bids data set after merger
%
im1000=find(mc_unit==-1000);                                              % MC has the convention that the first price point is at -1000, rather than
mc_unit(im1000)=-10001;                                                   % at -10001, which is the convention with bids. Change these prices to -10001 to be consistent with bids
i1000=find(mc_unit==1000);                                                %
mc_unit(i1000)=10001;                                                     %
im1000_merger=find(mc_unit_merger==-1000);                                %
mc_unit_merger(im1000_merger)=-10001;                                     %
i1000_merger=find(mc_unit_merger==1000);                                  %
mc_unit_merger(i1000_merger)=10001;                                       %
%
%-------------------------------------------------------------------------%
%                   (5) Calculate Output After Merger                     %
%-------------------------------------------------------------------------%
%

tcost_mat=[];
tcost_ahead_mat=[];
tcost_allo_mat=[];
mktcp_mat=[];
tqcall_mat=[];

indcost_mat = [];
indcost_ahead_mat = [];
indcost_allo_mat = [];
indprofit_mat = [];
qcall_mat = [];
%
for j1 = 1:length(aucvec_use)                                             %
    %
    %~~~~~~~~~~~~~~~~~~ (5.1) load data for this auction ~~~~~~~~~~~~~~~~~~~~~%
    %
    thisauc=aucvec_use(j1);                                               % ID of this auction
    %
    totdemauc = totdem(find(time_dem==thisauc));                          % total demand
    %
    pauc = p(find(time_pq==thisauc));                                     % real bids
    qinc_auc = qinc(find(time_pq==thisauc));                              %
    bidderidauc = bidderid(find(time_pq==thisauc));                       %
    biddervecauc = unique(bidderidauc);                                   %
    %
    iauc3 = find(ismember(time_mc,thisauc).*ismember(qse_id,biddervecauc));% find the marginal cost data
    mcp_auc = mc_unit(iauc3);                                             % for firms that submitted bids
    mcq_auc = mc_inc_q(iauc3);                                            %
    qseidauc = qse_id(iauc3);                                             %
    %
    mcp_auc_merger=mc_unit_merger(find(time_mc_merger==thisauc));         %
    mcq_auc_merger=mc_inc_merger(find(time_mc_merger==thisauc));          %
    qseid_auc_merger=qseid_merger(find(time_mc_merger==thisauc));         %
    
    % find original mc after merger
    mcp_auc_merger_org=mc_unit_merger_org(find(time_mc_merger_org==thisauc));
    mcq_auc_merger_org=mc_inc_merger_org(find(time_mc_merger_org==thisauc));
    qseid_auc_merger_org=qseid_merger_org(find(time_mc_merger_org==thisauc));
    
    % find day-ahead schedule after merger
    id_auc_ahead_merger=id_ahead_merger(find(time_ahead_merger==thisauc));
    q_ahead_auc_merger=q_ahead_merger(find(time_ahead_merger==thisauc));
    %
    qcont_merger_mat_auc = qcont_merger_mat...                            %
        (find(time_qcont_merger==thisauc),:);                             % contract positions of CH bidders
    % in this auction after merger
    tcost_mat(j1,1) = thisauc;
    tcost_ahead_mat(j1,1) = thisauc;
    tcost_allo_mat(j1,1) = thisauc;
    mktcp_mat(j1,1) = thisauc;
    tqcall_mat(j1,1) = thisauc;
    
    indcost_sim = [];
    indcost_ahead_sim = [];
    indcost_allo_sim = [];
    indprofit_sim = [];
    qcall_sim = [];
    for r = 1:R
        
        type_r = type_sim(:,r);
        
        p_auc_merger = p_merger(find(time_merger==thisauc));                  % bids after merger
        bidderid_auc_merger = bidderid_merger(find(time_merger==thisauc));    %
        qinc_auc_merger_r = qinc_merger(find(time_merger==thisauc),:);
        
        id_allo_auc = id_allo(find(time_allo==thisauc));
        qcall_allo_auc = qcall_allo(find(time_allo==thisauc),r);
        
        qinc_auc_merger = [];
        for j = 1:length(bidders_CH_merger)
            q_this = qinc_auc_merger_r((j-1)*n_pgrid+1:j*n_pgrid,(type_r(j)+1));
            qinc_auc_merger = [qinc_auc_merger;q_this];
        end
        
        %~~~~~~~~~~~~~ (5.2) find market clearing price after merger ~~~~~~~~~~~~~%
        %
        [pauc_merger_all,qauc_merger_all,bidderidauc_merger_all]=...          % replace CH players' real bid with bids
            replace_bids_merger(bidders_CH,bidders_CH_merger,pauc,qinc_auc,...%
            bidderidauc,p_auc_merger,qinc_auc_merger,bidderid_auc_merger);    %
        %
        [aggqmerger, aggpmerger] = agg_supply(pauc_merger_all,qauc_merger_all);
        mktcp_merger = find_mktclr_new(aggqmerger,aggpmerger,totdemauc);      % market clearing price after merger
        %
        %~~~~~~~~~~~~~~~~~~ (5.3) simulate output after merger ~~~~~~~~~~~~~~~~~~~%
        %
        %output_auc=[];                                                        % record output for this auction
        tqcall_merger=0;                                                      % record quantity called in this auction
        tcost_merger=0;
        tcost_ahead_merger=0;% record total cost for this auction
        tcost_allo_merger=0;
        %
        biddervecauc_merger = unique(bidderidauc_merger_all);                 % unique bidder ID after merger in this auction
        %
        bidder_auc = [];
        indcost_auc = [];
        indcost_ahead_auc = [];
        indcost_allo_auc = [];
        indprofit_auc = [];
        qcall_auc = [];
        
        for k1=1:length(biddervecauc_merger)                                  %
            %
            thisbidder_merger = biddervecauc_merger(k1);                      %
            
            % original cost function after merger
            mcpbidder_merger_org = mcp_auc_merger_org(qseid_auc_merger_org==thisbidder_merger);
            mcqbidder_merger_org = mcq_auc_merger_org(qseid_auc_merger_org==thisbidder_merger);
            
            % find day-ahead schedule
            qbidder_ahead = q_ahead_auc_merger(find(id_auc_ahead_merger==thisbidder_merger));
            %
            if ismember(thisbidder_merger,bidders_CH_merger)                  %
                mcpbidder_merger = mcp_auc_merger(find(qseid_auc_merger==...      %
                    thisbidder_merger));                                          %
                mcqbidder_merger = mcq_auc_merger(find(qseid_auc_merger==...      %
                    thisbidder_merger));                                          %
                pbidder_merger = pauc_merger_all(find(bidderidauc_merger_all ==...%
                    thisbidder_merger));                                          %
                qbidder_merger = qauc_merger_all(find(bidderidauc_merger_all ==...%
                    thisbidder_merger));                                          %
            else                                                              %
                mcpbidder_merger = mcp_auc(find(qseidauc==thisbidder_merger));    %
                mcqbidder_merger = mcq_auc(find(qseidauc==thisbidder_merger));    %
                pbidder_merger = pauc(find(bidderidauc==thisbidder_merger));      %
                qbidder_merger = qinc_auc(find(bidderidauc==thisbidder_merger));  % incremental quantity
            end                                                               %
            
            %
            if max(mcqbidder_merger)==0 & max(qbidder_merger)>0               %
                mcqbidder_merger = qbidder_merger;                            %
                mcpbidder_merger = pbidder_merger;                            %
            end                                                               %
            %
            ybidder_merger = cumsum(qbidder_merger);                          % cumulative bids for this bidder after merger
            mcqcumbidder_merger = cumsum(mcqbidder_merger);                   % cumulative mc for this bidder after merger
            qcall_merger = find_qcall_new(mktcp_merger,aggqmerger,...         % quantity called of this bidder
                aggpmerger,totdemauc,ybidder_merger,pbidder_merger);          %
            indcost_merger = find_individualcost(mcqcumbidder_merger,...      % production cost of this bidder
                mcpbidder_merger,qcall_merger,thisbidder_merger);             %
            tqcall_merger=tqcall_merger+qcall_merger;                         % quantity called of this auction
            tcost_merger=tcost_merger+indcost_merger;                         % total cost of this auction
            %
            
            % find tcost of producing day-ahead schedule and qcall
            mcqcumbidder_merger_org = cumsum(mcqbidder_merger_org);
            qcall_allo_bidder = qcall_allo_auc(find(id_allo_auc==thisbidder_merger));
            
            if max(mcqbidder_merger_org)>0
                indcost_ahead_merger = find_individualcost(mcqcumbidder_merger_org,...      % production cost of this bidder
                    mcpbidder_merger_org,qcall_merger-qbidder_ahead,thisbidder_merger);             %
                
                indcost_allo_merger = find_individualcost(mcqcumbidder_merger_org,...
                    mcpbidder_merger_org,qcall_allo_bidder-qbidder_ahead,thisbidder_merger);
            else
                indcost_ahead_merger=0;
                indcost_allo_merger=0;
            end
            tcost_ahead_merger=tcost_ahead_merger+indcost_ahead_merger;
            tcost_allo_merger=tcost_allo_merger+indcost_allo_merger;
            
            if ismember(thisbidder_merger,bidders_CH_merger)                  %
                qcont_bidder_merger=qcont_merger_mat_auc...                   %
                    (find(bidders_CH_merger==thisbidder_merger));             %
                [profit_merger,totcost_merger] = find_profit1...              %
                    (mcqcumbidder_merger,mcpbidder_merger,qcall_merger,...    %
                    mktcp_merger,qcont_bidder_merger,thisbidder_merger);      %
            end                                                               %
            %
            %-------------------------------------------------------------------------%
            %                            (6) Record Output                            %
            %-------------------------------------------------------------------------%
            %
            if ismember(thisbidder_merger,bidders_CH_merger)                  % record output if this firm is in CH
                
                bidder_auc=[bidder_auc;thisbidder_merger];
                indcost_auc=[indcost_auc;indcost_merger];
                indcost_ahead_auc=[indcost_ahead_auc;indcost_ahead_merger];
                indcost_allo_auc=[indcost_allo_auc;indcost_allo_merger];
                indprofit_auc = [indprofit_auc;profit_merger];
                qcall_auc = [qcall_auc;qcall_merger];
                
            end                                                               %
        end
        
        tcost_mat(j1,r+1) = tcost_merger;
        tcost_ahead_mat(j1,r+1) = tcost_ahead_merger;
        tcost_allo_mat(j1,r+1) = tcost_allo_merger;
        mktcp_mat(j1,r+1) = mktcp_merger;
        tqcall_mat(j1,r+1) = tqcall_merger;
        
        indcost_sim = [indcost_sim indcost_auc];
        indcost_ahead_sim = [indcost_ahead_sim indcost_ahead_auc];
        indcost_allo_sim = [indcost_allo_sim indcost_allo_auc];
        indprofit_sim = [indprofit_sim indprofit_auc];
        qcall_sim = [qcall_sim qcall_auc];
    end
    
    indcost_sim = [bidder_auc indcost_sim];
    indcost_ahead_sim = [bidder_auc indcost_ahead_sim];
    indcost_allo_sim = [bidder_auc indcost_allo_sim];
    indprofit_sim = [bidder_auc indprofit_sim];
    qcall_sim = [bidder_auc qcall_sim];
    
    
    a=ones(size(bidder_auc,1),1);                                         %
    
    indcost_mat = [indcost_mat; [a*thisauc indcost_sim]];
    indcost_ahead_mat = [indcost_ahead_mat; [a*thisauc indcost_ahead_sim]];
    indcost_allo_mat = [indcost_allo_mat; [a*thisauc indcost_allo_sim]];
    indprofit_mat = [indprofit_mat; [a*thisauc indprofit_sim]];
    qcall_mat = [qcall_mat;[a*thisauc qcall_sim]];
    
    
    %
end% for j1 = 1:samplelength


filename2 = ['merger_allbidders_s_draw_tcost ' num2str(id1) ' acquires ' num2str(id2)...           %
    '_' num2str(side) '.csv'];
xlswrite(filename2,tcost_mat);

filename3 = ['merger_allbidders_s_draw_mktcp ' num2str(id1) ' acquires ' num2str(id2)...           %
    '_' num2str(side) '.csv'];
xlswrite(filename3,mktcp_mat);

filename4 = ['merger_allbidders_s_draw_tqcall ' num2str(id1) ' acquires ' num2str(id2)...           %
    '_' num2str(side) '.csv'];
xlswrite(filename4,tqcall_mat);

filename5 = ['merger_allbidders_s_draw_indcost ' num2str(id1) ' acquires ' num2str(id2)...           %
    '_' num2str(side) '.csv'];
xlswrite(filename5,indcost_mat);

filename6 = ['merger_allbidders_s_draw_indprofit ' num2str(id1) ' acquires ' num2str(id2)...           %
    '_' num2str(side) '.csv'];
xlswrite(filename6,indprofit_mat);

filename7 = ['merger_allbidders_s_draw_indqcall ' num2str(id1) ' acquires ' num2str(id2)...           %
    '_' num2str(side) '.csv'];
xlswrite(filename7,qcall_mat);

filename8 = ['merger_allbidders_s_draw_tcost_ahead ' num2str(id1) ' acquires ' num2str(id2)...           %
    '_' num2str(side) '.csv'];
xlswrite(filename8,tcost_ahead_mat);

filename9 = ['merger_allbidders_s_draw_indcost_ahead ' num2str(id1) ' acquires ' num2str(id2)...           %
    '_' num2str(side) '.csv'];
xlswrite(filename9,indcost_ahead_mat);

filename10 = ['merger_allbidders_s_draw_tcost_allo ' num2str(id1) ' acquires ' num2str(id2)...           %
    '_' num2str(side) '.csv'];
xlswrite(filename10,tcost_allo_mat);

filename11 = ['merger_allbidders_s_draw_indcost_allo ' num2str(id1) ' acquires ' num2str(id2)...           %
    '_' num2str(side) '.csv'];
xlswrite(filename11,indcost_allo_mat);
end                                                                       %
%-------------------------------------------------------------------------%
