function [q_aggs_deriv,p_aggs]=agg_supply_smooth(price,quantity,h,p_eval)

% generates the ad curve for the valuation quantity pairs
% smoothes with kernel bandwith h

sp = size(p_eval);
if sp(1)<sp(2)
     p_eval=p_eval';
 end

nbids=length(price);

neval=length(p_eval);

p_aggs1=p_eval;
q_aggs_deriv1 = p_eval;

for i=1:neval
    p = p_eval(i);
    qd=0;
    for j=1:nbids
        kin = (p-price(j))/h;
        x=exp(-kin^2/2)/(sqrt(2*pi));
        qd=qd+quantity(j)*x/h;

    end
    q_aggs_deriv1(i)=qd;
end

sortmat=sortrows([p_aggs1,q_aggs_deriv1],1);

p_aggs=sortmat(:,1);
q_aggs_deriv=sortmat(:,2);

