function [S,m] = NewWest(Xu,conind,prew)
%
% [S,m] = NewWest(Xu,conind,prew)
%
% This function computes the Newey-West (1994) estimator of the covariance
% of the sample mean of the rows of Xu, which are potentially correlated.
%
% Inputs:
%
%   Xu:     T-by-k    T observations, k regressors
%   conind: scalar    index of constant term in Xu; 0 = no constant term
%   prew: scalar      1 = pre-whiten (default = 0)
%
% Outputs:
%
%   S:      k-by-k
%   m:      scalar (bandwidth parameter)
%
% Written by Dana Galizia, Carleton University

%% Initialization

T = size(Xu,1);
T2 = T;

k = size(Xu,2);

n = round(4*((T/100)^(2/9)));
w = ones(k,1);

if conind > 0
    w(conind) = 0;
end

if nargin < 3
    prew = 0;
end

%% Pre-whitening

if prew == 1
    A = Xu(2:T,:)'*Xu(1:(T-1),:)*pinv(Xu(1:(T-1),:)'*Xu(1:(T-1),:));
    Xu = Xu(2:T,:) - Xu(1:(T-1),:)*A';
    Q = eye(k)/(eye(k) - A);
    T2 = T-1;
end

%% Obtain bandwidth parameter

sig = zeros(n+1,1);
sumh = Xu*w;

for j = 0:n
    sig(j+1) = sumh((j+1):T2)'*sumh(1:(T2-j))/T2;
end

s1 = 2*(1:n)*sig(2:(n+1));
s0 = sig(1) + 2*ones(1,n)*sig(2:(n+1));

gam = 1.1447*((s1/s0)^2)^(1/3);
m = floor(gam*(T^(1/3)));

%%  Autocovariances of hd

Om = zeros(k,k,m+1);

for j = 0:m
    Om(:,:,j+1) = Xu((j+1):T2,:)'*Xu(1:(T2-j),:)/T2;
end

%% Compute Sd and S

S = Om(:,:,1);

for j = 1:m
    S = S + (1-j/(m+1))*(Om(:,:,j+1)+Om(:,:,j+1)');
end

if prew == 1
    S = Q*S*Q';
end
