% BGP, April 10, 2018


clear all;
close all

% Plain RBC
dynare Rbc.mod;

% Augmented RBC
dynare Rbc2.mod;

% Smets-Wouters
dynare SW.mod;

% Carlstrom and Fuerst (1997, AER)
dynare CF.mod;

% Bernanke-Gertelr-Gilchrist
dynare BGG.mod;

% Christiano, Motto and Rostagno (2014)
dynare CMR.mod;


load RBCSimulatedSpectrum.mat
spXmhRBC=spXmh/mean(spXmh)*1;

load RBC2SimulatedSpectrum.mat
spXmhRBC2=spXmh/mean(spXmh)*1;

load SWSimulatedSpectrum.mat
spXmhSW=spXmh/mean(spXmh)*1;

load CFSimulatedSpectrum.mat
spXmhCF=spXmh/mean(spXmh)*1;

load BGGSimulatedSpectrum.mat
spXmhBGG=spXmh/mean(spXmh)*1;

load CMRSimulatedSpectrum.mat
spXmhCMR=spXmh/mean(spXmh)*1;





%% Plotting

TT = 1024;                   % number of points in fft
Todd = logical(mod(TT,2));
if Todd
    TT2 = (TT+1)/2;
else
    TT2 = TT/2 + 1;
end
frmn = 1/60;            % lowest frequency to plot
frmx = 1/4;             % highest frequency to plot
xl = [frmn,frmx];                           % min and max of x-axis in frequencies
xl = log(1./min(xl([2,1]),realmax));
fsz=18;
xtickvec = [4, 6, 24, 32,40, 50, 60, 80, 200];   % vector of xtick mark locations
ntick = numel(xtickvec);                                % number of xtick marks
xticklab = cell(1,ntick);                               % cell to hold xtick labels
for j = 1:ntick                                         % for each tick location
    xticklab{j} = num2str(xtickvec(j),'%i');                % label = string value of xtick mark
end
xtickvec = log(xtickvec);                               % get logs of tick marks

freqs = linspace(0,.5,TT2)';                % vector of (ordinary) frequencies
xl = [frmn,frmx];                           % min and max of x-axis in frequencies
xax = log(min(1./freqs,realmax));           % get log of periodicities associated with frequencies
xl = log(1./min(xl([2,1]),realmax));        % min and max of x-axis in log of periodicity



h=figure;
eval(['plot(xax,spXmhRBC,''-'',''LineWidth'',4,''color'',rgb(''black''));']);   % plot data spectrum
xlim(xl)
hold on;
eval(['plot(xax,spXmhRBC2,''-'',''LineWidth'',4,''color'',rgb(''darkgray''));']);   % plot data spectrum
eval(['plot(xax,spXmhSW,''-'',''LineWidth'',4,''color'',rgb(''dimgray''));']);   % plot data spectrum
eval(['plot(xax,spXmhCF,''-.'',''LineWidth'',4,''color'',rgb(''black''));']);   % plot data spectrum
eval(['plot(xax,spXmhBGG,''-.'',''LineWidth'',4,''color'',rgb(''darkgray''));']);   % plot data spectrum
eval(['plot(xax,spXmhCMR,''-.'',''LineWidth'',4,''color'',rgb(''dimgray''));']);   % plot data spectrum
ll=legend('RBC','Augmented RBC','Smets and Wouters','Carlstrom and Fuerst','Bernanke, Gilschrist and Gertler','Christiano, Motto and Rostagno','Location','northwest','AutoUpdate','off');
set(ll,'FontName','Times','FontSize',16,'interpreter', 'latex')
set(ll,'color','none');
yy=ylim;
area(([xtickvec(4) xtickvec(2) ]),.995*[yy(2) yy(2) ], 'facecolor',rgb('whitesmoke'), 'edgecolor',rgb('whitesmoke'));
area(([xtickvec(6) xtickvec(4)]) ,.995*[yy(2) yy(2) ], 'facecolor',rgb('gainsboro'), 'edgecolor',rgb('gainsboro'));
yy=ylim;
eval(['plot(xax,spXmhRBC,''-'',''LineWidth'',4,''color'',rgb(''black''));']);   % plot data spectrum
eval(['plot(xax,spXmhRBC2,''-'',''LineWidth'',4,''color'',rgb(''darkgray''));']);   % plot data spectrum
eval(['plot(xax,spXmhSW,''-'',''LineWidth'',4,''color'',rgb(''dimgray''));']);   % plot data spectrum
eval(['plot(xax,spXmhCMR,''-.'',''LineWidth'',4,''color'',rgb(''dimgray''));']);   % plot data spectrum
eval(['plot(xax,spXmhBGG,''-.'',''LineWidth'',4,''color'',rgb(''darkgray''));']);   % plot data spectrum
eval(['plot(xax,spXmhCF,''-.'',''LineWidth'',4,''color'',rgb(''black''));']);   % plot data spectrum
set(gca,'XTick',xtickvec,'XTickLabel',xticklab,'FontName','Times','FontSize',fsz,'xgrid','on')
xlabel('Periodicity','FontName','Times','FontSize',fsz)
hold off
title('Hours')


