###################################################################
# Name              : EstimateFactorScores.R
# Description       : This program estimates factor scores using 
#                     raw measures and estimates of the measurement 
#                     system 
###################################################################

###################################################################
# Define a function that estimates factor scores on each sample 
###################################################################

factor.score.estim.func              <- function(data, lambda, eps, mean, cov, prob){
  
  # Load data
  setwd(dir_data)                           
  measures      <- call.data(data)
  n             <- nrow(measures)
  
  
  # Load measurement system specification 
  setwd(dir_anal)                             
  source(inputFM)                             
  
  # Fill in an indicaitor list with variables that are missing for each observation i in the dataset 
  missindic       <- list()
  
  for (i in 1:n){
    missindic[[i]] <- which(y[i,1:nZ]!="NA")
  }
  
  checkmiss <- matrix(0, n, nZ)
  nonmissf  <- matrix(0, n, nF)
  remove    <- rep(0, n)
  for (i in 1:n){
    for (j in 1:nZ){
      checkmiss[i, j]  <- j %in%  missindic[[i]]
    }
    for (f in 1:nF){
      nonmissf[i,f]       <- sum(checkmiss[i,startSeq[f]:endSeq[f]])     
    }
    remove[i]          <- 0 %in%  nonmissf[i,]
  }
  

  # Estimate factor scores for the whole dataset (loop over optim)
  theta_estim_miss          <- matrix(NA, n, nF)
  theta_estim_missBFGS      <- matrix(NA, n, nF)
  theta_estim_missCG        <- matrix(NA, n, nF)
  
  for (i in 1:n){
    
  if (remove[i]!=1){
    if (invar==0){
      #theta_estim_miss[i,]     <-  optim(rep(0,nF), bartlett.func,y=y[i,1:nZ], loadings=lambda, omega = diag(eps), comp=missindic[[i]])$par
      theta_estim_missBFGS[i,] <-  optim(rep(0,nF), bartlett.func, method= "BFGS", y=y[i,1:nZ], loadings=lambda, omega = diag(eps), comp=missindic[[i]])$par
      #theta_estim_missCG[i,]   <-  optim(rep(0,nF), bartlett.func, method= "CG", y=y[i,1:nZ], loadings=lambda, omega = diag(eps), comp=missindic[[i]])$par
      
    } else if (invar==1){
      #theta_estim_miss[i,]     <-  optim(rep(0,nF), bartlett.func,y=y[i,1:nZ], loadings=lambda, omega = diag(eps), comp=missindic[[i]])$par
      theta_estim_missBFGS[i,] <-  optim(rep(0,nF), bartlett.func, method= "BFGS", y=y[i,1:nZ], loadings=lambda[[treat[i]]], omega = diag(eps), comp=missindic[[i]])$par
      #theta_estim_missCG[i,]   <-  optim(rep(0,nF), bartlett.func, method= "CG", y=y[i,1:nZ], loadings=lambda, omega = diag(eps), comp=missindic[[i]])$par
    } 
    }
  }
  
  # Rename output of this process
  #scoresall                    <- theta_estim_miss
  #scores                       <- list()
  #scores[[1]]                  <- theta_estim_miss[which(treat==1),]
  #scores[[2]]                  <- theta_estim_miss[which(treat==2),]
  
  scoresallBFGS                <- theta_estim_missBFGS
  scoresBFGS                   <- list()
  scoresBFGS[[1]]              <- theta_estim_missBFGS[which(treat==1),]
  scoresBFGS[[2]]              <- theta_estim_missBFGS[which(treat==2),]
  
  #scoresallCG                  <- theta_estim_missCG
  #scoresCG                     <- list()
  #scoresCG[[1]]                <- theta_estim_missCG[which(treat==1),]
  #scoresCG[[2]]                <- theta_estim_missCG[which(treat==2),]
  
  
 # return(list(scoresallBFGS, scores[[1]], scores[[2]],scoresallBFGS, scoresBFGS[[1]], scoresBFGS[[2]],scoresallCG, scoresCG[[1]], scoresCG[[2]]))
  return(list("NA","NA","NA",scoresallBFGS, scoresBFGS[[1]], scoresBFGS[[2]],"NA","NA","NA"))
} 


###################################################################
# Run function defined above on the true and boostrapped datasets 
###################################################################
for (boot in 0:Bootstrap){
  
  # Estimate factor scores on true data 
  if (boot==0 & onlyboot==0){ 
    
    setwd(dir_outputFM)
    load("trueFM.R")
    
    ptm <- proc.time()
    fs_true    <- factor.score.estim.func("measures.csv", lambda, eps, mean.mix, cov.mix, prob.mix)
    proc.time() - ptm
    
    # Save output 
    setwd(dir_outputFM)
    save(fs_true, file="fs_true.R")
  } 
  
  
  # Estimate factor scores on bootstrapped samples
  if (boot==1){ 
    fs_bstrap    <- list()
    
     for (b in 1:bsample){
   
      bequiv <- (b + (node-1)*bsample)
      if (invar==0){
        fs_bstrap[[b]]   <- try(factor.score.estim.func(paste("measures_b", (b + (node-1)*bsample), ".csv", sep=""), 
                                                        lambdaBoot[,,bequiv] ,epsBoot[,bequiv],
                                                        list(meanBoot[,,bequiv,1], meanBoot[,,bequiv,2]), 
                                                        list(covBoot[,,bequiv,1], covBoot[,,bequiv,2])))
      } else if (invar==1){
        fs_bstrap[[b]]   <- try(factor.score.estim.func(paste("measures_b", (b + (node-1)*bsample), ".csv", sep=""), 
                                                        list(lambdaBoot[,,bequiv,1] ,lambdaBoot[,,bequiv,2]) ,
                                                        epsBoot[,bequiv],
                                                        list(meanBoot[,,bequiv,1], meanBoot[,,bequiv,2]), 
                                                        list(covBoot[,,bequiv,1], covBoot[,,bequiv,2])))
      }

    } 
    
    # Save output from this node 
    setwd(dir_outputFM)
    save(fs_bstrap, file=nameBootFS)
  } 
  
}

