md.flexfunc.MC            <- function(invest, cogrdf, ncogrdf, cogrdf_var, ncogrdf_var, start, posExo, posInv , weighting, nInvest, nS){
  nExo    <- length(posExo) 
  
  # Organize output to make it easier for next steps 
  if (nInvest==1){
    J            <- length(invest)
    Einv_exo     <- invest[posExo]
    Einv_ins     <- invest[posInv]
  
  } else if (nInvest==2){
    matinv           <- invest[,1]
    timeinv          <- invest[,2]
    
    Einvmat_exo     <- matinv[posExo]
    Einvmat_ins     <- matinv[posInv]
    
    Einvtime_exo    <- timeinv[posExo]
    Einvtime_ins    <- timeinv[posInv]  
  }

  Ecogrdf_exo      <- cogrdf[posExo]
  Ecogrdf_ins      <- cogrdf[posInv]
  
  Encogrdf_exo     <- ncogrdf[posExo]
  Encogrdf_ins     <- ncogrdf[posInv]

  
  # Define moments 
  mindist.cog.func    <- function(outparam){ 
    Epf_exo           <- outparam[1:nExo]
    
    if (nInvest==1){
      
      Epf_inv         <- outparam[nExo+1]
      exom            <- Ecogrdf_exo - (Epf_exo + Epf_inv * Einv_exo ) 
      endom           <- Ecogrdf_ins - (Epf_inv * Einv_ins)
      
    } else if (nInvest==2){ 
      
    Epf_mat         <- outparam[nExo+1]
    Epf_time        <- outparam[nExo+2]
    exom            <- Ecogrdf_exo - (Epf_exo + Epf_mat * Einvmat_exo + Epf_time * Einvtime_exo ) 
    endom           <- Ecogrdf_ins - (Epf_mat * Einvmat_ins + Epf_time * Einvtime_ins)
    
    } 
  
    allm            <- matrix(c(exom, endom), 1, length(c(exom, endom)))
    
    if (weighting==TRUE){
      #objfunc         <- as.numeric(allm %*% solve(nearPD(cogrdf_var)$mat) %*% t(allm))
    objfunc         <- as.numeric(allm %*% solve(make.positive.definite(cogrdf_var)) %*% t(allm))
    } 
    if (weighting==FALSE){
    objfunc         <- as.numeric(allm %*% t(allm))
    } 
    
    return(objfunc)  
  }
  
  cogpf            <- optim(start[,1], mindist.cog.func,  control=list(maxit=10000))
  #cogpf            <- optim(start[,1], mindist.cog.func, method=c("CG"),  control=list(maxit=10000))
  #cogpf            <- optim(start[,1], mindist.cog.func, method=c("BFGS"), control=list(maxit=10000))
  pf <- cogpf$par
  
  ### Non-cognitive skill 
  if (nS==2){
    

   mindist.ncog.func    <- function(outparam){ 
   Epf_exo         <- outparam[1:nExo]
   
   if (nInvest==1){
     
     Epf_inv         <- outparam[nExo+1]
     exom            <- Encogrdf_exo - (Epf_exo + Epf_inv * Einv_exo  ) 
     endom           <- Encogrdf_ins - (Epf_inv * Einv_ins)
     
   } else if (nInvest==2){ 
     
     Epf_mat         <- outparam[nExo+1]
     Epf_time        <- outparam[nExo+2]
     exom            <- Encogrdf_exo - (Epf_exo + Epf_mat * Einvmat_exo + Epf_time * Einvtime_exo ) 
     endom           <- Encogrdf_ins - (Epf_mat * Einvmat_ins + Epf_time * Einvtime_ins)
     
   } 
  
     allm            <- matrix(c(exom, endom), 1, length(c(exom, endom)))
     
     if (weighting==TRUE){
       #objfunc         <- as.numeric(allm %*% solve(nearPD(ncogrdf_var)$mat) %*% t(allm))
       objfunc         <- as.numeric(allm %*% solve(make.positive.definite(ncogrdf_var)) %*% t(allm))
     } 
     if (weighting==FALSE){
       objfunc         <- as.numeric(allm %*% t(allm))
     } 
     
     return(objfunc)  
   }
   
   ncogpf           <- optim(start[,2], mindist.ncog.func ,  control=list(maxit=10000))
   #ncogpf           <- optim(start[,2], mindist.ncog.func , method=c("BFGS"), control=list(maxit=10000))
   #ncogpf           <- optim(start[,2], mindist.ncog.func , method=c("CG"), control=list(maxit=10000))
   
   
   pf <- cbind(cogpf$par, ncogpf$par)
  }
  return(pf)
} 
