###################################################################
# Name              : CobbDouglas_IV_MC.R
# 
# Description       : This program estimates the structural 
#                     parameters of the simpler Cobb Douglas production 
#                     functions for cognitive skill for the MC exercise
###################################################################



###################################################################
# Estimate starting values 
###################################################################
start1      <- lm(cog1 ~ cbind(treat, cog0,  cogmo, mat, time), data=regdata)$coef
start       <- cbind(start1)
start       <- cbind(rep(0, length(start1)))
ninvest      <- 2

###################################################################
# Estimate production functions on simulated samples
###################################################################
iv_bstrap             <- array(0, dim=c(length(start1), nof))

for (b in 1:nof){  
 
  iv_bstrap[,b]         <- md.flexfunc.MC(invest_bstrap[,,b], rdform_bstrap[,1,b], 
                                        0, cogrdf_var[c(posExo, posInv), c(posExo, posInv)], 0,
                                        start, posExo, posInv, weighting="FALSE", nInvest = ninvest, nS = 1)
  print(b)
} 


##############################################################################
# Create table of estimates (point estimate followed by bootstrapped 
# standard errors, 95% ci, p-value one tail test and p-value two tailed test)
############################################################################## 
outb        <- list(iv_bstrap) 

outtable        <- list()
for (s in 1:1) {
  npar                 <- length(start1 )
  outtable[[s]]        <- matrix(0, npar*5, 1)
  
  for (i in 1:npar){
    for (j in 1:1){
      
      
      mean             <- mean(outb[[s]][i,])
      se               <- sd(outb[[s]][i,])
      t_stat           <- mean/se
      t_crit           <- (outb[[s]][i,] - mean)/se
      p_val            <- 1 - ecdf(t_crit)(t_stat)
      p_val2           <- 1 - ecdf(t_crit^2)(t_stat^2)
      
      outtable[[s]][(i*5-4), j]  <- round(mean,3)
      outtable[[s]][(i*5-3),j]   <- round(se,3) 
      outtable[[s]][(i*5-2), j]  <- paste("[", round(quantile(outb[[s]][i,], .025),3), ",", 
                                          round(quantile(outb[[s]][i,], .975),3), "]", sep="") 
      outtable[[s]][(i*5-1), j]  <- p_val 
      outtable[[s]][i*5, j]      <- p_val2 
      
    } 
  } 
} 


# Name output rows and columns 
basic    <- c("Intercept", "", "","","",
              "Treat", "", "", "","",
              "cog0","", "", "","",
              "cogmo", "", "", "", "") 

pfnames    <- basic 
pfnames    <- c(pfnames, "mat", "", "", "","", "time", "", "", "","")  
colnames(outtable[[1]]) <- c("Cognitive skills")   #, "Socio-emotional skills"
rownames(outtable[[1]]) <- pfnames


# Save output 
setwd(dir_outputPF)
save( iv_bstrap, file=paste("OUTPUT_IV_pval", ".R", sep=""))
write.csv(cbind(outtable[[1]]), file=paste("PF_IV_pval", ".csv", sep=""))

