************************************************************************************************
* Name			: globals.do
*
* Description	: This dofile defines the globals defining the directories and groups of variables 
*                 used in the various do files.
************************************************************************************************
/*
global testerFE 	no 			/*Take out tester FE before standardizing measures*/ 
global invar 		no 		/*Incorporate intercepts in the measurement system for when we will allow for measurement system variance*/ 
global pure 		no 			/*Only pure control and pure stimulation groups*/ 

********************************************************************************
* DIRECTORIES 
********************************************************************************
global dir					"AER-2015-0183_data_appendix"                        /*Write down the name of your main directory here*/ 
global dir_statacode 		"$dir\code\stata" 
global dir_output 			"$dir\output" 
global dir_mplus 			"$dir\code\mplus" 

if ("$testerFE" == "no"  & "$invar" == "no" & "$pure" == "no")  { 
global dir_data "$dir\data"
} 

if ("$testerFE" == "yes"  & "$invar" == "no" & "$pure" == "no") { 
global dir_data "$dir\data_testerFE"
} 

if ("$testerFE" == "no"  & "$invar" == "yes" & "$pure" == "no") { 
global dir_data "$dir\data_invar"
} 

if ("$testerFE" == "no"  & "$invar" == "no" & "$pure" == "yes"){
global dir_data "$dir\data_puresample"
} */ 

********************************************************************************
* GROUPS OF VARIABLES 
********************************************************************************
#delim; 

global child_tostd0 	"b_tot_cog0 b_tot_lr0 b_tot_le0 b_tot_mf0 
						 mac_words0 mac_unders0
						 bates_unsociable0 bates_difficult0 bates_unadaptable0 bates_unstoppable0
						 fci_play_mat_type0  fci_play_act0"; 

global child_tostd1 	"b_tot_cog1 b_tot_lr1 b_tot_le1 b_tot_mf1 
						 mac_words1 mac_phrases1
						 bates_unsociable1 bates_difficult1 bates_unadaptable1 bates_unstoppable1 
						 roth_attention1 roth_inhibit1 roth_sociable1 
						 fci_play_mat_type1 Npicbooks1 Npaintbooks1 Ntoysmade1 Ntoysbought1 Nthingsmove1 Ntoysshape1 
						 NtoysgivenML1 NtoysmadeML1 Ntoysmade1 Npicbooksi1
						 fci_play_act1 home_stories1 home_read1 home_toys1 home_name1 "; 

global mother_tostd0  	"edu_yrs_mo0 cesdA0 cesdB0 cesdC0 cesdD0 cesdE0 cesdF0 cesdG0 cesdH0 cesdI0 cesdJ0 "; 

global mother_tostd1  	"peabody_mo1 cesdA1 cesdB1 cesdC1 cesdD1 cesdE1 cesdF1 cesdG1 cesdH1 cesdI1 cesdJ1 raventot"; 

global X	 			"married0 married1 nkids1 nkids0 ln_nkids1 ln_nkids0 wealth_index0 
						adult_mags0 adult_books0 
						period_terrorism2		
						tpobc_pop1993  meanprice_juglibros_log FUmeanprice_log";
						 						 
global other 			"date_survey_fu1 stim_date_last_visit1
						totwklyhrs_mo1 mwork1 edu_yrs_mo1
						b_age_mth0 b_age_mth1 age_mo0 age_mo1 
						male premature_bayley_0 birthweight_0 stunted_TC_0 firstborn0 
						crowding0 wealth_index0 own_dwelling0 
						nim cod_dane group0 male eva_fu ent_fu llaveper region"; 
					 
global child_std1 "" ;
foreach var in  $child_tostd1{ ;
	global child_std1 "$child_std1 `var'_st " ;
} ;

global child_std0 "" ;
foreach var in  $child_tostd0{ ;
	global child_std0 "$child_std0 `var'_st " ;
} ;

global mother_std1 "" ;
foreach var in  $mother_tostd1{ ;
	global mother_std1 "$mother_std1 `var'_st " ;
} ;

global mother_std0 "" ;
foreach var in  $mother_tostd0{ ;
	global mother_std0 "$mother_std0 `var'_st " ;
} ;

global X_std "" ;
foreach var in  $X{ ;
	global X_std "$X_std `var'_st " ;
} ;


global measures 		"$child_std0 $child_std1 $mother_std0 $mother_std1 $X $X_std $other"; 
					
global covs_eva			"male i.eva_fu" ;

global covs_ent			"male i.ent_fu" ;

global covs_labor		"age_mo1 age_mo1_sq edu_yrs_mo1 nokids2 nokids3 nokids4 nokids5 nokids6plus i.ent_fu "  ;

global balance_child	"male b_age_mth0 premature_bayley_0 birthweight_0 stunted_TC_0 firstborn0 
						 b_tot_cog0_st b_tot_lr0_st b_tot_le0_st b_tot_mf0_st mac_words0_st
						 bates_difficult0_st bates_unsociable0_st bates_unadaptable0_st bates_unstoppable0_st"; 
								 
global balance_mother	"edu_yrs_mo0 married0 age_mo0	
						 cesdA0_st cesdB0_st cesdD0_st cesdE0_st cesdF0_st cesdG0_st cesdH0_st cesdI0_st cesdJ0_st "; 

global balance_hh		"crowding0 wealth_index0 own_dwelling0 fci_play_act0 fci_play_mat_type0 
						adult_books0 adult_mags0
						tpobc_pop1993  meanprice_juglibros_log FUmeanprice_log"; 
#delim cr 

********************************************************************************
* OTHER
********************************************************************************
gl outregopt 			"excel nocons nor2 stats(coef se) noaster dec(3)"


