* Figures on Age vs. Usage patterns

clear
set more off
cd  "~/Dropbox/IntlMedDevMkts/"
*capture log close
*log using output/Figures_3and4and5.smcl, replace

********************************************************************
* basics with raw data---EU and US
*Parameters_ageU = [ bootstrap*ones(size(age_u1,1),1) , [1:size(age_u1,1)]' , age_u1 , age_u0 ]
*filename = sprintf('../temp/Parameters_ageU_%d.csv',bootstrap);
*csvwrite(filename,Parameters_ageU)
insheet b age fe1 nn1 fe0 nn0 using temp/Parameters_ageU_0.csv , clear


foreach USe in 0 1 {

twoway (line fe`USe' age , lcolor(green) lwidth(thick)) ///
 	(line nn`USe' age , lcolor(orange) lpattern("-.") lwidth(thick)) ///
	, legend( order( 1 "age FE" 2 "NN") rows(1) size(large)) graphregion(color(white))  ///
	ytitle("Partial Effect of Age on Utility", size(large)) ylabel(-.7(.1).1,labsize(large)) ///
	xtitle("Age Since Introduction to Region (Months)",size(large)) xlabel(0(12)24,labsize(large))
graph export output/fig_aFE_vs_NN_`USe'.pdf, replace 

}

