%-------------------------------------------------------------------------
%-------------------------------------------------------------------------
% 1) Load/compute data, assumed parameters, and demand/supply estimates
% 2) UB scenario: Assume firms enter if E[\pi_j(Q_j,J(Tc,0))|I^{EU}_j] > FClaunch^{EU} + 0, as if there is no cost of longer trials, \chi = 0.
    % In data we observe firms that entered if
    % E[\pi_j(Q_j,J(0,0;J^{US}))|I^{EU}_j] > FClaunch^{EU} + 0 if only EU; and
    % additionally E[\pi_j^{US+EUextra}(Q_j,J(Tc^US,\chi Tc^{US}))|I^{EU}_j] >
    % FClaunch^{US} + \chi Tc^{US} if US also.
    % Need to establish new baseline Tc=0 for all (so less info on USj).
    % New price equilibrium and usage calculations required.
    % All same firms enter? Depends on worst Qj in data and FClaunch^{EU}.
    % More firms enter (?) than true EQ, so more choice, lower prices---CS UB sure, but PS?
% 3) LB scenario: Assume firms enter if E[\pi_j(Q_j,J(Tc,0))|I^{EU}_j] > FClaunch^{EU} + \chi Tc, as if \chi=1.6M/mo, but as if other firms treat \chi=0.
    % Only difference in entry from UB is that firms make single agent
    % calculation to not enter as cost \chi Tc rises vs. risk benefit.
    % Benefit if enter comes directly from UB.
    % Once entry determined, new price and usage equilibrium required.
    % Less firms enter than true EQ, so less choice, higher prices---CS LB sure, but PS?

clear all
if exist('~/IntlMedDevMkts/code')
cd('~/IntlMedDevMkts/code')
else
cd('~/Dropbox/IntlMedDevMkts/code')
end
%addpath('csvwrite_with_headers')

bootstrap = 0 % 0 for full sample; change for bootstrap samples

%--------------------------------------------------------
for modifier=1:11
modifier = modifier-1;

TrialCost_vector= [ 16 ];
for i=1:size(TrialCost_vector,2)
    TrialCost=TrialCost_vector(i);
    clear Cfcl

%% -------------------------------------------------------------------------
%-------------------------------------------------------------------------
% welfare numbers as a function of T_c, then pick optimal T_c (set identified)
Tc_min=1;
Tc_max=31;
Tc_vector = [Tc_min:1:Tc_max];
%
for clin = Tc_min:Tc_max
%Cfcl_Tc=[Risk_priors_UB';Risk_priors_LB';Risk_mean_UB;Risk_mean_LB;PctStent_UB;PctStent_LB;CS_UB;CS_LB;PS_UB;PS_LB;NewProducts_UB;NewProducts_LB;FC_UB;FC_LB;TSa_UB;TSa_LB];
%Cfcl_Tc = [ bootstrap*ones(size(Cfcl_Tc,1),1) , Tc*ones(size(Cfcl_Tc,1),1) , [1:size(Cfcl_Tc,1)]' , Cfcl_Tc ];
%filename = strcat('../temp/Cfcl_Tc',int2str(Tc),'_b',int2str(bootstrap),'.csv');
%Tc = clin-1;
filename = strcat('../temp/Cfcl_ObsLearn/Cfcl_Tc',int2str(clin),'_ObsLearn_m',int2str(modifier),'_FC',int2str(TrialCost),'_b',int2str(bootstrap),'.csv');
Cfcl_Tc = importdata(filename);
Cfcl(:,clin) = Cfcl_Tc(:,end);
end

CS_UB = Cfcl(9,:);
CS_LB = Cfcl(10,:);
avgP_UB = Cfcl(11,:);
avgP_LB = Cfcl(12,:);
PS_UB = Cfcl(13,:);
PS_LB = Cfcl(14,:);
FC_UB = Cfcl(17,:);
FC_LB = Cfcl(18,:);
TSa_UB = Cfcl(19,:);
TSa_LB = Cfcl(20,:);

%% -------------------------------------------------------------------------
%-------------------------------------------------------------------------
deltaTSa_UB = ( TSa_UB-TSa_UB(1) ) / TSa_UB(1) *100;
deltaTSa_LB = ( TSa_LB-TSa_LB(1) ) / TSa_LB(1) *100;
% compute identified set of optimal trial length Tc
[ TS_optimal_UB , TcTSub ] = max(deltaTSa_UB);
[ TS_optimal_LB , TcTSlb ] = max(deltaTSa_LB);
TcWindow = Tc_vector(deltaTSa_UB<=TS_optimal_LB);
TcWindow = [ Tc_min , TcWindow , Tc_max ]; %always should include Tc_min and max
TcUB_TS = min(TcWindow(TcWindow>=TcTSub))-1
TcLB_TS = max(TcWindow(TcWindow<=TcTSlb))-1
%

deltaCS_UB = ( CS_UB-CS_UB(1) ) / CS_UB(1) *100;
deltaCS_LB = ( CS_LB-CS_LB(1) ) / CS_LB(1) *100;
% compute identified set of optimal trial length Tc -- CS criterion
[ CS_optimal_UB , TcCSub ] = max(deltaCS_UB);
[ CS_optimal_LB , TcCSlb ] = max(deltaCS_LB);
TcWindow_CS = Tc_vector(deltaCS_UB<=CS_optimal_LB);
TcWindow_CS = [ Tc_min , TcWindow_CS , Tc_max ]; %always should include Tc_min and max
TcUB_CS = min(TcWindow_CS(TcWindow_CS>=TcCSub))-1
TcLB_CS = max(TcWindow_CS(TcWindow_CS<=TcCSlb))-1
%

deltaPS_UB = ( PS_UB-PS_UB(1) ) / PS_UB(1) *100;
deltaPS_LB = ( PS_LB-PS_LB(1) ) / PS_LB(1) *100;


%% -------------------------------------------------------------------------
%-------------------------------------------------------------------------
% Export results

%Cfcl_Optimal=[TcUB_TS;TcLB_TS;TcUB_CS;TcLB_CS;max(TSa_UB);max(TSa_LB);max(CS_UB);max(CS_LB)];
Cfcl_Optimal=[TcUB_TS;TcLB_TS;TcUB_CS;TcLB_CS;max(TSa_UB);max(TSa_LB);max(CS_UB);max(CS_LB)];
Cfcl_Optimal = [ bootstrap , modifier , Cfcl_Optimal' ]
filename = strcat('../temp/Cfcl_ObsLearn/Cfcl_Optimal','_ObsLearn_m',int2str(modifier),'_FC',int2str(TrialCost),'_b',int2str(bootstrap),'.csv');
csvwrite(filename,Cfcl_Optimal)

end
end

%
exit
