function [Sigma] ...
    = fcn_Estimate_Demand_DE( age, clinical, amc, lnsjs0, lnsjg , p, USe_jt, USe, check, ... 
    qm1, pm1 , LnsjgIV, ageIV, dum_g,XeT,aT, num_uniq_thg, num_uniq_th_ght, num_uniq_tj, ...
    Mht,Mt,h,tj,th,th_ght,thg,frac_zeros_jt,eta_jht,etaQW_jht,Nht,Ht,dum_ght,...
    sigmaQ2_inv_start, aFEversion, Sigma_fix, Sigma_start );

%Demand_Cfcn( Y , X , Xe , Zo , Zlasso , p , mc , sj , sjg , dum_g , g , Sigma );
g = size(dum_g,2);
%Sigma_start = [Thetap_start;Lambda_start;SigmaH_start;SigmaEU_start;SigmaA_start;GammaH_start]; 
% parameter constraints
constraints = [ 0,.0003 ; .95*[0*ones(g,1),ones(g,1)] ; 1*[0*ones(g,1),ones(g,1)] ; 20*[0*ones(1,1),ones(1,1)] ; 3*[0*ones(2,1),ones(2,1)] ; 0,1 ; 0,1 ; 0,2 ];
%constraints = constraints(1:LOOP(l),:);
%constraints = [];
% increments for grid
increments = [ .000025 ; .025*ones(g,1) ; .025*ones(g,1) ; .5*ones(1,1) ; .1*ones(2,1) ; .1 ; .1 ; .1 ];
%increments = increments(1:LOOP(l),:);

%--------------------------------------------------------------------------
% Differential Evolution options and run

% set title
optimInfo.title = 'Demand';
% specify objective function
objFctHandle = @Demand_Cfcn;
% define parameter names, ranges, quantizations and initial values :
%if aFEversion==2
    paramDefCell = {'', constraints(Sigma_fix(:,2)==0,:) , increments(Sigma_fix(:,2)==0,:) , Sigma_start };
%else
%    paramDefCell = {'', constraints(1:size(Sigma_start,1),:) , increments(1:size(Sigma_start,1),:) , Sigma_start };
%end
% (single vector-valued parameter with no name, as function foxholes is
% called with a parameter vector as only input) 

% no additional function parameters needed
%objFctSettings = {};
objFctSettings = { age, clinical, amc, lnsjs0, lnsjg , p, USe_jt, USe, check, ... 
    qm1, pm1 , LnsjgIV, ageIV, dum_g,XeT,aT, num_uniq_thg, num_uniq_th_ght, num_uniq_tj, ...
    Mht,Mt,h,tj,th,th_ght,thg,frac_zeros_jt,eta_jht,etaQW_jht,Nht,Ht,dum_ght,...
    sigmaQ2_inv_start, aFEversion, Sigma_fix };
% no parameter vector needed
objFctParams = [];
% get default DE parameters (F=.8,CR=.7,NP=30,...)
DEParams = getdefaultparams;
% comment out to play a short sound when a new best member was found
DEParams.playSound = 0;   
% 0 random pop; 1 uses guess; 2 makes 20% of pop noise near guess
DEParams.useInitParams = 1;
% set number of population members (often 10*D is suggested; here we use
% more as we know that the Foxholes functions has many local minima).
DEParams.NP = 200;
% DE-stepsize F from interval [0, 2]. A good initial guess is the interval 
% [0.5, 1], e.g. 0.8.
DEParams.F = 0.8;
% Crossover probability constant from interval [0, 1]. If the parameters are
% correlated, high values of CR work better. The reverse is true for no correlation.
DEParams.CR = 0.5;
% do not use slave process here
DEParams.feedSlaveProc = 0;
% save history
DEParams.saveHistory = 0;
% set times
DEParams.maxiter       = 20; % 5-10 may be fine for bootstrap (with simplex after)
DEParams.maxtime       = Inf;  % in seconds
DEParams.maxclock      = [];
% set display options
DEParams.refreshiter   = Inf;
DEParams.refreshtime   = Inf;  % in seconds
DEParams.refreshtime2  = Inf;  % in seconds
DEParams.refreshtime3  = Inf;  % in seconds
% do not send E-mails
emailParams = [];

% set random state in order to always use the same population members here
rng(0,'twister');
% start differential evolution
[Sigma, bestval] = ...
	differentialevolution(DEParams, paramDefCell, objFctHandle, ...
	objFctSettings, objFctParams, emailParams, optimInfo); 

%disp(' ');
%disp('Best parameter set returned by function differentialevolution:');
%disp(Sigma_l);



end