function [d_jht,q_jt,Ep_jt,adjAV_jt,CS_t] ...
    = fcn_Welfare( J,J_j, Sigma , dum_g , lnsjs0 , lnsjg , USe_jt , sigmaQ2_inv , amc , clinical , ...
        tj , etaQW_jht , eta_jht , thg , dum_ght , th_ght , th , Mht , p_jht , mc_jht , t_ht , Mht_ht, Mt , ...
        num_uniq_thg, num_uniq_th_ght, num_uniq_tj, num_uniq_t_ht, ...
        scale );

%--------------------------------------------------------------------
% Demand parameters
thetap = Sigma(1);
Lambda = Sigma(2:size(dum_g,2)+1,:);
sigmaH2 = Sigma(size(dum_g,2)+2:2*size(dum_g,2)+1,:);
sigmaEU2_inv = Sigma(2*size(dum_g,2)+2);
sigmaAc2_inv  = Sigma(2*size(dum_g,2)+3);
sigmaA2_inv  = Sigma(2*size(dum_g,2)+4);
gammaH = Sigma(2*size(dum_g,2)+5);
% Implied jt-level utility parameters
lambda = dum_g*Lambda;
lambda_ght=dum_ght*Lambda;
sigmaH2_jt = dum_g*sigmaH2;
R = sigmaH2_jt./ (2*(1-lambda).^2);
dQW_jt = lnsjs0 - lnsjg.*lambda - (1-lambda).*R;
sigma2_jt = 1./( USe_jt*sigmaQ2_inv + sigmaEU2_inv + amc.*sigmaA2_inv + clinical.*sigmaAc2_inv );
w_signals_jt = sigma2_jt.*(amc.*sigmaA2_inv + clinical.*sigmaAc2_inv);
d_jt = dQW_jt - .5*gammaH*(w_signals_jt.*sigma2_jt)./(1-lambda);

%--------------------------------------------------------------------
% jht-level Ep and CS,AV (need to aggregate over these to get market level)
%choice probabilities at estimated Demand params
%blow up to h level
J_jht = J(tj,:);  
% compute market shares for this guess
sigma_jht = (gammaH.*(w_signals_jt.*sigma2_jt)).^.5;
sigmaH_jt = dum_g*(sigmaH2.^.5);
d_jht = d_jt(tj,:) + sigmaH_jt(tj,:).*etaQW_jht + sigma_jht(tj,:).*eta_jht;
u_jht = exp(d_jht./(1-lambda(tj,:))) .*J_jht; %u_jht=0 if J=0 will flow through
I_ght = accumarray([thg,ones(size(thg,1),1)], u_jht, [num_uniq_thg 1], @sum);
cp_jght = u_jht./(I_ght(thg,:));
I_ht = accumarray([th_ght,ones(size(th_ght,1),1)], I_ght.^(1-lambda_ght), [num_uniq_th_ght 1], @sum);
cp_ght = I_ght(thg,:).^(1-lambda(tj,:)) ./ ( 1 + I_ht(th,:) );
cp_jht = cp_ght .* cp_jght;
% q
q_jht = cp_jht.*Mht;
q_jt = accumarray([tj,ones(size(tj,1),1)], q_jht.*J_jht , [num_uniq_tj 1], @sum);
q_jht(J_jht==0)=1; %can't divide by 0, but AV will =0 so will be okay
% Ep
Ep_jht = -thetap .* (p_jht-mc_jht) .* ( 1./(1-lambda(tj,:)) - lambda(tj,:)./(1-lambda(tj,:)) .* cp_jght - cp_jht);
%mean(Ep_jht)
%min(Ep_jht)
Ep_jt = accumarray([tj,ones(size(tj,1),1)], Mht.*Ep_jht.*J_jht , [num_uniq_tj 1], @sum) ./ Mt;
% CS
CS_ht = scale*Mht.*reallog( 1 + I_ht(th,:) ) ;
CS_t = accumarray([t_ht,ones(size(t_ht,1),1)], scale*Mht_ht.*reallog( 1 + I_ht ) , [num_uniq_t_ht 1], @sum) ;
% AV
I_ght_nj = I_ght(thg,:)-u_jht;
I_ht_nj = I_ht(th,:) - I_ght(thg,:).^(1-lambda(tj,:)) + I_ght_nj.^(1-lambda(tj,:));
CS_ht_nj = scale*Mht.*reallog( 1 + I_ht_nj ) ;
AV_jht = (CS_ht - CS_ht_nj) ./ q_jht;
adjAV_jht = (1+Ep_jht).*AV_jht;
adjAV_jt = accumarray([tj,ones(size(tj,1),1)], Mht.*adjAV_jht.*J_jht , [num_uniq_tj 1], @sum) ./ Mt;

end








