clear all
cd ~/IntlMedDevMkts/output/Cfcl_Optonly_v3

loc resultfilename "bigtable_v3"

* sample table
import delim using Cfcl_Optimal_param7_mod4_b0_dc1_us0_mc1_siga21_sigac1, clear
keep v1-v9
keep if _n == 0

save ../`resultfilename'.dta, replace


program define buildtable
	args mod ptc us dc mc sig1 sig2 tablename
	import delim using Cfcl_Optimal_param`ptc'_mod`mod'_b0_dc`dc'_us`us'_mc`mc'_siga2`sig1'_sigac`sig2', clear
	keep v1-v9
	tempfile 
	append using ../`tablename'.dta
	save ../`tablename'.dta, replace

	loc ct = 0
	forval bs = 1/100{
		cap import delim using Cfcl_Optimal_param`ptc'_mod`mod'_b`bs'_dc`dc'_us`us'_mc`mc'_siga2`sig1'_sigac`sig2', clear varnames(nonames)
		keep v1-v9
		if _rc == 0{
		*	qui destring *, replace force
			if `ct' == 0{
				tempfile se
				qui save `se', replace
				loc ct = 2
			}
			else{
				qui append using `se'
				qui save `se', replace
			}
		}
	}
	use `se', clear
	collapse (sd) *
	append using ../`tablename'.dta
	save ../`tablename'.dta, replace
end


* BASE
buildtable 4 7 0 1 1 1 1 `resultfilename'
* EU
buildtable 4 7 1 1 1 1 1 `resultfilename'
* Discount 
forval dis = 1/3{
	buildtable 4 7 0 `dis' 1 1 1 `resultfilename'
}
*  MC
forval mc = 1/3{
	buildtable 4 7 0 1 `mc' 1 1 `resultfilename'
}
* POST MKT
forval postmkt = 1/11{
	buildtable 4 7 0 1 1 `postmkt' 1 `resultfilename'
}
* FC, SigQ, Rho
forval ptc = 1/3{
	forval mod = 1/7{
		buildtable `mod' `ptc' 0 1 1 1 1 `resultfilename'
	}
}
* Inv Sig
forval sig2 = 1/11{
	buildtable 4 4 0 1 1 1 `sig2' `resultfilename'
}
* No DES/ NO Stent
forval stent = 5/6{
	buildtable 4 `stent' 0 1 1 1 1 `resultfilename'
}

use ../`resultfilename'.dta, clear
drop v1
gen order = _n
gsort -order 
gen mod = mod(order, 2)
replace v4 = v4 - 1 if mod == 0
replace v5 = v5 - 1 if mod == 0
replace v8 = v8 - 1 if mod == 0
replace v9 = v9 - 1 if mod == 0
order v3 v2 v5 v4 v7 v6 v9 v8
save ../`resultfilename'.dta, replace
