* Show amount of EU stents implanted that are not available in US

cd  "~/Dropbox/IntlMedDevMkts/"
clear
use data/EUdata_agg

bysort t: egen Qnever = total(q) if USeventual==0
bysort t: egen Qnow = total(q) if USlater==1
collapse (sum) Q=q (max) Qnever Qnow, by(t)
gen Snever=Qnever/Q
gen Snow=(Qnever+Qnow)/Q

twoway (line Snow t, sort lcolor(navy) lpattern("_.") lwidth(thick) )  /// 
		   (line Snever t, sort lcolor(navy) lpattern(".....-") lwidth(thick) ), ///
           ytitle("Share in the EU",size(large)) yscale(range(0 1)) ylabel(0(0.2)1,labsize(large)) ytick(0(0.2)1) /// 
           xtitle("")   ///
           legend(order(1 "Currently not in US" 2 "Never in US") rows(1) size(large))  ///
           xlabel(1(12)97) xlabel(13 "Jan 05" 37 "Jan 07" 61 "Jan 09" 85 "Jan 11" 109 "Jan 13",labsize(large)) ///
           graphregion( color(white) )
graph export output/fig_EUnotinUS.pdf, replace 

su Snow Snever
