* ATE(Qj) vs. time

clear
set more off
cd  "~/Dropbox/IntlMedDevMkts/"

********************************************************************
* merge data sets

* product entry dates collapse and clean
clear
use data/EUdata_agg
*
preserve
collapse (count) Jt=p , by(t)
sort t
tempfile temp_Jt    
save "`temp_Jt'"  
restore
*
append using data/USdata_agg
keep manufacturer product t j tj enterEU age USeventual enterUS pay
gen age_enterEU = age if t==enterEU
gen age_enterUS = age if t==enterUS
collapse (min) j enterEU enterUS USeventual age_enterEU age_enterUS pay, by(manufacturer product)
replace age_enterEU = 1 if age_enterEU==. & enterEU~=.
replace age_enterUS = 1 if age_enterUS==. & enterUS~=.
gen EUentryDate = dofm(mofd(date("January 01 2004","MDY")) + enterEU - age_enterEU)
gen USentryDate = dofm(mofd(date("January 01 2004","MDY")) + enterUS - age_enterUS)
format EUentryDate USentryDate %td
sort j
tempfile temp1    
save "`temp1'"      
* merge Qj from demand estimates
insheet b j EpiQj1 using "temp/Parameters_Epi_0.csv", clear
drop b
rename epiqj1 EpiQj1
sort j
merge 1:m j using "`temp1'" , keep(match) nogen
*

********************************************************************
* Distribution of EpiQj1

replace EpiQj1=EpiQj1/1e6

su EpiQj1, detail
histogram EpiQj1, width(25) start(0) fraction ///
 	graphregion(color(white)) ///
	ytitle("Fraction of Products",size(large)) ylabel(,labsize(large)) ///
	xtitle("Expected Lifetime Profits at EU Entry ($ Millions)",size(large)) xlabel(,labsize(large)) 
graph export "output/fig_EpiQj1_distribution.pdf", replace 
su EpiQj1 if EpiQj1>25
histogram EpiQj1 if EpiQj1>25, width(25) start(0) fraction ///
 	graphregion(color(white)) ///
	ytitle("Fraction of Products (|>$25M)",size(large)) ylabel(,labsize(large)) ///
	xtitle("Expected Lifetime Profits at EU Entry ($ Millions)",size(large)) xlabel(,labsize(large)) 
graph export "output/fig_EpiQj1_distribution_gt25M.pdf", replace 

bysort USeventual: su EpiQj1, detail

preserve
keep if pay==1
su EpiQj1, detail
histogram EpiQj1, width(25) start(0) fraction ///
 	graphregion(color(white)) ///
	ytitle("Fraction of Products",size(large)) ylabel(,labsize(large)) ///
	xtitle("Expected Lifetime Profits at EU Entry ($ Millions)",size(large)) xlabel(,labsize(large)) 
graph export "output/fig_EpiQj1_distribution_pay1.pdf", replace 
su EpiQj1 if EpiQj1>25
histogram EpiQj1 if EpiQj1>25, width(25) start(0) fraction ///
 	graphregion(color(white)) ///
	ytitle("Fraction of Products (|>$25M)",size(large)) ylabel(,labsize(large)) ///
	xtitle("Expected Lifetime Profits at EU Entry ($ Millions)",size(large)) xlabel(,labsize(large)) 
graph export "output/fig_EpiQj1_distribution_gt25M_pay1.pdf", replace 
bysort USeventual: su EpiQj1, detail
restore

