version 14
#delimit;
set more off;


global data_dir "/Users/davidsblakeslee/Dropbox/Karnataka Water Depletion Study" //put your directory here;
global table_dir "/Users/davidsblakeslee/Dropbox/Karnataka Water Depletion Study/Tables" // put your directory here;


use "$data_dir/final_data_AER.dta", clear;



global strformat "%8.3f";

capture program drop sig_p;
program sig_p;
   args obj_var point_est_var point_sd_var p_val row_id_var row_num;
   local point_est `point_est_var';
   local point_sd `point_sd_var';
   if `p_val' > 0.1 {;
      replace `obj_var' = string(`point_est', "$strformat") if `row_id_var' == `row_num';
      };
   if `p_val' > 0.05 & `p_val' <= 0.1  {;
      replace `obj_var' = string(`point_est', "$strformat")+"*" if `row_id_var' == `row_num';
      };
   if `p_val' > 0.01 & `p_val' <= 0.05  {;
      replace `obj_var' = string(`point_est', "$strformat")+"**" if `row_id_var' == `row_num';
      };
   if `p_val' <= 0.01 {;
      replace `obj_var' = string(`point_est', "$strformat")+"***" if `row_id_var' == `row_num';
      };
   replace `obj_var' = "[" + string(`point_sd', "$strformat") + "]" + " " if `row_id_var' == `row_num' + 1;
   end;



   
foreach var of varlist 
	hh_head_literate hh_head_age total_land_inherited caste_non_marginal {;
	
	gen cm_`var' = `var';
	replace cm_`var' = 0 if `var' == .;
	
	gen msng_`var' = (`var' == .);
	
};


global hh_head_controls 
	"cm_hh_head_literate cm_hh_head_age cm_total_land_inherited cm_caste_non_marginal
	msng_hh_head_literate msng_hh_head_age msng_total_land_inherited msng_caste_non_marginal"; 


generate row_num = _n;


	
local row = 4;
forvalues i=0(1)25 {;
	generate col`i' = "";
};

order col*;
sort row_num;
	
	
foreach var of varlist 
	r_pct_hh_mem_ownfarm_a r_pct_hh_mem_aglabor_a 
	r_pct_hh_mem_wagelabor_a 
	r_pct_hh_mem_notworking_a 
	r_pct_hh_mem_outvillwork_a
	pct_hh_mem_snlmigrat_a {;

	replace col0 = "`var'" if row_num == `row';
	
	reghdfe `var' first_bw_failed
		$hh_head_controls
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled)  cluster(villcode);
	test first_bw_failed;
	sig_p col2 _b[first_bw_failed] _se[first_bw_failed] r(p) row_num `row';

	reghdfe `var' first_bw_failed_nonimm
		$hh_head_controls
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled)  cluster(villcode);
	test first_bw_failed_nonimm;
	sig_p col4 _b[first_bw_failed_nonimm] _se[first_bw_failed_nonimm] r(p) row_num `row';
	
	reghdfe `var' first_bw_immfailed
		$hh_head_controls
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled)  cluster(villcode);
	test first_bw_immfailed;
	sig_p col6 _b[first_bw_immfailed] _se[first_bw_immfailed] r(p) row_num `row';

		
	local row = `row' + 3;
	
};

local row = `row' + 1;

foreach source in 
	onfarm offfarm total  {;

	replace col0 = "level `source' inc" if row_num == `row';
	
	replace inc_`source'_2015 = inc_`source'_2015/1000;
	
	reghdfe inc_`source'_2015 first_bw_failed
		$hh_head_controls
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled)  cluster(villcode);
	test first_bw_failed;
	sig_p col2 _b[first_bw_failed] _se[first_bw_failed] r(p) row_num `row';

	reghdfe inc_`source'_2015 first_bw_failed_nonimm
		$hh_head_controls
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled)  cluster(villcode);
	test first_bw_failed_nonimm;
	sig_p col4 _b[first_bw_failed_nonimm] _se[first_bw_failed_nonimm] r(p) row_num `row';
	
	reghdfe inc_`source'_2015 first_bw_immfailed
		$hh_head_controls
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled)  cluster(villcode);
	test first_bw_immfailed;
	sig_p col6 _b[first_bw_immfailed] _se[first_bw_immfailed] r(p) row_num `row';
	
		
	local row = `row' + 3;
	
};



order col0-col25;
sort row_num;	


outsheet col0-col6 using "$table_dir/_TableA7 alternative failure measures (AER).csv" if
	row_num < `row', comma replace;

	
tab first_bw_failed if bw_never ~= 1 & household_level == 1;
tab first_bw_immfailed if bw_never ~= 1 & household_level == 1;
tab first_bw_failed_nonimm if bw_never ~= 1 & household_level == 1;

