version 14
#delimit;
set more off;


global data_dir "/Users/davidsblakeslee/Dropbox/Karnataka Water Depletion Study" //put your directory here;
global table_dir "/Users/davidsblakeslee/Dropbox/Karnataka Water Depletion Study/Tables" // put your directory here;


use "$data_dir/final_data_AER.dta", clear;



global strformat "%8.3f";
global strformat_2 "%8.0f";

capture program drop sig_p;
program sig_p;
   args obj_var point_est_var point_sd_var p_val row_id_var row_num;
   local point_est `point_est_var';
   local point_sd `point_sd_var';
   if `p_val' > 0.1 {;
      replace `obj_var' = string(`point_est', "$strformat")+" [" + string(`point_sd', "$strformat") + "]" if `row_id_var' == `row_num';
      };
   if `p_val' > 0.05 & `p_val' <= 0.1  {;
      replace `obj_var' = string(`point_est', "$strformat")+"*"+" [" + string(`point_sd', "$strformat") + "]" if `row_id_var' == `row_num';
      };
   if `p_val' > 0.01 & `p_val' <= 0.05  {;
      replace `obj_var' = string(`point_est', "$strformat")+"**"+" [" + string(`point_sd', "$strformat") + "]" if `row_id_var' == `row_num';
      };
   if `p_val' <= 0.01 {;
      replace `obj_var' = string(`point_est', "$strformat")+"***"+" [" + string(`point_sd', "$strformat") + "]" if `row_id_var' == `row_num';
      };
   end;


foreach var of varlist 
	hh_head_literate hh_head_age total_land_inherited caste_non_marginal {;
	
	gen cm_`var' = `var';
	replace cm_`var' = 0 if `var' == .;
	
	gen msng_`var' = (`var' == .);
	
};


global hh_head_controls 
	"cm_hh_head_literate cm_hh_head_age cm_total_land_inherited cm_caste_non_marginal
	msng_hh_head_literate msng_hh_head_age msng_total_land_inherited msng_caste_non_marginal";




generate row_num = _n;


bysort villcode: gen village_level = _n;
replace village_level = . if village_level > 1;

bysort district_name: gen district_level = _n;
replace district_level = . if district_level > 1;



local row = 4;
forvalues i=0(1)25 {;
	generate col`i' = "";
};

order col*;
sort row_num;

replace inc_total_2015 = inc_total_2015/1000;		
replace inc_onfarm_2015 = inc_onfarm_2015/1000;
replace inc_offfarm_2015 = inc_offfarm_2015/1000;

gen bw_ever = (bw_never == 0) if bw_never ~= .;

su district_level if district_name ~= "";
replace col3 = string(r(N), "$strformat_2") if row_num == `row';
replace col0 = "num districts" if row_num == `row';
local row = `row' + 2;
su village_level if villcode ~= .;
replace col3 = string(r(N), "$strformat_2") if row_num == `row';
replace col0 = "num villages" if row_num == `row';
local row = `row' + 2;
su household_level;
replace col3 = string(r(N), "$strformat_2") if row_num == `row';
replace col0 = "num households" if row_num == `row';
local row = `row' + 2;

su bw_ever if household_level == 1 & bw_ever == 1 [aw=hh_weight_norm_fs];
replace col3 = string(r(N), "$strformat_2") if row_num == `row';
replace col0 = "num hhs ever drilled" if row_num == `row';
local row = `row' + 4;

replace first_bw_cost = first_bw_cost/10000;

foreach var of varlist 
	first_bw_ydrilled first_bw_depth {;

	replace col0 = "`var'" if row_num == `row';
	
	su `var' [aw=hh_weight_norm], detail;
	replace col3 = string(r(mean), "$strformat_2") + " [" + string(r(sd), "$strformat_2") + "]" if row_num == `row';
	
	local row = `row' + 2;
	
};

foreach var of varlist 
	first_bw_cost first_bw_failed {;

	replace col0 = "`var'" if row_num == `row';
	
	su `var' [aw=hh_weight_norm];
	replace col3 = string(r(mean), "$strformat") + " [" + string(r(sd), "$strformat") + "]" if row_num == `row';
	
	local row = `row' + 2;
	
};

foreach var of varlist 
	first_bw_yfailed {;

	replace col0 = "`var'" if row_num == `row';
	
	su `var' [aw=hh_weight_norm];
	replace col3 = string(r(mean), "$strformat_2") + " [" + string(r(sd), "$strformat_2") + "]" if row_num == `row';
	
	local row = `row' + 2;
	
};

local row = `row' + 4;

foreach var of varlist 
	caste_non_marginal hh_head_literate hh_head_age house_pucca house_electricity
	bpl_household
	
	total_land_inherited 
	asset_value_2015 {;

	replace col0 = "`var'" if row_num == `row';
	
	su `var' if bw_non_operational == 0 & household_level == 1 [aw=hh_weight_norm_fs];
	replace col2 = string(r(mean), "$strformat") if row_num == `row';

	su `var' if bw_non_operational == 1 & household_level == 1 [aw=hh_weight_norm_fs];
	replace col4 = string(r(mean), "$strformat") if row_num == `row';
	
	
	reg `var' bw_non_operational if household_level == 1 [pw=hh_weight_norm_fs], cluster(villcode);
	test bw_non_operational;
	sig_p col6 _b[bw_non_operational] _se[bw_non_operational] r(p) row_num `row';

	reghdfe `var' bw_non_operational if household_level == 1 [pw=hh_weight_norm_fs], absorb(villcode) cluster(villcode);
	test bw_non_operational;
	sig_p col7 _b[bw_non_operational] _se[bw_non_operational] r(p) row_num `row';

	
	local row = `row' + 2;
	
};

local row = `row' + 1;


foreach var of varlist 
	inc_total_2015 inc_onfarm_2015 inc_offfarm_2015 {;

	replace col0 = "`var'" if row_num == `row';
	
	su `var' if bw_non_operational == 0 & household_level == 1 [aw=hh_weight_norm_fs];
	replace col2 = string(r(mean), "$strformat") if row_num == `row';

	su `var' if bw_non_operational == 1 & household_level == 1 [aw=hh_weight_norm_fs];
	replace col4 = string(r(mean), "$strformat") if row_num == `row';
	
	
	reg `var' bw_non_operational if household_level == 1 [pw=hh_weight_norm_fs], cluster(villcode);
	test bw_non_operational;
	sig_p col6 _b[bw_non_operational] _se[bw_non_operational] r(p) row_num `row';

	reghdfe `var' bw_non_operational if household_level == 1 [pw=hh_weight_norm_fs], absorb(villcode) cluster(villcode);
	test bw_non_operational;
	sig_p col7 _b[bw_non_operational] _se[bw_non_operational] r(p) row_num `row';

	
	local row = `row' + 2;
	
};

local row = `row' + 1;

foreach var of varlist 
	r_pct_hh_mem_ownfarm_a r_pct_hh_mem_aglabor_a 
	r_pct_hh_mem_wagelabor_a r_pct_hh_mem_notworking_a r_pct_hh_mem_outvillwork_a pct_hh_mem_snlmigrat_a {;

	replace col0 = "`var'" if row_num == `row';
	
	su `var' if bw_non_operational == 0 & household_level == 1 [aw=hh_weight_norm_fs];
	replace col2 = string(r(mean), "$strformat") if row_num == `row';

	su `var' if bw_non_operational == 1 & household_level == 1 [aw=hh_weight_norm_fs];
	replace col4 = string(r(mean), "$strformat") if row_num == `row';
	
	reg `var' bw_non_operational if household_level == 1 [pw=hh_weight_norm_fs], cluster(villcode);
	test bw_non_operational;
	sig_p col6 _b[bw_non_operational] _se[bw_non_operational] r(p) row_num `row';

	reghdfe `var' bw_non_operational if household_level == 1 [pw=hh_weight_norm_fs], absorb(villcode) cluster(villcode);
	test bw_non_operational;
	sig_p col7 _b[bw_non_operational] _se[bw_non_operational] r(p) row_num `row';

	
	local row = `row' + 2;
	
};


order col0-col25;
sort row_num;
outsheet col0-col6 using "$table_dir/_Table1 summary stats (AER).csv" if
	row_num < `row', comma replace;
	
