version 14
#delimit;
set more off;


global data_dir "/Users/davidsblakeslee/Dropbox/Karnataka Water Depletion Study" //put your directory here;
global table_dir "/Users/davidsblakeslee/Dropbox/Karnataka Water Depletion Study/Tables" // put your directory here;


use "$data_dir/borewell_census_data_AER.dta", clear;


eststo: reg fail number_sources ln_age;           
eststo: reg fail number_sources ln_age ln_depth;  

esttab using "$table_dir/_TableA3_borewell_census_AER.csv", replace
keep (number_sources ln_age ln_depth _cons)
order (number_sources ln_age ln_depth _cons)
cells(b(star fmt(%9.3f)) se(abs par fmt(%9.3f)) )
extracols(1)
starlevels (* 0.10 ** 0.05 *** 0.01) label
stats (r2 N, fmt(%9.3f %9.0g) labels(R-squared));	
estimates clear;
