cd "C:\figures"
	  
**************************************
* Figure_1.pdf: historical evolution *
**************************************

use "Charts_historical_data.dta", clear
label var treasuries_financial_sector "Treasuries held by financial sector"
label var deposits "Household deposits"
label var treasuries_row "Treasuries held by the RoW (RHS)"
twoway(line deposits date, lpattern(solid) lwidth(medium) lcolor(gs10) xlabel(#5,angle(0)) xtitle("") ylabel(0(2000)10000, angle(0) axis(2)) ///
	                       ytitle("Deposits and Treasuries, in billion $", axis(2)) c(l) yaxis(2) ///
						   tline(2007q3 2008q4, lcolor(gs0) lwidth(medium))) ///
	  (line treasuries_financial_sector  date,  lpattern(solid) lwidth(medium) lcolor(gs0) ///
                            ytitle("Treasuries, in billion $") xmtick(##4) ylabel(0(500)2000, angle(0)) ///
 	                       legend(bplacement(nw) region(fcolor(gs15)) ring(0)) legend(cols(1))) ///
      (line treasuries_row date, lpattern(dash) lwidth(medium) lcolor(gs0) ylabel(0(2000)10000, angle(0) axis(2)) ///
	                       ytitle("Deposits and Treasuries, in billion $", axis(2)) c(l) yaxis(2) )

								   
							   
***************************************
* Figure_2.pdf: repo and ABCP markets *
***************************************
	 
use "Charts_data.dta", clear
label var repos "Repo"
label var abcp "ABCP"
label var  abs2depositsnormalised "ABS (incl. CDO)"
label var cdo2depositsnormalised "CDO (incl. CDO squared)"	 
twoway (line repos   date, lpattern(solid) lwidth(medium) lcolor(gs0) ///
                           xlabel(#10,angle(45)) xtitle("") ytitle("normalised to one in 2007q2") xlabel(#6,angle(0)) xmtick(##4) ylabel(#5, angle(0)) ymtick(0(0.1)1.1) ///
                           tline(2007q3 2008q4, lcolor(gs0) lpattern(dot) lwidth(medium)) ///
                           ) ///
       (line abcp    date, lpattern(dash) lwidth(medium) lcolor(gs0))   ///
	   (line abs2depositsnormalised date, lpattern(solid) lline 1 in the DO file)width(medium) lcolor(gs10)) ///
	   (line cdo2depositsnormalised date, lpattern(dash) lwidth(medium) lcolor(gs10) ///
 	   legend(bplacement(ne) ring(0) region(fcolor(gs15))) ///
	   legend(cols(1))    ) 

	   
***********************
* Figure_3.pdf: rates *
***********************
	 
use "Charts_data.dta", clear
gen corporate_spread_inv = usd3mtd156n/corporate_rate
label var usd3mtd156n "3-Month LIBOR"
label var fedfunds "Fed Fund rate"
label var corporate_rate "Corporate loan rate"
label var corporate_spread_inv "3-Month LIBOR / Corp. rate (RHS)"
twoway (line usd3mtd156n date, lpattern(solid) lwidth(medium) lcolor(gs10) ///
                           xlabel(#10,angle(45)) xtitle("") ytitle("Rates, in %") xlabel(#6,angle(0)) xmtick(##4) ylabel(0(2)10, angle(0)) ///
                           tline(2007q3 2008q4, lcolor(gs0) lpattern(dot) lwidth(medium)) ///
 	                       legend(size(vsmall) bplacement(ne) region(fcolor(gs15)) ring(0)) legend(cols(1))) ///
      (line fedfunds date, lpattern(dash) lwidth(medium) lcolor(gs10)) ///
      (line corporate_rate date, lpattern(dash) lwidth(medium) lcolor(gs0)) ///
      (line corporate_spread_inv date, msymbol(O) connect(none) lpattern(solid) lwidth(medium) lcolor(gs0) ylabel(0(0.2)1, angle(0) axis(2)) ///
	                       ytitle("3-Month LIBOR / Corporate loan rate", axis(2)) c(l) yaxis(2) )
		  	  
	
	  
	  
	  
	  
	  
	  
	  
	  
	  
	  
	  
	  
	  
	  
