
/*************************************************************/
/* Bunching at alternative kinks, 66-69 year olds, 1996-2004 */
/*************************************************************/

local sample "$sampleList"
** Look at bunching at alternative possible kinks for 66-69 year olds, 2000-2004

	if "`sample'" == "s1Main"               local sampleTitle "1% Sample, claim by 65, no SE Income"
	if "`sample'" == "s1Full"               local sampleTitle "1% Sample, no SE Income"
	if "`sample'" == "s1Both"               local sampleTitle "1% Sample, claim by 65"
	if "`sample'" == "s1SE"                 local sampleTitle "1% Sample, claim by 65, SE income"
	if "`sample'" == "s1Claim"              local sampleTitle "1% Sample, claimed, no SE income"
	if "`sample'" == "s1Placebo"            local sampleTitle "1% Sample, not yet claimed"
	
	** Load the 1996-2004 data for 66-69 year olds
	local a1 = 66 
	local a2 = 69
	local y1 = 1996
	local y2 = 2004
	local bw = 800
	
	# delimit ;
	use "$datadir/cfopSSA_`sample'_`bw'" if 
		age>=`a1' & age<=`a2' &
		year>=`y1' & year<=`y2', 
		clear 
	;
	# delimit cr
	

	** collapse dataset to counts
	collapse (sum) count (mean) real_threshold, by(realDistanceRound year)
	gen rd1k = realDistanceRound / 1e3
	egen total = total(count), by(year)
	gen prob = count/total
	
	keep if realDistanceRound<=5e4
	gen panelVar = realDistanceRound/`bw'
	tsset year panelVar
	gen original = 1
	tsfill
	gen filledIn = missing(original)
	assert missing(realDistanceRound) & missing(count) & missing(prob) if filledIn
	replace realDistanceRound = `bw'*panelVar if filledIn
	replace prob = 0 if filledIn
	replace rd1k = realDistanceRound/1e3
    
    
    * Three kinks: 62-64 year old, 65 year old, inflate 66-69 year old 1999 kink by CPI-U (almost identical to inflating by SSA index)
    forvalues k = 2/4{
        gen kink`k' = real_threshold if year<2000
    }
    ** Real threshold for pre-nra people
    replace kink2 = 12764.25366 if year == 2000
    replace kink2 = 13149.848 if year == 2001
    replace kink2 = 13672.43847 if year == 2002
    replace kink2 = 13652.20174 if year == 2003
    replace kink2 = 13436.58994 if year == 2004

    ** Inflate 1999 threshold by CPI-U
    replace kink3 = 20969 if year == 2000
    replace kink3 = 21566 if year == 2001
    replace kink3 = 21907 if year == 2002
    replace kink3 = 22406 if year == 2003
    replace kink3 = 23003 if year == 2004
    
    
    ** Inflate 2000 threshold by CPI-U
    replace kink4 = real_threshold if year == 2000
    replace kink4 = 22139.57244 if year == 2001
    replace kink4 = 22489.6052 if year == 2002
    replace kink4 = 23002.15318 if year == 2003
    replace kink4 = 23614.71052 if year == 2004

    ** Adjust by real_threshold
    forvalues k = 2/4{
        replace kink`k' = kink`k' - real_threshold
    }
    
    
    ** Make time series plot, graphs
    gen order = _n
    sort order

    local row   0
    forvalues k = 1/4{
        gen b`k'       = .
        gen b`k'SE     = .
        gen b`k'SEDM   = . 
    }
    gen yearPost = . 
    
    ** define kink as +/- 3k 
    local exclude = int(3000/`bw')
		local cfop2004 ""
    qui sum year
		local yMax = min(r(max), 2004)
		if `yMax' >= 2004 local cfop2004 "cfop2004"
    qui forvalues year = 1996/`yMax'{
    
        ** max values for ig high/low 
        local max = 30000
        local min = -10000
        sum realDistanceRound if year == `year'
        local max = min(`r(max)', `max')

        ** set sample 
        gen sample =  year == `year' & realDistanceRound<=`max' & realDistanceRound>=`min'
        sum real_threshold if sample
        local zstar = r(mean)

        # delimit ;
        capture bunchPoly realDistanceRound prob if sample, 
            kink(0) exclude(`exclude') bw(`bw') degree(7) keep(1) print(0) nboot(100)
        ;
        # delimit cr            
        local rc = _rc
        
        ** fill in for graphing 
        local ++row
        sort order
        replace yearPost    = `year' in `row'
        if _rc == 0{
            replace b1           = r(scaledMass) in `row'
            replace b1SE         = r(scaledMassBS) in `row'
            replace b1SEDM       = r(scaledMassSE) in `row'
        }
        if _rc != 0{
            local rc = _rc
            noisily di "year = `year', a1 = `a1', bw = `bw', sample = `sample': error code: `rc'"
        }
        
        local nox "nolabel"
        local noy "nolabel"
        if `year' == 1996 | `year' == 1999 | `year' == 2002 local noy ""  
        if `year' == 2002 | `year' == 2003 | `year' == 2004 local nox ""       
            
        if `rc' != 0{
            ** make a filler graph 
            gen zero_temp = 0 in 1
            # delimit ;
            twoway scatter zero_temp realDistanceRound if _n==1, 
                name(cfop`year', replace) legend(off) xtitle("") ytitle("") title("") 
                xlabel(,nolabel) ylabel(,nolabel)
                graphregion(color(white))
            ;
            # delimit cr
            drop zero_temp
        }
        
        if `rc' == 0{
            local l2 = 0
            local l3 = 0
            local l4 = 0
            
            forvalues k = 2/4{
                sum kink`k' if year == `year'
                local l`k' = `r(mean)'/1000
            }
            noisily di "  year: `year', k2: `l2', k3: `l3', k4: `l4'"
            # delimit ;
            twoway 
                (connected prob rd1k if !missing(smoothDensity),  lcolor(edkblue) mcolor(navy) msize(small))
                (line smoothDensity rd1k if !missing(smoothDensity),  lcolor(cranberry)),
                title("`year'", ring(0))
                xlabel(#4, `nox' labsize(large))
                xtitle("")
                xline(0 `l2' `l3' `l4', lcolor(gs12))
                ylabel(#4, `noy' labsize(large))
                legend(off)
                graphregion(color(white))
                name(cfop`year', replace)
            ; 
            # delimit cr
        }
        
        ** Look at bunching at alternative kinks
        forvalues k = 2/4 {
            gen rd`k' = realDistanceRound-round(kink`k', `bw')
            sum rd`k' if year == `year'
            local max = min(`r(max)', 3e4)
            replace sample = year == `year' & rd`k'>=-1e4 & rd`k'<=`max'
            # delimit ;
            capture bunchPoly rd`k' prob if sample, 
                kink(0) exclude(`exclude') bw(`bw') degree(7) keep(0) print(0) nboot(100)
            ;
            # delimit cr            
            local rc = _rc
            drop rd`k'
            
            ** fill in for graphing 
            sort order
            if _rc == 0{
                replace b`k'        = r(scaledMass) in `row'
                replace b`k'SE      = r(scaledMassBS) in `row'
                replace b`k'SEDM    = r(scaledMassSE) in `row'
            }
            if _rc != 0{
                local rc = _rc
                noisily di " kink `k', year = `year', a1 = `a1', bw = `bw', sample = `sample': error code: `rc'"
                stop
            }
        }
        
        if `rc' == 0 drop smoothDensity
        drop sample
    } /* end year loop */
    
		noi di "ok so far"

    ** Combine plots
    # delimit ;
    graph combine
        cfop1996 cfop1997 cfop1998 
        cfop1999 cfop2000 cfop2001 
        cfop2002 cfop2003 `cfop2004',
        cols(3) title("Distribution of Earnings, `a1'-`a2' year olds")
        subtitle("`sampleTitle', 1996-2004, BW = `bw'")
        xsize(10) ysize(7.5) imargin(tiny)
        l1title("Percent") b1title("Real distance to kink (thousands of dollars)")
        ycommon xcommon 
        graphregion(color(white))
    ;
    # delimit cr
    graph save "$figdir/densPolyAlt_9604_6669_`bw'_`sample'", replace
    capture window manage close graph _all
    
    ** Make time series
    local title  "Normalized excess mass at kink"
    foreach stat in b1 b2 b3 b4{

        ** make upper and lower confidence bounds
        gen upper = `stat'+1.96*`stat'SE
        gen lower = `stat'-1.96*`stat'SE

        ** plot elasticities plus confidence bands
        # delimit ;
        twoway
            (connected `stat' yearPost if !missing(`stat'), sort lcolor(edkblue) lwidth(medthick) mcolor(edkblue))
            (line       upper yearPost if !missing(`stat'), sort lcolor(maroon) lwidth(medthick) lpattern(dash))
            (line       lower yearPost if !missing(`stat'), sort lcolor(maroon) lwidth(medthick) lpattern(dash)),
            title("`title', `a1'-`a2' year olds")
            subtitle("`sampleTitle', 1996-2004, BW = `bw'")
            ylabel(, angle(horizontal))
            ytitle("`title'")
            legend(off)
            xtitle("Year")
            xsize(10) ysize(7.5)
            graphregion(color(white))
            xlabel(1996(2)2004)
        ;
        # delimit cr
        graph save "$figdir/yearTS_densPoly_`stat'_9604_6669_`bw'_`sample'.gph", replace
        drop upper lower
        capture window manage close graph _all
    }
    
    ** plot all three together
    # delimit ;
    twoway
        (connected b1 yearPost if !missing(b1), sort lcolor(edkblue) lwidth(medthick) mcolor(edkblue) msize(small))
        (connected b2 yearPost if !missing(b2), sort lcolor(maroon) lwidth(medthick) mcolor(maroon) lpattern(dash) msize(small))
        (connected b3 yearPost if !missing(b3), sort lcolor(forest_green) lwidth(medthick) mcolor(forest_green) lpattern(dot) msize(small))
        (connected b4 yearPost if !missing(b4), sort lcolor(purple) lwidth(medthick) mcolor(purple) lpattern(dotdash) msize(small)),
        title("`title', `a1'-`a2' year olds")
        subtitle("`sampleTitle', 1996-2004, BW = `bw'")
        ylabel(, angle(horizontal))
        ytitle("`title'")
        legend(
            order(
            1 "Reaches NRA"
            2 "Pre-NRA" 
            3 "Inflate 1999"
            4 "Inflate 2000"
            )
            cols(3) ring(6)
        )
        xtitle("Year")
        xsize(10) ysize(7.5)
        graphregion(color(white))
        xlabel(1996(2)2004)
    ;
    # delimit cr
    graph save "$figdir/densPoly_threeKink_9604_6669_`bw'_`sample'.gph", replace
    capture window manage close graph _all
    
    ** outsheet to a table
    sort order
    outsheet yearPost b1 b1SE b2 b2SE b3 b3SE b4 b4SE if !missing(yearPost) ///
			using "$tabdir/altThresholds_9604_6669_`bw'_`sample'.txt", replace

