%% f_est1990
%
% Estimate e, phi for 1990, for given specification rules, print results

function est1990(bw,yearsPre,t0,t1Pre,t1Post,density,optInner,optOuter,p0,name, ages, scale)

        [dataB, bVarB, bunchBSB, dataPre, bVarPre, bunchBSPre, dataPost, bVarPost, bunchBSPost] = ...
            setData1990(bw, yearsPre,t0,t1Pre,t1Post,density, ages, scale);
    
        wMat = eye(yearsPre+1);
        dataB.wMat = wMat;
        dataB.year = (1989:1990)';
        dataB.ts = [0 1]';
        dataB.opt = optInner;
        
        % Estimate both
             [estEP, objValMain, flagMain] = fminsearch(...
                @(p) calcGmmInert([p 0], dataB, wMat), p0, optOuter);
             assert (objValMain < 1e8);
             assert (flagMain==1)
            
            % Bootstrap standard errors
            [~, epLB, epUB, estEP_p, estBS, jacDet] = ...
                calcBSSE(estEP, dataB,wMat,bunchBSB, optOuter);
            
            % Stars
            if estEP_p(1)<=0.01 
                eStars = '***';
            elseif estEP_p(1)<=0.05
                eStars = '** ';
            elseif estEP_p(1)<=0.1
                eStars = '*  ';
            else 
                eStars = '   ';
            end
            if estEP_p(2) <=0.01
                phiStars = '***';
            elseif estEP_p(2)<=0.05
                phiStars = '** ';
            elseif estEP_p(2)<=0.1
                phiStars = '*  ';
            else 
                phiStars = '   ';
            end
                
        % Estimate e using pre-period data
            wMat = eye(yearsPre);
            [estElPre,objVal,flag] = fminunc(@(el) calcGmmNoAC(el, dataPre, wMat), 0.1,optOuter);
            assert (objVal < 1e-6 || flag==1) 

            % Bootstrap SEs
            [~, ~, ePreLB, ePreUB, estEPre_p] = calcBSSE_e(estElPre, dataPre,wMat,bunchBSPre, optOuter);
            
            % Stars
            if estEPre_p <=0.01 
                ePreStars = '***';
            elseif estEPre_p <=0.05
                ePreStars = '** ';
            elseif estEPre_p <=0.1
                ePreStars = '*  ';
            else
                ePreStars = '   ';
            end
        
        % Estimate e using post-period data
            wMat = 1;
            [estElPost,objVal,flag] = fminunc(@(el) calcGmmNoAC(el, dataPost, wMat), 0.1,optOuter);
            assert (objVal < 1e-6 || flag==1) 

            % Bootstrap SEs
            [~, ~, ePostLB, ePostUB, estEPost_p] = calcBSSE_e(estElPost, dataPost,wMat,bunchBSPost, optOuter);
            % Stars
            if estEPost_p <=0.01 
                ePostStars = '***';
            elseif estEPost_p <=0.05
                ePostStars = '** ';
            elseif estEPost_p <=0.1
                ePostStars = '*  ';
            else
                ePostStars = '   ';
            end
                        
        % Output results 
            fprintf(' %s: &     %4.2f      &     %6.0f      ',name, estEP(1), estEP(2)*scale)
            fprintf(' &     %4.2f       &     %4.2f       \\\\ \n', estElPost, estElPre);
                        
            fprintf('           & [%4.2f, %4.2f]%s & [%6.0f, %6.0f]%s ', epLB(1), epUB(1), eStars, epLB(2)*scale, epUB(2)*scale, phiStars);
            fprintf(' & [%4.2f, %4.2f]%s  & [%4.2f, %4.2f]%s  \\\\ \n', ePostLB, ePostUB, ePostStars, ePreLB, ePreUB, ePreStars);
           % fprintf('Flag: %g\n', flagMain);
           % fprintf('Obj val final: %g \n', objValMain);     
            
        %  Determinant info:
       % nP = sum(jacDet > 0);
       % n0 = sum(jacDet == 0);
        %fprintf('  N jacDet positive %4.0f , n zero %4.0f \\\\ \n', nP, n0);
%         fprintf('  Sensitivity of ests to bunching \n');
%         names = {'el', 'phi'};
%         X = bunchBSB';
%         for ii = 1:length(estEP)
%             Y = estBS(ii,:)';
% 
% 
%             sens = (X'*X)\(X'*Y);
%             fprintf('    %s ', names{ii});
%             for jj = 1:length(sens)
%                 adj = sqrt( var(X(:,jj))/var(Y) );
%                 fprintf('& %3.2f', sens(jj)*adj);
%             end
%             fprintf(' \\\\ \n');
% 
% 
%         end


end