***************
*** Table 9 ***
***************


*** 1) Re-issuances

foreach v in reissued reissued_two_year {
foreach x in pcwordcount accept {

cd "$db\Clean Code\Weak Patents"
use reissue_reexam_sample, clear

* keep IT only
gen tc = floor(artunit / 100)
gen three_digit = floor(artunit / 10)
keep if tc == 21 | tc == 24 | tc == 26 | three_digit == 362 | three_digit == 368 | three_digit == 369  // units highlighted by Simcoe

* generate variables we need for analysis 

* keep track of tech centers
gen tech_center=trunc(artunit/100)
* we have 8 technology centers because we are excluding design patents

* bring signal SD
cd "$db\Clean Code\Examiner Effect Testing"
merge m:1 examiner using `x'_examiner_effect_it, keepusing(x_signal_sd)
keep if _merge==3
drop _merge

sum `v', d
gen mean_`v'=r(mean)

* now bring in examiner-specific estimates (leave-one-out)
merge 1:1 application using `x'_effect_loo
keep if _merge==3
drop _merge
egen examiner_id=group(examiner)

* standardize by signal SD and mean of outcome
replace loo_shrunk_examiner_effect=loo_shrunk_examiner_effect/x_signal_sd*mean_`v'

* with grant year fe's
clear matrix
areg `v' loo_shrunk_examiner_effect, cluster(examiner_id) absorb(filing_year)
matrix b=e(b)  
gen coeff_year=b[1,1]
matrix v=e(V) 
gen se_year=sqrt(v[1,1])
gen t_year=coeff_year/se_year
matrix N=e(N)
gen N_year=N[1,1]

* with artunit by grant year fe's
clear matrix
areg `v' loo_shrunk_examiner_effect, cluster(examiner_id) absorb(year_artunit)
matrix b=e(b)  
gen coeff_yearbyart=b[1,1]
matrix v=e(V) 
gen se_yearbyart=sqrt(v[1,1])
gen t_yearbyart=coeff_yearbyart/se_yearbyart
matrix N=e(N)
gen N_yearbyart=N[1,1]

* with year_artunit_class fe's 
clear matrix
areg `v' loo_shrunk_examiner_effect, cluster(examiner_id) absorb(year_artunit_class)
matrix b=e(b)  
gen coeff_yearbyartbyclass=b[1,1]
matrix v=e(V) 
gen se_yearbyartbyclass=sqrt(v[1,1])
gen t_yearbyartbyclass=coeff_yearbyartbyclass/se_yearbyartbyclass
matrix N=e(N)
gen N_yearbyartbyclass=N[1,1]

* store estimates in Excel spreadsheet 
cd "$db\Clean Code\Final Tables\"

if "`v'"=="reissued" & "`x'"=="pcwordcount" local coeff_year "B4"
if "`v'"=="reissued" & "`x'"=="pcwordcount" local coeff_yearbyart "C4"
if "`v'"=="reissued" & "`x'"=="pcwordcount" local coeff_yearbyartbyclass "D4"
if "`v'"=="reissued" & "`x'"=="pcwordcount" local se_year "B5"
if "`v'"=="reissued" & "`x'"=="pcwordcount" local se_yearbyart "C5"
if "`v'"=="reissued" & "`x'"=="pcwordcount" local se_yearbyartbyclass "D5"

if "`v'"=="reissued_two_year" & "`x'"=="pcwordcount" local coeff_year "E4"
if "`v'"=="reissued_two_year" & "`x'"=="pcwordcount" local coeff_yearbyart "F4"
if "`v'"=="reissued_two_year" & "`x'"=="pcwordcount" local coeff_yearbyartbyclass "G4"
if "`v'"=="reissued_two_year" & "`x'"=="pcwordcount" local se_year "E5"
if "`v'"=="reissued_two_year" & "`x'"=="pcwordcount" local se_yearbyart "F5"
if "`v'"=="reissued_two_year" & "`x'"=="pcwordcount" local se_yearbyartbyclass "G5"

if "`v'"=="reissued" & "`x'"=="accept" local coeff_year "B6"
if "`v'"=="reissued" & "`x'"=="accept" local coeff_yearbyart "C6"
if "`v'"=="reissued" & "`x'"=="accept" local coeff_yearbyartbyclass "D6"
if "`v'"=="reissued" & "`x'"=="accept" local se_year "B7"
if "`v'"=="reissued" & "`x'"=="accept" local se_yearbyart "C7"
if "`v'"=="reissued" & "`x'"=="accept" local se_yearbyartbyclass "D7"

if "`v'"=="reissued_two_year" & "`x'"=="accept" local coeff_year "E6"
if "`v'"=="reissued_two_year" & "`x'"=="accept" local coeff_yearbyart "F6"
if "`v'"=="reissued_two_year" & "`x'"=="accept" local coeff_yearbyartbyclass "G6"
if "`v'"=="reissued_two_year" & "`x'"=="accept" local se_year "E7"
if "`v'"=="reissued_two_year" & "`x'"=="accept" local se_yearbyart "F7"
if "`v'"=="reissued_two_year" & "`x'"=="accept" local se_yearbyartbyclass "G7"

putexcel set IT_PAE_tables, sheet("Table6_PanelA") modify
putexcel `coeff_year'=coeff_year 
putexcel `se_year'=se_year
putexcel `coeff_yearbyart'=coeff_yearbyart 
putexcel `se_yearbyart'=se_yearbyart
putexcel `coeff_yearbyartbyclass'=coeff_yearbyartbyclass 
putexcel `se_yearbyartbyclass'=se_yearbyartbyclass

* now save the t stat and N in the other excel spreadsheet
putexcel set IT_PAE_tables_t, sheet("Table6_PanelA") modify
putexcel `coeff_year'=N_year 
putexcel `se_year'=t_year
putexcel `coeff_yearbyart'=N_yearbyart 
putexcel `se_yearbyart'=t_yearbyart
putexcel `coeff_yearbyartbyclass'=N_yearbyartbyclass 
putexcel `se_yearbyartbyclass'=t_yearbyartbyclass

}

* now regression with best linear predictor

cd "$db\Clean Code\Weak Patents"
use reissue_reexam_sample, clear

* keep IT only
gen tc = floor(artunit / 100)
gen three_digit = floor(artunit / 10)
keep if tc == 21 | tc == 24 | tc == 26 | three_digit == 362 | three_digit == 368 | three_digit == 369  // units highlighted by Simcoe

* generate variables we need for analysis 

* keep track of tech centers
gen tech_center=trunc(artunit/100)
* we have 8 technology centers because we are excluding design patents

* bring signal SD and examiner-level shrinkage factors for regressor of interest 
cd "$db\Clean Code\Patent outcomes and examiner behavior"
drop if missing(appl_id)
merge 1:m appl_id using NPE_portfolio_linear_predictor
keep if _merge==3
drop _merge

sum `v', d
gen mean_`v'=r(mean)
egen examiner_id=group(examiner)

sum NPE_portfolio_hat, d
* standardize by SD and mean of outcome
gen NPE_portfolio_hat_sd=NPE_portfolio_hat/r(sd)*mean_`v'

* with grant year fe's
clear matrix
areg `v' NPE_portfolio_hat_sd, cluster(examiner_id) absorb(filing_year)
matrix b=e(b)  
gen coeff_year=b[1,1]
matrix v=e(V) 
gen se_year=sqrt(v[1,1])
gen t_year=coeff_year/se_year
matrix N=e(N)
gen N_year=N[1,1]

* with artunit by grant year fe's
clear matrix
areg `v' NPE_portfolio_hat_sd, cluster(examiner_id) absorb(year_artunit)
matrix b=e(b)  
gen coeff_yearbyart=b[1,1]
matrix v=e(V) 
gen se_yearbyart=sqrt(v[1,1])
gen t_yearbyart=coeff_yearbyart/se_yearbyart
matrix N=e(N)
gen N_yearbyart=N[1,1]

* with year_artunit_class fe's 
clear matrix
areg `v' NPE_portfolio_hat_sd, cluster(examiner_id) absorb(year_artunit_class)
matrix b=e(b)  
gen coeff_yearbyartbyclass=b[1,1]
matrix v=e(V) 
gen se_yearbyartbyclass=sqrt(v[1,1])
gen t_yearbyartbyclass=coeff_yearbyartbyclass/se_yearbyartbyclass
matrix N=e(N)
gen N_yearbyartbyclass=N[1,1]

* store estimates in Excel spreadsheet 
cd "$db\Clean Code\Final Tables\"

if "`v'"=="reissued" local coeff_year "B8"
if "`v'"=="reissued" local coeff_yearbyart "C8"
if "`v'"=="reissued" local coeff_yearbyartbyclass "D8"
if "`v'"=="reissued" local se_year "B9"
if "`v'"=="reissued" local se_yearbyart "C9"
if "`v'"=="reissued" local se_yearbyartbyclass "D9"

if "`v'"=="reissued_two_year" local coeff_year "E8"
if "`v'"=="reissued_two_year" local coeff_yearbyart "F8"
if "`v'"=="reissued_two_year" local coeff_yearbyartbyclass "G8"
if "`v'"=="reissued_two_year" local se_year "E9"
if "`v'"=="reissued_two_year" local se_yearbyart "F9"
if "`v'"=="reissued_two_year" local se_yearbyartbyclass "G9"

putexcel set IT_PAE_tables, sheet("Table6_PanelA") modify
putexcel `coeff_year'=coeff_year 
putexcel `se_year'=se_year
putexcel `coeff_yearbyart'=coeff_yearbyart 
putexcel `se_yearbyart'=se_yearbyart
putexcel `coeff_yearbyartbyclass'=coeff_yearbyartbyclass 
putexcel `se_yearbyartbyclass'=se_yearbyartbyclass

* now save the t stat and N in the other excel spreadsheet
putexcel set IT_PAE_tables_t, sheet("Table6_PanelA") modify
putexcel `coeff_year'=N_year 
putexcel `se_year'=t_year
putexcel `coeff_yearbyart'=N_yearbyart 
putexcel `se_yearbyart'=t_yearbyart
putexcel `coeff_yearbyartbyclass'=N_yearbyartbyclass 
putexcel `se_yearbyartbyclass'=t_yearbyartbyclass

}

*** 2) Court decisions

foreach v in Infringement Invalidity {

* regression on examiner effects
foreach x in pcwordcount accept {

cd "$db\Clean Code\Weak Patents"
use trial_outcomes_data, clear

* keep IT only
gen tc = floor(artunit / 100)
gen three_digit = floor(artunit / 10)
keep if tc == 21 | tc == 24 | tc == 26 | three_digit == 362 | three_digit == 368 | three_digit == 369  // units highlighted by Simcoe

* generate variables we need for analysis 

* keep track of tech centers
gen tech_center=trunc(artunit/100)
* we have 8 technology centers because we are excluding design patents

* bring signal SD
cd "$db\Clean Code\Examiner Effect Testing"
merge m:1 examiner using `x'_examiner_effect_it, keepusing(x_signal_sd)
keep if _merge==3
drop _merge

sum `v', d
gen mean_`v'=r(mean)

* now bring in examiner-specific estimates (leave-one-out)
merge 1:1 application using `x'_effect_loo
keep if _merge==3
drop _merge
egen examiner_id=group(examiner)

* standardize by signal SD
replace loo_shrunk_examiner_effect=loo_shrunk_examiner_effect/x_signal_sd

* with grant year fe's
clear matrix
areg `v' loo_shrunk_examiner_effect, cluster(examiner_id) absorb(filing_year)
matrix b=e(b)  
gen coeff_year=b[1,1]
matrix v=e(V) 
gen se_year=sqrt(v[1,1])
gen t_year=coeff_year/se_year
matrix N=e(N)
gen N_year=N[1,1]

* with artunit by grant year fe's
clear matrix
areg `v' loo_shrunk_examiner_effect, cluster(examiner_id) absorb(year_artunit)
matrix b=e(b)  
gen coeff_yearbyart=b[1,1]
matrix v=e(V) 
gen se_yearbyart=sqrt(v[1,1])
gen t_yearbyart=coeff_yearbyart/se_yearbyart
matrix N=e(N)
gen N_yearbyart=N[1,1]

* with year_artunit_class fe's 
clear matrix
areg `v' loo_shrunk_examiner_effect, cluster(examiner_id) absorb(year_artunit_class)
matrix b=e(b)  
gen coeff_yearbyartbyclass=b[1,1]
matrix v=e(V) 
gen se_yearbyartbyclass=sqrt(v[1,1])
gen t_yearbyartbyclass=coeff_yearbyartbyclass/se_yearbyartbyclass
matrix N=e(N)
gen N_yearbyartbyclass=N[1,1]

* store estimates in Excel spreadsheet 
cd "$db\Clean Code\Final Tables\"

if "`v'"=="Invalidity" & "`x'"=="pcwordcount" local coeff_year "B4"
if "`v'"=="Invalidity" & "`x'"=="pcwordcount" local coeff_yearbyart "C4"
if "`v'"=="Invalidity" & "`x'"=="pcwordcount" local coeff_yearbyartbyclass "D4"
if "`v'"=="Invalidity" & "`x'"=="pcwordcount" local se_year "B5"
if "`v'"=="Invalidity" & "`x'"=="pcwordcount" local se_yearbyart "C5"
if "`v'"=="Invalidity" & "`x'"=="pcwordcount" local se_yearbyartbyclass "D5"

if "`v'"=="Infringement" & "`x'"=="pcwordcount" local coeff_year "E4"
if "`v'"=="Infringement" & "`x'"=="pcwordcount" local coeff_yearbyart "F4"
if "`v'"=="Infringement" & "`x'"=="pcwordcount" local coeff_yearbyartbyclass "G4"
if "`v'"=="Infringement" & "`x'"=="pcwordcount" local se_year "E5"
if "`v'"=="Infringement" & "`x'"=="pcwordcount" local se_yearbyart "F5"
if "`v'"=="Infringement" & "`x'"=="pcwordcount" local se_yearbyartbyclass "G5"

if "`v'"=="Invalidity" & "`x'"=="accept" local coeff_year "B6"
if "`v'"=="Invalidity" & "`x'"=="accept" local coeff_yearbyart "C6"
if "`v'"=="Invalidity" & "`x'"=="accept" local coeff_yearbyartbyclass "D6"
if "`v'"=="Invalidity" & "`x'"=="accept" local se_year "B7"
if "`v'"=="Invalidity" & "`x'"=="accept" local se_yearbyart "C7"
if "`v'"=="Invalidity" & "`x'"=="accept" local se_yearbyartbyclass "D7"

if "`v'"=="Infringement" & "`x'"=="accept" local coeff_year "E6"
if "`v'"=="Infringement" & "`x'"=="accept" local coeff_yearbyart "F6"
if "`v'"=="Infringement" & "`x'"=="accept" local coeff_yearbyartbyclass "G6"
if "`v'"=="Infringement" & "`x'"=="accept" local se_year "E7"
if "`v'"=="Infringement" & "`x'"=="accept" local se_yearbyart "F7"
if "`v'"=="Infringement" & "`x'"=="accept" local se_yearbyartbyclass "G7"

putexcel set IT_PAE_tables, sheet("Table6_PanelB") modify
putexcel `coeff_year'=coeff_year 
putexcel `se_year'=se_year
putexcel `coeff_yearbyart'=coeff_yearbyart 
putexcel `se_yearbyart'=se_yearbyart
putexcel `coeff_yearbyartbyclass'=coeff_yearbyartbyclass 
putexcel `se_yearbyartbyclass'=se_yearbyartbyclass

* now save the t stat and N in the other excel spreadsheet
putexcel set IT_PAE_tables_t, sheet("Table6_PanelB") modify
putexcel `coeff_year'=N_year 
putexcel `se_year'=t_year
putexcel `coeff_yearbyart'=N_yearbyart 
putexcel `se_yearbyart'=t_yearbyart
putexcel `coeff_yearbyartbyclass'=N_yearbyartbyclass 
putexcel `se_yearbyartbyclass'=t_yearbyartbyclass

}

* now regression with best linear predictor

cd "$db\Clean Code\Weak Patents"
use trial_outcomes_data, clear

* keep IT only
gen tc = floor(artunit / 100)
gen three_digit = floor(artunit / 10)
keep if tc == 21 | tc == 24 | tc == 26 | three_digit == 362 | three_digit == 368 | three_digit == 369  // units highlighted by Simcoe

* generate variables we need for analysis 

* keep track of tech centers
gen tech_center=trunc(artunit/100)
* we have 8 technology centers because we are excluding design patents

* bring signal SD and examiner-level shrinkage factors for regressor of interest 
cd "$db\Clean Code\Patent outcomes and examiner behavior"
drop if missing(appl_id)
merge 1:m appl_id using NPE_portfolio_linear_predictor
keep if _merge==3
drop _merge

sum `v', d
gen mean_`v'=r(mean)
egen examiner_id=group(examiner)

sum NPE_portfolio_hat, d
gen NPE_portfolio_hat_sd=NPE_portfolio_hat/r(sd)

* with grant year fe's
clear matrix
areg `v' NPE_portfolio_hat_sd, cluster(examiner_id) absorb(filing_year)
matrix b=e(b)  
gen coeff_year=b[1,1]
matrix v=e(V) 
gen se_year=sqrt(v[1,1])
gen t_year=coeff_year/se_year
matrix N=e(N)
gen N_year=N[1,1]

* with artunit by grant year fe's
clear matrix
areg `v' NPE_portfolio_hat_sd, cluster(examiner_id) absorb(year_artunit)
matrix b=e(b)  
gen coeff_yearbyart=b[1,1]
matrix v=e(V) 
gen se_yearbyart=sqrt(v[1,1])
gen t_yearbyart=coeff_yearbyart/se_yearbyart
matrix N=e(N)
gen N_yearbyart=N[1,1]

* with year_artunit_class fe's 
clear matrix
areg `v' NPE_portfolio_hat_sd, cluster(examiner_id) absorb(year_artunit_class)
matrix b=e(b)  
gen coeff_yearbyartbyclass=b[1,1]
matrix v=e(V) 
gen se_yearbyartbyclass=sqrt(v[1,1])
gen t_yearbyartbyclass=coeff_yearbyartbyclass/se_yearbyartbyclass
matrix N=e(N)
gen N_yearbyartbyclass=N[1,1]

* store estimates in Excel spreadsheet 
cd "$db\Clean Code\Final Tables\"

if "`v'"=="Invalidity" local coeff_year "B8"
if "`v'"=="Invalidity" local coeff_yearbyart "C8"
if "`v'"=="Invalidity" local coeff_yearbyartbyclass "D8"
if "`v'"=="Invalidity" local se_year "B9"
if "`v'"=="Invalidity" local se_yearbyart "C9"
if "`v'"=="Invalidity" local se_yearbyartbyclass "D9"

if "`v'"=="Infringement" local coeff_year "E8"
if "`v'"=="Infringement" local coeff_yearbyart "F8"
if "`v'"=="Infringement" local coeff_yearbyartbyclass "G8"
if "`v'"=="Infringement" local se_year "E9"
if "`v'"=="Infringement" local se_yearbyart "F9"
if "`v'"=="Infringement" local se_yearbyartbyclass "G9"

putexcel set IT_PAE_tables, sheet("Table6_PanelB") modify
putexcel `coeff_year'=coeff_year 
putexcel `se_year'=se_year
putexcel `coeff_yearbyart'=coeff_yearbyart 
putexcel `se_yearbyart'=se_yearbyart
putexcel `coeff_yearbyartbyclass'=coeff_yearbyartbyclass 
putexcel `se_yearbyartbyclass'=se_yearbyartbyclass

* now save the t stat and N in the other excel spreadsheet
putexcel set IT_PAE_tables_t, sheet("Table6_PanelB") modify
putexcel `coeff_year'=N_year 
putexcel `se_year'=t_year
putexcel `coeff_yearbyart'=N_yearbyart 
putexcel `se_yearbyart'=t_yearbyart
putexcel `coeff_yearbyartbyclass'=N_yearbyartbyclass 
putexcel `se_yearbyartbyclass'=t_yearbyartbyclass

}


*** 3) USPTO decisions

* IPR occurence 

foreach v in ipr {

* regression on examiner effects
foreach x in pcwordcount accept {

cd "$db\Clean Code\Examiner Effect Testing"
use examiner_effect_dataset_v2, clear
cd "$db\Clean Code\Weak Patents"
merge 1:1 application using ipr_sample
drop if _merge==2
gen ipr=(_merge==3)
drop _merge 

* keep IT only
gen tc = floor(artunit / 100)
gen three_digit = floor(artunit / 10)
keep if tc == 21 | tc == 24 | tc == 26 | three_digit == 362 | three_digit == 368 | three_digit == 369  // units highlighted by Simcoe

* generate variables we need for analysis 

* keep track of tech centers
gen tech_center=trunc(artunit/100)
* we have 8 technology centers because we are excluding design patents

* bring signal SD
cd "$db\Clean Code\Examiner Effect Testing"
merge m:1 examiner using `x'_examiner_effect_it, keepusing(x_signal_sd)
keep if _merge==3
drop _merge

sum `v', d
gen mean_`v'=r(mean)

* now bring in examiner-specific estimates (leave-one-out)
merge 1:1 application using `x'_effect_loo
keep if _merge==3
drop _merge
egen examiner_id=group(examiner)

* standardize by signal SD and mean rate
replace loo_shrunk_examiner_effect=loo_shrunk_examiner_effect/x_signal_sd*mean_`v'

* with grant year fe's
clear matrix
areg `v' loo_shrunk_examiner_effect, cluster(examiner_id) absorb(filing_year)
matrix b=e(b)  
gen coeff_year=b[1,1]
matrix v=e(V) 
gen se_year=sqrt(v[1,1])
gen t_year=coeff_year/se_year
matrix N=e(N)
gen N_year=N[1,1]

* with artunit by grant year fe's
clear matrix
areg `v' loo_shrunk_examiner_effect, cluster(examiner_id) absorb(year_artunit)
matrix b=e(b)  
gen coeff_yearbyart=b[1,1]
matrix v=e(V) 
gen se_yearbyart=sqrt(v[1,1])
gen t_yearbyart=coeff_yearbyart/se_yearbyart
matrix N=e(N)
gen N_yearbyart=N[1,1]

* with year_artunit_class fe's 
clear matrix
areg `v' loo_shrunk_examiner_effect, cluster(examiner_id) absorb(year_artunit_class)
matrix b=e(b)  
gen coeff_yearbyartbyclass=b[1,1]
matrix v=e(V) 
gen se_yearbyartbyclass=sqrt(v[1,1])
gen t_yearbyartbyclass=coeff_yearbyartbyclass/se_yearbyartbyclass
matrix N=e(N)
gen N_yearbyartbyclass=N[1,1]

* store estimates in Excel spreadsheet 
cd "$db\Clean Code\Final Tables\"

if "`v'"=="ipr" & "`x'"=="pcwordcount" local coeff_year "B4"
if "`v'"=="ipr" & "`x'"=="pcwordcount" local coeff_yearbyart "C4"
if "`v'"=="ipr" & "`x'"=="pcwordcount" local coeff_yearbyartbyclass "D4"
if "`v'"=="ipr" & "`x'"=="pcwordcount" local se_year "B5"
if "`v'"=="ipr" & "`x'"=="pcwordcount" local se_yearbyart "C5"
if "`v'"=="ipr" & "`x'"=="pcwordcount" local se_yearbyartbyclass "D5"

if "`v'"=="ipr" & "`x'"=="accept" local coeff_year "B6"
if "`v'"=="ipr" & "`x'"=="accept" local coeff_yearbyart "C6"
if "`v'"=="ipr" & "`x'"=="accept" local coeff_yearbyartbyclass "D6"
if "`v'"=="ipr" & "`x'"=="accept" local se_year "B7"
if "`v'"=="ipr" & "`x'"=="accept" local se_yearbyart "C7"
if "`v'"=="ipr" & "`x'"=="accept" local se_yearbyartbyclass "D7"

putexcel set IT_PAE_tables, sheet("Table6_PanelC") modify
putexcel `coeff_year'=coeff_year 
putexcel `se_year'=se_year
putexcel `coeff_yearbyart'=coeff_yearbyart 
putexcel `se_yearbyart'=se_yearbyart
putexcel `coeff_yearbyartbyclass'=coeff_yearbyartbyclass 
putexcel `se_yearbyartbyclass'=se_yearbyartbyclass

* now save the t stat and N in the other excel spreadsheet
putexcel set IT_PAE_tables_t, sheet("Table6_PanelC") modify
putexcel `coeff_year'=N_year 
putexcel `se_year'=t_year
putexcel `coeff_yearbyart'=N_yearbyart 
putexcel `se_yearbyart'=t_yearbyart
putexcel `coeff_yearbyartbyclass'=N_yearbyartbyclass 
putexcel `se_yearbyartbyclass'=t_yearbyartbyclass

}

* now regression with best linear predictor

cd "$db\Clean Code\Examiner Effect Testing"
use examiner_effect_dataset_v2, clear
cd "$db\Clean Code\Weak Patents"
merge 1:1 application using ipr_sample
drop if _merge==2
gen ipr=(_merge==3)
drop _merge 

* keep IT only
gen tc = floor(artunit / 100)
gen three_digit = floor(artunit / 10)
keep if tc == 21 | tc == 24 | tc == 26 | three_digit == 362 | three_digit == 368 | three_digit == 369  // units highlighted by Simcoe

* generate variables we need for analysis 

* keep track of tech centers
gen tech_center=trunc(artunit/100)
* we have 8 technology centers because we are excluding design patents

* bring signal SD and examiner-level shrinkage factors for regressor of interest 
cd "$db\Clean Code\Patent outcomes and examiner behavior"
drop if missing(appl_id)
merge 1:m appl_id using NPE_portfolio_linear_predictor
keep if _merge==3
drop _merge

sum `v', d
gen mean_`v'=r(mean)
egen examiner_id=group(examiner)

sum NPE_portfolio_hat, d
gen NPE_portfolio_hat_sd=NPE_portfolio_hat/r(sd)*mean_`v'

* with grant year fe's
clear matrix
areg `v' NPE_portfolio_hat_sd, cluster(examiner_id) absorb(filing_year)
matrix b=e(b)  
gen coeff_year=b[1,1]
matrix v=e(V) 
gen se_year=sqrt(v[1,1])
gen t_year=coeff_year/se_year
matrix N=e(N)
gen N_year=N[1,1]

* with artunit by grant year fe's
clear matrix
areg `v' NPE_portfolio_hat_sd, cluster(examiner_id) absorb(year_artunit)
matrix b=e(b)  
gen coeff_yearbyart=b[1,1]
matrix v=e(V) 
gen se_yearbyart=sqrt(v[1,1])
gen t_yearbyart=coeff_yearbyart/se_yearbyart
matrix N=e(N)
gen N_yearbyart=N[1,1]

* with year_artunit_class fe's 
clear matrix
areg `v' NPE_portfolio_hat_sd, cluster(examiner_id) absorb(year_artunit_class)
matrix b=e(b)  
gen coeff_yearbyartbyclass=b[1,1]
matrix v=e(V) 
gen se_yearbyartbyclass=sqrt(v[1,1])
gen t_yearbyartbyclass=coeff_yearbyartbyclass/se_yearbyartbyclass
matrix N=e(N)
gen N_yearbyartbyclass=N[1,1]

* store estimates in Excel spreadsheet 
cd "$db\Clean Code\Final Tables\"

if "`v'"=="ipr" local coeff_year "B8"
if "`v'"=="ipr" local coeff_yearbyart "C8"
if "`v'"=="ipr" local coeff_yearbyartbyclass "D8"
if "`v'"=="ipr" local se_year "B9"
if "`v'"=="ipr" local se_yearbyart "C9"
if "`v'"=="ipr" local se_yearbyartbyclass "D9"

putexcel set IT_PAE_tables, sheet("Table6_PanelC") modify
putexcel `coeff_year'=coeff_year 
putexcel `se_year'=se_year
putexcel `coeff_yearbyart'=coeff_yearbyart 
putexcel `se_yearbyart'=se_yearbyart
putexcel `coeff_yearbyartbyclass'=coeff_yearbyartbyclass 
putexcel `se_yearbyartbyclass'=se_yearbyartbyclass

* now save the t stat and N in the other excel spreadsheet
putexcel set IT_PAE_tables_t, sheet("Table6_PanelC") modify
putexcel `coeff_year'=N_year 
putexcel `se_year'=t_year
putexcel `coeff_yearbyart'=N_yearbyart 
putexcel `se_yearbyart'=t_yearbyart
putexcel `coeff_yearbyartbyclass'=N_yearbyartbyclass 
putexcel `se_yearbyartbyclass'=t_yearbyartbyclass
}


* IPR instituted 

foreach v in ipr_instituted {

* regression on examiner effects
foreach x in pcwordcount accept {

cd "$db\Clean Code\Weak Patents"
use ipr_sample, clear

* keep IT only
gen tc = floor(artunit / 100)
gen three_digit = floor(artunit / 10)
keep if tc == 21 | tc == 24 | tc == 26 | three_digit == 362 | three_digit == 368 | three_digit == 369  // units highlighted by Simcoe

* generate variables we need for analysis 

* keep track of tech centers
gen tech_center=trunc(artunit/100)
* we have 8 technology centers because we are excluding design patents

* bring signal SD
cd "$db\Clean Code\Examiner Effect Testing"
merge m:1 examiner using `x'_examiner_effect_it, keepusing(x_signal_sd)
keep if _merge==3
drop _merge

sum `v', d
gen mean_`v'=r(mean)

* now bring in examiner-specific estimates (leave-one-out)
merge 1:1 application using `x'_effect_loo
keep if _merge==3
drop _merge
egen examiner_id=group(examiner)

* standardize by signal SD
replace loo_shrunk_examiner_effect=loo_shrunk_examiner_effect/x_signal_sd*mean_`v'

* with grant year fe's
clear matrix
areg `v' loo_shrunk_examiner_effect, cluster(examiner_id) absorb(filing_year)
matrix b=e(b)  
gen coeff_year=b[1,1]
matrix v=e(V) 
gen se_year=sqrt(v[1,1])
gen t_year=coeff_year/se_year
matrix N=e(N)
gen N_year=N[1,1]

* with artunit by grant year fe's
clear matrix
areg `v' loo_shrunk_examiner_effect, cluster(examiner_id) absorb(year_artunit)
matrix b=e(b)  
gen coeff_yearbyart=b[1,1]
matrix v=e(V) 
gen se_yearbyart=sqrt(v[1,1])
gen t_yearbyart=coeff_yearbyart/se_yearbyart
matrix N=e(N)
gen N_yearbyart=N[1,1]

* with year_artunit_class fe's 
clear matrix
areg `v' loo_shrunk_examiner_effect, cluster(examiner_id) absorb(year_artunit_class)
matrix b=e(b)  
gen coeff_yearbyartbyclass=b[1,1]
matrix v=e(V) 
gen se_yearbyartbyclass=sqrt(v[1,1])
gen t_yearbyartbyclass=coeff_yearbyartbyclass/se_yearbyartbyclass
matrix N=e(N)
gen N_yearbyartbyclass=N[1,1]

* store estimates in Excel spreadsheet 
cd "$db\Clean Code\Final Tables\"

if "`v'"=="ipr_instituted" & "`x'"=="pcwordcount" local coeff_year "E4"
if "`v'"=="ipr_instituted" & "`x'"=="pcwordcount" local coeff_yearbyart "F4"
if "`v'"=="ipr_instituted" & "`x'"=="pcwordcount" local coeff_yearbyartbyclass "G4"
if "`v'"=="ipr_instituted" & "`x'"=="pcwordcount" local se_year "E5"
if "`v'"=="ipr_instituted" & "`x'"=="pcwordcount" local se_yearbyart "F5"
if "`v'"=="ipr_instituted" & "`x'"=="pcwordcount" local se_yearbyartbyclass "G5"

if "`v'"=="ipr_instituted" & "`x'"=="accept" local coeff_year "E6"
if "`v'"=="ipr_instituted" & "`x'"=="accept" local coeff_yearbyart "F6"
if "`v'"=="ipr_instituted" & "`x'"=="accept" local coeff_yearbyartbyclass "G6"
if "`v'"=="ipr_instituted" & "`x'"=="accept" local se_year "E7"
if "`v'"=="ipr_instituted" & "`x'"=="accept" local se_yearbyart "F7"
if "`v'"=="ipr_instituted" & "`x'"=="accept" local se_yearbyartbyclass "G7"

putexcel set IT_PAE_tables, sheet("Table6_PanelC") modify
putexcel `coeff_year'=coeff_year 
putexcel `se_year'=se_year
putexcel `coeff_yearbyart'=coeff_yearbyart 
putexcel `se_yearbyart'=se_yearbyart
putexcel `coeff_yearbyartbyclass'=coeff_yearbyartbyclass 
putexcel `se_yearbyartbyclass'=se_yearbyartbyclass

* now save the t stat and N in the other excel spreadsheet
putexcel set IT_PAE_tables_t, sheet("Table6_PanelC") modify
putexcel `coeff_year'=N_year 
putexcel `se_year'=t_year
putexcel `coeff_yearbyart'=N_yearbyart 
putexcel `se_yearbyart'=t_yearbyart
putexcel `coeff_yearbyartbyclass'=N_yearbyartbyclass 
putexcel `se_yearbyartbyclass'=t_yearbyartbyclass

}

* now regression with best linear predictor

cd "$db\Clean Code\Weak Patents"
use ipr_sample, clear

* keep IT only
gen tc = floor(artunit / 100)
gen three_digit = floor(artunit / 10)
keep if tc == 21 | tc == 24 | tc == 26 | three_digit == 362 | three_digit == 368 | three_digit == 369  // units highlighted by Simcoe

* generate variables we need for analysis 

* keep track of tech centers
gen tech_center=trunc(artunit/100)
* we have 8 technology centers because we are excluding design patents

* bring signal SD and examiner-level shrinkage factors for regressor of interest 
cd "$db\Clean Code\Patent outcomes and examiner behavior"
drop if missing(appl_id)
merge 1:m appl_id using NPE_portfolio_linear_predictor
keep if _merge==3
drop _merge

sum `v', d
gen mean_`v'=r(mean)
egen examiner_id=group(examiner)

sum NPE_portfolio_hat, d
gen NPE_portfolio_hat_sd=NPE_portfolio_hat/r(sd)*mean_`v'

* with grant year fe's
clear matrix
areg `v' NPE_portfolio_hat_sd, cluster(examiner_id) absorb(filing_year)
matrix b=e(b)  
gen coeff_year=b[1,1]
matrix v=e(V) 
gen se_year=sqrt(v[1,1])
gen t_year=coeff_year/se_year
matrix N=e(N)
gen N_year=N[1,1]

* with artunit by grant year fe's
clear matrix
areg `v' NPE_portfolio_hat_sd, cluster(examiner_id) absorb(year_artunit)
matrix b=e(b)  
gen coeff_yearbyart=b[1,1]
matrix v=e(V) 
gen se_yearbyart=sqrt(v[1,1])
gen t_yearbyart=coeff_yearbyart/se_yearbyart
matrix N=e(N)
gen N_yearbyart=N[1,1]

* with year_artunit_class fe's 
clear matrix
areg `v' NPE_portfolio_hat_sd, cluster(examiner_id) absorb(year_artunit_class)
matrix b=e(b)  
gen coeff_yearbyartbyclass=b[1,1]
matrix v=e(V) 
gen se_yearbyartbyclass=sqrt(v[1,1])
gen t_yearbyartbyclass=coeff_yearbyartbyclass/se_yearbyartbyclass
matrix N=e(N)
gen N_yearbyartbyclass=N[1,1]

* store estimates in Excel spreadsheet 
cd "$db\Clean Code\Final Tables\"

if "`v'"=="ipr_instituted" local coeff_year "E8"
if "`v'"=="ipr_instituted" local coeff_yearbyart "F8"
if "`v'"=="ipr_instituted" local coeff_yearbyartbyclass "G8"
if "`v'"=="ipr_instituted" local se_year "E9"
if "`v'"=="ipr_instituted" local se_yearbyart "F9"
if "`v'"=="ipr_instituted" local se_yearbyartbyclass "G9"

putexcel set IT_PAE_tables, sheet("Table6_PanelC") modify
putexcel `coeff_year'=coeff_year 
putexcel `se_year'=se_year
putexcel `coeff_yearbyart'=coeff_yearbyart 
putexcel `se_yearbyart'=se_yearbyart
putexcel `coeff_yearbyartbyclass'=coeff_yearbyartbyclass 
putexcel `se_yearbyartbyclass'=se_yearbyartbyclass

* now save the t stat and N in the other excel spreadsheet
putexcel set IT_PAE_tables_t, sheet("Table6_PanelC") modify
putexcel `coeff_year'=N_year 
putexcel `se_year'=t_year
putexcel `coeff_yearbyart'=N_yearbyart 
putexcel `se_yearbyart'=t_yearbyart
putexcel `coeff_yearbyartbyclass'=N_yearbyartbyclass 
putexcel `se_yearbyartbyclass'=t_yearbyartbyclass
}
