

***-----------------------------------------------------------------------------------------------------------------------------***	
***   				Barrage, Chyn, Hastings (2019, AEJ:Policy)		     				        ***
***						FIGURE 1									***	
***-----------------------------------------------------------------------------------------------------------------------------***	
	
/* This do-file replicates Figure 1.
Inputs:   BCH_Replication_Figure1.dta
Outputs:  Figure1_BP_NonBPNonCompetitor_TimeSeries_2010_price.eps
*/
	
clear all
set more off

*Set directory:
include 1_SET_DIRECTORY.do

*Open data:
use BCH_Replication_Figure1.dta, clear


****************** 
**   Figure 1   **           
******************
 sort week 

 graph twoway (line mprice_bp1 week) (line mprice_no week,clpattern(dash)) if week>2600, ///
 xline(2616) xline(2638) text(2.85 2616 "Oil Spill", place(nw) size(small)) ///
 text(2.85 2638 "Oil Leak Capped", place(nw) size(small)) ///
 ytitle("Avg. Price, $/gal", margin(small)) xtitle("") ///
 graphregion(color(white) fcolor(white) icolor(white) ifcolor(white) lcolor(white) ilcolor(white)) plotregion(color(white) fcolor(white) icolor(white) ifcolor(white) lcolor(white) ilcolor(white))

 graph export Figure1_BP_NonBPNonCompetitor_TimeSeries_2010_price.eps, replace
 
