***-----------------------------------------------------------------------------------------------------------------------------***	
***   				Barrage, Chyn, Hastings (2019, AEJ:Policy)		     				        ***
***						TABLE 4										***	
***-----------------------------------------------------------------------------------------------------------------------------***	
	
/* This do-file replicates BCH Table 3.
Inputs:   BCH_Replication_Table4.dta
Outputs:  Table4_BCH.xls
*/
	
clear all
set more off

*Install programs:
cap net install outreg2, from(http://fmwww.bc.edu/repec/bocode/o/)

*Set directory:
include 1_SET_DIRECTORY.do

*Open data:
use BCH_Replication_Table4.dta, clear

		   
******************** 
** Table 4, Col 1 **  
********************

reg price_diff bp1 green_index bp1_green dm_inc bp1_dminc dm_core_adsp_t00_08 bp1_dm_core_adsp_t00_08, cluster(random_zip)

egen id_tag=tag(random_id) if e(sample)==1
count if id_tag==1
local stations=`r(N)'
drop id_tag
cap outreg2 using Table4_BCH.xls, replace excel dec(3) addstat(# of zips,`e(N_clust)', # of stations,`stations')


******************** 
** Table 4, Col 2 **  
********************

reg price_diff bp1 green_index bp1_green dm_inc bp1_dminc dm_core_adsp_t00_08 bp1_dm_core_adsp_t00_08 dm_ancil_adsp_t00_08 bp1_dm_ancil_adsp_t00_08, cluster(random_zip) 

egen id_tag=tag(random_id) if e(sample)==1
count if id_tag==1
local stations=`r(N)'
drop id_tag
cap outreg2 using Table4_BCH.xls, append excel dec(3) addstat(# of zips,`e(N_clust)', # of stations,`stations')


******************** 
** Table 4, Col 3 **  
********************

reg price_diff bp1 green_zip bp1_green_zip dm_inc bp1_dminc dm_core_adsp_t00_08 bp1_dm_core_adsp_t00_08 bp1_green_zip_dm_core_t00_08, cluster(random_zip) 

egen id_tag=tag(random_id) if e(sample)==1
count if id_tag==1
local stations=`r(N)'
drop id_tag
cap outreg2 using Table4_BCH.xls, append excel dec(3) addstat(# of zips,`e(N_clust)', # of stations,`stations')


******************** 
** Table 4, Col 4 **  
********************

reg price_diff bp1 green_zip bp1_green_zip dm_inc bp1_dminc dm_core_adsp_t00_08 bp1_dm_core_adsp_t00_08 bp1_green_zip_dm_core_t00_08 dm_ancil_adsp_t00_08 bp1_dm_ancil_adsp_t00_08 bp1_green_zip_dm_ancil_t00_08, cluster(random_zip) 

egen id_tag=tag(random_id) if e(sample)==1
count if id_tag==1
local stations=`r(N)'
drop id_tag
cap outreg2 using Table4_BCH.xls, append excel dec(3) addstat(# of zips,`e(N_clust)', # of stations,`stations')
	
	
