
clear all
set more off 
cap log close 
set mem 12g 
set matsize 11000

global dir "/home/research/cavoced/cred" 
global build "$dir/build"
global analy "$dir/analysis"

global prodir "${analy}/prog"
global logdir "${analy}/prog" 
global rawdir "${analy}/raw" 
global temdir "${analy}/temp" 
global anadir "${analy}/data"
global outdir "${analy}/output"

global texdir "$outdir/tex"
global txtdir "$outdir/txt"
global xlsdir "$outdir/xls"
global londir "$outdir/xls/long"
global figdir "$outdir/figs"
set scheme s1color
local figbacks "plotregion(fcolor(white)) graphregion(fcolor(white) lwidth(large)) bgcolor(white)"



use $temdir/aca_CENCOL_withwages_rr, clear


*General Persist
		gen persist=.
			foreach g in 2 3 4 5 {
				local i=`g'-1
				replace persist=(mlot`g'_partic==1) if mlot`i'_cat==2 & lotnum==`i'
				gen persist`i'=(mlot`g'_partic==1) if mlot`i'_cat==2
				}




***********************************************
*Persistence Regressions
***********************************************
*Dropping out of lottery after 1st loss
	*What determines not applying again if lose lot 1?
	eststo clear


global tabvarlist "sex_F race_W  race_H race_A age_atfirst gpa_prereq  enr_othdis_prelot1  sfa_bog sfa_pell sfa_calg sfa_loan emp_anypre emp_numq emp_gr8pre emp_prewag  dwork_health      dwork_retail dwork_admin  dwork_educ  dwork_acfo_food "
global allvarlist "sex_F zrace_W  zrace_H zrace_A age_atfirst zgpa_prereq    sfa_bog sfa_pell  emp_pre  emp_pre "

	foreach g in 1 2 3 4{
		eststo c`g': reg persist $allvarlist wag_pre1   emp_hepre1 if appflag & lotnum==`g' & lot_cat==2 ,
		estadd ysumm
		}
		eststo ca: reg persist $allvarlist wag_pre1   emp_hepre1   i.lotnum rlotfe* if appflag & lotnum<5 & lot_cat==2 ,
		estadd ysumm
		suest c1 c2 c3 c4 ca, cluster(ssn)
		test [c1_mean=c2_mean=c3_mean=c4_mean]
		
		#delimit;
		esttab c*  using "$outdir/rr/fir_persistregs.tex", replace label stat(ymean N) se keep($allvarlist ) 
			nomtitles prehead(" ") prefoot(" ") posthead(" ") postfoot(" ") nogaps nolines nonumbers;

