
clear all
set more off 
cap log close 
set mem 12g 
set matsize 11000

global dir "/home/research/cavoced/cred" 
global build "$dir/build"
global analy "$dir/analysis"

global prodir "${analy}/prog"
global logdir "${analy}/prog" 
global rawdir "${analy}/raw" 
global temdir "${analy}/temp" 
global anadir "${analy}/data"
global outdir "${analy}/output"

global texdir "$outdir/tex"
global txtdir "$outdir/txt"
global xlsdir "$outdir/xls"
global londir "$outdir/xls/long"
global figdir "$outdir/figs"
	global optionss "label se nonotes  nogaps nomtitles noobs nonumbers nolines "
set scheme s1color
local figbacks "plotregion(fcolor(white)) graphregion(fcolor(white) lwidth(large)) bgcolor(white)"



**************************************************************
*Merge Transfer to CENCOL Data
***************************************************************		
use $temdir/aca_CENCOL_withwages_rr, clear
			keep ssn mlot1_term
			gen SID=reverse(substr(reverse(ssn),3,.))
			duplicates drop
			tempfile tempsp
			save `tempsp'
use /home/research/cavoced/cte/data/trans_ALL
		keep SID trans_*
		duplicates drop
		joinby SID using `tempsp', unmatched(both)
		keep if _merge==3
		gen transyear=floor(trans_term/10000)
		gen trans_flag=transyear>mlot1_term & transyear<(mlot1_term+6)
		keep if trans_flag
		keep ssn trans_flag trans_seg
		tempfile temptrn
		save `temptrn'
		clear
***************************************************

use $temdir/aca_CENCOL_withwages_rr, clear

		
		
	********************
	*Regressions
	**********************
	drop appflag
	egen appflag=tag(ssn lotnum)
	global racevar "age_at  race_H race_A race_OBX"
	global acadvar "gpa_prelot1   "
	global empvar "hemp_anypre emp_pre "	
	global finvar "sfa_bog sfa_pel  sfa_cal "	

	
*Create a consistent sample for the 1st stage regressions
	reg numlots  lot_adm $racevar $acadvar $empvar $finvar loof* if lotnum==1 & appflag==1
	gen ESAMPLEall=e(sample)
	reg logwage0 win14   zc0* if lotnum<5   & ysince_lot1==5.25 , cluster(ssn)  
	gen ESAMPLE57=e(sample)
	foreach g of varlist E*{
		bysort ssn: egen a=total(`g')
		replace `g'=a>0
		drop a
		}	



	gen poste=yearqtr>(classof +1)

	gen poste5=rys==5
		egen keepflag=tag(ssn yearqtr)

***********************************************
*Outcomes
***********************************************
	keep if ESAMPLE57==1
		drop tagflag
		egen tagflag=tag(ssn)
		qui tab ssn, gen(ssnfe)
		local covars1="age_at race_H race_A race_OBX "	
		local covars2="age_at race_H race_A race_OBX gpa_prelot1   "	
		local covars3="age_at race_H race_A race_OBX gpa_prelot1   hemp_anypre emp_pre "	
		local covars4="age_at race_H race_A race_OBX gpa_prelot1   hemp_anypre emp_pre sfa_bog sfa_pel sfa_cal missfin "	

	gen trashtrash=logwage0 if ysince_lot1<0 & ysince_lot1>-5
		bysort ssn lotnum: egen meanprewage=mean(trashtrash)
	gen ysince_coh=yearqtr-classof
		gen ensamp=(ysince_lot1>-5 & ysince_lot1<5.3) if enr==0
			replace ensamp=(ysince_coh>-5 & ysince_coh<5.3) if enr==1
	gen rysince_coh=ceil(yearqtr-classof)
	foreach g in 1 2 3 4 5 {
		gen pposte`g'=(rysince_coh==`g' & classof!=.)
		}	

	*Dummies for quarters since
		gen qysince_coh=ysince_coh*4+93
			replace qysince_coh=0 if qysince_coh==.
			forvalues y=1/175{
				gen qsyfe`y'=qysince_coh==`y'
				}
				rename qsyfe74 omit
		replace pposte5=1 if rysince_coh==6 & classof!=.
			
		gen post_lot1adm=(yearqtr>mlot1_term & mlot1_adm==1 & mlot1_term!=.)
		gen post_enr=(yearqtr>classof & enrn==1 & classof!=.)

		*create trends
			egen ssnn=group(ssn)
			gen t=yearqtr-2000
			sum ssnn
			local nn=r(max)
			forvalues y=1/`nn'{
				qui gen ssntr`y'=t*(ssnn==`y')		
				}
		
*********************************************************
*Create Pictures
*********************************************************		
		
		eststo at54: areg logwages qsy* yfe* qfe* agfe*  enrolled  if ESAMPLE5==1 & keepflag==1 & ensamp==1 , absorb(ssn) cluster(ssn)
			mat a=-19,0,0
			forvalues y=75/114{
				local b=`y'-93
				mat b=`b',_b[qsyfe`y'], _se[qsyfe`y']
				mat a=a\b
				}
				preserve
				clear
				svmat a
				gen u=a2+2*a3
				gen l=a2-2*a3
				twoway scatter a2 u l a1 if a1>-21, ylab(, nogrid)  connect( l l l)  `figbacks' yline(0, lcolor(black))  lpattern(solid dash dash) msymbol(o none none) mcolor(navy) lcolor(navy navy navy) xtitle("Quarters Since Enrollment") ytitle("Log Earnings Effect") xscale(r(-20(4)21)) xlabel(-20(4)21) legend(off)
						graph export  "$outdir/rr/fe_byq_enr.eps", replace
				restore
	
***********************************************************
*Create Estimates
***********************************************************		
		*at year 5 estimates
		*OLS and IV
		eststo at51: reg logwage0 enrn  enrolled  	`covars4' yfe* qfe* flot loofe*    gap if lotnum==1 & rys==5, cluster(ssn)  
			estimates save "$temdir/fetest_ols5" , replace
		eststo at52: ivreg2 logwage0 (enrn=lot_adm)  enrolled  	`covars4' yfe* qfe* flot loofe*      gap if lotnum==1 & rys==5, cluster(ssn)  
			estimates save "$temdir/fetest_iv5" , replace
		*FE with full sample
		eststo at53: reg logwages ppo* yfe* qfe* agfe*  enrolled `covars4' if ESAMPLE5==1 & keepflag==1 & ensamp==1 , cluster(ssn)
			estimates save "$temdir/fetest_dda5" , replace
		eststo at54: areg logwages ppo* yfe* qfe* agfe*  enrolled  if ESAMPLE5==1 & keepflag==1 & ensamp==1 , absorb(ssn) cluster(ssn)
			estimates save "$temdir/fetest_fea5" , replace
		eststo at54: areg logwages ppo* yfe* qfe* agfe*  enrolled ssntr* if ESAMPLE5==1 & keepflag==1 & ensamp==1 , absorb(ssn) cluster(ssn)
			estimates save "$temdir/fetest_fedeta5" , replace	
		*FE with just enrolled people
		eststo at56: areg logwages ppo* yfe* qfe* agfe*  enrolled  if ESAMPLE5==1 & ysince_lot1>-5 & ysince_lot1<5.3 &keepflag==1 & enr==1, absorb(ssn) cluster(ssn)
			estimates save "$temdir/fetest_fee5" , replace		
		
		
		
		
	*Post-enrollment, with and without FE/Trends
		eststo at51: reg logwage0 enrn  enrolled  	`covars4' yfe* qfe* flot loofe*    gap if lotnum==1 & ysince_lot1>0 & ysince_lot1<5.3, cluster(ssn)  
			estimates save "$temdir/fetest_olsa0" , replace
		eststo at52: ivreg2 logwage0 (enrn=lot_adm)  enrolled  	`covars4' yfe* qfe* flot loofe*      gap if lotnum==1 & ysince_lot1>0 & ysince_lot1<5.3, cluster(ssn)  
			estimates save "$temdir/fetest_iva1" , replace
		eststo atp1: reg logwages poste  enrolled  	`covars4' yfe* qfe* flot loofe*      gap if keepflag==1 & ensamp==1, cluster(ssn)  
			estimates save "$temdir/fetest_olsa" , replace
		eststo atp1: reg logwages poste  enrolled  	`covars4' yfe* qfe* flot loofe*      gap if keepflag==1 & ensamp==1 & enr==1, cluster(ssn)  
			estimates save "$temdir/fetest_olsa2" , replace
		eststo at56: areg logwages poste yfe* qfe* agfe*  enrolled  if ensamp==1 &keepflag==1, absorb(ssn) cluster(ssn)
			estimates save "$temdir/fetest_fea1" , replace
		eststo at57: areg logwages poste yfe* qfe* agfe*  enrolled  if ensamp==1  &keepflag==1 & enr==1, absorb(ssn) cluster(ssn)
			estimates save "$temdir/fetest_fea2" , replace
		eststo at56: areg logwages poste yfe* qfe* agfe*  enrolled ssntr* if ensamp==1 &keepflag==1, absorb(ssn) cluster(ssn)
			estimates save "$temdir/fetest_fedeta1" , replace
		eststo at57: areg logwages poste yfe* qfe* agfe*  enrolled ssntr* if ensamp==1  &keepflag==1 & enr==1, absorb(ssn) cluster(ssn)
			estimates save "$temdir/fetest_fedeta2" , replace

			
	*FE and IV		
		eststo atp2: ivreg2 logwages (post_enr=post_lot1)   enrolled  	agfe* yfe* qfe*  if keepflag==1 & ysince_lot1>-5 & ysince_lot1<5.3, cluster(ssn)  
			estimates save "$temdir/fetest_iva2" , replace
		eststo atp3: ivreg2 logwages (post_enr=post_lot1)  ssnfe* enrolled  	 agfe*  yfe* qfe*      gap if keepflag==1 & ysince_lot1>-5 & ysince_lot1<5.3, cluster(ssn)  
			estimates save "$temdir/fetest_ivfe" , replace
		eststo atp3: ivreg2 logwages (post_enr=post_lot1)  ssnfe* ssntr* enrolled  	 agfe* yfe* qfe*      gap if keepflag==1 & ysince_lot1>-5 & ysince_lot1<5.3, cluster(ssn)  
			estimates save "$temdir/fetest_ivfetr" , replace		

		
		
		