clear all
set more off 
cap log close 
set mem 12g 
set matsize 11000

global dir "/home/research/cavoced/cred" 
global build "$dir/build"
global analy "$dir/analysis"

global prodir "${analy}/prog"
global logdir "${analy}/prog" 
global rawdir "${analy}/raw" 
global temdir "${analy}/temp" /*unclean data, but not raw*/
global anadir "${analy}/data"
global outdir "${analy}/output"

global texdir "$outdir/tex"
global txtdir "$outdir/txt"
global xlsdir "$outdir/xls"
global londir "$outdir/xls/long"
global figdir "$outdir/figs"



**************************************************************
*Merge INDUSTRY on to CENCOL data
*************************************************************
use  "$temdir/aca_awa_CENCOL_stacked", clear
gen STUDENT_SSN=substr(ssn,1,strpos(ssn,"_")-1)
drop _merge
*variables for quarters since first lottery
gen qts_since=round(yearqtr-mlot1_term, 0.25)


	*Separate into time-varying and time-nonvarying
		*Time-invariant
			keep ssn STUDENT_SSN mlot* lot* enrol* sex* race* age_at *prelot1 awa_* 
			duplicates drop
	joinby  STUDENT_SSN using $anadir/CENCOL_earnings_naics, unmatched(both)
	drop if _merge==2 		
	destring WAGES, replace
	destring YEAR, replace
	destring Q, replace
	gen yearqtr=YEAR+(Q-1)/4
	rename WAGES wages
			
		*Federal minimum wage is about 15000 per year
		bysort ssn lotnum YEAR QT: egen totwa=total(wages)
			gen made_minwage=totwa>3750
		*More NAICS2 stuff
			gen t_workhealth=substr(NAICS,1,2)=="62"
				gen t_workhealth_hosp=substr(NAICS,1,3)=="622"
				gen t_workhealth_amb=substr(NAICS,1,3)=="621"
				gen t_workhealth_nursres=substr(NAICS,1,3)=="623"
			gen t_workretail=substr(NAICS,1,2)=="44" | substr(NAICS,1,2)=="45"
				gen t_workretail_groc=substr(NAICS,1,4)=="4451"
				gen t_workretail_heal=substr(NAICS,1,4)=="4461"
				gen t_workretail_cloth=substr(NAICS,1,4)=="4481"|substr(NAICS,1,4)=="4521"|substr(NAICS,1,4)=="4529"
			gen t_workadmin=substr(NAICS,1,2)=="56" 
				gen t_workadmin_plac=substr(NAICS,1,4)=="5613"
			gen t_workeduc=substr(NAICS,1,2)=="61"
			gen t_workacfo=substr(NAICS,1,2)=="72"
				gen t_workacfo_hotel=substr(NAICS,1,3)=="721"
				gen t_workacfo_food=substr(NAICS,1,3)=="722"
			
			
			
			foreach v of varlist t_*{
					
					gen trash2=made_minwage*`v'
					bysort ssn lotnum YEAR QT: egen trash=sum(`v')
						replace `v'=trash>0
						drop trash
					bysort ssn lotnum YEAR QT: egen trash=sum(trash2)
						gen min`v'=trash>0
						drop trash trash2
						}
				bysort ssn lotnum YEAR QT: egen trash=sum(made_min)
					gen work_minwag=trash>0
				renpfix t_work work_
				renpfix mint_work mwork_

				keep ssn yearqtr work_* mwork*
		duplicates drop
		tempfile tempind
		save `tempind'


*THIS PROGRAM RUNS VARIOUS JOINT REGRESSIONS OF BALANCE

use $temdir/aca_CENCOL_withwages, clear


		gen sfa_any=sfa_cal==1|sfa_bog==1|sfa_pel==1|sfa_loa==1
			label var sfa_any "Had Any Financial Aid"
			label var emp_numq "Quarters Employed"
			label var emp_anypre "Employed $>$ 1 Quarter"
			label var emp_gr8pre "Employed $>$ 8 Quarters"
			label var emp_prewag "Mean Quarterly Earnings"
			label var dwork_minwag         "Ever Earned at Least Min Wage"
			label var dwork_health         "Industry is Health"
			label var dwork_health_hosp    "Industry is Health: Hospitals"
			label var dwork_health_amb     "Industry is Health: Ambulatory"
			label var dwork_health_nursres "Industry is Health: Nursing/Residential Care"
			label var dwork_retail         "Industry is Retail"
			label var dwork_admin          "Industry is Administrative"
			label var dwork_admin_plac     "Industry is Administrative: Placement Service"
			label var dwork_educ           "Industry is Education"
			label var dwork_acfo_food      "Industry is Food Service"	
*KEEP A FLAT VERSION
keep if appflag==1

global tabvarlist "sex_F race_W race_B race_H race_A age_atfirst gpa_prelot1 enr_othcol_prelot1 enr_othdis_prelot1  sfa_bog sfa_pell sfa_cal sfa_loan emp_anypre emp_numq emp_gr8pre emp_prewag  dwork_health dwork_health_hosp   dwork_health_amb    dwork_health_nursres dwork_retail dwork_admin  dwork_educ  dwork_acfo_food "


*Individual Regressions (Table 1)
foreach g in all 57{
			preserve
			*First set it up
				gen o=1
			
				eststo trash: reg o 
				eststo trash1: reg o $regvarlist if lotnum==1 & lot_cat<4 & ESAMPLE`g'==1
				esttab trash   trash trash  using "$outdir/rr/regs_balance_indols_`g'.tex",  replace nostar se drop(*) nogaps nonumbers nonotes noobs nomtitles nocons scalar( ) prehead("\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi}\begin{tabular}{lccc}\hline\hline")					posthead("&&\multicolumn{2}{c}{\underline{Admit-Reject Difference}}\\&Mean&All&1st Lottery\\\hline") postfoot("")
			*Then run the individual regressions
			foreach z in $tabvarlist{	
			

			
				egen m`z'=mean(`z')
				eststo m`z': reg m`z' o if lotnum==1 & ESAMPLE`g'==1, nocons
				eststo da`z': reg `z' lot_adm rlotfe*  if lotnum<5 & ESAMPLE`g'==1, vce(cluster lot_term)
				eststo d1`z': reg `z' lot_adm rlotfe* if lotnum==1  & ESAMPLE`g'==1,vce(cluster lot_term)
				esttab m`z'  da`z' d1`z'   using "$outdir/rr/regs_balance_indols_`g'.tex",  append nostar se keep (`z') label nogaps nonumbers nonotes noobs nomtitles nocons rename(o `z' lot_adm `z' ) 						prehead("") posthead("") prefoot("") postfoot("")
				}
				
				eststo mzz: reg  o if lotnum==1 & ESAMPLE`g'==1, nocons
				eststo dazz: reg o lotnumfe* if lotnum<5 & ESAMPLE`g'==1, vce(cluster ssn)
				eststo d1zz: reg o if lotnum==1  & ESAMPLE`g'==1,vce(cluster ssn)
				
				esttab mzz dazz d1zz  using "$outdir/rr/regs_balance_indols_`g'.tex",  append nostar se drop(*) stat(N) label nogaps nonumbers nonotes noobs nomtitles nocons 						prehead("\hline") posthead("") prefoot("") postfoot("\hline\hline")
				restore
						}
						
*Overall (robustness)
eststo total2: reg lot_adm $allvarlist  if lotnum==1 & ESAMPLE5==1, absorb(lot_term)
eststo total4: reg lot_adm $allvarlist i.lotnum if lotnum<5 & ESAMPLE5==1	, absorb(lot_term)
esttab total* using "$outdir/rr/regs_balance_total.tex",  replace nostar se keep ($allvarlist) b(%9.3f)  se(%9.3f) label nogaps nonumbers nonotes noobs nomtitles nocons stat(N F p) prehead(" ") prefoot(" ") posthead(" ") postfoot(" ") 
eststo clear
						
						
