
clear all
set more off 
cap log close 
set mem 12g 
set matsize 11000

global dir "/home/research/cavoced/cred" 
global build "$dir/build"
global analy "$dir/analysis"

global prodir "${analy}/prog"
global logdir "${analy}/prog" 
global rawdir "${analy}/raw" 
global temdir "${analy}/temp" /*unclean data, but not raw*/
global anadir "${analy}/data"
global outdir "${analy}/output"

global texdir "$outdir/tex"
global txtdir "$outdir/txt"
global xlsdir "$outdir/xls"
global londir "$outdir/xls/long"
global figdir "$outdir/figs"




use $temdir/aca_CENCOL_withwages_rr, clear

		
	********************
	*Regressions
	**********************
	
	global racevar "age_at  race_H race_A race_OBX"
	global acadvar "gpa_prelot1   "
	global empvar "hemp_anypre emp_pre "	
	global finvar "sfa_bog sfa_pel  sfa_cal "	

	
*Create a consistent sample for the 1st stage regressions
	reg numlots  lot_adm $racevar $acadvar $empvar $finvar loof* if lotnum==1 & appflag==1
	gen ESAMPLEall=e(sample)
	reg logwage0 win14   zc0* if lotnum<5   & ysince_lot1==5.25 , cluster(ssn)  
	gen ESAMPLE57=e(sample)
	foreach g of varlist E*{
		bysort ssn: egen a=total(`g')
		replace `g'=a>0
		drop a
		}	
	keep if ESAMPLE57==1
		
*new wages definitions
gen wages0_top=wages0
			replace wages0_top=30000 if wages0_top>30000 & wages0_top!=.
gen wages0_cen=wages0 if wages0<=30000		

*winsorized versions
gen cwages0_top=wages0_top
gen cwages0_bot=wages0
	replace cwages0_bot=100 if cwages0_bot<100
gen cwages0_top99=wages0
	replace cwages0_top99=40000 if cwages0_top9>40000&cwages0_top9!=.
gen cwages0_bottop99=wages0
	replace cwages0_bottop99=100 if cwages0_bottop99<100
	replace cwages0_bottop99=40000 if cwages0_bottop99>40000 & cwages0_bottop!=.
gen cwages0_bottop95=wages0
	replace cwages0_bottop95=100 if cwages0_bottop95<100
	replace cwages0_bottop95=30000 if cwages0_bottop95>30000 & cwages0_bottop95!=.

*trimmed versions
gen twages0_top=wages0_cen
gen twages0_bot=wages0
	replace twages0_bot=. if cwages0_bot<100
gen twages0_top99=wages0
	replace twages0_top99=. if twages0_top9>40000&twages0_top9!=.
gen twages0_bottop99=wages0
	replace twages0_bottop99=. if twages0_bottop99<100
	replace twages0_bottop99=. if twages0_bottop99>40000 & twages0_bottop99!=.
gen twages0_bottop95=wages0
	replace twages0_bottop95=. if twages0_bottop95<100
	replace twages0_bottop95=. if twages0_bottop95>30000 & twages0_bottop95!=.
	

******************************************************
	eststo clear
		local covars0=" "	
		local covars1="age_at race_H race_A race_OBX "	
		local covars2="age_at race_H race_A race_OBX gpa_prelot1   "	
		local covars3="age_at race_H race_A race_OBX gpa_prelot1   hemp_anypre emp_pre "	
		local covars4="age_at race_H race_A race_OBX gpa_prelot1   hemp_anypre emp_pre sfa_bog sfa_pel sfa_cal missfin "	


	*Table 3: Enroll and awa2
		foreach endo in enrn enr {

		eststo ie1657: ivreg2 wages0 (`endo'=lot_adm)  enrolled  	`covars4' yfe* qfe* flot loofe*     `covars' gap if lotnum==1 & rys==5, cluster(ssn)  
			estadd scalar Ftous=e(widstat)
			sum wages0 if e(sample)  & lot_adm==0
			estadd scalar meanwag=r(mean)				
			estimates save "$temdir/lev`endo'1157" , replace			
		eststo ie1657: ivreg2 wages0_top (`endo'=lot_adm)  enrolled  	`covars4' yfe* qfe* flot loofe*     `covars' gap if lotnum==1 & rys==5, cluster(ssn)  
			estadd scalar Ftous=e(widstat)
			sum wages0_top if e(sample)  & lot_adm==0
			estadd scalar meanwag=r(mean)				
			estimates save "$temdir/lev`endo'1257" , replace	
		eststo ie1657: ivreg2 wages0_c (`endo'=lot_adm)  enrolled  	`covars4' yfe* qfe* flot loofe*     `covars' gap if lotnum==1 & rys==5, cluster(ssn)  
			estadd scalar Ftous=e(widstat)
			sum wages0 if e(sample)  & lot_adm==0
			estadd scalar meanwag=r(mean)				
			estimates save "$temdir/lev`endo'1357" , replace	
			}
			}
		
	
	

*Winsorizing sensitivity table
	eststo clear
	foreach g of varlist twages0* cwages0*{
		eststo g`g': ivreg2 `g' (enrn=lot_adm)  enrolled  	`covars4' yfe* qfe* flot loofe*     `covars' gap if lotnum==1 & rys==5, cluster(ssn)  
			estadd scalar Ftous=e(widstat)
			sum wages0 if e(sample)  & lot_adm==0
			estadd scalar meanwag=r(mean)				
		}
	
	global optionss "label se nonotes  nogaps nomtitles noobs nonumbers nolines "
	
	foreach z in 0_top 0_top99 0_bot 0_bottop99 0_bottop95{
	esttab *`z' using "$outdir/condacc/reg_levsens_`z'.tex", replace nostar              keep(enrn )	 stat(N N_clust , label("N" "Students"  )) 	  $optionss prehead(" ") posthead(" ") postfoot(" ") keep(enrn)
	}

	
	