clear all
set more off

*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><
*																				
*		epp-tables-figures.do
*		see AEJPol_2017_0709_data_read_me.pdf
*
*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><

cd "your\path\here"

*-------------------------------------------------------------------------------
*	Macro used in many places
*-------------------------------------------------------------------------------

loc X stdscore_tm1_avg Xgys* stdscore_tm1_avgXgys* MI_stdscore_tm1_avg ///
	retained female MI_female ell sped i.raceth t_va_subj MI_t_va_subj

*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><
*	Table 1 and Figure A2
*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><

use epp-obsv-pre , clear

*-------------------------------------------------------------------------------
*	Table 1, Panel A
*-------------------------------------------------------------------------------

loc inst so ms pic ls act qu feed grp tck tks th ps 
loc plan ip sw as 
loc envi ex msb env rc 

foreach x in obsvmean ///
			 obsvmean_inst `inst' ///
			 obsvmean_plan `plan' ///
			 obsvmean_envi `envi' {
		
	sum `x' need_`x' have_`x'
			
}		

*-------------------------------------------------------------------------------
*	Table 1, Panel B
*-------------------------------------------------------------------------------

sum any_needs any_haves 
sum Nneeds Nhaves
sum Nneeds if Nneeds > 0 
sum Nhaves if Nhaves > 0

*-------------------------------------------------------------------------------
*	Figure A2
*-------------------------------------------------------------------------------

hist obsvmean , frac ///
	ytitle( Fraction of teachers ) ///
	xtitle( Teacher mean observation score ) ///
	scheme( s2mono )
	
*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><
*	Table 2 and Table A1
*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><
*-------------------------------------------------------------------------------
*	Table 2 - student characteristics
*-------------------------------------------------------------------------------

use epp-analysis , clear
keep if year == 2014

gen stdscore_tm1_ma  = stdscore_tm1 if subject == "ma"
gen stdscore_tm1_rla = stdscore_tm1 if subject == "rla"

gen white  = raceth == 1
gen black  = raceth == 2
gen latino = raceth == 3
gen other  = inlist( raceth , 4 , 6 )

loc stupre stdscore_tm1_ma stdscore_tm1_rla female white black latino other ell sped retained 

collapse `stupre' , by( studentid schoolid treat rblock ) 

foreach x in `stupre' {

	di in yellow "`x'"

	qui bysort rblock : center `x'
	qui sum `x'
	qui replace c_`x' = c_`x' + r(mean)
	sum c_`x' if treat == 0
	sum c_`x' if treat == 1
	
	epp_est , y( `x' ) t( treat ) 
	
}

*-------------------------------------------------------------------------------
*	Table 2 and Table A1 - teacher characteristics
*-------------------------------------------------------------------------------

use epp-analysis , clear
keep if year == 2014

replace t_expr = . if MI_t_expr == 1 // undo the "fill in missing with 0"

loc tchpre t_expr t_va_avg t_va t_pmatches_nat tm_va tm_sgrade tm_ssubj

collapse `tchpre' , by( teacherid schoolid treat rblock t_targ t_ment t_norole targXt mentXt noroleXt ) 
isid teacherid

merge 1:1 teacherid using epp-obsv-pre , nogen keep( master match ) keepusing( obsvmean )

foreach x in t_expr t_va_avg obsvmean {

	di in yellow "`x'"

	qui bysort rblock : center `x'
	qui sum `x'
	qui replace c_`x' = c_`x' + r(mean)
	sum c_`x' if treat == 0
	sum c_`x' if treat == 1
	
	epp_est , y( `x' ) t( treat ) 
	epp_est , y( `x' ) t( targXt mentXt noroleXt ) x( t_ment t_norole )
	
}

*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><
*	Table 3
*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><
*-------------------------------------------------------------------------------
*	Table 3, Panel A - school-level regressions
*-------------------------------------------------------------------------------

use epp-analysis , clear
keep if year == 2014

* reduce to school-level observations
keep studentid subject schoolid rblock treat stdscore stdscore_tm1 
duplicates drop
drop if mi( stdscore_tm1 )
collapse (mean) stdscore stdscore_tm1 (count) n_stu = stdscore , by( schoolid treat rblock ) 

epp_est , y( stdscore ) t( treat ) wt( n_stu )
epp_est , y( stdscore ) t( treat ) x( stdscore_tm1 ) wt( n_stu )

*-------------------------------------------------------------------------------
*	Table 3, Panels B and C, Columns 1-2 - student-level, experiment year
*-------------------------------------------------------------------------------

use epp-analysis , clear
keep if year == 2014

epp_est , y( stdscore ) t( treat ) wt( wt_stu_tch )
epp_est , y( stdscore ) t( treat ) x( `X' ) wt( wt_stu_tch )
epp_est , y( stdscore ) t( targXt mentXt noroleXt ) x( t_ment t_norole ) wt( wt_stu_tch )
epp_est , y( stdscore ) t( targXt mentXt noroleXt ) x( t_ment t_norole `X' ) wt( wt_stu_tch )

*-------------------------------------------------------------------------------
*	Table 3, Panels B and C, Column 3 - student-level, year after experiment
*-------------------------------------------------------------------------------

use epp-analysis , clear
keep if year == 2015

epp_est , y( stdscore ) t( treat ) x( `X' ) wt( wt_stu_tch )
epp_est , y( stdscore ) t( targXt mentXt noroleXt ) x( t_ment t_norole `X' ) wt( wt_stu_tch )

*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><
*	Table A2
*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><
	
use epp-analysis , clear
keep if year == 2014

epp_est , y( t_targ_tot ) t( targXt mentXt noroleXt ) x( t_ment t_norole ) wt( wt_stu_tch )
epp_est , y( t_ment_tot ) t( targXt mentXt noroleXt ) x( t_ment t_norole ) wt( wt_stu_tch )

*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><
*	Table 4 and Table A3
*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><

use epp-analysis , clear
keep if year == 2014

*-------------------------------------------------------------------------------
*	Table 4
*-------------------------------------------------------------------------------

epp_est , y( stdscore ) t( targXt targXtXt_pmatches ) ///
	x( mentXt noroleXt t_ment t_norole targXt_pmatches `X' ) wt( wt_stu_tch )
	
epp_est , y( stdscore ) t( targXt targXtXt_pmatches_high ) ///
	x( mentXt noroleXt t_ment t_norole targXt_pmatches_high `X' ) wt( wt_stu_tch )
	
epp_est , y( stdscore ) t( targXt targXtXt_needs ) ///
	x( mentXt noroleXt t_ment t_norole targXt_needs `X' ) wt( wt_stu_tch ) 
	
epp_est , y( stdscore ) t( targXt targXtXt_pmatches targXtXt_needs ) ///
	x( mentXt noroleXt t_ment t_norole targXt_pmatches targXt_needs `X' ) wt( wt_stu_tch )
	
epp_est , y( stdscore ) t( targXt targXtXt_va targXtXtm_va ) ///
	x( mentXt noroleXt t_ment t_norole targXt_va targXtm_va MI_t_va MI_tm_va `X' ) wt( wt_stu_tch )
	
epp_est , y( stdscore ) t( targXt targXtXt_va targXtXtm_va targXtXtxtm_va ) ///
	x( mentXt noroleXt t_ment t_norole targXt_va targXtm_va targXtxtm_va MI_t_va MI_tm_va MI_txtm_va `X' ) wt( wt_stu_tch )
	
epp_est , y( stdscore ) t( targXt targXtXt_pmatches targXtXt_va targXtXtm_va ) ///
	x( mentXt noroleXt t_ment t_norole targXt_pmatches targXt_va targXtm_va MI_t_va MI_tm_va `X' ) wt( wt_stu_tch )
	
epp_est , y( stdscore ) t( targXt targXtXt_pmatches targXtXt_va targXtXtm_va targXtXtxtm_va ) ///
	x( mentXt noroleXt t_ment t_norole targXt_pmatches targXt_va targXtm_va targXtxtm_va MI_t_va MI_tm_va MI_txtm_va `X' ) wt( wt_stu_tch )

*-------------------------------------------------------------------------------
*	Table A3
*-------------------------------------------------------------------------------
	
epp_est , y( stdscore ) t( targXt targXtXtm_ssubj ) ///
	x( mentXt noroleXt t_ment t_norole targXtm_ssubj MI_tm_ssubj `X' ) wt( wt_stu_tch )
	
epp_est , y( stdscore ) t( targXt targXtXtm_sgrade ) ///
	x( mentXt noroleXt t_ment t_norole targXtm_sgrade MI_tm_sgrade `X' ) wt( wt_stu_tch )
	
epp_est , y( stdscore ) t( targXt targXtXt_expr targXtXt_expr2 ) ///
	x( mentXt noroleXt t_ment t_norole targXt_expr targXt_expr2 MI_t_expr `X' ) wt( wt_stu_tch )
	
epp_est , y( stdscore ) t( targXt targXtXt_expr_young ) ///
	x( mentXt noroleXt t_ment t_norole targXt_expr_young MI_t_expr `X' ) wt( wt_stu_tch )
	
epp_est , y( stdscore ) t( targXt targXtXtm_expr ) ///
	x( mentXt noroleXt t_ment t_norole targXtm_expr MI_tm_expr `X' ) wt( wt_stu_tch )	 

*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><
*	Table 5
*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><

use epp-obsv-post , clear

preserve
keep if t_targ == 1 
epp_est , y( obsvmean )          t( treat ) x( i.expr_group i.year )
epp_est , y( obsvmean_match )    t( treat ) x( i.expr_group i.year )
epp_est , y( obsvmean_notmatch ) t( treat ) x( i.expr_group i.year )
epp_est , y( obsvmean_notneed )  t( treat ) x( i.expr_group i.year )
restore

preserve
keep if t_ment == 1 
epp_est , y( obsvmean )          t( treat ) x( i.expr_group i.year )
restore

preserve
keep if t_norole == 1 
epp_est , y( obsvmean )          t( treat ) x( i.expr_group i.year )
restore

*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><
*	Figure A3
*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><

use epp-analysis-add , clear

bysort rblock : center stdscore 
sum stdscore 
replace c_stdscore = c_stdscore + r(mean)

collapse (mean) c_stdscore , by( treat year )
reshape wide c_stdscore , i( year ) j( treat )

tw 	( scatter c_stdscore1 year , c(l) lc( black ) lp( solid ) mc( black ) ) ///
	( scatter c_stdscore0 year , c(l) lc( black ) lp( dash  ) mc( black ) ) ///
	, ///
	ytitle( Mean student math and reading/ELA score ) ///
	yscale( range( -.5 .5 ) ) ///
	ylabel( -.5(.25).5 ) ///
	xtitle( Year ) ///
	legend( order( 1 "Treatment" 2 "Control" ) ) ///
	scheme( s2mono )

*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><
*	Table C1
*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><
*-------------------------------------------------------------------------------
*	Table C1, Column 1 
*-------------------------------------------------------------------------------

use epp-analysis , clear
keep if year == 2014

keep teacherid schoolid treat rblock t_targ t_ment t_norole targXt mentXt noroleXt 
duplicates drop
count
assert r(N) == 136

append using attrited-treat-year 
isid teacherid 
count
assert r(N) == 141

replace attrit_t0 = 0 if mi( attrit_t0 )

epp_est , y( attrit_t0 ) t( treat ) 

drop if t_targ == 1 // no attrition from target
epp_est , y( attrit_t0 )  t( mentXt noroleXt ) x( t_norole )

*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><
*	Table C2
*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><
*-------------------------------------------------------------------------------
*	Table C2, Column 1 
*-------------------------------------------------------------------------------

use epp-analysis , clear

egen obs_in_2015 = max( year == 2015 ) , by( teacherid )
gen attrit_tp1 = obs_in_2015 == 0

keep teacherid attrit_tp1 schoolid treat rblock t_targ t_ment t_norole targXt mentXt noroleXt 
duplicates drop
count
assert r(N) == 136

epp_est , y( attrit_tp1 ) t( treat ) 
epp_est , y( attrit_tp1 )  t( targXt mentXt noroleXt ) x( t_ment t_norole )

*-------------------------------------------------------------------------------
*	Lee-style bounds, find teachers to trim
*-------------------------------------------------------------------------------

use epp-analysis , clear
keep if year == 2015

gen delta_excl = .e

foreach r in targ ment norole {

	levelsof teacherid if t_`r' == 1 , clean

	foreach i in `r(levels)' {
	
		qui areg stdscore targXt mentXt noroleXt t_ment t_norole ///
			if teacherid != `i' [ aw = wt_stu_tch ] , absorb( rblock )
			
		replace delta_excl = _b[`r'Xt] if teacherid == `i'
	
	}
	
}

keep teacherid treat t_targ t_ment t_norole delta_excl
duplicates drop  
isid teacherid

  sort treat t_targ t_ment t_norole   delta_excl  
bysort treat t_targ t_ment t_norole ( delta_excl ) : gen min_rank = _n
bysort treat t_targ t_ment t_norole ( delta_excl ) : gen max_rank = abs( _n - _N ) + 1

foreach m in min max {
	list teacherid if ( t_targ == 1 & treat == 0 & `m'_rank == 1 ) ///
					| ( t_ment == 1 & treat == 1 & `m'_rank == 1 ) ///
					| ( t_norole == 1 & treat == 0 & `m'_rank <= 3 )
}

*-------------------------------------------------------------------------------
*	Table C2, Column 5 
*-------------------------------------------------------------------------------

use epp-analysis , clear
keep if year == 2015

drop if inlist( teacherid , 66635 , 83840 , 97959 , 97964 , 97989 ) // identified above

epp_est , y( stdscore ) t( treat ) x( `X' ) wt( wt_stu_tch )
epp_est , y( stdscore ) t( targXt mentXt noroleXt ) x( t_ment t_norole `X' ) wt( wt_stu_tch )

*-------------------------------------------------------------------------------
*	Table C2, Column 6 
*-------------------------------------------------------------------------------

use epp-analysis , clear
keep if year == 2015

drop if inlist( teacherid , 93609 , 30817 , 97974 , 48772 , 14213 ) // identified above

epp_est , y( stdscore ) t( treat ) x( `X' ) wt( wt_stu_tch )
epp_est , y( stdscore ) t( targXt mentXt noroleXt ) x( t_ment t_norole `X' ) wt( wt_stu_tch )

*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><
*<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><
