*******************************
* Selection figures for paper *
*******************************
clear
set more off
set scheme s1mono

log using selection_appendix, text replace

/* cps_search was downloaded from the IPUMS CPS website. Here are the samples, variables,
   and data quality flags corresponding to  this dataset: 

 Sample	Note
IPUMS-CPS, ASEC 1968	
IPUMS-CPS, ASEC 1969	
IPUMS-CPS, ASEC 1970	
IPUMS-CPS, ASEC 1971	
IPUMS-CPS, ASEC 1972	
IPUMS-CPS, ASEC 1973	
IPUMS-CPS, ASEC 1974	
IPUMS-CPS, ASEC 1975	
IPUMS-CPS, ASEC 1976	
IPUMS-CPS, ASEC 1977	
IPUMS-CPS, ASEC 1978	
IPUMS-CPS, ASEC 1979	
IPUMS-CPS, ASEC 1980	
IPUMS-CPS, ASEC 1981	
IPUMS-CPS, ASEC 1982	
IPUMS-CPS, ASEC 1983	
IPUMS-CPS, ASEC 1984	
IPUMS-CPS, ASEC 1985	
IPUMS-CPS, ASEC 1986	
IPUMS-CPS, ASEC 1987	
IPUMS-CPS, ASEC 1988	
IPUMS-CPS, ASEC 1989	
IPUMS-CPS, ASEC 1990	
IPUMS-CPS, ASEC 1991	
IPUMS-CPS, ASEC 1992	
IPUMS-CPS, ASEC 1993	

Type	Variable	Label
H	YEAR	Survey year
H	SERIAL	Household serial number
H	MONTH	Month
H	CPSID	CPSID, household record
H	ASECFLAG	Flag for ASEC
H	STATEFIP	State (FIPS code)
H	METAREA	Metropolitan area
P	PERNUM	Person number in sample unit
P	CPSIDP	CPSID, person record
P	AGE	Age
P	SEX	Sex
P	RACE	Race
P	MARST	Marital status
P	POPSTAT	Adult civilian, armed forces, or child
P	EMPSTAT	Employment status
P	LABFORCE	Labor force status
P	OCC1990	Occupation, 1990 basis
P	IND1990	Industry, 1990 basis
P	CLASSWKR	Class of worker
P	UHRSWORK1	Hours usually worked per week at main job
P	DURUNEM2	Continuous weeks unemployed, intervalled
P	DURUNEMP	Continuous weeks unemployed
P	WHYUNEMP	Reason for unemployment
P	EDUC	Educational attainment recode
P	OCC50LY	Occupation last year, 1950 basis
P	IND50LY	Industry last year, 1950 basis
P	OCC90LY	Occupation last year, 1990 basis
P	IND90LY	Industry last year, 1990 basis
P	CLASSWLY	Class of worker last year
P	WKSWORK1	Weeks worked last year
P	WKSWORK2	Weeks worked last year, intervalled
P	UHRSWORKLY	Usual hours worked per week (last yr)
P	LOOKING	Looking for work
P	FULLPART	Worked full or part time last year
P	NWLOOKWK	Weeks looked for work last year (didn't work)
P	WANTJOB	Want regular job now
P	BLVENOWK	Believe no work available
P	CANTFIND	Could not find work
P	FWKADS	Placed or checked ads to find work
P	FWKEMPLR	Checked with employer for work
P	FWKOTHER	Used other methods to find work
P	FWKPUBAG	Checked public employment agency for work
P	FWKPVTAG	Checked private employment agency for work
P	FWKRELAT	Checked with friends and relatives for work
P	INTENFWK	Intend to find work in the next 12 months
P	INCWAGE	Wage and salary income

Type	Variable
P	QAGE
P	QSEX
P	QRACE
P	QLABFORC
P	QOCC
P	QFWKADS

*/

***************
* Directories *
***************

clear mata
clear matrix
set maxvar 10000
set matsize 10000

use summary_by_year_comp, replace
merge n:1 description_new using soc_codes_corresp
drop if _merge==2
replace soc_new=999999 if soc_new==.
drop _merge

drop if description_new_miss==1 | soc_new==999999
drop if year<1950

gen occsoc=floor(soc_new/100)
replace occsoc=1110 if occsoc==1120
replace occsoc=1130 if occsoc==1131
replace occsoc=2510 if occsoc==2511
replace occsoc=2520 if occsoc==2590
replace occsoc=2911 if occsoc==2990
replace occsoc=3190 if occsoc==3110
replace occsoc=3520 if occsoc==3510
replace occsoc=3530 if occsoc==3590
replace occsoc=3990 if occsoc==3970
replace occsoc=4130 if occsoc==4140
replace occsoc=4530 if occsoc==4540

foreach var of varlist spitz*C {
   gen `var'_W=`var'/words*1000
}

bys year: egen sum_ads=sum(ct)
bys year occsoc: egen sum_ads_=sum(ct)
gen share=sum_ads_/sum_ads

collapse (mean) spitz*W [aw=share], by(occsoc)
save selection_fixed_task, replace

use cps_search, clear

***********************
* Sample Restrictions *
***********************
*Keep 16-64 year old, non-military
keep if age>=16 & age<=64 & popstat==1
drop if qocc==4  | qsex==4 | qage==4

gen byte nonwhite=(race~=100)
gen byte not_married = (marst~=1 & marst~=2) 

*Keep unemployed, looking for work, w/ positive person weight
keep if looking==2 & empstat<=22 & wtsupp>0


***********************
*Variable construction*
***********************

gen female=sex==2

gen experience=.
replace experience=age-6 if  (educ<=12 & educ>=2)
replace experience=age-7 if  educ==14
replace experience=age-8 if  educ==15
replace experience=age-9 if  educ==16 | educ==13
replace experience=age-10 if  educ==17
replace experience=age-11 if  educ==21 | educ==22
replace experience=age-12 if educ==23
replace experience=age-13 if  educ==20 | educ==25
replace experience=age-14 if  educ==24 | educ==26
replace experience=age-15 if  educ==30
replace experience=age-16 if  educ==40
replace experience=age-17 if  educ==50
replace experience=age-18 if  educ>=60 & educ<=65
replace experience=age-19 if  educ>=70 & educ<=71
replace experience=age-20 if  educ>=80 & educ<=84
replace experience=age-21 if  educ==90 
replace experience=age-22 if  educ>=99 & educ<=102 
replace experience=age-24 if  educ>=110 & educ<=111
replace experience=age-25 if educ>=112 & educ<=115
replace experience=age-28 if educ>=116 & educ<.
replace experience=0 if experience<0
gen experience5=floor(experience/10)
replace experience5=3 if experience5>=4

tab year, gen(yr)

*Recode variables
foreach var of varlist fwk* {
	tab `var'
	gen d_`var'=`var'==2
	}
	
gen educ1=(educ<=71) /*LT HS*/
gen educ2=(educ>71 & educ<=73) /*HS DEGREE*/
gen educ3=(educ>73 & educ<110) /*SOME COLLEGE*/
gen educ4=(educ>=110 & educ<=111)  /*COLLEGE */
gen educ5=(educ>=112 & educ<=125) /* POST-COLLEGE */
	
**************************************************
* FIGURE: Methods of Job Search Among Unemployed *
**************************************************
*Variables for plots
foreach var of varlist d_* {
	gen p_`var'=.
}
gen yr_plot=.
label var yr_plot "Year"
label var p_d_fwkads "Placed/checked ads"
label var p_d_fwkrelat "Friends and relatives"
label var p_d_fwkpvtag "Private emp. agency"
label var p_d_fwkemplr "Contacted employer directly"
label var p_d_fwkother "Other"

foreach var of varlist d_fwk* {
	foreach year of numlist 1964(1)1996 {
		local yr=`year'-1963
		sum `var' [aw=wtsupp] if year==`year'
		replace p_`var'=r(mean) in `yr'	
		replace yr_plot=`year' in `yr'
	}
}

twoway (scatter p_d_fwkads yr_plot in 5/30, yaxis(1) mcolor(navy) lcolor(navy)  msize(small)) ///
(scatter p_d_fwkrelat yr_plot in 5/30, yaxis(1) mcolor(dkorange) lcolor(dkorange)  msize(small)) ///
(scatter p_d_fwkpvtag yr_plot in 5/30, yaxis(1) mcolor(green) lcolor(green)  msize(small)) ///
(scatter p_d_fwkemplr yr_plot in 5/30, yaxis(1) mcolor(purple) lcolor(purple) msymbol(Oh)  msize(small)) ///
(scatter p_d_fwkother yr_plot in 13/33, yaxis(1) mcolor(red) lcolor(red)  msize(small)), ///
	ytitle("Fraction using job search method", margin(medlarge) size(medium) axis(1))  ///
	  xlabel(1970(5)1990)   ylabel(0(.1)1, )
graph export jobsearch_ads.eps, replace

*****************************************************************
* FIGURE: Formally testing differential selection by occupation *
*****************************************************************
tab occ50ly, sort gen(occdum)
drop occdum6-occdum260

gen yr_plot_trends=.

foreach var of varlist  occdum1-occdum5  {
	foreach yr of numlist 1(1)26 {
		gen `var'_`yr'=`var'*yr`yr'
	}
}

reg d_fwkads occdum1 occdum2 occdum3 occdum4 occdum5 occdum1_2-occdum1_26 occdum2_2-occdum2_26 occdum3_2-occdum3_26 occdum4_2-occdum4_26 occdum5_2-occdum5_26 i.experience5 not_married  female nonwhite yr2-yr26 [aw=wtsupp]

*F-Tests
test  occdum2_2= occdum2_3= occdum2_4= occdum2_5= occdum2_6= occdum2_7= occdum2_8= occdum2_9= occdum2_10= occdum2_11= occdum2_12= occdum2_13= occdum2_14= occdum2_15= occdum2_16= ///
	occdum2_17= occdum2_18= occdum2_19= occdum2_20= occdum2_21= occdum2_22= occdum2_23= occdum2_24= occdum2_25= occdum2_26=0 
test  occdum3_2= occdum3_3= occdum3_4= occdum3_5= occdum3_6= occdum3_7= occdum3_8= occdum3_9= occdum3_10= occdum3_11= occdum3_12= occdum3_13= occdum3_14= occdum3_15= occdum3_16= ///
	occdum3_17= occdum3_18= occdum3_19= occdum3_20= occdum3_21= occdum3_22= occdum3_23= occdum3_24= occdum3_25= occdum3_26=0 
test  occdum4_2= occdum4_3= occdum4_4= occdum4_5= occdum4_6= occdum4_7= occdum4_8= occdum4_9= occdum4_10= occdum4_11= occdum4_12= occdum4_13= occdum4_14= occdum4_15= occdum4_16= ///
	occdum4_17= occdum4_18= occdum4_19= occdum4_20= occdum4_21= occdum4_22= occdum4_23= occdum4_24= occdum4_25= occdum4_26=0 
test  occdum5_2= occdum5_3= occdum5_4= occdum5_5= occdum5_6= occdum5_7= occdum5_8= occdum5_9= occdum5_10= occdum5_11= occdum5_12= occdum5_13= occdum5_14= occdum5_15= occdum5_16= ///
	occdum5_17= occdum5_18= occdum5_19= occdum5_20= occdum5_21= occdum5_22= occdum5_23= occdum5_24= occdum5_25= occdum5_26=0 
	
*Variables for plots
foreach var of varlist occdum2 occdum3 occdum4 occdum5 {
	gen p_`var'=.
	gen p_`var'_up=.
	gen p_`var'_down=.
}

foreach var of varlist occdum2 occdum3 occdum4 occdum5 {
	foreach year of numlist 2(1)26 {
		replace p_`var'=_b[`var'_`year'] in `year'
		replace p_`var'_up=_b[`var'_`year']+1.96*_se[`var'_`year'] in `year'
		replace p_`var'_down=_b[`var'_`year']-1.96*_se[`var'_`year'] in `year'
		replace yr_plot_trends=`year'+1967 in `year'
	}
}

label var occdum2 "Operative workers"
label var occdum3 "Laborers"
label var occdum4 "Clerical"
label var occdum5 "Managers"
label var yr_plot_trends "Year"

foreach var of varlist occdum2 occdum3 occdum4 occdum5 {
	twoway (line p_`var'_up yr_plot_trends in 2/30, yaxis(1) mcolor(orange) lcolor(orange) lpattern(dash)  msize(small)) ///
	(line p_`var' yr_plot_trends in 2/30, yaxis(1) mcolor(navy) lcolor(navy)  msize(small)) ///
	(line p_`var'_down yr_plot_trends in 2/30, yaxis(1) mcolor(orange) lcolor(orange)lpattern(dash)  msize(small)), ///
		ytitle("Probability that person placed/checked ads", margin(medlarge) size(medium) axis(1))  ///
		  xlabel(1970(5)1990)   ylabel(-.5(.1).5, ) legend(off) title(`: variable label `var'')
	graph export differential_trends_`var'.eps, replace
}

***********************************************************
* DIFFERENTIAL TRENDS BY INTENSITY OF ROUTINE/NON-ROUTINE *
***********************************************************
*Goal here: 
	* (1) Take fixed S-O task measures by occupation (from create_task_data_w_occ_crosswalks.do)
	* (2) Test for differential trends based on occupation being above/below
	*		75th percentile / below 25th percentile in task intensity
	
*Merge with the *job loss* occupation by OCC1990
rename occ1990 occ1990_cur
rename occ90ly occ1990
*The fixed_tasks.dta dataset is created in the Build_CPS.do file
merge n:1 occ1990 using occ1990_occsoc_correspondence, keep(3)
drop _merge
merge n:1 occsoc using selection_fixed_task, keep(3)
drop _merge

*Let's re-standardize the Spitz-Oener task measures
*Note: percentiles are based within a specific subpopulation: unemployed workers

*Percentiles
foreach var of varlist  spitz_nr_analytic_C_W spitz_nr_inter_C_W spitz_r_cognitive_C_W spitz_r_manual_C_W spitz_nr_manual_C_W {
	xtile `var'_q = `var' [aw=wtsupp], n(4) /*Person Weights -- we could also weight by person-hours*/
}

*High and low task intensity occupations: 1st and 4th Quartiles
foreach name in "spitz_nr_analytic" "spitz_nr_inter" "spitz_r_cognitive" "spitz_r_manual" "spitz_nr_manual" {
		gen `name'_high=(`name'_C_W_q==4)
		gen `name'_low=(`name'_C_W_q==1)
}

foreach var of varlist spitz_nr_analytic_high spitz_nr_analytic_low spitz_r_manual_high spitz_r_manual_low spitz_nr_inter_high  spitz_nr_inter_low spitz_r_cognitive_high spitz_r_cognitive_low spitz_nr_manual_high spitz_nr_manual_low educ1 educ2 educ3 educ4 educ5 {
	foreach yr of numlist 1(1)26 {
		gen `var'_`yr'=`var'*yr`yr'
	}
}

*Variables for plots
foreach var of varlist spitz_nr_analytic_high spitz_nr_analytic_low spitz_r_manual_high spitz_r_manual_low spitz_nr_inter_high  spitz_nr_inter_low spitz_r_cognitive_high spitz_r_cognitive_low spitz_nr_manual_high spitz_nr_manual_low educ1 educ2 educ3 educ4 educ5  {
	gen p_`var'=.
	gen p_`var'_up=.
	gen p_`var'_down=.
}

label var spitz_nr_analytic_high "High non-routine analytic"
label var spitz_nr_analytic_low "Low non-routine analytic"

label var spitz_r_manual_high "High routine manual"
label var spitz_r_manual_low "Low routine manual"

label var spitz_nr_inter_high "High non-routine interactive"
label var spitz_nr_inter_low "Low non-routine interactive"

label var spitz_r_cognitive_high "High routine cognitive"
label var spitz_r_cognitive_low "Low routine cognitive"
	
label var spitz_nr_manual_high "High non-routine manual"
label var spitz_nr_manual_low "Low non-routine manual"

label var educ2 "H.S. Degree"
label var educ3 "Some College"
label var educ4 "College"
label var educ5 "Post Graduate"

foreach var of varlist spitz_nr_analytic_high spitz_nr_analytic_low spitz_r_manual_high spitz_r_manual_low spitz_nr_inter_high  spitz_nr_inter_low spitz_r_cognitive_high spitz_r_cognitive_low spitz_nr_manual_high spitz_nr_manual_low    {

	reg d_fwkads `var' `var'_2-`var'_26  i.experience5 not_married  female educ2 educ3 educ4 educ5 nonwhite yr2-yr26 [aw=wtsupp]

	replace p_`var'=0
	replace p_`var'_up=0
	replace p_`var'_down=0
	foreach year of numlist 2(1)26 {
		replace p_`var'=_b[`var'_`year'] in `year'
		replace p_`var'_up=_b[`var'_`year']+1.96*_se[`var'_`year'] in `year'
		replace p_`var'_down=_b[`var'_`year']-1.96*_se[`var'_`year'] in `year'
		replace yr_plot_trends=`year'+1967 in `year'
	}
	
	twoway (line p_`var'_up yr_plot_trends in 2/30, yaxis(1) mcolor(orange) lcolor(orange) lpattern(dash)  msize(small)) ///
		(line p_`var' yr_plot_trends in 2/30, yaxis(1) mcolor(navy) lcolor(navy)  msize(small)) ///
		(line p_`var'_down yr_plot_trends in 2/30, yaxis(1) mcolor(orange) lcolor(orange)lpattern(dash)  msize(small)), ///
			ytitle("Probability that person placed/checked ads", margin(medlarge) size(medium) axis(1))  ///
			xtitle("Year")  xlabel(1970(5)1990)   ylabel(-.5(.1).5, ) legend(off) title(`: variable label `var'')
		graph export differential_trends_`var'.eps, replace
}

reg d_fwkads educ2 educ3 educ4 educ5 educ2_2-educ2_26 educ3_2-educ3_26 educ4_2-educ4_26 educ5_2-educ5_26 i.experience5 not_married female nonwhite yr2-yr26 [aw=wtsupp]

foreach var of varlist educ2 educ3 educ4 educ5   {
	capture gen p_`var'=.
	capture gen p_`var'_up=.
	capture gen p_`var'_down=.
	replace p_`var'=0
	replace p_`var'_up=0
	replace p_`var'_down=0
	foreach year of numlist 2(1)26 {
		replace p_`var'=_b[`var'_`year'] in `year'
		replace p_`var'_up=_b[`var'_`year']+1.96*_se[`var'_`year'] in `year'
		replace p_`var'_down=_b[`var'_`year']-1.96*_se[`var'_`year'] in `year'
		replace yr_plot_trends=`year'+1967 in `year'
	}
	
	twoway (line p_`var'_up yr_plot_trends in 2/30, yaxis(1) mcolor(orange) lcolor(orange) lpattern(dash)  msize(small)) ///
		(line p_`var' yr_plot_trends in 2/30, yaxis(1) mcolor(navy) lcolor(navy)  msize(small)) ///
		(line p_`var'_down yr_plot_trends in 2/30, yaxis(1) mcolor(orange) lcolor(orange)lpattern(dash)  msize(small)), ///
			ytitle("Probability that person placed/checked ads", margin(medlarge) size(medium) axis(1))  ///
			xtitle("Year")  xlabel(1970(5)1990)   ylabel(-.5(.1).5 ) legend(off) title(`: variable label `var'')
		graph export differential_trends_`var'.eps, replace
}


**************************************************
* FIGURE: Methods of Job Search By Occupation    *
**************************************************
*Variables for plots
capture gen yr_plot=.
foreach var of varlist spitz_nr_analytic_high spitz_nr_analytic_low spitz_r_manual_high spitz_r_manual_low spitz_nr_inter_high  spitz_nr_inter_low spitz_r_cognitive_high spitz_r_cognitive_low spitz_nr_manual_high spitz_nr_manual_low educ1 educ2 educ3 educ4 educ5 {
	capture gen p_d_`var'=.

	foreach year of numlist 1964(1)1996 {
		local yr=`year'-1963
		sum d_fwkads [aw=wtsupp] if year==`year' & `var'==1
		replace p_d_`var'=r(mean) in `yr'	
		replace yr_plot=`year' in `yr'
	}
}

label var yr_plot "Year"
label var p_d_spitz_nr_analytic_high "High non-routine analytic"
label var p_d_spitz_nr_analytic_low "Low non-routine analytic"
label var p_d_spitz_r_manual_high "High routine manual"
label var p_d_spitz_r_manual_low "Low routine manual"
label var p_d_spitz_nr_inter_high "High non-routine interactive"
label var p_d_spitz_nr_inter_low "Low non-routine interactive"
label var p_d_spitz_r_cognitive_high "High routine cognitive"
label var p_d_spitz_r_cognitive_low "Low routine cognitive"	
label var p_d_spitz_nr_manual_high "High non-routine manual"
label var p_d_spitz_nr_manual_low "Low non-routine manual"
label var p_d_educ1 "Less than H.S."
label var p_d_educ2 "H.S. Degree"
label var p_d_educ3 "Some College"
label var p_d_educ4 "College"
label var p_d_educ5 "Post Graduate"

foreach name in "spitz_nr_analytic" "spitz_r_manual" "spitz_nr_inter" "spitz_r_cognitive" "spitz_nr_manual"    {
	twoway (scatter p_d_`name'_high yr_plot in 5/30, yaxis(1) mcolor(black) msymbol(Oh) lcolor(dkorange)  msize(small)) ///
	(scatter p_d_`name'_low yr_plot in 5/30, yaxis(1) mcolor(green) lcolor(green)  msize(small)), ///
	ytitle("Probability that person placed/checked ads", margin(medlarge) size(medium) axis(1))  ///
	  xlabel(1970(5)1990)   ylabel(0(.1)1, )
	  graph export trends_`name'.eps, replace
}

twoway (line p_d_educ1 yr_plot in 5/30, yaxis(1) lpattern(dash)  mcolor(black) lcolor(black)  msize(small)) ///
	(line p_d_educ2 yr_plot in 5/30, yaxis(1) lpattern(shortdash) mcolor(green) lcolor(green)  msize(small)) ///
	(line p_d_educ3 yr_plot in 5/30, yaxis(1) lwidth(medthin)  mcolor(red) lcolor(red)  msize(small)) ///
	(line p_d_educ4 yr_plot in 5/30, yaxis(1) lpattern(thick) mcolor(gray) lcolor(gray)  msize(small)) ///
        (line p_d_educ5 yr_plot in 5/30, yaxis(1) lpattern(thick) lpattern(longdash) mcolor(blue) lcolor(blue)  msize(small)), ///
	ytitle("Probability that person placed/checked ads", margin(medlarge) size(medium) axis(1))  ///
	  xlabel(1970(5)1990)   ylabel(0(.1)1, )
	  graph export trends_educ.eps, replace

log close

