/* Phase in analysis

Mitchells Plain



set more off
clear all
set matsize 1000

cap cd "C:/Users/UCTAdmin/Dropbox"
cap cd "C:/Users/Grant Smith/Dropbox (GRS collaborations)"
cap cd "/Users/kjack/Dropbox"
cap cd "C:/Users/JPAL/Dropbox"
cap cd "/Users/Grant/Dropbox"

* Set macros

global IN  "SA Utilities/Phase in/Mitchell's Plain/Data and analysis"

global resdir "SA Utilities/Paper/Tables-Figures"

use "$IN/Data/admin_data/workingdata.dta", clear

*/

*********************************
** (8) CE and NPV CALCULATIONS **
*********************************
/* RUN NPV_SE_V2 ON SERVER */


// First, cost effectiveness from current customer base


** Estimate inputs to NPV calculation

			cap file close iv1
				file open iv1 using ///
					"$resdir/MP_PV.tex", ///
					write text replace
				file write iv1 "\begin{tabular}{l cc}"	_n
				file write iv1 "\hline" _n
				file write iv1 " & Postpaid & Prepaid \\ " _n
				file write iv1 "  \hline" _n
				file write iv1 " \\" _n

preserve

	drop if switchmonthD == 1
	keep if shortrun == 1
	
	xi:xtivreg revenue (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen rev_0 = _b[1._at]
	local rev_0 : display %-4.2f _b[1._at]
	local se_0  : display %-4.2f _se[1._at]
	gen rev_1 = _b[2._at]
	local rev_1 : display %-4.2f _b[2._at]
	local se_1  : display %-4.2f _se[2._at]
	
	
	file write iv1 " & \multicolumn{2}{c}{Revenue estimate} \\ " _n
			
	file write iv1 "Revenue $(pq^m)$ & `rev_0' & `rev_1' \\ " _n
	file write iv1 " & (`se_0') & (`se_1') \\ " _n

	file write iv1 " \hline " _n
	file write iv1 " \\ " _n

	
	xi:xtivreg timing (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen timing_0 = _b[1._at]
	local timing_0 : display %-4.2f _b[1._at]
	local se_0  : display %-4.2f _se[1._at]
	gen timing_1 = _b[2._at]
	local timing_1 : display %-4.2f _b[2._at]
	local se_1  : display %-4.2f _se[2._at]


	file write iv1 " & \multicolumn{2}{c}{Payment timing estimate} \\ " _n
			
	file write iv1 "Months since consumption $(s^m)$ & `timing_0' & `timing_1' \\ " _n
	file write iv1 " & (`se_0') & (`se_1') \\ " _n
	file write iv1 " \hline " _n
	file write iv1 " \\ " _n

		
	xi:xtivreg cost (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen cost_0 = _b[1._at]
	local cost_0 : display %-4.2f _b[1._at]
	local se_0  : display %-4.2f _se[1._at]
	gen cost_1 = _b[2._at]
	local cost_1 : display %-4.2f _b[2._at]
	local se_1  : display %-4.2f _se[2._at]


	file write iv1 " & \multicolumn{2}{c}{Cost estimate} \\ " _n
			
	file write iv1 "Cost $(cq^m + b^m)$ & `cost_0' & `cost_1' \\ " _n
	file write iv1 " & (`se_0') & (`se_1') \\ " _n
	file write iv1 "Includes: & & \\ " _n
	file write iv1 "- Meter reading & 0.91 & 0 \\ " _n
	file write iv1 "- Billing & 0.85 & 0 \\ " _n
	file write iv1 "- Vendor commission & 0 & 0.002/kWh \\ " _n
	file write iv1 "- Losses (percent) & 11.25 & 11.25 \\ " _n
	file write iv1 "- Disconnections & 90 & 0 \\ " _n
	file write iv1 " \hline " _n
	file write iv1 "\\"
	
	
** Calculate mean NPV 
	
	sum rev_* cost_* timing_*

	gen NPV_0 = 0 // ignore diff in meter cost
	gen NPV_1 = 0
	
	cap gen i = .
	replace i = 1+.00643 // annual rate of 8%
	
	
	
		forval m = 0/1 {
	
		replace NPV_`m' = NPV_`m' + (rev_`m' / (i^(1+timing_`m'))) - ((cost_`m') / (i ^ 1)) 
		
		}

	
	gen NPV_diff = NPV_1 / abs(NPV_0)	
	sum NPV_0 
	local pv_0 : display %-4.2f `r(mean)'
	sum NPV_1 
	local pv_1 : display %-4.2f `r(mean)'
	sum NPV_diff
	
	file write iv1 "Present value & `pv_0' & `pv_1' \\ " _n
	
restore

				
preserve
	
	insheet using "$IN/Data/admin_data/NPV_diff.txt", tab clear names
	*keep if _n > _N - 4
	drop if characteristic == "Characteristic"
	destring se, replace
	sum se if characteristic == "NPV_0"
	local se_0 : display %-4.2f `r(mean)'
	sum se if characteristic == "NPV_1"
	local se_1 : display %-4.2f `r(mean)'
	
	file write iv1 " & (`se_0') & (`se_1') \\ " _n
	file write iv1 " \hline " _n
	file write iv1 "\end{tabular}" _n
	file close iv1
	
restore

// What if customer behavior didn't change?


preserve

	drop if switchmonthD == 1
	keep if shortrun == 1
	
	xtivreg revenue (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen rev_0 = _b[1._at]
	
	xtivreg usd_30_real (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen rev_1 = _b[1._at] // revenue ignoring write offs
	
	xtivreg cost (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen cost_0 = _b[1._at]

	// all of the differences are on the cost side
	// now assign pp admin costs to postpaid consumption
	replace cost = mcons_30 * mc * 1.1125 // supply cost
	replace cost = cost + (mcons_30 * vendor) // assign everyone vending costs rather than postpaid costs
	
	xtivreg cost (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen cost_1 = _b[1._at] // cost with disconnection and billing adjustments, but holding consumption fixed
	
	xtivreg timing (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen timing_0 = _b[1._at]
	gen timing_1 = _b[2._at]
	

** Calculate mean NPV 
	
	keep if _n == 1
	sum rev_* cost_* timing_*
	

	gen NPV_0 = 0 // ignore diff in meter cost
	gen NPV_1 = 0
	
	gen i = 1+.00643 // annual rate of 8%
	
	
		forval m = 0/1 {
	
		replace NPV_`m' = NPV_`m' + (rev_`m' / (i^(1+timing_`m'))) - ((cost_`m') / (i ^ 1)) 
		
		}

	gen NPV_perc = NPV_1/abs(NPV_0)
	sum NPV_perc NPV_0 NPV_1

restore

// Payback period // 

* prepaid meter costs ~66USD while a postpaid meter costs ~30USD
* Q: how long does it take for the difference in annual net revenue to make up for the difference in cost?

* Annual net revenue: 4.2 * 12 = 50.4 -- well above the difference in fixed price // PV at the start of the year is ~47



// Figures // 

 

preserve

	* by interest rate
	
	insheet using "$IN/Data/admin_data/NPV_int.txt", tab clear
	gen annual = ((_n-1)*3) / 100
	
	twoway (line npv_0 annual) (line npv_1 annual , lpattern(dash)) , ///
		xtitle(Annual interest rate) ytitle(Monthly net revenue (USD2014)) ///
		legend(order(1 "Postpaid" 2 "Prepaid" )) xline(0.08, lpattern(dot) lcolor(black)) ///
		graphregion(fcolor(white) lcolor(white))
		
		graph export "$resdir/MP_NPVvsinterest.pdf", replace

	
	* by marginal cost
	
	insheet using "$IN/Data/admin_data/NPV_cost.txt", tab clear
	
	twoway (line npv_0 mcx) (line npv_1 mcx , lpattern(dash)) , ///
		xtitle(X times marginal costs (USD)) ytitle(Monthly net revenue (USD2014)) ///
		legend(order(1 "Postpaid" 2 "Prepaid" )) xline(1, lpattern(dot) lcolor(black)) ///
		graphregion(fcolor(white) lcolor(white))
		
		graph export "$resdir/MP_NPVvscost.pdf", replace

	
	* by loss
	
	insheet using "$IN/Data/admin_data/NPV_loss.txt", tab clear
	
	twoway (line npv_0 lossx) (line npv_1 lossx , lpattern(dash)) , ///
		xtitle(Prepaid impact on losses (USD)) ytitle(Monthly net revenue (USD2014)) ///
		legend(order(1 "Postpaid" 2 "Prepaid" )) xline(1, lpattern(dot) lcolor(black)) ///
		graphregion(fcolor(white) lcolor(white))
		
		graph export "$resdir/MP_NPVvsloss.pdf", replace

restore

*/
		
* Heterogeneity  


preserve

drop if switchmonthD == 1
keep if shortrun == 1

cap file close NPV_het_base
file open NPV_het_base using "$IN/Data/admin_data/NPV_het_base.txt", write text replace

file write NPV_het_base "Characteristic" _tab "high" _tab "NPV_0" _tab "NPV_1" _n

	
foreach var of varlist mlifeline_switch below_medkwh pval300 outstanding1 usuallylate ever_disconnected_cr { 

	xtset, clear
	
	tempfile all
	save `all', replace

	forval h = 0/1 {
	
			di "var is `var'"
			di "q is `q'"

			keep if `var' == `h'
			
			* get observed stats
						xtset id monthyear
						
						xtivreg revenue (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
						margins, at(pp = (0 1)) post
					
						gen rev_0 = _b[1._at]
						gen rev_1 = _b[2._at]
						
						xtivreg cost (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
						margins, at(pp = (0 1)) post
						gen cost_0 = _b[1._at]
						gen cost_1 = _b[2._at]
						
						xtivreg timing (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
						margins, at(pp = (0 1)) post
						gen timing_0 = _b[1._at]
						gen timing_1 = _b[2._at]
					
						sum rev_* cost_* timing_*
					
						gen NPV_0 = 0 // ignore meter cost 
						gen NPV_1 = 0
						gen NPV_diff = .
						
						gen i = 1+.00643 // monthly rate
						
						
							forval m = 0/1 {
						
							replace NPV_`m' = NPV_`m' + (rev_`m' / (i^(1+timing_`m'))) - ((cost_`m') / (i ^ 1)) 
							
							}
							replace NPV_diff = (NPV_1 ) / abs(NPV_0)
						
						
						sum NPV_0
						local NPV_0 : display %8.0fc `r(mean)'
						
						sum NPV_1
						local NPV_1 : display %8.0fc `r(mean)'
			
			file write NPV_het_base "`var'" _tab "`h'" _tab "`NPV_0'" _tab "`NPV_1'" _n
		
			use `all', clear
			
		} // end q loop
	
	} // end var loop

file close NPV_het_base 
	
restore

preserve

	insheet using "$IN/Data/admin_data/NPV_het_base.txt", tab clear

	tempfile het
	save `het', replace

	insheet using "$IN/Data/admin_data/NPV_het.txt", tab clear
	// mlifeline_switch below_medkwh pval300 usuallylate outstanding1 ever_disconnected_cr
	sort characteristic high shortrun
	merge m:1 characteristic high using `het'
		
	gen x = . 
	replace x = 1 if characteristic == "mlifeline_switch" & high == 0
	replace x = 2 if characteristic == "mlifeline_switch" & high == 1
	
	replace x = 4 if characteristic == "below_medkwh" & high == 0
	replace x = 5 if characteristic == "below_medkwh" & high == 1
	
	replace x = 7 if characteristic == "pval300" & high == 0
	replace x = 8 if characteristic == "pval300" & high == 1
		
	replace x = 10 if characteristic == "usuallylate" & high == 0
	replace x = 11 if characteristic == "usuallylate" & high == 1
	
	replace x = 13 if characteristic == "outstanding1" & high == 0
	replace x = 14 if characteristic == "outstanding1" & high == 1
	
	replace x = 16 if characteristic == "ever_disconnected_cr" & high == 0
	replace x = 17 if characteristic == "ever_disconnected_cr" & high == 1
	
	gen label = -.2

		
		twoway (bar observed x,  barwidth(.75)) (rcap cinormallb cinormalub x, ) ///
			(scatter label x,  mlabel(npv_0)  mlabcolor(black) msymbol(none) mlabposition(6) ), ///
			yline(1, lcolor(black) lpattern(dash)) yline(0, lcolor(black)) yscale(range(-0.5(.5)5)) xtitle("") ///
			ylabel(-0.4 "Postpaid PV" 0 "0" 1 "100%" 2 "200%" 3 "300%" 4 "400%" 5 "500%", angle(0) labsize(small) noticks nogrid) ///
			xlabel(1 "Domestic" 2 "Lifeline" 4 "High kWh" 5 "Low kWh" 7 "High prop val" 8 "Low prop val" ///
			10 "Usually on time" 11 "Usually late" 13 "No debts" 14 "Outstanding debts" 16 "Never disconnected" 17 "Disconnected" ///
			, angle(90))  ytitle("Prepaid returns relative to postpaid") legend(off)  graphregion(fcolor(white) lcolor(white)) 
			
			graph export "$resdir/NPV_het.pdf", replace	

	** Table

		cap file close het
        file open het using "$resdir/MP_NPV_het.tex", write text replace
        file write het "\begin{tabular}{l cc} " _n
        file write het "\hline" _n
        file write het " & Average returns & Relative returns \\ " _n
        file write het " & Postpaid & Pre / Post \\ \hline " _n

        file write het " \\" _n
		
		cap destring npv_0, replace ignore(",")
		
		foreach char in mlifeline_switch below_medkwh pval300 usuallylate outstanding1 ever_disconnected_cr {
			forval h = 0/1 {
				sum observed if characteristic == "`char'" & high == `h'
                local b`char'`h' : display %-9.2f `r(mean)'
                sum se if characteristic == "`char'" & high == `h'
                local se`char'`h' : display %-4.2f `r(mean)'
				
				sum npv_0 if characteristic == "`char'" & high == `h'
				local v`char'`h' : display %-9.0fc `r(mean)'
				
				}
			}
			
		
		file write het "Domestic & `vmlifeline_switch0' & `bmlifeline_switch0' \\ " _n
		file write het " & & (`semlifeline_switch0') \\ " _n
		file write het "Lifeline & `vmlifeline_switch1' & `bmlifeline_switch1' \\ " _n
		file write het " & & (`semlifeline_switch1') \\ " _n
		file write het " \\ " _n
		file write het "Above median kWh & `vbelow_medkwh0' & `bbelow_medkwh0' \\ " _n
		file write het " & & (`sebelow_medkwh0') \\ " _n
		file write het "Below median kWh & `vbelow_medkwh1' & `bbelow_medkwh1' \\ " _n
		file write het " & & (`sebelow_medkwh1') \\ " _n
		file write het " \\ " _n
		file write het "High prop value & `vpval3000' & `bpval3000' \\ " _n
		file write het " & & (`sepval3000') \\ " _n
		file write het "Low prop value & `vpval3001' & `bpval3001' \\ " _n
		file write het " & & (`sepval3001') \\ " _n
		file write het " \\ " _n
		file write het "Usually on time & `vusuallylate0' & `busuallylate0' \\ " _n
		file write het " & & (`seusuallylate0') \\ " _n
		file write het "Usually late & `vusuallylate1' & `busuallylate1' \\ " _n
		file write het " & & (`seusuallylate1') \\ " _n
		file write het " \\ " _n
		file write het "No debts & `voutstanding10' & `boutstanding10' \\ " _n
		file write het " & & (`seoutstanding10') \\ " _n
		file write het "Outstanding debts & `voutstanding11' & `boutstanding11' \\ " _n
		file write het " & & (`seoutstanding11') \\ " _n
		file write het " \\ " _n
		file write het "Never disconnected & `vever_disconnected_cr0' & `bever_disconnected_cr0' \\ " _n
		file write het " & & (`seever_disconnected_cr0') \\ " _n
		file write het "Ever disconnected & `vever_disconnected_cr1' & `bever_disconnected_cr1' \\ " _n
		file write het " & & (`seever_disconnected_cr1') \\ " _n
		file write het " \hline " _n
		file write het "\end{tabular}" _n
		file close het		
			
restore

preserve // presentation versions


	insheet using "$IN/Data/admin_data/NPV_het.txt", tab clear
	// mlifeline_switch below_medkwh pval300 usuallylate outstanding1 ever_disconnected_cr
	
	gen x = . 
	replace x = 1 if characteristic == "below_medkwh" & high == 0
	replace x = 2 if characteristic == "below_medkwh" & high == 1
	
	replace x = 4 if characteristic == "pval300" & high == 0
	replace x = 5 if characteristic == "pval300" & high == 1
	
		twoway (bar observed x, horizontal barwidth(.75)) (rcap cinormallb cinormalub x, horizontal), ///
			xline(0, lcolor(black))  ///
			ylabel(1 "High kWh" 2 "Low kWh" 4 "High prop val" 5 "Low prop val" ///
			, angle(0)) yscale(reverse) ///
			ytitle("") legend(off)  graphregion(fcolor(white) lcolor(white)) aspectratio(.9, placement(right))
			graph export "$resdir/NPV_het_present1.pdf", replace	
	
	replace x = .
	replace x = 1 if characteristic == "usuallylate" & high == 0
	replace x = 2 if characteristic == "usuallylate" & high == 1
	
	replace x = 4 if characteristic == "outstanding1" & high == 0
	replace x = 5 if characteristic == "outstanding1" & high == 1
	
	twoway (bar observed x, horizontal barwidth(.75)) (rcap cinormallb cinormalub x, horizontal), ///
			xline(0, lcolor(black))  ///
			ylabel(1 "Usually on time" 2 "Usually late" 4 "No debts" 5 "Outstanding debts"  ///
			, angle(0)) yscale(reverse) ///
			ytitle("") legend(off)  graphregion(fcolor(white) lcolor(white)) aspectratio(.9, placement(right))
			graph export "$resdir/NPV_het_present2.pdf", replace


	replace x = . 

	replace x = 1 if characteristic == "mlifeline_switch" & high == 0
	replace x = 2 if characteristic == "mlifeline_switch" & high == 1
	
	replace x = 4 if characteristic == "pval300" & high == 0
	replace x = 5 if characteristic == "pval300" & high == 1
		
	replace x = 7 if characteristic == "usuallylate" & high == 0
	replace x = 8 if characteristic == "usuallylate" & high == 1
	
	replace x = 10 if characteristic == "ever_disconnected_cr" & high == 0
	replace x = 11 if characteristic == "ever_disconnected_cr" & high == 1

	
		twoway (bar observed x if observed < 2,  barwidth(.75)) (rcap cinormallb cinormalub x if observed < 2, ) , ///
			yline(1, lcolor(black) lpattern(dash)) yline(0, lcolor(black)) yscale(range(0(.5)3)) xtitle("") ///
			ylabel(0 "0" 1 "100%" 2 "200%" 3 "300%", angle(0) labsize(small) noticks nogrid) ///
			xlabel(1 "Domestic" 2 "Lifeline" 4 "High prop val" 5 "Low prop val" ///
			7 "Usually on time" 8 "Usually late" 10 "Never disconnected" 11 "Ever disconnected" ///
			, angle(90))  ytitle("Relative net revenue (pre / post)") legend(off)  graphregion(fcolor(white) lcolor(white)) 
			
			graph export "$resdir/NPV_het_brief.pdf", replace	
 
	restore
	
