/* Phase in analysis

Mitchells Plain

*/

set more off
clear all
set matsize 1000
set seed 5925169

cap cd "C:/Users/UCTAdmin/Dropbox"
cap cd "C:/Users/Grant Smith/Dropbox (GRS collaborations)"
cap cd "/Users/kjack/Dropbox"
cap cd "/Users/kelsey/Dropbox"
cap cd "C:/Users/JPAL/Dropbox"
cap cd "/Users/Grant/Dropbox"

* ssc install boottest

* Set macros

global IN  "SA Utilities/Phase in/Mitchell's Plain/Data and analysis"

global resdir "SA Utilities/Paper/Tables-Figures"

global bootrep 10 // change to appropriate number 


/* Final clean up and instrument construction

use "$IN/Data/admin_data/workingdata.dta", clear

sort id monthyear	
bys id: egen ever_switch = max(switchmonthD)

// clean up instrument

local shortstart 2014m11
local shortend 2015m4
local shortcount = tm(`shortend') - tm(`shortstart') + 1
local shortplus = `shortcount'+1

gen shortrun = 1 if monthyear >= tm(`shortstart') & monthyear <= tm(`shortend')
replace shortrun = 0 if shortrun == .

bys id: egen any_short = max(shortrun)
drop if any_short == 0 
drop any_short

gen holiday = group > 9 // delete if this is not necessary

cap drop grouptag
egen grouptag = tag(group) if shortrun == 1 & switchmonthD == 0
cap drop idtag
egen idtag = tag(id) if shortrun == 1 & switchmonthD == 0

cap drop pred_start pred_startmonth
reg assigned_start c.group#mp if shortrun == 1,  cl(group)
predict pred_start
format pred_start %td
tab pred_start

gen pred_startmonth = mofd(pred_start)
format pred_startmonth %tm

gen assignIV = (monthyear > pred_startmonth)
la var assignIV "Predicted assignment"

// for balance table
gen instr1 = group if mp == 1
gen instr2 = group if mp == 0
replace instr1 = 0 if instr1 == .
replace instr2 = 0 if instr2 == .

// for first stage
tab monthyear if shortrun == 1, gen(IV_)
gen IV_0 = monthyear < tm(`shortstart')
gen IV_`shortplus' = monthyear > tm(`shortend')

foreach var of varlist IV_* {

	replace `var' = 0 if `var' == .
	
	gen `var'_MP = `var'*group if mp == 1 
	replace `var'_MP = 0 if `var'_MP == .

	gen `var'_noMP = `var'*group if mp == 0
	replace `var'_noMP = 0 if `var'_noMP == .
	
	gen `var'all = `var'*group
	
	}

drop IV_0* IV_7*

bys id : egen mean_madc = mean(madc_30) if projectmonth == 0 & madc_30 != . & pp == 0			
bys id : egen mean_usd = mean(usd_30_real) if projectmonth == 0  & madc_30 != . & pp == 0		
bys id : egen months = mean(timing) if projectmonth == 0  & pp == 0		

foreach var in mean_madc mean_usd months sharelate outstanding1 ever_disconnected_cr mlifeline_switch propval_real_usd {
	carryforward `var', replace
	}

gen longrun = 1 if monthyear > tm(2013m10) & monthyear < tm(2016m5)
replace longrun = 0 if longrun == .

saveold "$IN/Data/admin_data/workingdata_analysis.dta", replace

*/

use "$IN/Data/admin_data/workingdata_analysis.dta", clear

ddd
**********************************************************************
* (1) Balance checks and summary stats
**********************************************************************



// A. Parallel trends after removing monthyear effects // 

	cap drop hhfe resid mfirst1
	xtreg madc_30 i.monthyear lifeline if switchmonthD == 0 & projectmonth == 0, fe cl(id)
	
	predict hhfe if switchmonthD == 0 & projectmonth == 0, xbu
	gen resid = madc_30-hhfe
	
	gen mfirst1 = mofd(first1)
	
	preserve
		bys monthyear group : egen mresid = mean(resid)
		bys monthyear group : egen sdresid = sd(resid)
		drop if projectmonth == 1
		duplicates drop monthyear group, force
		gen up1 = mresid + sdresid
		gen down1 = mresid - sdresid
		
		twoway (line mresid monthyear), by(group, graphregion(fcolor(white) lcolor(black) ///
		ifcolor(white) ilcolor(white)) plotregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white))) ///
		ytitle("Residual") graphregion(fcolor(white) lcolor(white)) xtitle("") subtitle(, nobox) note("")
	
		*	graph export "$resdir/MP_resid_trends_group.pdf", replace
	
	restore	



// B. Summary stats // 

	cap file close sumstats
	file open sumstats using "$resdir/MP_sumstats_basic.tex", write text replace
	file write sumstats "\begin{tabular}{l cccccc}" _n
	*file write sumstats "\small " _n
	file write sumstats "\hline" _n

		
		xtsum id if shortrun == 1  & switchmonthD == 0			// avg number of obs per account
		local obs : display %8.0fc `r(N)'	
		local accts : display %8.0fc `r(n)'
		local months : display %8.2fc `r(Tbar)'
		
		xtsum id if pp ==1 & switchmonthD == 0 & shortrun == 1		// avg number of pp obs per account (excl switch month)
		local monthspp : display %8.2fc `r(Tbar)'
		
		preserve
		bys id : egen num = sum(1) if shortrun == 1  & switchmonthD == 0		// NOTE THESE INCLUDE BLANKS!!!!
		duplicates drop id, force
		sum num, d
		sum num , detail
		local totsd : display %-4.3f `r(sd)'
		local totmin : display %8.0fc `r(min)'
		local totmax : display %8.0fc `r(max)'
		local totmed : display %8.0fc `r(p50)'
		restore
		
		preserve
		bys id : egen num = sum(pp==1)  if shortrun == 1  & switchmonthD == 0			// NOTE THESE INCLUDE BLANKS!!!!
		duplicates drop id, force
		sum num , detail
		local ppsd : display %-4.3f `r(sd)'
		local ppmin : display %8.0fc `r(min)'
		local ppmax : display %8.0fc `r(max)'
		local ppmed : display %8.0fc `r(p50)'
		restore

		preserve
		sum mean_madc if idtag == 1 & shortrun == 1 & switchmonthD == 0, detail
		local kmean : display %-4.2f `r(mean)'
		local ksd : display %-4.2f `r(sd)'
		local kmin : display %8.0fc `r(min)'
		local kmax : display %8.0fc `r(max)'
		local kmed : display %8.0fc `r(p50)'
		restore
		
		preserve
		sum mean_usd if idtag == 1  & shortrun == 1 & switchmonthD == 0, detail
		local dmean : display %-4.0f `r(mean)'
		local dsd : display %-4.0f `r(sd)'
		local dmin : display %8.0fc `r(min)'
		local dmax : display %8.0fc `r(max)'
		local dmed : display %8.0fc `r(p50)'
		restore

		preserve 
		sum months if idtag == 1  & shortrun == 1 & switchmonthD == 0, detail
		local monthmean : display %-4.2f `r(mean)'
		local monthsd : display %-4.2f `r(sd)'
		local monthmin : display %8.0fc `r(min)'
		local monthmax : display %8.0fc `r(max)'
		local monthmed : display %8.0fc `r(p50)'
		restore
		
		preserve
		sum sharelate if idtag == 1  & shortrun == 1 & switchmonthD == 0, detail
		local latemean : display %-4.2f `r(mean)'
		local latesd : display %-4.2f `r(sd)'
		local latemin : display %8.0fc `r(min)'
		local latemax : display %8.0fc `r(max)'
		local latemed : display %-4.2fc `r(p50)'
		restore

		preserve
		sum outstanding1 if idtag == 1  & shortrun == 1 & switchmonthD == 0, detail
		local outmean : display %-4.2f `r(mean)'
		local outsd : display %-4.2f `r(sd)'
		local outmin : display %8.0fc `r(min)'
		local outmax : display %8.0fc `r(max)'
		local outmed : display %8.0fc `r(p50)'
		restore
		
		preserve
		sum ever_disconnected_cr if idtag == 1  & shortrun == 1 & switchmonthD == 0, detail
		local dismean : display %-4.2f `r(mean)'
		local dissd : display %-4.2f `r(sd)'
		local dismin : display %8.0fc `r(min)'
		local dismax : display %8.0fc `r(max)'
		local dismed : display %8.0fc `r(p50)'
		restore
		
		preserve
		sum propval_real_usd if idtag == 1  & shortrun == 1 & switchmonthD == 0, detail
		local pmean : display %8.0fc `r(mean)'
		local psd : display %8.0fc `r(sd)'
		local pmin : display %8.0fc `r(min)'
		local pmax : display %8.0fc `r(max)'
		local pmed : display %12.0fc `r(p50)'
		restore
		
		preserve
		sum mlifeline_switch if idtag == 1  & shortrun == 1 & switchmonthD == 0, detail
		local lmean : display %-4.2f `r(mean)'
		local lsd : display %-4.2f `r(sd)'
		local lmin : display %8.0fc `r(min)'
		local lmax : display %8.0fc `r(max)'
		local lmed : display %8.0fc `r(p50)'
		restore

		file write sumstats "& Number & Mean & Median & SD & Min & Max \\ " _n
		file write sumstats "& (1) & (2) & (3) & (4) & (5) & (6) \\ \hline" _n
		file write sumstats " \\ " _n
		file write sumstats "& \multicolumn{6}{c}{Panel A. Phase-in window observations} \\" _n
		file write sumstats "Total obs. & `obs' & - & - & - & - & - \\" _n
		file write sumstats "Total cust & `accts' & - & - & - & - & - \\" _n
		file write sumstats "Obs. per cust & - & `months' & `totmed' & `totsd' & `totmin' & `totmax' \\" _n
		file write sumstats "Prepaid obs. per cust & - & `monthspp' & `ppmed' & `ppsd' & `ppmin' & `ppmax' \\ " _n
		file write sumstats " \\ " _n
		file write sumstats "& \multicolumn{6}{c}{Panel B. Pre-project customer-level statistics} \\" _n
		file write sumstats "Daily kWh & - & `kmean' & `kmed' & `ksd' & `kmin' & `kmax' \\ " _n
		file write sumstats "Amount owed per mo. & - & `dmean' & `dmed' & `dsd' & `dmin' & `dmax' \\ " _n	
		file write sumstats "Months late & - & `monthmean' & `monthmed' & `monthsd' & `monthmin' & `monthmax' \\ " _n
		file write sumstats "Share paid late & - & `latemean' & `latemed' & `latesd' & `latemin' & `latemax' \\ " _n
		file write sumstats "Outstanding debts & - & `outmean' & - & - & `outmin' & `outmax' \\ " _n
		file write sumstats "Ever disconnected & - & `dismean' & - & - & `dismin' & `dismax' \\ " _n
		file write sumstats "Lifeline tariff & - & `lmean' & - & - & `lmin' & `lmax' \\ " _n
		file write sumstats "Property value & - & `pmean' & `pmed' & `psd' & `pmin' & `pmax' \\ \hline  " _n
	
		file write sumstats "\end{tabular}" _n
		file close sumstats
	
	
	
// C. Balance tables // 

	preserve
 
		local balance mean_madc mean_usd months sharelate outstanding1 ever_disconnected_cr mlifeline_switch l_prop
		
		keep if idtag == 1
		gen l_prop = ln(propval_real_usd)
		
		label var mean_madc "Daily kWh"
		label var mean_usd "Amount owed per month"
		label var months "Months late"
		label var sharelate "Share paid late"
		label var outstanding1 "Outstanding debts" 
		label var ever_disconnected_cr "Ever disconnected"
		label var mlifeline_switch "Lifeline tariff"
		label var l_prop "Log property value"
		
		
		cap file close balance
		file open balance using ///
			"$resdir/MP_balance_level_propval.tex", ///
			write text replace
		file write balance "\begin{tabular}{lccccc}"	_n
		file write balance "\hline" _n
		file write balance "& Group & Phase 1 & Phase 2 & Switch & Ever \\" _n
		file write balance " & order & order & order & date & switched \\ " _n
		file write balance " & (1) & (2) & (3) & (4) & (5) \\ \hline" _n
					
		foreach Y of local balance {
			
			* Run regressions
			
			foreach X in group {
	
				reg `Y' `X' , cl(group)
				
				local coef_`X'		= _b[`X'] 
				local coef_`X' 	: display %-4.3f `coef_`X''
				local se_`X' 		= _se[`X']
				local se_`X'		: display %-4.3f `se_`X''
				
				local p_`X'  		= (2 * ttail(e(df_r), abs(_b[`X']/_se[`X']))) 
				if `p_`X''>0.1 	local stars_`X' =""
				if `p_`X''<=0.1	local stars_`X' = "*" 
				if `p_`X''<=0.05	local stars_`X' = "**" 
				if `p_`X''<=0.01   local stars_`X' = "***"
			}
			
			reg `Y' instr1 instr2 , cl(group)
				
				foreach X in instr1 instr2 {
				
					local coef_`X'		= _b[`X'] 
					local coef_`X' 	: display %-4.3f `coef_`X''
					local se_`X' 		= _se[`X']
					local se_`X'		: display %-4.3f `se_`X''
					
					local p_`X'  		= (2 * ttail(e(df_r), abs(_b[`X']/_se[`X']))) 
					if `p_`X''>0.1 	local stars_`X' =""
					if `p_`X''<=0.1	local stars_`X' = "*" 
					if `p_`X''<=0.05	local stars_`X' = "**" 
					if `p_`X''<=0.01   local stars_`X' = "***"
				}
				
			foreach X in switchdate switcher {
	
				reg `Y' `X' , cl(group)
				
				local coef_`X'		= _b[`X'] 
				local coef_`X' 	: display %-4.3f `coef_`X''
				local se_`X' 		= _se[`X']
				local se_`X'		: display %-4.3f `se_`X''
				
				local p_`X'  		= (2 * ttail(e(df_r), abs(_b[`X']/_se[`X']))) 
				if `p_`X''>0.1 	local stars_`X' =""
				if `p_`X''<=0.1	local stars_`X' = "*" 
				if `p_`X''<=0.05	local stars_`X' = "**" 
				if `p_`X''<=0.01   local stars_`X' = "***"
			}
			
			
			local ylab 				: variable label `Y'
	
		file write balance "`ylab' & `coef_group'`stars_group' & `coef_instr1'`stars_instr1' & `coef_instr2'`stars_instr2' & `coef_switchdate'`stars_switchdate' & `coef_switcher'`stars_switcher'  \\" _n
		file write balance " & (`se_group') &  (`se_instr1') & (`se_instr2') &  (`se_switchdate') & (`se_switcher') \\ " _n
		} 
		
		file write balance "\hline" _n
		file write balance "\end{tabular}"
		file close balance
		
	restore
	


// D. Figure: Switch windows // 
	
	local holiday_start = td(18dec2014)
	local holiday_end = td(5jan2015)
	format share %-9.2f
	
	twoway (scatteri 27 `holiday_start' 27 `holiday_end', bcolor(gs10) fcolor(white) recast(area)) ///
		(scatter group maildrop if grouptag == 1, msymbol(circle) mcolor(navy)) /// *(scatter group assigned_start if grouptag == 1, msymbol(square_hollow) mcolor(navy)) /// 
		(scatter group medswitch if grouptag == 1, msymbol(triangle_hollow) mcolor(navy) mlabel("(share)") mlabcolor(navy) mlabpos(3)) , ///
		xla(20028 20089 20148 20209, format(%tdD_m_CY)) xscale(range(20028 20250)) ///
		yscale(range(1(2)27)) ylabel(1(2)27, angle(0)) ytitle(Randomization group) ///
		graphregion(fcolor(white) lcolor(white)) ///
		legend(order(2 "Customers informed" 3 "Median switch date (share switched)" 1 "Holiday") rows(4) colfirst) 
		
	graph export "$resdir/MP_switch_window.pdf", replace



// E. Figure: Descriptive analysis of changes in kWh // 
	
	preserve
	
		bys monthyear: egen medkWh = median(madc_30)
		egen monthtag = tag(monthyear)
		gen switched = (pp > 0 & switcher == 1)
		bys monthyear: egen share_switched = mean(switched)
	
		twoway (line medkWh monthyear if monthtag == 1, sort) ///
			(line share_switched monthyear if  monthtag == 1, sort yaxis(2) lcolor(gs8) lpattern(dash)), ///
			legend(order(1 "Median daily avg kWh" 2 "Share switched") cols(2)) ///
			ytitle("Median daily avg kWh") yscale(range(10(2)18)) ylabel(10(2)18) ///
			yscale(range(0(.2)1) axis(2)) ylabel(0(.2)1, axis(2)) ///
			ytitle("Share switched", axis(2)) xtitle("") ///
			graphregion(fcolor(white) lcolor(white))
	
			graph export "$resdir/MP_kwhplot.pdf", replace 
	
	restore


// F. Figure: Marginal costs to City // 

	preserve
	
	egen mtag = tag(monthyear)

		twoway (line mc monthyear if mtag == 1, sort), ///
		legend(off) ///
		ytitle("Average marginal cost (USD)")  ///
		xtitle("") ///
		graphregion(fcolor(white) lcolor(white))

		graph export "$resdir/MP_costs.pdf", replace 
		
	restore
	
	


***********************************
**** (2) Effect on consumption ****
***********************************

// A. Basic table // 

preserve
drop if switchmonthD == 1
drop if shortrun == 0

	cap file close iv1
	file open iv1 using ///
		"$resdir/MP_all.tex", ///
		write text replace
					
		
	file write iv1 "\begin{tabular}{l cc cc}" _n
	file write iv1 "\hline" _n
	file write iv1 " & \multicolumn{2}{c}{Avg daily kWh} & \multicolumn{2}{c}{log(Avg daily kWh)} \\ " _n
	file write iv1 " & OLS & IV & OLS & IV \\ " _n
	file write iv1 " & (1) & (2) & (3) & (4) \\ \hline" _n
			
				local ppcoef "Prepaid"
				local ppstd ""
				local boot "Wild-bootstrap p"
				local r2line "$ R^2$"
				local Nline "N"
				local Nclusline "N customers"
				
				
				* Col 1: OLS + FE - short run
				xtreg madc_30 pp i.monthyear lifeline tariff_error if shortrun == 1, fe cl(group)
					local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
						local asterisk = ""
						if `p'<0.1 {
							local asterisk = "*"
							if `p'<0.05 {
								local asterisk = "**"
								if `p'<0.01 {
									local asterisk = "***"
								}
							}
						}
						
					local b : display %-4.3f _b[pp]
					local se : display %-4.3f _se[pp]
					local r2 : display %-4.3f `e(r2_o)'
					local N : display %9.0gc `e(N)'
					local Nclus : display %9.0gc `e(N_g)'
	
					local ppcoef "`ppcoef' & `b'`asterisk'"
					local ppstd "`ppstd' & (`se')"
					local r2line "`r2line' & `r2'"
					local Nline "`Nline' & `N'"
					local Nclusline "`Nclusline' & `Nclus'"	
		
					boottest pp, reps($bootrep) boottype(wild) nograph
					local p : display %-4.3f `r(p)'
					local boot "`boot' & [`p']"

			
				* Col 2: IV predicted group, FE - short run
				xi:	xtivreg madc_30 i.monthyear lifeline (pp = c.group#mp#monthyear) tariff_error if shortrun == 1, fe vce(cluster group) small
					local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
						local asterisk = ""
						if `p'<0.1 {
							local asterisk = "*"
							if `p'<0.05 {
								local asterisk = "**"
								if `p'<0.01 {
									local asterisk = "***"
								}
							}
						}
						
					local b : display %-4.3f _b[pp]
					local se : display %-4.3f _se[pp]
					local r2 : display %-4.3f `e(r2_o)'
					local N : display %9.0gc `e(N)'
					local Nclus : display %9.0gc `e(N_g)'
	
					local ppcoef "`ppcoef' & `b'`asterisk'"
					local ppstd "`ppstd' & (`se')"
					local r2line "`r2line' & `r2'"
					local Nline "`Nline' & `N'"
					local Nclusline "`Nclusline' & `Nclus'"
					
					boottest pp, reps($bootrep) boottype(wild) nograph
					local p : display %-4.3f `r(p)'
					local boot "`boot' & [`p']"

			* Col 3: OLS + FE - logs
				xtreg l_madc pp i.monthyear lifeline tariff_error if shortrun == 1, fe cl(group)
					local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
						local asterisk = ""
						if `p'<0.1 {
							local asterisk = "*"
							if `p'<0.05 {
								local asterisk = "**"
								if `p'<0.01 {
									local asterisk = "***"
								}
							}
						}
						
					local b : display %-4.3f _b[pp]
					local se : display %-4.3f _se[pp]
					local r2 : display %-4.3f `e(r2_o)'
					local N : display %9.0gc `e(N)'
					local Nclus : display %9.0gc `e(N_g)'
	
					local ppcoef "`ppcoef' & `b'`asterisk'"
					local ppstd "`ppstd' & (`se')"
					local r2line "`r2line' & `r2'"
					local Nline "`Nline' & `N'"
					local Nclusline "`Nclusline' & `Nclus'"	
		
					boottest pp, reps($bootrep) boottype(wild) nograph
					local p : display %-4.3f `r(p)'
					local boot "`boot' & [`p']"

			
				* Col 4: IV - logs
				xi:	xtivreg l_madc i.monthyear lifeline (pp = c.group#mp#monthyear) tariff_error if shortrun == 1, fe vce(cluster group) small
					local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
						local asterisk = ""
						if `p'<0.1 {
							local asterisk = "*"
							if `p'<0.05 {
								local asterisk = "**"
								if `p'<0.01 {
									local asterisk = "***"
								}
							}
						}
						
					local b : display %-4.3f _b[pp]
					local se : display %-4.3f _se[pp]
					local r2 : display %-4.3f `e(r2_o)'
					local N : display %9.0gc `e(N)'
					local Nclus : display %9.0gc `e(N_g)'
	
					local ppcoef "`ppcoef' & `b'`asterisk'"
					local ppstd "`ppstd' & (`se')"
					local r2line "`r2line' & `r2'"
					local Nline "`Nline' & `N'"
					local Nclusline "`Nclusline' & `Nclus'"
					
					boottest pp, reps($bootrep) boottype(wild) nograph
					local p : display %-4.3f `r(p)'
					local boot "`boot' & [`p']"
					
					file write iv1 " " _n
					file write iv1 "`ppcoef' \\" _n
					file write iv1 "`ppstd' \\" _n
					file write iv1 "`boot' \\" _n
					file write iv1 "`Nline' \\" _n
					file write iv1 "`Nclusline' \\" _n
					file write iv1 "\hline" _n
		
		file write iv1 "\end{tabular}" _n	
		file close iv1	
	
	
restore



****************************
** (3) Event study figure **	 												
****************************

/* Event Study figs */

// start with OLS // 

preserve

	replace months_since = monthyear - switchmonth
	drop if (months_since > 4 | months_since < -4) & months_since ! = .
	gen months_since_4 = months_since + 4
	replace months_since_4 = 3 if switcher == 0
	tab months_since_4, gen(eventtime_)
	drop if switchmonthD == 1
	
	*replace months_since_6 = 
		
	*drop if switchmonth == monthyear

	cap drop beta hi lo
	xtreg madc_30 eventtime_2 eventtime_3 eventtime_6 eventtime_7 eventtime_8 eventtime_9 lifeline tariff_error i.monthyear if shortrun == 1, fe cl(group) 

	*reghdfe madc_30 ib5.months_since_6 lifeline tariff_error, absorb(monthyear) cl(group) 
			
	matrix b = e(b)
	matrix V = e(V)

	gen beta = .
	gen hi = .
	gen lo = .
	local i = 1

	foreach t of numlist 2/3 6/9 {
	
		di "i is `i'"
		replace beta = b[1,`i'] if eventtime_`t' == 1
		replace hi = b[1,`i'] + invnormal(0.975) * sqrt(V[`i',`i']) if eventtime_`t' == 1 
		replace lo = b[1,`i'] - invnormal(0.975) * sqrt(V[`i',`i']) if eventtime_`t' == 1 
		local i = `i'+1
		
		}
	
	replace beta = 0 if eventtime_4 == 1
	replace hi = 0 if eventtime_4 == 1
	replace lo = 0 if eventtime_4 == 1
	
	duplicates drop beta hi lo eventtime_*, force
	
	twoway (scatter beta months_since_4 ) ///
		(rspike hi lo months_since_4, sort lcolor(gs6) msize(vtiny)), ///
		xlabel(0 "-4" 2 "-2" 4 "0" 6 "2" 8 "4") /// *xlabel(4 "-30" 10 "-24" 16 "-18" 22 "-12" 28 "-6" 34 "0" 40 "6" 46 "12") ///
		xtitle("Months since switch") legend(off) xline(4, lpattern(dot)) ///
		ytitle("Avg daily kWh (est'd coeff)", tstyle(size(medium))) ///
		graphregion(fcolor(white) lcolor(white))
	graph export "$resdir/MP_eventstudy_timeFE_OLS.pdf",  replace
	
restore	

// then IV // 

preserve	
		
	replace months_since = monthyear - switchmonth
	drop if (months_since > 4 | months_since < -4) & months_since ! = .
	gen months_since_4 = months_since + 4
	replace months_since_4 = 3 if switcher == 0
	tab months_since_4, gen(eventtime_)
	drop if switchmonthD == 1

	cap drop beta hi lo
	xtivreg madc_30 lifeline tariff_error (eventtime_2 eventtime_3 eventtime_6 eventtime_7 eventtime_8 eventtime_9 = c.group#mp#monthyear) i.monthyear if shortrun == 1, fe vce(cluster group)

	matrix b = e(b)
	matrix V = e(V)

	gen beta = .
	gen hi = .
	gen lo = .
	local i = 1

	foreach t of numlist 2/3 6/9 {
	
		di "i is `i'"
		replace beta = b[1,`i'] if eventtime_`t' == 1
		replace hi = b[1,`i'] + invnormal(0.975) * sqrt(V[`i',`i']) if eventtime_`t' == 1 
		replace lo = b[1,`i'] - invnormal(0.975) * sqrt(V[`i',`i']) if eventtime_`t' == 1 
		local i = `i'+1
		
		}
	
	replace beta = 0 if eventtime_4 == 1
	replace hi = 0 if eventtime_4 == 1
	replace lo = 0 if eventtime_4 == 1
	
	duplicates drop beta hi lo eventtime_*, force
	
	twoway (scatter beta months_since_4 ) ///
		(rspike hi lo months_since_4, sort lcolor(gs6) msize(vtiny)), ///
		xlabel(0 "-4" 2 "-2" 4 "0" 6 "2" 8 "4") /// *xlabel(4 "-30" 10 "-24" 16 "-18" 22 "-12" 28 "-6" 34 "0" 40 "6" 46 "12") ///
		xtitle("Months since switch") legend(off) xline(4, lpattern(dot)) ///
		ytitle("Avg daily kWh (est'd coeff)", tstyle(size(medium))) ///
		graphregion(fcolor(white) lcolor(white))	
		
	graph export "$resdir/MP_eventstudy_timeFE_IV.pdf",  replace
	
restore	

// "long run" 

	
	preserve // OLS FIGURE

	replace months_since = monthyear - switchmonth

	drop if switcher == 0
	drop if months_since > 12
	drop if months_since < -12
	tab months_since, gen(eventtime)
	drop if switchmonth == monthyear
	drop eventtime13 // switch month
	drop eventtime12 // base month
	drop eventtime1 // additional omitted month to allow FEs

	cap drop beta hi lo
	xtreg madc_30 eventtime* i.monthyear lifeline tariff_error if months_since != 0, fe cl(group)
			
	matrix b = e(b)
	matrix V = e(V)

	gen beta = .
	gen hi = .
	gen lo = .
	local i = 1

	foreach t of numlist 2/11 14/25 {
	
		di "i is `i'"
		replace beta = b[1,`i'] if eventtime`t' == 1
		replace hi = b[1,`i'] + invnormal(0.975) * sqrt(V[`i',`i']) if eventtime`t' == 1 
		replace lo = b[1,`i'] - invnormal(0.975) * sqrt(V[`i',`i']) if eventtime`t' == 1 
		local i = `i'+1
		
		}
		
	duplicates drop beta hi lo months_since, force
	
	twoway (scatter beta months_since) ///
		(rspike hi lo months_since, sort lcolor(gs6) msize(vtiny)), ///
		xlabel(-12 "-12" -6 "-6" 0 "0" 6 "6" 12 "12") /// *xlabel(4 "-30" 10 "-24" 16 "-18" 22 "-12" 28 "-6" 34 "0" 40 "6" 46 "12") ///
		xtitle("Months since switch") legend(off) xline(0, lpattern(dot)) ///
		ytitle("Avg daily kWh (est'd coeff)", tstyle(size(medium))) ///
		graphregion(fcolor(white) lcolor(white))
	graph export "$resdir/MP_eventstudy_longrun_OLS.pdf",  replace
	
	restore	
	
**********************************************
** (4) Heterogeneous effects on consumption **
**********************************************
																			
preserve
drop if switchmonthD == 1
cap drop idtag
egen idtag = tag(id) if shortrun == 1
keep if shortrun == 1

label define mlifeline_switch 0 "Domestic" 1 "Lifeline", replace
label val mlifeline_switch mlifeline_switch
label define usuallylate 0 "Usually on time" 1 "Usually late", replace
label val usuallylate usuallylate
label define below_medkwh 0 "Above median kWh" 1 "Below median kWh", replace
label val below_medkwh below_medkwh
label define pval300 0 "High prop value" 1 "Low prop value", replace
label val pval300 pval300
label define outstanding1 0 "No debts" 1 "Outstanding debts"
label val outstanding1 outstanding1
label define ever_disconnected_cr 0 "Never disconnected" 1 "Ever disconnected"
label val ever_disconnected_cr ever_disconnected_cr

cap drop assignIV_int pp_int
	
	ds IV_*_*
	local inst `r(varlist)'
	foreach var of local inst {
		gen `var'_int = .
		}
		gen pp_int = .
		
foreach out in madc_30 l_madc {

	cap file close iv1
		if "`out'" == "madc_30" {
			file open iv1 using ///
				"$resdir/MP_hetTE.tex", ///
				write text replace
					}
					else {
						file open iv1 using ///
							"$resdir/MP_hetTE_log.tex", ///
							write text replace
						}
				
			file write iv1 "\begin{tabular}{lc ccccc}"	_n
			file write iv1 "\hline" _n
			file write iv1 " & & & \multicolumn{2}{c}{OLS} & \multicolumn{2}{c}{IV} \\ " _n
			file write iv1 " & \multirow{2}{*}{N cust} & \multirow{2}{*}{Mean} & Total effects & Difference & Total effects & Difference  \\ " _n
			file write iv1 " & & & (1) & (2) & (3) & (4)  \\ \hline" _n

		foreach intvar of varlist mlifeline_switch below_medkwh pval300 usuallylate outstanding1 ever_disconnected_cr  { // ever_disconnected_cr

				file write iv1 " \\ " _n
				
				foreach var of local inst {
					replace `var'_int = `var' * `intvar'
					}
				replace pp_int = pp * `intvar'
				
				local coef`intvar' " "
				local std`intvar' " "
				local coef1`intvar' " "
				local std1`intvar' " "
				
				xtreg `out' c.pp##`intvar' i.monthyear##i.`intvar' i.`intvar'##i.tariff_error, fe cl(group)
					local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
						local asterisk = ""
						if `p'<0.1 {
							local asterisk = "*"
							if `p'<0.05 {
								local asterisk = "**"
								if `p'<0.01 {
									local asterisk = "***"
								}
							}
						}
					local b : display %-4.3f _b[pp]
					local se : display %-4.3f _se[pp]
					local coef`intvar' "`coef`intvar'' & `b'`asterisk'"
					local std`intvar' "`std`intvar'' & (`se')"


				local p = (2 * ttail(e(df_r), abs(_b[1.`intvar'#c.pp]/_se[1.`intvar'#c.pp])))
					local asterisk = ""
						if `p'<0.1 {
							local asterisk = "*"
							if `p'<0.05 {
								local asterisk = "**"
								if `p'<0.01 {
									local asterisk = "***"
								}
							}
						}
					local b : display %-4.3f _b[1.`intvar'#c.pp]
					local se : display %-4.3f _se[1.`intvar'#c.pp]
					local coef`intvar' "`coef`intvar'' & `b'`asterisk'"
					local std`intvar' "`std`intvar'' & (`se')"
					
					boottest 1.`intvar'#c.pp, reps($bootrep) boottype(wild) nograph
					local p : display %-4.3f `r(p)'
					local boot "`p'"
					
				test c.pp + 1.`intvar'#c.pp = 0
				local p = r(p)
						local asterisk = ""
						if `p'<0.1 {
							local asterisk = "*"
							if `p'<0.05 {
								local asterisk = "**"
								if `p'<0.01 {
									local asterisk = "***"
								}
							}
						}
					lincom c.pp + 1.`intvar'#c.pp
					local b1 : display %-4.3f `r(estimate)'
					local se1 : display %-4.3f `r(se)'
					local coef1`intvar' "`coef1`intvar'' & `b1'`asterisk' & [`boot'] "
					local std1`intvar' "`std1`intvar'' & (`se1') &"
					
				xtivreg `out'  (pp pp_int = c.group#mp#monthyear#`intvar') i.monthyear##i.`intvar' i.`intvar'##i.tariff_error, fe vce(cluster group) small
					local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
						local asterisk = ""
						if `p'<0.1 {
							local asterisk = "*"
							if `p'<0.05 {
								local asterisk = "**"
								if `p'<0.01 {
									local asterisk = "***"
								}
							}
						}
					local b : display %-4.3f _b[pp]
					local se : display %-4.3f _se[pp]
					local coef`intvar' "`coef`intvar'' & `b'`asterisk'"
					local std`intvar' "`std`intvar'' & (`se')"

				local p = (2 * ttail(e(df_r), abs(_b[pp_int]/_se[pp_int])))
						local asterisk = ""
						if `p'<0.1 {
							local asterisk = "*"
							if `p'<0.05 {
								local asterisk = "**"
								if `p'<0.01 {
									local asterisk = "***"
								}
							}
						}
					local b : display %-4.3f _b[pp_int]
					local se : display %-4.3f _se[pp_int]
					local coef`intvar' "`coef`intvar'' & `b'`asterisk'"
					local std`intvar' "`std`intvar'' & (`se')"

										
					boottest pp_int, reps($bootrep) boottype(wild) nograph
					local p : display %-4.3f `r(p)'
					local boot1 "`p'"
					
				test pp + pp_int = 0
				local p = r(p)
						local asterisk = ""
						if `p'<0.1 {
							local asterisk = "*"
							if `p'<0.05 {
								local asterisk = "**"
								if `p'<0.01 {
									local asterisk = "***"
								}
							}
						}
					lincom pp + pp_int
					local b1 : display %-4.3f `r(estimate)'
					local se1 : display %-4.3f `r(se)'
					local coef1`intvar' "`coef1`intvar'' & `b1'`asterisk' & [`boot1'] "
					local std1`intvar' "`std1`intvar'' & (`se1') &"
					
			local dlab0 : label `intvar' 0
			local dlab1 : label `intvar' 1
			sum id if e(sample) & `intvar' == 0 & idtag == 1
			local Nacct0 : display %-9.0gc `r(N)'
			sum id if e(sample) & `intvar' == 1 & idtag == 1			
			local Nacct1 : display %-9.0gc `r(N)'
						
			sum madc_30 if `intvar' == 0 & idtag == 1 
			local mean0 : display %-9.2f `r(mean)'
			sum madc_30 if `intvar' == 1 & idtag == 1 
			local mean1 : display %-9.2f `r(mean)'

			file write iv1 "\multirow{2}{1.5in}{`dlab0'}& \multirow{2}{*}{`Nacct0'} & \multirow{2}{*}{`mean0'} `coef`intvar'' \\" _n
			file write iv1 "& & `std`intvar''  \\ " _n
			
			file write iv1 "\multirow{2}{1.5in}{`dlab1'}& \multirow{2}{*}{`Nacct1'}  & \multirow{2}{*}{`mean1'}  `coef1`intvar'' \\" _n
			file write iv1 "& & `std1`intvar''  \\ " _n

			
		}
		file write iv1 "\hline \\" _n
		file write iv1 "\end{tabular}" _n
		file close iv1	
		
	}
	
restore

***************************	
** (5) Robustness checks **
***************************

** First stage **

preserve
drop if switchmonthD == 1
keep if shortrun == 1

	cap file close iv1
		file open iv1 using ///
			"$resdir/MP_firststage.tex", ///
			write text replace
			
	file write iv1 "\begin{tabular}{l c}" _n
	file write iv1 "\hline" _n
	file write iv1 " & Prepaid \\ " _n
	file write iv1 " & (1) \\ \hline" _n
	
	local IV IV_2_MP IV_2_noMP IV_3_MP IV_3_noMP IV_4_MP IV_4_noMP IV_5_MP IV_5_noMP IV_6_MP IV_6_noMP
	
	xtreg pp `IV' i.monthyear tariff_error lifeline, fe cluster(group)
	
	local N : display %9.0gc `e(N)'
	xtsum id if e(sample)
	local Nclus : display %9.0gc `r(n)'
	local r2 : display %-4.3f `e(r2_o)'
	local F : display %-4.3f `e(F)'
	
	foreach inst of local IV {
		local p = (2 * ttail(e(df_r), abs(_b[`inst']/_se[`inst'])))
						local star_`inst' = ""
						if `p'<0.1 {
							local star_`inst' = "*"
							if `p'<0.05 {
								local star_`inst' = "**"
								if `p'<0.01 {
									local star_`inst' = "***"
								}
							}
						}
						
					local b_`inst' : display %-4.3f _b[`inst']
					local se_`inst' : display %-4.3f _se[`inst']
				}	
		file write iv1 "Phase 1 order x December 2014 & `b_IV_2_MP'`star_IV_2_MP' \\" _n
		file write iv1 "& (`se_IV_2_MP')  \\ " _n
		file write iv1 "Phase 2 order x December 2014 & `b_IV_2_noMP'`star_IV_2_noMP' \\" _n
		file write iv1 "& (`se_IV_2_noMP')  \\ " _n
		file write iv1 "Phase 1 order x January 2015 & `b_IV_3_MP'`star_IV_3_MP' \\" _n
		file write iv1 "& (`se_IV_3_MP')  \\ " _n
		file write iv1 "Phase 2 order x January 2015 & `b_IV_3_noMP'`star_IV_3_noMP' \\" _n
		file write iv1 "& (`se_IV_3_noMP')  \\ " _n
		file write iv1 "Phase 1 order x February 2015 & `b_IV_4_MP'`star_IV_4_MP' \\" _n
		file write iv1 "& (`se_IV_4_MP')  \\ " _n
		file write iv1 "Phase 2 order x February 2015 & `b_IV_4_noMP'`star_IV_4_noMP' \\" _n
		file write iv1 "& (`se_IV_4_noMP')  \\ " _n
		file write iv1 "Phase 1 order x March 2015 & `b_IV_5_MP'`star_IV_5_MP' \\" _n
		file write iv1 "& (`se_IV_5_MP')  \\ " _n
		file write iv1 "Phase 2 order x March 2015 & `b_IV_5_noMP'`star_IV_5_noMP' \\" _n
		file write iv1 "& (`se_IV_5_noMP')  \\ " _n
		file write iv1 "Phase 1 order x April 2015 & `b_IV_6_MP'`star_IV_6_MP' \\" _n
		file write iv1 "& (`se_IV_6_MP')  \\ " _n
		file write iv1 "Phase 2 order x April 2015 & `b_IV_6_noMP'`star_IV_6_noMP' \\" _n
		file write iv1 "& (`se_IV_6_noMP')  \\ " _n
		file write iv1 " \\" _n
		file write iv1 "F-stat & `F' \\" _n
		file write iv1 "$ R^2$ & `r2' \\" _n
		file write iv1 "N & `N' \\" _n
		file write iv1 "N customers & `Nclus' \\" _n
		file write iv1 "\hline \\" _n
		file write iv1 "\end{tabular}" _n
		file close iv1	
		
restore

** Set 1: Phase I vs Phase II ** 

preserve
drop if switchmonthD == 1
keep if shortrun == 1

	cap file close iv1
		file open iv1 using ///
			"$resdir/MP_phase_robustness.tex", ///
			write text replace
			
	file write iv1 "\begin{tabular}{l cc cc}" _n
	file write iv1 "\hline" _n
	file write iv1 " & \multicolumn{2}{c}{Avg daily kWh} & \multicolumn{2}{c}{Log avg daily kWh} \\ " _n
	file write iv1 " & OLS & IV & OLS & IV \\ " _n
	file write iv1 " & (1) & (2) & (3) & (4) \\ \hline" _n
			
foreach mp in 1 0 {

	if `mp' == 1 {
					file write iv1 " \\ " _n
					file write iv1 "& \multicolumn{4}{c}{Panel A: Phase 1 (Mitchell's Plain)} \\" _n
					}
					else {
						file write iv1 " \\ " _n
						file write iv1 "& \multicolumn{4}{c}{Panel B: Phase 2} \\" _n
						}
					
				local ppcoef "Prepaid"
				local ppstd ""
				local boot "Wild-bootstrap p"
				local r2line "$ R^2$"
				local Nline "N"
				local Nclusline "N customers"
				
				* Col 1: OLS in levels
				xtreg madc_30 pp i.monthyear lifeline tariff_error if mp == `mp', fe cl(group)
					local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
						local asterisk = ""
						if `p'<0.1 {
							local asterisk = "*"
							if `p'<0.05 {
								local asterisk = "**"
								if `p'<0.01 {
									local asterisk = "***"
								}
							}
						}
						
					local b : display %-4.3f _b[pp]
					local se : display %-4.3f _se[pp]
					local r2 : display %-4.3f `e(r2_o)'
					local N : display %9.0gc `e(N)'
					xtsum id if e(sample)
					local Nclus : display %9.0gc `r(n)'
	
					local ppcoef "`ppcoef' & `b'`asterisk'"
					local ppstd "`ppstd' & (`se')"
					local r2line "`r2line' & `r2'"
					local Nline "`Nline' & `N'"
					local Nclusline "`Nclusline' & `Nclus'"	
		
					boottest pp, reps($bootrep) boottype(wild) nograph
					local p : display %-4.3f `r(p)'
					local boot "`boot' & `p'"
				
				* Col 2: IV in levels
				xtivreg madc_30 i.monthyear lifeline (pp = c.group#mp#monthyear) tariff_error if mp == `mp', fe vce(cluster group) small
					local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
						local asterisk = ""
						if `p'<0.1 {
							local asterisk = "*"
							if `p'<0.05 {
								local asterisk = "**"
								if `p'<0.01 {
									local asterisk = "***"
								}
							}
						}
						
					local b : display %-4.3f _b[pp]
					local se : display %-4.3f _se[pp]
					local r2 : display %-4.3f `e(r2_o)'
					local N : display %9.0gc `e(N)'
					local Nclus : display %9.0gc `e(N_g)'
	
					local ppcoef "`ppcoef' & `b'`asterisk'"
					local ppstd "`ppstd' & (`se')"
					local r2line "`r2line' & `r2'"
					local Nline "`Nline' & `N'"
					local Nclusline "`Nclusline' & `Nclus'"	
		
					boottest pp, reps($bootrep) boottype(wild) nograph
					local p : display %-4.3f `r(p)'
					local boot "`boot' & `p'"

				* Col 3: OLS in logs
				xtreg l_madc pp i.monthyear lifeline tariff_error if mp == `mp', fe cl(group)
					local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
						local asterisk = ""
						if `p'<0.1 {
							local asterisk = "*"
							if `p'<0.05 {
								local asterisk = "**"
								if `p'<0.01 {
									local asterisk = "***"
								}
							}
						}
						
					local b : display %-4.3f _b[pp]
					local se : display %-4.3f _se[pp]
					local r2 : display %-4.3f `e(r2_o)'
					local N : display %9.0gc `e(N)'
					xtsum id if e(sample)
					local Nclus : display %9.0gc `r(n)'
	
					local ppcoef "`ppcoef' & `b'`asterisk'"
					local ppstd "`ppstd' & (`se')"
					local r2line "`r2line' & `r2'"
					local Nline "`Nline' & `N'"
					local Nclusline "`Nclusline' & `Nclus'"	
		
					boottest pp, reps($bootrep) boottype(wild) nograph
					local p : display %-4.3f `r(p)'
					local boot "`boot' & [`p']"
				
				* Col 4: IV in logs
				xtivreg l_madc i.monthyear lifeline (pp = c.group#mp#monthyear) tariff_error if mp == `mp', fe vce(cluster group) small
					local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
						local asterisk = ""
						if `p'<0.1 {
							local asterisk = "*"
							if `p'<0.05 {
								local asterisk = "**"
								if `p'<0.01 {
									local asterisk = "***"
								}
							}
						}
						
					local b : display %-4.3f _b[pp]
					local se : display %-4.3f _se[pp]
					local r2 : display %-4.3f `e(r2_o)'
					local N : display %9.0gc `e(N)'
					local Nclus : display %9.0gc `e(N_g)'
	
					local ppcoef "`ppcoef' & `b'`asterisk'"
					local ppstd "`ppstd' & (`se')"
					local r2line "`r2line' & `r2'"
					local Nline "`Nline' & `N'"
					local Nclusline "`Nclusline' & `Nclus'"	
		
					boottest pp, reps($bootrep) boottype(wild) nograph
					local p : display %-4.3f `r(p)'
					local boot "`boot' & [`p']"

				file write iv1 " " _n
				file write iv1 "`ppcoef' \\" _n
				file write iv1 "`ppstd' \\" _n
				file write iv1 "`boot' \\" _n
				file write iv1 "`r2line' \\" _n
				file write iv1 "`Nline' \\" _n
				file write iv1 "`Nclusline' \\" _n
				file write iv1 "\hline" _n
		
				}
			
		
		file write iv1 "\end{tabular}" _n	
		file close iv1	
	
restore

** Set 2: Robustness to alt specifications **
* instruments, comparison groups

preserve
drop if switchmonthD == 1
gen comparison = 0
*keep if shortrun == 1
				
			local olscoef "Prepaid"
			local olsstd ""
			local ivcoef "Prepaid"
			local ivstd ""
			
			local Nline "N"
			local Nclusline "N customers"
			
			* base
			xtreg madc_30 pp i.monthyear lifeline tariff_error if shortrun == 1, fe cl(group)
				local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[pp]
				local se : display %-4.3f _se[pp]
				local N : display %9.0gc `e(N)'
				xtsum id if e(sample)
				local Nclus : display %9.0gc `r(n)'

				local olscoef "`olscoef' & `b'`asterisk' "
				local olsstd "`olsstd' &  (`se') "
				
				
			xtivreg madc_30 (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error if shortrun == 1, fe vce(cluster group) small
				local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[pp]
				local se : display %-4.3f _se[pp]

				local ivcoef "`ivcoef' & `b'`asterisk'"
				local ivstd "`ivstd' &  (`se')"
				
				local Nline "`Nline' & `N'"
				local Nclusline "`Nclusline' & `Nclus'"
				
				
			* alternate instrument - no spline
			xtivreg madc_30 (pp = c.group#monthyear) i.monthyear lifeline tariff_error if shortrun == 1, fe vce(cluster group) small
				local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[pp]
				local se : display %-4.3f _se[pp]
				local N : display %9.0gc `e(N)'
				xtsum id if e(sample)
				local Nclus : display %9.0gc `r(n)'

				local olscoef "`olscoef' & -- "
				local olsstd "`olsstd' &  "
				local ivcoef "`ivcoef' & `b'`asterisk'"
				local ivstd "`ivstd' &  (`se')"
				
				local Nline "`Nline' & `N'"
				local Nclusline "`Nclusline' & `Nclus'"	

				
			* alternate instrument - group dummies
			xtivreg madc_30 (pp = group#mp#monthyear) i.monthyear lifeline tariff_error if shortrun == 1, fe vce(cluster group) small
				local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[pp]
				local se : display %-4.3f _se[pp]
				local N : display %9.0gc `e(N)'
				xtsum id if e(sample)
				local Nclus : display %9.0gc `r(n)'

				local olscoef "`olscoef' & -- "
				local olsstd "`olsstd' &  "
				local ivcoef "`ivcoef' & `b'`asterisk'"
				local ivstd "`ivstd' &  (`se')"
				
				local Nline "`Nline' & `N'"
				local Nclusline "`Nclusline' & `Nclus'"	

		* long panel 
		gen groupIV = group if monthyear > tm(2014m10) & monthyear < tm(2015m5)
		replace groupIV = 0 if groupIV == . // avoid identification off of non-compliance outside of project window
		
		xtreg madc_30 pp i.monthyear lifeline tariff_error, fe cl(group)
				local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[pp]
				local se : display %-4.3f _se[pp]
				local N : display %9.0gc `e(N)'
				xtsum id if e(sample)
				local Nclus : display %9.0gc `r(n)'

				local olscoef "`olscoef' & `b'`asterisk' "
				local olsstd "`olsstd' &  (`se') "
				
				
			xtivreg madc_30 (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group) small
				local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[pp]
				local se : display %-4.3f _se[pp]

				local ivcoef "`ivcoef' & `b'`asterisk'"
				local ivstd "`ivstd' &  (`se')"
				
				local Nline "`Nline' & `N'"
				local Nclusline "`Nclusline' & `Nclus'"
				
				
	* comparison group 1	 		
	append using "$IN/Data/admin_data/price_elast_cr.dta"

	drop if madc_30 > 300
	replace l_madc = ln(madc_30)
	replace pp = 0 if pp == . 
	replace tariff_error = 0 if tariff_error == .
	replace project = 0 if project == .
	replace lifeline = 0 if lifeline == .
	replace group = 0 if group == .
	replace mp = 0 if mp == .
	drop if monthyear == .
	drop if monthyear < tm(2014m11) | monthyear > tm(2015m4)
	xtset id monthyear
	
			xtreg madc_30 pp i.monthyear lifeline tariff_error, fe cl(group)
				local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[pp]
				local se : display %-4.3f _se[pp]
				local N : display %9.0gc `e(N)'
				xtsum id if e(sample)
				local Nclus : display %9.0gc `r(n)'

				local olscoef "`olscoef' & `b'`asterisk' "
				local olsstd "`olsstd' &  (`se') "
				
				
			xtivreg madc_30 (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group) small
				local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[pp]
				local se : display %-4.3f _se[pp]

				local ivcoef "`ivcoef' & `b'`asterisk'"
				local ivstd "`ivstd' &  (`se')" 
				
				local Nline "`Nline' & `N'"
				local Nclusline "`Nclusline' & `Nclus'"
				
		replace comparison = 1 if comparison == .
	/*	
		binscatter madc_30 monthyear, ///
			by(comparison) linetype(connect) xline(658) ///
			legend(order(2 "Comparison group" 1 "Project sample")) xtitle("") ///
			ytitle(Avg daily kWh) msymbols(O T) xla(624 636 648 660 672,format(%tm))
			
		graph export "$resdir/MP_DD.pdf", replace
	*/		
		
		drop if comparison != 0
		
	* comparison group 2	 		
	append using "$IN/Data/admin_data/non_project.dta"

	drop if madc_30 > 300
	replace l_madc = ln(madc_30)
	replace pp = 1 if pp == . 
	replace tariff_error = 0 if tariff_error == .
	replace project = 0 if project == .
	replace group = 0 if group == .
	replace mp = 0 if mp == .
	drop if monthyear < tm(2014m11) | monthyear > tm(2015m4)
	xtset id monthyear
	// first, how representative are project hh?
	
	reg madc_30 project##lifeline pp i.monthyear if monthyear >= tm(2015m1), cl(id)
	
	// second, table: 
	
			xtreg madc_30 pp i.monthyear lifeline tariff_error, fe cl(group)
				local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[pp]
				local se : display %-4.3f _se[pp]
				local N : display %12.0gc `e(N)'
				xtsum id if e(sample)
				local Nclus : display %9.0gc `r(n)'

				local olscoef "`olscoef' & `b'`asterisk' "
				local olsstd "`olsstd' &  (`se') "
				di "N is `N'"
				
				
			xtivreg madc_30 (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group) small
				local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[pp]
				local se : display %-4.3f _se[pp]

				local ivcoef "`ivcoef' & `b'`asterisk'"
				local ivstd "`ivstd' &  (`se')"
				
				local Nline "`Nline' & `N'"
				local Nclusline "`Nclusline' & `Nclus'"
		
		drop if comparison != 0
		
				cap file close iv1
				file open iv1 using ///
					"$resdir/MP_robustness_1.tex", ///
					write text replace
				file write iv1 "\begin{tabular}{l cccccc}"	_n
				file write iv1 "\hline" _n
				file write iv1 " & Base & Group IV & 1.$ Group_g$ IV & Long panel & DD Postpaid & DD Prepaid \\ " _n
				file write iv1 " & (1) & (2) & (3) & (4) & (5) & (6)  \\ \hline" _n
				file write iv1 " \\" _n
				file write iv1 " & \multicolumn{6}{c}{Panel A: OLS} \\ " _n
				file write iv1 "`olscoef' \\" _n
				file write iv1 "`olsstd' \\ " _n
				file write iv1 " \\" _n
				file write iv1 " \hline \\" _n
				file write iv1 " & \multicolumn{6}{c}{Panel B: IV} \\ " _n
				file write iv1 "`ivcoef' \\" _n
				file write iv1 "`ivstd' \\ " _n
				file write iv1 " \\" _n
				file write iv1 " \hline \\" _n
				file write iv1 "`Nline' \\" _n
				file write iv1 "`Nclusline' \\" _n
				file write iv1 " Month-year FE & x & x & x & x & x & x \\ \hline" _n
				file write iv1 "\end{tabular}" _n
				file close iv1		
restore				

** Set 3: Robustness to alt samples **

preserve
		gen recent = monthyear >= tm(2013m11)
		keep if shortrun == 1
			local olscoef "Prepaid"
			local olsstd ""
			local ivcoef "Prepaid"
			local ivstd ""
			
			local Nline "N"
			local Nclusline "N customers"
		
			* base
			xtreg madc_30 pp i.monthyear lifeline tariff_error if switchmonthD == 0, fe cl(group)
				local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[pp]
				local se : display %-4.3f _se[pp]
				local N : display %9.0gc `e(N)'
				xtsum id if e(sample)
				local Nclus : display %9.0gc `r(n)'

				local olscoef "`olscoef' & `b'`asterisk' "
				local olsstd "`olsstd' &  (`se') "
				
			xtivreg madc_30 (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error if switchmonthD == 0, fe vce(cluster group) small
				local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[pp]
				local se : display %-4.3f _se[pp]
				
				local ivcoef "`ivcoef' & `b'`asterisk'"
				local ivstd "`ivstd' &  (`se')"
				
				local Nline "`Nline' & `N'"
				local Nclusline "`Nclusline' & `Nclus'"	

			* switchers only
			xtreg madc_30 pp i.monthyear lifeline tariff_error if switcher == 1 & switchmonthD == 0, fe cl(group)
				local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[pp]
				local se : display %-4.3f _se[pp]
				local N : display %9.0gc `e(N)'
				xtsum id if e(sample)
				local Nclus : display %9.0gc `r(n)'
			
				local olscoef "`olscoef' & `b'`asterisk' "
				local olsstd "`olsstd' &  (`se') "
				
			xtivreg madc_30 (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error if switcher == 1 & switchmonthD == 0, fe vce(cluster group) small
				local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[pp]
				local se : display %-4.3f _se[pp]

				local ivcoef "`ivcoef' & `b'`asterisk'"
				local ivstd "`ivstd' &  (`se')"
				
				local Nline "`Nline' & `N'"
				local Nclusline "`Nclusline' & `Nclus'"	
				
			* no debt recovery
			xtreg madc_30 pp i.monthyear lifeline tariff_error if pp_recovery == 0 & switchmonthD == 0, fe cl(group)
				local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[pp]
				local se : display %-4.3f _se[pp]
				local N : display %9.0gc `e(N)'
				xtsum id if e(sample)
				local Nclus : display %9.0gc `r(n)'
			
				local olscoef "`olscoef' & `b'`asterisk' "
				local olsstd "`olsstd' &  (`se') "
				
			xtivreg madc_30 (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error if pp_recovery == 0 & switchmonthD == 0, fe vce(cluster group) small
				local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[pp]
				local se : display %-4.3f _se[pp]

				local ivcoef "`ivcoef' & `b'`asterisk'"
				local ivstd "`ivstd' &  (`se')"
				
				local Nline "`Nline' & `N'"
				local Nclusline "`Nclusline' & `Nclus'"	

			* trim
			xtreg madc_trim pp i.monthyear lifeline tariff_error if switchmonthD == 0, fe cl(group)
				local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[pp]
				local se : display %-4.3f _se[pp]
				local N : display %9.0gc `e(N)'
				xtsum id if e(sample)
				local Nclus : display %9.0gc `r(n)'
			
				local olscoef "`olscoef' & `b'`asterisk' "
				local olsstd "`olsstd' &  (`se') "
				
			xtivreg madc_trim (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error if switchmonthD == 0, fe vce(cluster group) small
				local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[pp]
				local se : display %-4.3f _se[pp]

				local ivcoef "`ivcoef' & `b'`asterisk'"
				local ivstd "`ivstd' &  (`se')"
				
				local Nline "`Nline' & `N'"
				local Nclusline "`Nclusline' & `Nclus'"	
				
			* smoothed
			xtreg madc_365 pp i.monthyear lifeline tariff_error if switchmonthD == 0, fe cl(group)
				local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[pp]
				local se : display %-4.3f _se[pp]
				local N : display %9.0gc `e(N)'
				xtsum id if e(sample)
				local Nclus : display %9.0gc `r(n)'
			
				local olscoef "`olscoef' & `b'`asterisk' "
				local olsstd "`olsstd' &  (`se') "
				
			xtivreg madc_365 (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error if switchmonthD == 0, fe vce(cluster group) small
				local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[pp]
				local se : display %-4.3f _se[pp]

				local ivcoef "`ivcoef' & `b'`asterisk'"
				local ivstd "`ivstd' &  (`se')"
				
				local Nline "`Nline' & `N'"
				local Nclusline "`Nclusline' & `Nclus'"	
				
			* balanced - fill in zeros
			tsfill
			replace madc_30 = 0 if madc_30 == .
			bys id: carryforward lifeline, replace
			bys id: carryforward pp, replace
			bys id: carryforward tariff_error, replace
			replace switchmonthD = 0 if switchmonthD == .
			bys id: carryforward group, replace
			
			xtreg madc_30 pp i.monthyear lifeline tariff_error if switchmonthD == 0, fe cl(group)
				local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[pp]
				local se : display %-4.3f _se[pp]
				local N : display %9.0gc `e(N)'
				xtsum id if e(sample)
				local Nclus : display %9.0gc `r(n)'
			
				local olscoef "`olscoef' & `b'`asterisk' "
				local olsstd "`olsstd' &  (`se') "

		
			xtivreg madc_30 (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error if switchmonthD == 0, fe vce(cluster group) small
				local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[pp]
				local se : display %-4.3f _se[pp]

				local ivcoef "`ivcoef' & `b'`asterisk'"
				local ivstd "`ivstd' &  (`se')"
				
				local Nline "`Nline' & `N'"
				local Nclusline "`Nclusline' & `Nclus'"					
				
				drop if month == .
			
				
				cap file close iv1
				file open iv1 using ///
					"$resdir/MP_robustness_2.tex", ///
					write text replace
				file write iv1 "\begin{tabular}{l cccccc}"	_n
				file write iv1 "\hline" _n
				file write iv1 " & Base & Switchers only & No debt recovery & Trimmed & Smoothed & Balanced \\ " _n
				file write iv1 " & (1) & (2) & (3) & (4) & (5) & (6) \\ \hline" _n
				file write iv1 " \\" _n
				file write iv1 " & \multicolumn{6}{c}{Panel A: OLS} \\ " _n
				file write iv1 "`olscoef' \\" _n
				file write iv1 "`olsstd' \\ " _n
				file write iv1 " \\" _n
				file write iv1 " \hline \\" _n
				file write iv1 " & \multicolumn{6}{c}{Panel B: IV} \\ " _n
				file write iv1 "`ivcoef' \\" _n
				file write iv1 "`ivstd' \\ " _n
				file write iv1 " \\" _n
				file write iv1 " \hline \\" _n
				file write iv1 "`Nline' \\" _n
				file write iv1 "`Nclusline' \\" _n
				file write iv1 " Month-year FE & x & x & x & x & x & x \\ \hline" _n
				file write iv1 "\end{tabular}" _n
				file close iv1

restore

** Set 4: Robustness to implementation issues **
* load shedding, tariff error, placebo test
		
		preserve
	
		drop if switchmonthD == 1
		bys id: egen any_error = max(tariff_error)
		cap drop placebo*
		
		bys id (monthyear): gen placebo_pp = F12.pp
		
			local olscoef "Prepaid"
			local olsstd ""
			local ivcoef "Prepaid"
			local ivstd ""
			
			local Nline "N"
			local Nclusline "N customers"
			
			* base
			xtreg madc_30 pp i.monthyear lifeline tariff_error if shortrun == 1, fe cl(group)
				local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[pp]
				local se : display %-4.3f _se[pp]
				local N : display %9.0gc `e(N)'
				xtsum id if e(sample)
				local Nclus : display %9.0gc `r(n)'

				local olscoef "`olscoef' & `b'`asterisk' "
				local olsstd "`olsstd' &  (`se') "
				
				
			xtivreg madc_30 (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error if shortrun == 1, fe vce(cluster group) small
				local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[pp]
				local se : display %-4.3f _se[pp]
				local N : display %9.0gc `e(N)'
				xtsum id if e(sample)
				local Nclus : display %9.0gc `r(n)'

				local ivcoef "`ivcoef' & `b'`asterisk'"
				local ivstd "`ivstd' &  (`se')"
				
				local Nline "`Nline' & `N'"
				local Nclusline "`Nclusline' & `Nclus'"
			
			* tariff error
			xtreg madc_30 pp i.monthyear lifeline if any_error == 0 & shortrun == 1, fe cl(group)
				local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[pp]
				local se : display %-4.3f _se[pp]
				local N : display %9.0gc `e(N)'
				xtsum id if e(sample)
				local Nclus : display %9.0gc `r(n)'

			
				local olscoef "`olscoef' & `b'`asterisk' "
				local olsstd "`olsstd' &  (`se') "
				
			xtivreg madc_30 (pp = c.group#mp#monthyear) i.monthyear lifeline if any_error == 0 & shortrun == 1, fe vce(cluster group) small
				local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[pp]
				local se : display %-4.3f _se[pp]
				local N : display %9.0gc `e(N)'
				xtsum id if e(sample)
				local Nclus : display %9.0gc `r(n)'

				local ivcoef "`ivcoef' & `b'`asterisk'"
				local ivstd "`ivstd' &  (`se')"
				
				local Nline "`Nline' & `N'"
				local Nclusline "`Nclusline' & `Nclus'"	

			* no consolidated bills
			xtreg madc_30 pp i.monthyear lifeline if elect_only_ever == 1 & shortrun == 1, fe cl(group)
				local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[pp]
				local se : display %-4.3f _se[pp]
				local N : display %9.0gc `e(N)'
				xtsum id if e(sample)
				local Nclus : display %9.0gc `r(n)'
			
				local olscoef "`olscoef' & `b'`asterisk' "
				local olsstd "`olsstd' &  (`se') "
				
			xtivreg madc_30 (pp = c.group#mp#monthyear) i.monthyear lifeline if elect_only_ever == 1 & shortrun == 1, fe vce(cluster group) small
				local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[pp]
				local se : display %-4.3f _se[pp]
				local N : display %9.0gc `e(N)'
				xtsum id if e(sample)
				local Nclus : display %9.0gc `r(n)'

				local ivcoef "`ivcoef' & `b'`asterisk'"
				local ivstd "`ivstd' &  (`se')"
				
				local Nline "`Nline' & `N'"
				local Nclusline "`Nclusline' & `Nclus'"	
				

			* placebo
			xtreg madc_30 placebo_pp i.monthyear lifeline tariff_error if monthyear > tm(2013m10) & monthyear < tm(2014m5), fe cl(group)
				local p = (2 * ttail(e(df_r), abs(_b[placebo_pp]/_se[placebo_pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[placebo_pp]
				local se : display %-4.3f _se[placebo_pp]
				local N : display %9.0gc `e(N)'
				xtsum id if e(sample)
				local Nclus : display %9.0gc `r(n)'
			
				local olscoef "`olscoef' & `b'`asterisk' "
				local olsstd "`olsstd' &  (`se') "
				
			xtivreg madc_30 (placebo_pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error if monthyear > tm(2013m10) & monthyear < tm(2014m5), fe vce(cluster group) small
				local p = (2 * ttail(e(df_r), abs(_b[placebo_pp]/_se[placebo_pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[placebo_pp]
				local se : display %-4.3f _se[placebo_pp]
				local N : display %9.0gc `e(N)'
				xtsum id if e(sample)
				local Nclus : display %9.0gc `r(n)'
				
				local ivcoef "`ivcoef' & `b'`asterisk'"
				local ivstd "`ivstd' &  (`se')"
				
				local Nline "`Nline' & `N'"
				local Nclusline "`Nclusline' & `Nclus'"	
				
				cap file close iv1
				file open iv1 using ///
					"$resdir/MP_robustness_3.tex", ///
					write text replace
				file write iv1 "\begin{tabular}{l cccc}"	_n
				file write iv1 "\hline" _n
				file write iv1 " & Base & Tariff error & Consolidated bills & Placebo test \\ " _n
				file write iv1 " & (1) & (2) & (3) & (4) \\ \hline" _n
				file write iv1 " \\" _n
				file write iv1 " & \multicolumn{4}{c}{Panel A: OLS} \\ " _n
				file write iv1 "`olscoef' \\" _n
				file write iv1 "`olsstd' \\ " _n
				file write iv1 " \\" _n
				file write iv1 " \hline \\" _n
				file write iv1 " & \multicolumn{4}{c}{Panel B: IV} \\ " _n
				file write iv1 "`ivcoef' \\" _n
				file write iv1 "`ivstd' \\ " _n
				file write iv1 " \\" _n
				file write iv1 " \hline \\" _n
				file write iv1 "`Nline' \\" _n
				file write iv1 "`Nclusline' \\" _n
				file write iv1 " Month-year FE & x & x & x & x  \\ \hline" _n
				file write iv1 "\end{tabular}" _n
				file close iv1

	restore		

			
**********************************
** (6) Revenue related outcomes **
**********************************		

preserve

drop if switchmonthD == 1
keep if shortrun == 1
		
		local olscoef "Prepaid"
		local olsstd ""
		local ivcoef "Prepaid"
		local ivstd ""
		
		local olsboot "Wild-bootstrap p"
		local ivboot "Wild-bootstrap p"
		
		local Nline "N"
		local Nclusline "N customers"
		

		foreach outcome in usd_30_real lost_rev timing lost_interest cost_kwh billing_cost { 
			
			xtreg `outcome' pp i.monthyear lifeline tariff_error, fe cl(group)
				local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[pp]
				local se : display %-4.3f _se[pp]
				boottest pp, reps($bootrep) boottype(wild) nograph
				local p : display %-4.3f `r(p)'
				local olsboot "`olsboot' & [`p']"
				local N : display %9.0gc `e(N)'
				xtsum id if e(sample)
				local Nclus : display %9.0gc `r(n)'
			
				local olscoef "`olscoef' & `b'`asterisk' "
				local olsstd "`olsstd' &  (`se') "
				
			xtivreg `outcome' (pp = c.group#mp#monthyear) i.monthyear i.lifeline tariff_error, fe vce(cluster group) small
				local p = (2 * ttail(e(df_r), abs(_b[pp]/_se[pp])))
					local asterisk = ""
					if `p'<0.1 {
						local asterisk = "*"
						if `p'<0.05 {
							local asterisk = "**"
							if `p'<0.01 {
								local asterisk = "***"
							}
						}
					}
				local b : display %-4.3f _b[pp]
				local se : display %-4.3f _se[pp]
				boottest pp, reps($bootrep) boottype(wild) nograph
				local p : display %-4.3f `r(p)'
				local ivboot "`ivboot' & [`p']"
				local ivcoef "`ivcoef' & `b'`asterisk'"
				local ivstd "`ivstd' &  (`se')"
				
				local Nline "`Nline' & `N'"
				local Nclusline "`Nclusline' & `Nclus'"	

				}

				
				cap file close iv1
				file open iv1 using ///
					"$resdir/MP_prices.tex", ///
					write text replace
				file write iv1 "\begin{tabular}{l cccccc}"	_n
				file write iv1 "\hline" _n
				file write iv1 " & Revenue due & Foregone revenue & Payment delay & Foregone interest & Supply cost & Billing cost \\ " _n
				file write iv1 " & (1) & (2) & (3) & (4) & (5) & (6) \\ \hline" _n
				file write iv1 " \\" _n
				file write iv1 " & \multicolumn{6}{c}{Panel A: OLS} \\ " _n
				file write iv1 "`olscoef' \\" _n
				file write iv1 "`olsstd' \\ " _n
				file write iv1 "`olsboot' \\" _n
				file write iv1 " \\" _n

				file write iv1 " & \multicolumn{6}{c}{Panel B: IV} \\ " _n
				file write iv1 "`ivcoef' \\" _n
				file write iv1 "`ivstd' \\ " _n
				file write iv1 "`ivboot' \\" _n
				file write iv1 " \\" _n
		
				file write iv1 "`Nline' \\" _n
				file write iv1 "`Nclusline' \\ \hline" _n
				file write iv1 "\end{tabular}" _n
				file close iv1

restore

	
**********************************
** (7) Other tables and figures **
**********************************

// Correlations across heterogeneity vars

preserve

	drop if switchmonthD == 1
	egen pptag = tag(id pp)
	bys id: egen num_trans1 = mean(num_trans_pp)
	bys id: egen num_trans = max(num_trans1)

	keep if idtag == 1
	
	label var mlifeline "Lifeline"
	label var below_medkwh "Low kWh"
	label var pval300 "Low prop value"
	
	label var usuallylate "Usually late"
	label var outstanding1 "Unpaid bills"
	label var ever_disconnected_cr "Disconnected"
	label var num_trans "PP transactions"
	
	estpost correlate mlifeline below_medkwh pval300 usuallylate outstanding1 ever_disconnected_cr num_trans, matrix
	esttab using "$resdir/MP_het_corr.tex", ///
		tex not unstack compress noobs label nonotes nonumbers replace
	
restore
ddd
*************************
** BUNCHING HISTOGRAMS **
*************************

preserve 

tempfile temp
save `temp', replace

import excel "$IN/Data/admin_data/tariff_schedule_exVAT.xlsx", clear firstrow

lab var steps "kwh thresholds of tariff blocks"

// data are in cents, convert to Rand
qui ds
foreach var in `r(varlist)'{
	replace `var' = `var'/100 if "`var'" != "steps"
}

*convert zar values to real USD
qui ds *20*
foreach var in `r(varlist)'{
	gen `var'_real_usd = .
	replace `var'_real_usd = (`var'*(112.0067/95.275))*0.0873 		if substr("`var'", -4, 4) == "2011"
	replace `var'_real_usd = (`var'*(112.0067/100.5417))*0.0873 	if substr("`var'", -4, 4) == "2012"
	replace `var'_real_usd = (`var'*(112.0067/106.5833))*0.0873 	if substr("`var'", -4, 4) == "2013"
	replace `var'_real_usd = (`var'*(112.0067/112.0667))*0.0873 	if substr("`var'", -4, 4) == "2014"
	replace `var'_real_usd = (`var'*(112.0067/118.325))*0.0873 		if substr("`var'", -4, 4) == "2015"

}

keep lifeline1_2014_real_usd lifeline2_2014_real_usd domestic_2014_real_usd steps
set obs 12 // this is to assist graphs below
replace steps = 151 if _n == 9 
replace steps = 549 if _n == 10
replace steps = 401 if _n == 11
replace steps = 799 if _n == 12
sort steps
carryforward lifeline1_2014_real_usd lifeline2_2014_real_usd domestic_2014_real_usd, replace
rename steps mcons_no0
replace mcons_no0 = 999 if mcons_no0 == 800

tempfile tariff
save `tariff', replace

use `temp', clear
append using `tariff'

// Visual evidence of bunching // 

drop if switchmonthD == 1

twoway (hist mcons_no0 if mcons_no0 < 550 & mcons_no0 > 150 & bill_year > 2012 & switcher == 1 ///
	& switchmonthD == 0 & pp == 0 & lifeline == 1, width(10) fcolor(gs10) lcolor(gs11) frac) ///
	(hist mcons_no0 if mcons_no0 < 550 & mcons_no0 > 150 & bill_year > 2012 & switcher == 1 ///
	& switchmonthD == 0 & pp == 1 & lifeline == 1, width(10) fcolor(none) lcolor(black) frac) ///
	(scatter lifeline2_2014 mcons_no0 if mcons_no0 < 550 & mcons_no0 > 150, connect(stairstep) lcolor(gs12) mcolor(none) lpattern(dash_dot) lwidth(thick) yaxis(2)), ///
	xscale(range(150(50)550)) ytitle(Fraction) ytitle("Marginal price (USD)", axis(2)) yscale(range(0(.05).25) axis(2)) ///
	legend(order(1 "Postpaid" 2 "Prepaid")) graphregion(fcolor(white) lcolor(white)) ylabel(0(.05).25, axis(2)) ///
	xtitle(Total monthly usage) 
	graph export "$resdir/MP_bunch_ll.pdf", replace	

twoway (hist mcons_no0 if mcons_no0 < 800 & mcons_no > 400 & bill_year > 2012 & switcher == 1 ///
	& switchmonthD == 0 & pp == 0 & lifeline == 0, width(10) fcolor(gs10) lcolor(gs11) frac) ///
	(hist mcons_no0 if mcons_no0 < 800 & mcons_no > 400 & bill_year > 2012 & switcher == 1 ///
	& switchmonthD == 0 & pp == 1 & lifeline == 0, width(10) fcolor(none) lcolor(black) frac) ///
	(scatter domestic_2014 mcons_no0 if mcons_no0 < 800 & mcons_no > 400, connect(stairstep) lcolor(gs12) lpattern(dash_dot) lwidth(thick) mcolor(none) yaxis(2)), ///
	ytitle(Fraction) ytitle("Marginal price (USD)", axis(2))  yscale(range(0(.05).25) axis(2)) ylabel(0(.05).25, axis(2)) ///
	legend(order(1 "Postpaid" 2 "Prepaid")) graphregion(fcolor(white) lcolor(white)) ///
	xtitle(Total monthly usage)
	graph export "$resdir/MP_bunch_dom.pdf", replace	

// then for full hist for appendix tables

twoway (hist mcons_no0 if mcons_no0 < 1000 & bill_year > 2012 & switcher == 1 ///
	& switchmonthD == 0 & pp == 0 & lifeline == 1, width(10) fcolor(gs10) lcolor(gs11) frac) ///
	(hist mcons_no0 if mcons_no0 < 1000 & bill_year > 2012 & switcher == 1 ///
	& switchmonthD == 0 & pp == 1 & lifeline == 1, width(10) fcolor(none) lcolor(black) frac) ///
	(scatter lifeline2_2014 mcons_no0 if mcons_no0 < 1000, connect(stairstep) lcolor(gs12) mcolor(none) lpattern(dash_dot) lwidth(thick) yaxis(2)), ///
	ytitle(Fraction) ytitle("Marginal price (USD)", axis(2)) yscale(range(0(.05).25) axis(2)) ///
	legend(order(1 "Postpaid" 2 "Prepaid")) graphregion(fcolor(white) lcolor(white)) ylabel(0(.05).25, axis(2)) ///
	xtitle(Total monthly usage) 
	graph export "$resdir/MP_bunch_ll_full.pdf", replace	

twoway (hist mcons_no0 if mcons_no0 < 1000 & bill_year > 2012 & switcher == 1 ///
	& switchmonthD == 0 & pp == 0 & lifeline == 0, width(10) fcolor(gs10) lcolor(gs11) frac) ///
	(hist mcons_no0 if mcons_no0 < 1000 & bill_year > 2012 & switcher == 1 ///
	& switchmonthD == 0 & pp == 1 & lifeline == 0, width(10) fcolor(none) lcolor(black) frac) ///
	(scatter domestic_2014 mcons_no0 if mcons_no0 < 1000, connect(stairstep) lcolor(gs12) lpattern(dash_dot) lwidth(thick) mcolor(none) yaxis(2)), ///
	ytitle(Fraction) ytitle("Marginal price (USD)", axis(2))  yscale(range(0(.05).25) axis(2)) ylabel(0(.05).25, axis(2)) ///
	legend(order(1 "Postpaid" 2 "Prepaid")) graphregion(fcolor(white) lcolor(white)) ///
	xtitle(Total monthly usage)
	graph export "$resdir/MP_bunch_dom_full.pdf", replace
	
// use NPV_v* for NPV analysis
// use dofile bunching_v* for bunching analysis 
// use transactions_v* for transaction level graphs and sum stats	
