/*******************************************************************************

Coefficients to variables


This converts the coefficients on some central factor variables to a variable 
for graphing

*******************************************************************************/

capture program drop coef2var
program define coef2var
	syntax [, name(string) sample(string) disruption(int 0)] 
	
	if `disruption'==0 {
		
		gen `name'_coef=.
		gen `name'_se=.
		gen `name'_N=.
		
		quietly sum age_at_move if `sample'==1
		
		forvalues i=`=`r(min)''(1)`=`r(max)'' {
			replace `name'_coef=_b[`i'.age_at_move#c.Delta_odps$outcome] if _n==`i'
			replace `name'_se=_se[`i'.age_at_move#c.Delta_odps$outcome] if _n==`i'
			
			count if age_at_move==`i' & `sample'==1
				replace `name'_N=`r(N)' if _n==`i'
		}
		
		if "`name'"=="baselinekids" {
			replace `name'_coef=`name'_coef+_b[1978.fyob#c.Delta_odpskids]
		}
		
		gen `name'_upper=`name'_coef+1.96*`name'_se
		gen `name'_lower=`name'_coef-1.96*`name'_se

	}
	
	else if `disruption'==1 {
	
		foreach p in 50 {
			
			gen `name'_d`p'_coef=.
			gen `name'_d`p'_se=.
			
			quietly sum age_at_move if `sample'==1
			
			forvalues i=`=`r(min)'+1'(1)`r(max)' {
			
				lincom `i'.age_at_move + `p'*`i'.age_at_move#c.p_rank
					replace `name'_d`p'_coef=`r(estimate)' if _n==`i'
					replace `name'_d`p'_se=`r(se)' if _n==`i'
			
			}
				
			gen `name'_d`p'_upper=`name'_d`p'_coef+1.96*`name'_d`p'_se
			gen `name'_d`p'_lower=`name'_d`p'_coef-1.96*`name'_d`p'_se
				
		}	
	}
	
end
