/*******************************************************************************

Ranks


This program calculates ranks by cohorts

*******************************************************************************/

capture program drop ranks
program define ranks 

	syntax [if] [, parents(int 1) children(int 1) ]

	noisily display "Recode negative incomes as missing"

	replace p_inc=. if p_inc<0 
	replace c_inc=. if c_inc<0
	
	if `parents'==1 {			
		capture drop p_rank
		gen p_rank=.		
	}

	if `children'==1 {			
		capture drop c_rank
		gen c_rank=.		
	}
	
		* Parent and child ranks
		
		sum fyob 
		capture sum fyob `if'
		
		quietly forvalues cohort=`r(min)'(1)`r(max)' {
			
			noisily display "Cohort: `cohort'"
			
			if `parents'==1 {
				
				fastxtile tmp_p_rank=p_inc if fyob==`cohort', nq(100)

				replace p_rank=tmp_p_rank if fyob==`cohort'
			
				* Bottom ties
				
				sum p_inc
				
				gen zero_p_inc=(p_inc==`r(min)') if p_inc!=.
				sum zero_p_inc if fyob==`cohort', meanonly
				scalar p_bot=r(mean)*100
				scalar p_bot_rank=(floor(p_bot)*(floor(p_bot)+1)/2+(p_bot-floor(p_bot))*ceil(p_bot))/p_bot
				replace p_rank=round(p_bot_rank) if p_bot!=0 & p_rank==1 & fyob==`cohort'
				
				drop tmp_p_rank zero_p_inc
				scalar drop p_bot p_bot_rank 
				
			
			}
			
			if `children'==1 {
			
				count if fyob==`cohort' & c_inc!=.
			
				if `r(N)'==0 {
					continue
				}
			
				fastxtile tmp_c_rank=c_inc if fyob==`cohort', nq(100)

				replace c_rank=tmp_c_rank if fyob==`cohort'
				
				* Bottom ties
				
				sum c_inc
				
				gen zero_c_inc=(c_inc==`r(min)') if c_inc!=.
				sum zero_c_inc if fyob==`cohort', meanonly
				scalar c_bot=r(mean)*100
				scalar c_bot_rank=(floor(c_bot)*(floor(c_bot)+1)/2+(c_bot-floor(c_bot))*ceil(c_bot))/c_bot
				replace c_rank=round(c_bot_rank) if c_bot!=0 & c_rank==1 & fyob==`cohort'
				
				drop tmp_c_rank zero_c_inc
				scalar drop c_bot c_bot_rank	
			
			}
		}	
		
end
