/*******************************************************************************

Derived variables


This do file adds derived but useful variables to the core mobility files

*******************************************************************************/

* Parent indicator and family type

	gen num_parents=.
		replace num_parents=1 if p1_r_wages1991!=.
		replace num_parents=2 if p1_r_wages1991!=. & p2_r_wages1991!=.
	gen has_parents=(num_parents>0)

	gen byte samesex=(p1_sex==p2_sex & p1_sex!=.)
	gen byte family_type=.
		replace family_type=1 if num_parents==2 & samesex==0
		replace family_type=2 if num_parents==2 & samesex==1
		replace family_type=3 if num_parents==1 & p1_sex==1
		replace family_type=4 if num_parents==1 & p1_sex==2
		
	label define family_type 1 "Couple (opposite sex)" 2 "Couple (same sex)" 3 "Lone mother" 4 "Lone father"	
	label values family_type family_type
		
* Parent ages at child birth

	gen d_fyob=p1_fyob if p1_sex==2
		replace d_fyob=p2_fyob if p2_sex==2
		replace d_fyob=. if samesex==1

	gen m_fyob=p1_fyob if p1_sex==1
		replace m_fyob=p2_fyob if p2_sex==1
		replace m_fyob=. if samesex==1

	gen d_age=(fyob-d_fyob)
	gen m_age=(fyob-m_fyob)	
	
	drop num_parents samesex

* Number of kids

	forvalues k=1(1)7 {
		gen int num_kids`k'=(num_kids==`k')
	}	

* Kid birth order

	sort p1_int_id fyob
	bysort p1_int_id: gen birth_order=_n
	
* Flags for presence of parents and spouse
	
	gen byte has_p1=(p1_r_wages1991!=.)
	gen byte has_p2=(p2_r_wages1991!=.)
	gen byte has_spouse=(c_s_r_wages1991!=.)
