function [D,out1,out2] = EISTinfrasys(X,Y,Z)

%global RMsub manutrade trade t eta gamma alfa mu l aM aMs delta aA ksi1A ksi1M ksi1Ms  ksi2 Lbar kappatoll avTgr avMgr avAgr avTsgr avMsgr avAsgr fc aY aH ar tdum
%global wp rp rw p_E Z_M Z_A zA zM Z_M_Mor Z_A_Mor c_M c_A p_M p_A M A L_T L_M L_Ms L_A L R_Mp R_Ms R_Ap phi_M phi_Ms phi_A thetap Po_M Po_A ES_M Ubar RI AN AS phiMhat phiAhat LMMer LAAer LMmis
%global nR_M nR_Ms nR_A  nC deltaT xT infra %kappatollp


ksi1A = Z(1);     %A innov. fixed cost
ksi1M = Z(2);      %M innov. fixed cost
ksi1Ms = Z(3);      %M slow innov. fixed cost

beta = Z(4);
Lbar = Z(5);
T = Z(6);
mu = Z(7);           %manu labour share (fix)
alfa = Z(8);         %agri labour share (fix)
eta = Z(9);          %agri exponent in preferences
gamma = Z(10);        %agri minimum
ksi2 = Z(11);    %innov. marginal cost
deltaA = Z(12);
deltaM = Z(13);
aM = Z(14);          %manu Pareto coefficient
aA = Z(15);          %agri Pareto coefficient
aMs = Z(16);          %slow manu Pareto coefficient
wuknorm = Z(17);

%transport labour
tdum = Z(18);
zeta = Z(19);
rr = Z(20);
Z_T = Z(21);

t = Z(22);

RMsub = Z(23);
trade = Z(24);
LTsub = Z(25);
TTsub = Z(26);

boldkappaq = Z(27);

l = 1:500;

wp = zeros(length(l),T);
Z_M = zeros(length(l),T); Z_A = zeros(length(l),T);
c_M = zeros(length(l),T); c_A = zeros(length(l),T); p_M = zeros(length(l),T); p_A = zeros(length(l),T);
M = zeros(length(l),T); A = zeros(length(l),T);
L_M = zeros(length(l),T); L_A = zeros(length(l),T); L_Ms = zeros(length(l),T); L_T = zeros(length(l),T);
L = zeros(length(l),T); R_Mp = zeros(length(l),T); R_Ap = zeros(length(l),T); R_Ms = zeros(length(l),T);
nR_M = zeros(length(l),T); nR_A = zeros(length(l),T); nR_Ms = zeros(length(l),T);
phi_M = zeros(length(l),T); phi_A = zeros(length(l),T); phi_Ms = zeros(length(l),T);
thetap = zeros(length(l),T);
ES_M = zeros(length(l),T);
Ubar = zeros(1,T);
RI = zeros(1,T);
manutrade = zeros(length(l),T);
p_E=ones(length(l),1);

p_A(:,t) = ones(length(l),1);

Ubar(t) = X(1);
p_M(1,t) = X(2);
RI(t) = X(3);

Z_M(:,t) = Y(:,1);
Z_A(:,t) = Y(:,2);
p_E(:) = Y(:,3);
kappaqp = Y(:,4);
TSp = Y(:,5);


for i = 1:length(l)
    
    %Wages and consumption
    
    %wp(i,t) = Ubar(t)*(p_A(i,t)./eta)*(((p_A(i,t)./p_M(i,t))*((1-eta)/eta))^(eta-1))-p_A(i,t).*((1-eta)/eta)*gamma - RI(t);
    wp(i,t) = (Ubar(t)*(((p_A(i,t)./p_M(i,t))*((1-eta)/eta))^(eta-1))+gamma)*(p_A(i,t)./eta)-p_A(i,t).*((1-eta)/eta)*gamma - RI(t);
    c_A(i,t) = (wp(i,t)+RI(t)+p_A(i,t).*((1-eta)/eta)*gamma)*(eta./p_A(i,t));
    c_M(i,t) = (c_A(i,t)-gamma).*((p_A(i,t).*(1-eta))/(p_M(i,t).*eta));
    
    
    %Production and labor choices
    
    L_M(i,t) = ((wp(i,t).*(aM-1))/(aM*mu.*p_M(i,t).*Z_M(i,t)))^(1/(mu-1));
    L_A(i,t) = ((wp(i,t).*(aA-1))/(aA*alfa.*p_A(i,t).*Z_A(i,t)))^(1/(alfa-1));
    
    % phis and labour choice
    
    phi_M(i,t) = (1-((Z_M(i,t)*p_M(i,t)*(L_M(i,t).^mu))/(ksi2*wp(i,t)*(aM-1)))^(-1/2));
    phi_A(i,t) = (1-((Z_A(i,t)*p_A(i,t)*(L_A(i,t).^alfa))/(ksi2*wp(i,t)*(aA-1)))^(-1/2));
    
    
    if phi_M(i,t) < 0
        phi_M(i,t) = 0;
        L_M(i,t) = (wp(i,t)./(mu.*p_M(i,t).*Z_M(i,t)))^(1/(mu-1));   %this is L_M when phi_M is zero
    end
    
    if phi_A(i,t) < 0
        phi_A(i,t) = 0;
        L_A(i,t) = (wp(i,t)./(alfa.*p_A(i,t).*Z_A(i,t)))^(1/(alfa-1));   %this is L_A when phi_A is zero
    end
    
    if (ksi1M + ksi2*(1/(1-phi_M(i,t))))*wp(i,t) > (((Z_M(i,t)))*p_M(i,t).*((L_M(i,t).^mu))).*((phi_M(i,t))/(aM-1)-p_E(i));
        phi_M(i,t) = 0;
        L_M(i,t) = (wp(i,t)./(mu.*p_M(i,t).*Z_M(i,t)))^(1/(mu-1));   %this is L_M when phi_M is zero
    end
    
    if (ksi1A + ksi2*(1/(1-phi_A(i,t))))*wp(i,t) > (((Z_A(i,t)))*p_A(i,t).*(L_A(i,t).^alfa))*((phi_A(i,t))/(aA-1));
        phi_A(i,t) = 0;
        L_A(i,t) = (wp(i,t)./(alfa.*p_A(i,t).*Z_A(i,t)))^(1/(alfa-1));   %this is L_A when phi_A is zero
    end
    
    % Land Use and Land Rents
    
    fiA = 1;
    fiM = 1;
    
    if phi_A(i,t) == 0    %need to knock out fixed costs in calculating rents if firm would not innovate
        fiA = 0;
    end
    
    if phi_M(i,t) == 0
        fiM = 0;
    end
    
    %Potential Outputs (actual is multiplied by thetap and uses ex-post Z)
    M(i,t) = (Z_M(i,t)).*L_M(i,t).^mu;
    A(i,t) = (Z_A(i,t)).*L_A(i,t).^alfa;
    
    %kappatoll
    
    %negflag = @(y) (sign(y-(TTsub*Z_T*TSp(i)))+1)/2;
    %kapp = @(x) negflag(x)*(LTsub*wp(i,t)/(TTsub*Z_T*zeta))*(((zeta*(1-zeta)*(((((x/(TTsub*Z_T*TSp(i))))^rr)-1)^-1))+zeta)^((rr-1)/rr));
    %instead:
    %(((sign(tdemand(i,t)-(TTsub*Z_T*TSp(i)))+1)/2)*((LTsub*wp(i,t))/(TTsub*Z_T*zeta))*(((zeta*(1-zeta)*(((((tdemand(i,t)/(TTsub*Z_T*TSp(i))))^rr)-1)^-1))+zeta)^((rr-1)/rr)))
    
    %Calculate tertiary labour
    
    L_TA = 0;
    L_TM = 0;
    
    if i > 1
        L_TA = (((((LTsub*wp(i,t)/((((sign((abs(ES_M(i-1,t))+A(i,t))-(TTsub*Z_T*TSp(i)))+1)/2)*((LTsub*wp(i,t))/(TTsub*Z_T*zeta))*(((zeta*(1-zeta)*((((((abs(ES_M(i-1,t))+A(i,t))/(TTsub*Z_T*TSp(i))))^rr)-1)^-1))+zeta)^((rr-1)/rr)))*TTsub*Z_T*zeta))^(rr/(1-rr)))-zeta)/(1-zeta))^(-1/rr))*TSp(i);
        L_TM = (((((LTsub*wp(i,t)/((((sign((abs(ES_M(i-1,t))+M(i,t))-(TTsub*Z_T*TSp(i)))+1)/2)*((LTsub*wp(i,t))/(TTsub*Z_T*zeta))*(((zeta*(1-zeta)*((((((abs(ES_M(i-1,t))+M(i,t))/(TTsub*Z_T*TSp(i))))^rr)-1)^-1))+zeta)^((rr-1)/rr)))*TTsub*Z_T*zeta))^(rr/(1-rr)))-zeta)/(1-zeta))^(-1/rr))*TSp(i);
    else
        L_TA = (((((LTsub*wp(i,t)/((((sign((A(i,t))-(TTsub*Z_T*TSp(i)))+1)/2)*((LTsub*wp(i,t))/(TTsub*Z_T*zeta))*(((zeta*(1-zeta)*((((((A(i,t))/(TTsub*Z_T*TSp(i))))^rr)-1)^-1))+zeta)^((rr-1)/rr)))*TTsub*Z_T*zeta))^(rr/(1-rr)))-zeta)/(1-zeta))^(-1/rr))*TSp(i);
        L_TM = (((((LTsub*wp(i,t)/((((sign((M(i,t))-(TTsub*Z_T*TSp(i)))+1)/2)*((LTsub*wp(i,t))/(TTsub*Z_T*zeta))*(((zeta*(1-zeta)*((((((M(i,t))/(TTsub*Z_T*TSp(i))))^rr)-1)^-1))+zeta)^((rr-1)/rr)))*TTsub*Z_T*zeta))^(rr/(1-rr)))-zeta)/(1-zeta))^(-1/rr))*TSp(i);
    end
    
    R_Mp(i,t) = p_M(i,t).*(phi_M(i,t)./(aM-1)+1)*Z_M(i,t).*(L_M(i,t).^mu)-wp(i,t).*L_M(i,t) - fiM*wp(i,t)*(ksi1M + ksi2*(1/(1-phi_M(i,t))));
    R_Ap(i,t) = p_A(i,t).*(phi_A(i,t)./(aA-1)+1)*Z_A(i,t).*(L_A(i,t).^alfa)-wp(i,t).*L_A(i,t) - fiA*wp(i,t)*(ksi1A + ksi2*(1/(1-phi_A(i,t))));
    
    if tdum == 1
        if RMsub*R_Mp(i,t) > R_Ap(i,t)
            thetap(i,t) = 1;
            L_T(i,t) = L_TM;
        else
            thetap(i,t) = 0;
            L_T(i,t) = L_TA;
        end
    else
        if RMsub*(R_Mp(i,t))> R_Ap(i,t)
            thetap(i,t) = 1;
            L_T(i,t) = 0;
        else
            thetap(i,t) = 0;
            L_T(i,t) = 0;
        end
    end
    
    phi_M(i,t) = (thetap(i,t)).*phi_M(i,t);
    phi_A(i,t) = (1-thetap(i,t)).*phi_A(i,t);
    
    %Aggregate Labor
    L(i,t) = thetap(i,t).*L_M(i,t)+(1-thetap(i,t)).*L_A(i,t) + L_T(i,t);
    
    %Transport costs
    
    if thetap(i,t) == 1
        if i > 1
            tdemand(i,t) = abs(ES_M(i-1,t))+M(i,t);
        else
            tdemand(i,t) = M(i,t);
        end
    else
        if i > 1
            tdemand(i,t) = abs(ES_M(i-1,t))+A(i,t);
        else
            tdemand(i,t) = A(i,t);
        end
    end
    
    kappatollp(i,t) = (((sign(tdemand(i,t)-(TTsub*Z_T*TSp(i)))+1)/2)*((LTsub*wp(i,t))/(TTsub*Z_T*zeta))*(((zeta*(1-zeta)*(((((tdemand(i,t)/(TTsub*Z_T*TSp(i))))^rr)-1)^-1))+zeta)^((rr-1)/rr)));        
    
    kappap(i) = kappaqp(i) + kappatollp(i,t);
    
    
    %Construct Excess Supply
    if i > 1
        ES_M(i,t) =  ES_M(i-1,t) + (thetap(i,t)*M(i,t) - c_M(i,t).*L(i,t) - kappaqp(i)*(abs(ES_M(i-1,t))))/(length(l))-trade*manutrade(i,t);
    else
        ES_M(i,t) = (thetap(i,t)*M(i,t)-c_M(i,t).*L(i,t))/(length(l))-trade*manutrade(i,t);
    end
    
    %Construct prices for i+1
    if ES_M(i,t) > 0
        if i < length(l)
            p_M(i+1,t) = p_M(i,t)*exp(kappaqp(i)/length(l));
        end
    else
        if i < length(l)
            p_M(i+1,t) = p_M(i,t)*exp(-kappaqp(i)/length(l));
        end
    end
    
    %     %Generate Poisson draws
    %     Po_M(i,t) = rand;
    %     Po_Ms(i,t) = rand;
    %     Po_A(i,t) = rand;
    %
    %     %Generate Pareto and update productivity after innovation
    %     if Po_M(i,t) > phi_M(i,t);
    %         Z_M(i,t) = Z_M(i,t);
    %     else
    %         z = gprnd(1/aM,1/aM,1);
    %         Z_M(i,t) = z*Z_M(i,t);
    %     end
    %     if Po_Ms(i,t) > phi_Ms(i,t);
    %         Z_M(i,t) = Z_M(i,t);
    %     else
    %         z = gprnd(1/aMs,1/aMs,1);
    %         Z_M(i,t) = z*Z_M(i,t);
    %     end
    %     if Po_A(i,t) > phi_A(i,t);
    %         Z_A(i,t) = Z_A(i,t);
    %     else
    %         z = gprnd(1/aA,1/aA,1);
    %         Z_A(i,t) = z*Z_A(i,t);
    %     end
    %
    
    %work with averages for infra calc
    Z_M(i,t) = (1+phi_M(i,t)/(aM-1))*Z_M(i,t);
    Z_A(i,t) = (1+phi_A(i,t)/(aA-1))*Z_A(i,t);
    
    %Actual Outputs
    M(i,t) = thetap(i,t).*(Z_M(i,t)).*L_M(i,t).^mu;
    A(i,t) = (1-thetap(i,t)).*(Z_A(i,t)).*L_A(i,t).^alfa;
    
end

%Equilibrium in the goods market
if (Ubar(t) > 0 & sum((1-thetap(:,t)).*L_A(:,t))/length(l) < 100);
    d1 = ES_M(length(l),t);
else
    d1 = 1000000;
end

%Equilibrium condition in labor market

if (t > 1 & max(phi_A(:,t)) == 0)
    pp = p_M(1,t-1);
else
    pp = 100;
end

if (p_M(1,t)> 0 & p_M(1,t) < pp)
    d2 = sum(L(:,t))/length(l) - Lbar;
else
    d2 = 1000000;
end

%Calculate Rental Income (RI)

if (RI(t) > 0 & min(wp(:,t)) > 0)
    d3 = RI(t) - (sum(thetap(:,t).*(R_Mp(:,t))) + sum((1-thetap(:,t)).*R_Ap(:,t)))/(Lbar*length(l));
else
    d3 = 1000000;
end

D = [d1,d2,d3];

if nargout > 1
    out1 = [thetap(:,t),R_Mp(:,t),R_Ap(:,t),wp(:,t),L_T(:,t)];
    out2 = RI(t);
end


