%master for endogenous infrastructure and spatial takeoff

%profile on

datetime=datestr(now,31);
datetime=strrep(datetime,'/','_');
datetime=strrep(datetime,' ','_');
datetime=strrep(datetime,'-','_');
datetime=strrep(datetime,':','_');
datetime=strcat('run_',datetime)

for r = 1:1   %set number of runs
    
    clearvars -except r datetime
    
    %tic
    
    global RMsub manutrade trade t eta gamma alfa mu l aM aMs delta aA ksi1A ksi1M ksi1Ms ksi2 Lbar kappatoll avTgr avMgr avAgr avTsgr avMsgr avAsgr fc aY aH ar tdum
    global w rp rw rr zeta p_E Z_M Z_A zA zM Z_T Z_M_Mor Z_A_Mor c_M c_A p_M p_A M A L_T L_M L_Ms L_A L R_M R_Ms R_A phi_M phi_Ms phi_A theta Po_M Po_A ES_M Ubar RI AN AS phiMhat phiAhat LMMer LAAer LMmis
    global nR_M nR_Ms nR_A nC deltaT xT lCounty parp dT gammaT gain LTsub TTsub TS kappa kappaq boldkappaq tdemand kappatollb whold kappatolldirect coaltransport
    
    %Parameter Values
    
    load('intPSTM500lat') % labour distribution (l,i) normalised labour in sector i at location l
    % where l=1:500
    % i=(primary,secondary,tertiary,mining,textiles)
    load('indrevst2r.mat')  %this holds the historical data
    
    ksi1A = 0.3976;     %A innov. fixed cost
    ksi1M = 1.1355;      %M innov. fixed cost
    ksi1Ms = 13.4000;      %M slow innov. fixed cost
    
    beta = .95; l = 1:500; Lbar = 100; T = 171;
    mu = 0.67;           %manu laour share (fix)
    alfa = 0.59;         %agri labour share (fix)
    eta = 0.175;          %agri exponent in preferences
    gamma = 0.05;        %agri minimum
    ksi2 = 0.002;    %innov. marginal cost
    deltaA = 15; deltaM = 15;
    kappatoll = zeros(length(l),T); %transport toll
    kappaq = zeros(length(l),T); %transport q
    boldkappaq = 0.3;
    kappa = 0.2*ones(length(l),T); %total transport cost
    aM = 70;          %manu Pareto coefficient
    aA = 305;          %agri Pareto coefficient
    aMs = 455;          %slow manu Pareto coefficient
    wuknorm=0.005;  %0.005
    
    %transport labour
    tdum = 1; %1 is with tertiary labour
    Z_T = 1.5*ones(1,T);
    TS = 1*ones(length(l),T);
    
    zeta = 0.85; rr = 0.70;
    
    X0(1) = 0.0365; %Ubar(1) initial value for solver          0.0545
    X0(2) = 0.7758; %p_M(1,1) initial value for solver         0.9371
    X0(3) = 0.0292; %RI(1) initial value for solver            0.0634
    
    
    %Allocate variables
    w = zeros(length(l),T);
    Z_M = zeros(length(l),T); Z_A = zeros(length(l),T);
    Z_M_Mor = zeros(length(l),T); Z_A_Mor = zeros(length(l),T);
    c_M = zeros(length(l),T); c_A = zeros(length(l),T); p_M = zeros(length(l),T); p_A = zeros(length(l),T);
    M = zeros(length(l),T); A = zeros(length(l),T);
    L_M = zeros(length(l),T); L_A = zeros(length(l),T); L_Ms = zeros(length(l),T); L_T = zeros(length(l),T);
    L = zeros(length(l),T); R_M = zeros(length(l),T); R_A = zeros(length(l),T); R_Ms = zeros(length(l),T);
    nR_M = zeros(length(l),T); nR_A = zeros(length(l),T); nR_Ms = zeros(length(l),T);
    phi_M = zeros(length(l),T); phi_A = zeros(length(l),T); phi_Ms = zeros(length(l),T);
    theta = zeros(length(l),T);
    Po_M = zeros(length(l),T); Po_A = zeros(length(l),T);
    ES_M = zeros(length(l),T);
    Ubar = zeros(1,T);
    RI = zeros(1,T); fc = zeros(6,T);
    Z_Mvec = zeros(length(l),length(l)); Z_Avec = zeros(length(l),length(l));
    avMgr = zeros(1,T); avAgr = zeros(1,T); avTgr = zeros(1,T); avMsgr = zeros(1,T); avAsgr = zeros(1,T); avTsgr = zeros(1,T);
    manutrade = zeros(length(l),T);
    gain = nan(T,2^(nC-1),nC);
    
    %%% run endogenous infra
    idum = 0;  %=1 if running endogenous infra
    myCluster = parcluster('local');
    parp = myCluster.NumWorkers;
    xT = 1.15;    %infra cost
    
    dT = 0.7125*ones(T,1); %initial infra jump
    
    %dT = (1-(r-1)*.05)*ones(T,1); %initial infra jump
    
    gammaT = 1.02;  %growth of infra jump, 1.02 from Bogart
    for tt=1:T dT(tt) = dT(tt)*(gammaT^(tt-1)); end
    nC = 10; % number of counties; pick a number divisible into length(l)
    lCounty = zeros(length(l),1);  %mapping from location to county number
    for i=1:nC
        for j=1:length(l)/nC
            lCounty((i-1)*length(l)/nC+j)=i;
        end
    end
    
    %if idum == 1        %load initial distribution of transport costs from data
    load('infraintdata');
    infralat(:,1) = 1/mean(infralat(:,1))*infralat(:,1);   %normalize
    for jj = 1:size(infralat,1)
        TS((1+(jj-1)*(size(TS,1)/size(infralat,1))):jj*(size(TS,1)/size(infralat,1)),:)=infralat(jj,1); %update TS to infraintdata at date 1
    end
    kappaq(:,:) = boldkappaq.*exp(-TS(:,:)); %this initial kappaq and TS then passed to the pinfraopt
    %end
    
    %%% run with infra counterfactuals
    
    infracounterfactuals = 0; %with infra imposed from average of run_2019_01_08_13_59_36(1)-(20)
    smoother = 0; %run with uniform development of the infra (against the non-uniform start)
    timewarp = 0; %+ve number brings infra forward, -ve pushes it back in time
    
    
    if infracounterfactuals == 1
        load('run_2019_01_08_13_59_36_TS_mean')  %this is the average of run_2019_01_08_13_59_36(1)-(20)
        TSw = 1*ones(length(l),T);
        TSww = 1*ones(length(l),T);
        if smoother ==0
            for t=1:T
                for i=1:length(l)
                    TSw(i,t) = TS_mean(i,max(min(t+timewarp,T),1));
                end
            end
        else
            for t=2:T
                TS_grow(t)=mean(TS_mean(:,t)-TS_mean(:,t-1));  %average infra annum growth
            end
            for t=1:T
                if t == 1
                    TSww(:,t) = TS_mean(:,t);  
                else
                    for i=1:length(l)
                        TSww(i,t)=TSww(i,t-1)+TS_grow(t);   %add average infra annum
                    end
                end
            end
            for t=1:T
                for i=1:length(l)
                    TSw(i,t) = TSww(i,max(min(t+timewarp,T),1)); %do the timewarp
                end
            end
        end
        TS = TSw;
    end
    %figure;imagesc(TS_mean');figure;imagesc(TS');
    
    if idum == 1 && parp > 0
        p = gcp('nocreate');
        if isempty(p)
            p=parpool(parp-1);
        end
    end
    
    %%% energy costs, baseline: newp=0.54; wukp=0.63; lonp=3.93;
    new=428;  %newcastle l
    wuk=305;  %western UK l
    mid=246;
    lon=136;  %london l
    
    newp=0.54;  %0.54
    wukp=0.63;  %0.63
    midp=1.78;  %1.78
    lonp=3.93;  %3.93
    
    p_E=ones(length(l),1);
    
    for i = 1:500
        if i < mid
            p_E(i) = (lonp/wukp*wuknorm)+(lon-i)*((lonp/wukp*wuknorm)-midp/wukp*wuknorm)/(mid-lon);
        else
            if i<wuk
                p_E(i) = (midp/wukp*wuknorm)+(mid-i)*((midp/wukp*wuknorm)-wuknorm)/(wuk-mid);
            else
                p_E(i) = wuknorm+(wuk-i)*(wuknorm-(newp/wukp*wuknorm))/(new-wuk);
            end
        end
    end
    %
    %     p_Eo=ones(length(l),1);
    %      for i = 1:500
    %          if i<wuk
    %              p_Eo(i) = (lonp/wukp*wuknorm)+(lon-i)*((lonp/wukp*wuknorm)-wuknorm)/(wuk-lon);
    %          else
    %              p_Eo(i) = wuknorm+(wuk-i)*(wuknorm-(newp/wukp*wuknorm))/(new-wuk);
    %          end
    %      end
    %
    % figure; hold on; stairs(p_E);stairs(p_Eo); hold off
    %
    %
    
    
    %%% gross subsidy to tertiary labour wages
    LTsub = 1;
    
    %%% gross subsidy to manufacturing land use
    RMsub = 1;
    
    %%% improvement to labour transport tech
    TTsub = 1;
    
    %%% include trade
    trade = 0;
    
    %%% coal price related to transport cost
    coaltransport = 0;
    
    for t = 1:T
        
        %initialise productivities
        if t == 1
            EISTcalibinit
            
            %         %for the geographical counterfactuals
            %         %uncomment this block and pick Z_M2, 3 or 4
            %         X0(1) = 0.0140; %Ubar(1) initial value for solver
            %         X0(2) = 1.8558; %p_M(1,1) initial value for solver
            %         X0(3) = 0.0122; %RI(1) initial value for solver
            %
            %         %load ZM234
            %         Z_A_Mor(:,1)=Z_Ahold;
            %         Z_M_Mor(:,1)=Z_M4;
            
        end
        
        if trade == 1; %calculate net manu flows. %london at 135, liverpool at 295
            if t==1
                manutrade(135,t)=indrev(155+t,12).*(sum(M(:,t))/length(l));
            else
                manutrade(135,t)=indrev(155+t,12).*(sum(M(:,t-1))/length(l));
            end
        end
        
        r
        t
        
        if idum == 1
            pinfraopt;  %this runs the optimal infrastructure routine using EISTinfrasys
        end
        
        F=@(R)EISTsys(R);
        options=optimset('MaxFunEvals',10000000000,'TolFun',0.0001,'MaxIter',10000000,'Display','on');
        [X,Eval] = fsolve(F,X0,options);
        
        X0(1) = Ubar(t);
        X0(2) = p_M(1,t)*1.01;
        X0(3) = RI(t)*1.005;
        
        Eval
        
        
        %Diffusion
        for i = 1:length(l)
            if t < T
                for j = 1:length(l)
                    Z_Mvec(i,j) = exp(-deltaM*abs(i-j)/length(l))*Z_M(j,t);
                    Z_Avec(i,j) = exp(-deltaA*abs(i-j)/length(l))*Z_A(j,t);
                end
                Z_M(i,t+1) = max(Z_Mvec(i,:));
                Z_A(i,t+1) = max(Z_Avec(i,:));
                
                %Save Morning Productivity
                Z_M_Mor(:,t+1) = Z_M(:,t+1);
                Z_A_Mor(:,t+1) = Z_A(:,t+1);
            end
        end
    end
    
    if idum == 1
        save(['runs/' strcat(datetime,'(',num2str(r),')')],'-regexp','^(?!(myCluster|p)$).')
    else
        save(['runs/' strcat(datetime,'(',num2str(r),')')]);
    end
end


if idum == 1 && parp>0
    if verLessThan('matlab', '8') == 1
        matlabpool close;
    else
        delete(p);
    end
end

%Graphs

EISTgraphs
EISTcf

%toc

% % diagnostic
% [x1 y1] = find(phi_M>0);
% [x2 y2] = find(avTsgr>.015);
%
% if isempty(y1)==0
%     takeofft = 1710+y1(1)
%     takeoffl = latfromloc(x1(1))
%     if isempty(y2(1))==0
%         timeto115 = y2(1) - y1(1)
%     end
% end
%
% (1-mean(kappa(:,171))/mean(kappa(:,1)))
% hold on; stairs(1-mean(kappa(:,1:T))/mean(kappa(:,1))); stairs(1-mean(kappaq(:,1:T))/mean(kappaq(:,1))); stairs(1-mean(kappatoll(:,1:T))/mean(kappatoll(:,1))); hold off
