function[A B C NY NK NX A_nzlb B_nzlb B_zlb Indicator_Variables]= Matrix_Build_optimal(var)

%% LEGEND:
% ind_c_s= c^s
% ind_c_b= c^b
% ind_y_d= y
% ind_pi= \pi
% ind_i_b= i^b
% ind_i_s= i^s
% ind_l_j= \lambda_j  for j=1:7
% ind_b_b= b^b
% ind_bgd= b^{gdp}
% ind_c_r= c^r
% ind_iss= i^{ss}
% ind_d_t = d
%%

%% Indicator
% CONTROLS ARE in t and t+1
% ENDOGENOUS STATES are in t-1 and t
% EXOGENOUS STATES are in t and t+1
Indicator_Controls=['c_s','c_b','y__','pi_','i_b','i_s', 'r_n','w_b','w_s','l_b','l_s', 'l_1','l_4','l_5','l_7'];
Indicator_En_States=['l_2','l_3','l_6','b_b','bgd'];
Indicator_Ex_States=['c_r','iss','d_t'];

Indicator_Variables=[Indicator_Controls,Indicator_En_States,Indicator_Ex_States];

%% Dimensions
NY=length(Indicator_Variables)/3;
NX=length(Indicator_Ex_States)/3;
NK=NX+length(Indicator_En_States)/3;

%% Give the numbers

for i=0:length(Indicator_Variables)/3-1
eval(['ind_' Indicator_Variables(3*i+1:3*(i+1)) '=' num2str(i+1) ';' ]);
eval(['ind_' num2str(i+1) '=' num2str(i+1) ';' ]);

end

%% Initialize the Matrices

A=zeros(NY,NY);
B=zeros(NY,NY);
C=zeros(NY,NX);

%% Equations:

% Eq. 1 : FOC for y_t

% lambda_{6,t} k = y_{t} + lambda_{1,t} - lambda_{4,t}

A(ind_1, ind_l_6)= var.k;

B(ind_1 , ind_y__) = 1;
B(ind_1 , ind_l_1)= 1;
B(ind_1, ind_l_4)= -1;


%%

% Eq 2 : FOC for c^s_t

% lambda_{3,t}= - (1 - chi)* chi * lambda_c (c_t^b - c_t^s -c_t^r) -
% (1-chi)* lambda_{1,t}+ lambda_{3,t-1}/beta;

A(ind_2,ind_l_3)= 1;

B(ind_2,ind_c_b)= - var.chi * (1-var.chi) * var.lambda_c;
B(ind_2,ind_c_s) = var.chi * (1 -var.chi)* var.lambda_c;
B(ind_2 , ind_c_r) = (var.chi)* (1- var.chi)* var.lambda_c;
B(ind_2, ind_l_1) = - (1 - var.chi);
B(ind_2, ind_l_3) = 1/var.beta;

%%

% Eq. 3 : FOC for c^b_t

% lambda_{2,t} = chi * (1 - chi)* lambda_c * (c_t^b  - c_t^s - c_t^r) - chi
% * lamnda_{1,t} + lambda_{2,t-1}/beta + lambda_{4,t}

A(ind_3 , ind_l_2) = 1;

B(ind_3, ind_c_b) = var.chi * ( 1 - var.chi)* var.lambda_c;
B(ind_3, ind_c_s) = - var.chi * (1 - var.chi)* var.lambda_c;
B(ind_3 , ind_c_r) = - var.chi * (1 - var.chi) * var.lambda_c;
B(ind_3, ind_l_1) = - var.chi;
B(ind_3 , ind_l_2) = 1/var.beta;
B(ind_3 , ind_l_4) = 1;


%%

% Eq. 4 : FOC for \pi_t:

% - lambda_{6,t} = lambda_{pi} pi_t + sigma/beta (lambda_{2,t-1}+lambda_{3,t-1})
% - b/pi lambda_{4,t} - lambda_{6,t-1}

A(ind_4 , ind_l_6) = -1;

B(ind_4 , ind_pi_) = var.lambda_pi;
B(ind_4 , ind_l_2) = var.sigma/var.beta;
B(ind_4 , ind_l_3) = var.sigma/var.beta;
B(ind_4 , ind_l_4) = - var.b/var.Pi_bar;
B(ind_4 , ind_l_6) = - 1; 

%%

% Eq. 5 : FOC for i_t^s

% sigma * lambda_{3,t}= -  lambda_{5,t} + lambda_{7,t}

A(ind_5 , ind_l_3) = var.sigma;

B(ind_5 , ind_l_5)= -1;
B(ind_5 , ind_l_7) = -1;

%%

% Eq. 6 : FOC for i_t^b

% sigma lambda_{2,t} = lambda_{5,t} + b /(1+i) lambda_{4,t}

A(ind_6 , ind_l_2) = var.sigma;

B(ind_6 , ind_l_5) = 1;
B(ind_6 , ind_l_4) = var.b/(var.i_bar);

%%

% Eq. 7 : FOC for b^b

% - beta lambda_{4,t+1}/Pi_bar= - beta / Pi_bar lambda_{4,t} + phi * lambda_{5,t}


A(ind_7, ind_l_4)  = 1/var.i_bar;
A(ind_7, ind_l_2)  = - var.sigma * var.nu;

B(ind_7 , ind_l_4) = 1/var.i_bar;
B(ind_7 ,ind_l_5)  = var.phi;

%%

% Eq . 8 : Resource Constraint:

% 0 = y_t - chi * c_t^b - (1 - chi)* c_t^s

B(ind_8, ind_y__) = 1;
B(ind_8, ind_c_b) = - var.chi;
B(ind_8, ind_c_s) = - ( 1 - var.chi);

%%

% Eq. 9 : Savers' Euler :

% c_{t+1}^s + sigma pi_{t+1}= c_{t}^s + sigma i_t^s

A(ind_9 , ind_c_s) = 1;
A(ind_9 , ind_pi_) = var.sigma;

B(ind_9 , ind_c_s) = 1;
B(ind_9 , ind_i_s)= var.sigma;

%%

% Eq. 10 : Borrowers' Euler 

% c_{t+1}^b + sigma pi_{t+1}= c_t^b + sigma i_t^b

A(ind_10 , ind_c_b) = 1;
A(ind_10 , ind_pi_) = var.sigma;
A(ind_10 , ind_b_b) = -  var.sigma * var.nu;

B(ind_10 , ind_c_b) = 1;
B(ind_10 , ind_i_b) = var.sigma;
B(ind_10 , ind_d_t) = -  var.sigma * var.nu;

%%

% Eq. 11: B.c.

%beta /Pi_bar b_t = c_t^b + beta*b/Pi_bar i_t^b + b_{t-1}/Pi_bar - b/Pi_bar
%pi_t - y_t

A(ind_11 , ind_b_b) = 1/var.i_bar;

B(ind_11, ind_c_b) = 1;
B(ind_11, ind_i_b) =  var.b/var.i_bar;
B(ind_11, ind_b_b) = 1/var.Pi_bar;
B(ind_11, ind_pi_) = - var.b/var.Pi_bar;
B(ind_11, ind_y__) = - 1;

%%

% Eq. 12 : Spread:

% phi *b_t= i_t^b - i_t^s + phi d_t

A(ind_12 , ind_b_b) = var.phi;

B(ind_12 , ind_i_b) = 1;
B(ind_12 , ind_i_s) = - 1;
B(ind_12 , ind_d_t) = var.phi;

%%

% Eq. 13 : AS

% beta * pi_{t+1}= pi_{t} - k y_{t}

A(ind_13 , ind_pi_) = var.beta;

B(ind_13 , ind_pi_) = 1;
B(ind_13 , ind_y__) = - var.k;


%%

% Eq. 14 : Policy Rule:

% 0 = lambda_{7,t}

B(ind_14 , ind_l_7) = 1;

%%

% Eq. 15 : debt over gdp definition:

% chi* b_t  - b_t^{gdp}= chi* b * y_t

A(ind_15 , ind_b_b)= var.chi;
A(ind_15 , ind_bgd) = - 1;

B(ind_15 , ind_y__) = var.chi *var.b;



%% Hours Worked
%%b CHECK THE LABOR HOW DOES IT WORKS WE WANT TO HAVE (L_t^b - L^b) /L_b
%0 =  y_t - chi * y_bar/l_b * l_t^b - (1 - chi) * y_bar/l_s*l_t^s

B(ind_16,ind_y__)= 1;
B(ind_16,ind_l_b)= - var.chi ;
B(ind_16,ind_l_s)= - (1 - var.chi);

% 0= rho c_t^b  + (1 + eta) l_t^b - rho c_t^s  - (1 + eta) l_t^s
B(ind_17,ind_c_b)=  var.rho;
B(ind_17,ind_c_s)= - var.rho;
B(ind_17,ind_l_b)=  (1 + var.eta);
B(ind_17,ind_l_s)= - (1 + var.eta);

B(ind_18,ind_c_b)=  var.rho;
B(ind_18,ind_l_b)=  ( var.eta);
B(ind_18,ind_w_b)=  -1;

B(ind_19,ind_c_s)=  var.rho;
B(ind_19,ind_l_s)=  (  var.eta);
B(ind_19,ind_w_s)=  -1;


%%
%% EXOGENOUS PROCESS!
A(ind_20,ind_b_b)=  var.chi* (var.phi + var.nu);

B(ind_20,ind_d_t)=  var.chi* (var.phi + var.nu);
B(ind_20,ind_r_n)= -  1;

%% EXOGENOUS PROCESS

%%

% Eq. 16: Process for consumpion shock:

% c_{t+1}^r = c_t^r + epsilon_{c^r,t}

A(ind_21, ind_c_r) =1;

B(ind_21 , ind_c_r) = 1;

%%

% Eq. 17: Process for interest rate:

% i_{ss,t+1}= epsilon_{i_{ss},t}

A(ind_22 , ind_iss)= 1;

%%

% Eq. 18: Process for safe level:

% d_{t+1}= d_{t}+ epsilon_{d,t}

A(ind_23 , ind_d_t) = 1;
B(ind_23 , ind_d_t) = 1;

%%

B_nzlb= B;
A_nzlb= A;

%% CHANGE POLICY:

B_zlb= B_nzlb;

B_zlb(ind_14, :)=0;

%% ZLB:

% 0 = i_t^s - i_t^{ss}

B_zlb(ind_14 , ind_i_s)= 1;
B_zlb(ind_14 , ind_iss)= -1;


