function gh = gradtH_oh(Params,XP,XPp,XPd,XC,Choices,Pinct,HomeSt,Tt)

global  NALT Pvarn Int3 NhomebInt

Tt1 = Tt(:,1);
Tt2 = Tt(:,2);
Tt3 = Tt(:,3);
Cs = size(XC,1);

hchosen = (Choices==HomeSt); % vector that says whether current choice is home.
Phchosen = (Pinct == HomeSt); % vector that says whether past choice is home
hmat = (repmat([1:NALT],Cs,1) == repmat(HomeSt,1,NALT)); % Cs*NALT matrix that says, for each i, whether j is home

pp = plogit_mh(XC,XPd,HomeSt,Params)';  % this is CsxNALT of exp(deltaj)/sum(exp(deltah))
pph =  pdelta_mh(XC,XPd,HomeSt,Params)'; % this is CsxNALT of exp(deltaj)

sigma = Params(Pvarn+Int3+NALT+2+NhomebInt);
ppi = pinatt_mh(Params,XPp,XPd,XC,Pinct,HomeSt);

gth = hchosen .* (Tt1+Tt2) + ... // this is indicator of whether choice==ALT
       (((1 - ppi)/sigma).* (Tt2) .* (pp(hmat') - Phchosen))   - ... //  this is ((1-pi)/sigma)*(e(deltaj)/sum(exp) - Indicator(pastchoice==j))
       pp(hmat') + ... //  this is e(home)/sum(exp)
       ( (1 - ppi) .* (pph(hmat')) + ... // (1-pi)*exp(delta(home))
          (ppi.* edeltastar_mh(XC,XP,Pinct,HomeSt,Params) .* hchosen) + ...
          ((ppi.*(1 - ppi)/sigma) .* (edeltastar_mh(XC,XP,Pinct,HomeSt,Params) - deltaexp_mh(XC,XPd,HomeSt,Params)) .* (pp(hmat') - Phchosen))) ...
          ./ ... // denominator of whole expression; same expression as in the likelihood, see LogLikt
          ( (1-ppi) .* deltaexp_mh(XC,XPd,HomeSt,Params) + ppi .* edeltastar_mh(XC,XP,Choices,HomeSt,Params)) .* ...
          Tt3 ;
          
gh = gth;

clear hchosen Phchosen hmat pp pph gth

end
