function [L, g] = LogLikG_mh(Params)


% This function takes in a column vector of parameters of the likelihood function
% and DATA ( as well as other parameters of the problem) as globals, and
% returns as arguments -Loglikelihood, and gradient of -Loglikelihood.

global NT NALT Cvarn
global XCMATu XXP T PInc % bulk of DATA

L = 0;
g = 0;

    for t = 1:NT
    
    Pt = (XCMATu(:,2)==t);
    
    % xs for trying deltastar; take for all consumers in a given year.
    XC = XCMATu(Pt,5:4+Cvarn);
    HomeSt = XCMATu(Pt,4);

    Choices = XCMATu(Pt,3);
    Pinct = PInc(Pt,1);

    % recall: XPMAT = [prodid timeid2 XProd]; % Prod-T level matrix with:
    XP = XXP([(t-1)*NALT+Choices],:);
    % this is matrix of chars of the prod that each DM chooses
    
    % at time t, products chosen will be indexed by (t-1)*NALT + prod index
    XPp = XXP([(t-1)*NALT+Pinct],:);
    % xs at time t of past choice
    
    XPd = XXP((1:NALT)+NALT*(t-1),:);
    % ALL Xs of the period, in NALT*Pvarn form
    
    % elements for LogLikt
    Tt = T(Pt,:);

    Lt = LogLikt_mh(Params,XP,XPp,XPd,XC,Choices,Pinct,HomeSt,Tt);
    L = L + Lt;
    
    % gradients:
    gt = [gradtB_mh(Params,XP,XPp,XPd,XC,Choices,Pinct,HomeSt,Tt) ...
         gradtHbi_mh(Params,XP,XPp,XPd,XC,Choices,Pinct,HomeSt,Tt) ...
         gradtFE_mh(Params,XP,XPp,XPd,XC,Choices,Pinct,HomeSt,Tt) ...
         gradtH_mh(Params,XP,XPp,XPd,XC,Choices,Pinct,HomeSt,Tt) ...
         gradtmu_mh(Params,XP,XPp,XPd,XC,Choices,Pinct,HomeSt,Tt) ...
         gradtsigma_mh(Params,XP,XPp,XPd,XC,Choices,Pinct,HomeSt,Tt)];
    % the gradt terms has dimension NCSt*# of vars
    
    g = g + gt;
    
    clear XC XP XPd Pt Choices Pinct Tt t Lt

    end
    
    % - LogLikelihood, to be minimized
    L = -L;
    g = -g;

end
