function [XCMATu, XPMAT, dum_med, dum_big] = PrepareData(DataInputs)

global INSIDER_switch DIROFF_Switch Switchdummies Switchmergers;

%%%%%%%%%%%%%%%%%
%% Import data %%
%%%%%%%%%%%%%%%%%

%% First Firm-level data.
% Initialize variables.

load('Data.mat')

dataArray = Dta.FL;

% Allocate imported array to column variable names
firm_id = dataArray{:, 1};
time_id = dataArray{:, 2};
inc_id = dataArray{:, 3};
hdq_id = dataArray{:, 4};

Managers_dum15 = dataArray{:, 5};
Director_dum15 = dataArray{:, 6};
Officer_dum15 = dataArray{:, 7};

takeover_prem = dataArray{:, 8};

InstOwn_perc = dataArray{:, 9}; 

at0_100 = dataArray{:, 10};
at100_1000 = dataArray{:, 11};

InstOwn_CF_prem = dataArray{:, 12};

SP500 = dataArray{:, 13};

if  strcmp(DataInputs{3},'takeover_prem') == 1 
    mergervar = takeover_prem;
end

if strcmp(DataInputs{4},'InstOwn_perc') == 1
ownershipvar = InstOwn_perc;
end

% Clear temporary variables
clearvars filename delimiter startRow formatSpec fileID dataArray ans;

% Assemble XCMATu
% CHOOSE MERGER VARIABLE
if Switchmergers == 0 && Switchdummies == 3;
  
    XCMATu = [firm_id time_id inc_id hdq_id ownershipvar at0_100 at100_1000]; % leaves out TempHdq for now

elseif Switchmergers == 1 && Switchdummies == 3;
  
    XCMATu = [firm_id time_id inc_id hdq_id ownershipvar at0_100 at100_1000 mergervar]; % leaves out TempHdq for now

end


% now add insiders
if INSIDER_switch == 1 && strcmp(DataInputs{5},'dum15') == 1 
    XCMATu = [XCMATu,Managers_dum15]; 
elseif INSIDER_switch == 2 && strcmp(DataInputs{5},'dum15') == 1 && DIROFF_Switch == 2;
    XCMATu = [XCMATu,Managers_dum15,Director_dum15]; 
elseif INSIDER_switch == 2 && strcmp(DataInputs{5},'dum15') == 1 && DIROFF_Switch == 1;
    XCMATu = [XCMATu,Managers_dum15,Director_dum15,Officer_dum15]; 
elseif INSIDER_switch == 2 && strcmp(DataInputs{5},'dum15') == 1 && DIROFF_Switch == 3;
    XCMATu = [XCMATu,Managers_dum15,Director_dum15,Officer_dum15]; 
end

%% Now State-level data.
% Initialize variables.
dataArray = Dta.SL;

% Allocate imported array to column variable names
time_id = dataArray{:, 1};
state_option = dataArray{:, 2};
ATS = dataArray{:, 3};
DIR = dataArray{:, 4};
OFF = dataArray{:, 5};
DIROFF = DIR+OFF;

ExtremeS = dataArray{:, 6};
Dead1 = dataArray{:, 7};
PillStat = dataArray{:, 8};

%%%%%

clearvars filename delimiter startRow formatSpec fileID dataArray ans;

if strcmp(DataInputs{1},'ATS') == 1 
atsvar = ATS;
elseif strcmp(DataInputs{1},'PillStat') == 1
atsvar = PillStat;
end

if strcmp(DataInputs{2},'DIR') == 1 
XPMAT = [state_option time_id atsvar DIR OFF]; %
elseif strcmp(DataInputs{2},'DIROFF') == 1
XPMAT = [state_option time_id atsvar DIROFF]; 
elseif strcmp(DataInputs{2},'Dead') == 1
XPMAT = [state_option time_id atsvar Dead1 DIR OFF]; 
elseif strcmp(DataInputs{2},'ExtremeS') == 1
XPMAT = [state_option time_id atsvar ExtremeS DIR OFF]; 

end

if Switchdummies ==3
dum_med=at100_1000;
dum_big=(at0_100==0).*(dum_med==0);

end

end
