function d = deltaexp_mh(XC,XPd,HomeSt,Params)

global NALT Pvarn Cvarn Int Int3 NhomebInt HomebInt

% returns sum of exp of 51 Deltas for every NCS, and Cs # of
% choice instances
% XC Cs*51xPvarn matrix

if isempty(XC) == 1
d = 0;

else
    
betaP = Params(1:Pvarn)';
betaC = Params(Pvarn+1:Pvarn+Int3)';
betaHbi = Params(Pvarn+Int3+1:Pvarn+Int3+NhomebInt)';
FE = [0;Params(Pvarn+Int3+1+NhomebInt:Pvarn+Int3+NALT-1+NhomebInt)];
homeb = Params(Pvarn+Int3+NALT+NhomebInt);

% XC will be Cs x CVarn matrix
% XP will be Cs x PVarn matrix

Cs = size(XC,1);

% first take product characteristics
XProdr = repmat(XPd,Cs,1);
% order of indices: consumer, year, prod

% now generate interactions
XConr = reshape(XC,1,Cvarn*Cs);
XConr = repmat(XConr,NALT,1);
XConr = reshape(XConr,Cs*NALT,Cvarn);
% order of indices: consumer, year, prod

% create matrix made of columns reproducing p-level variables using in interaction
XProdM=[];
for i = 1:Cvarn
    XProdM =  [ XProdM XProdr(:,(Int(:,i)==1))]; % get columns according to columns of Int
end

% create matrix made of columns reproducing c-level variables using in interaction
XConM=[];
for i = 1:Cvarn
    XConM = [ XConM repmat(XConr(:,i),1,sum(Int(:,i)))]; % make copies of c-level vars according to sum by col of Int
end

XInt = XProdM.*XConM;

uti = XProdr * betaP' + XInt * betaC'; % generate utility index

homeBM = (homeb*ones(NALT,Cs) + repmat(betaHbi*XC(:,logical(HomebInt))',NALT,1)) .* (repmat(HomeSt',NALT,1) == kron((1:NALT)',ones(1,Cs)));
Deltas = reshape(uti,NALT,Cs)+ homeBM + repmat(FE,1,Cs); % Xuti is (NALT, NCS)
d = (exp(Deltas')*ones(NALT,1)); % sum of exp Deltas

end

clear Cs XProdr XConr XProdM XConM XInt uti Deltas

end

