function  d = deltastar_mh(XC,XP,Choices,HomeSt,Params) 

global NALT Pvarn Cvarn NhomebInt HomebInt Int Int3

betaP = Params(1:Pvarn)';
betaC = Params(Pvarn+1:Pvarn+Int3)';
betaHbi = Params(Pvarn+Int3+1:Pvarn+Int3+NhomebInt)';

FE = [0,Params(Pvarn+Int3+1+NhomebInt:Pvarn+Int3+NALT+NhomebInt-1)'];

homeb = Params(Pvarn+Int3+NALT+NhomebInt);

% XC will be Cs x CVarn matrix
% XP will be Cs x PVarn matrix

Cs = size(XC,1);

% first take product characteristics
% XProdr = repmat(XP,Cs,1);
% order of indices: consumer, year, prod

% now generate interactions
XConr = reshape(XC,1,Cvarn*Cs);
XConr = reshape(XConr,Cs,Cvarn);
% order of indices: consumer, year, prod

% create matrix made of columns reproducing p-level variables using in interaction
XProdM=[];
for i = 1:Cvarn
    XProdM =  [ XProdM XP(:,logical(Int(:,i)==1))]; % get columns according to columns of Int!
end

% create matrix made of columns reproducing c-level variables using in interaction
XConM=[];
for i = 1:Cvarn
    XConM = [ XConM repmat(XConr(:,i),1,sum(Int(:,i)))]; % make copies of c-level vars according to sum by col of Int
end

XInt = XProdM.*XConM;

uti = XP * betaP' + XInt * betaC' + FE(Choices)' + (HomeSt == Choices) .* (homeb*ones(Cs,1) + XC(:,logical(HomebInt))*betaHbi'); % generate utility index

d = uti;


clear Cs XConr XProdM XConM XInt uti 

end