function [fc, prod_fc_binary, prod_fc_full] = compute_fc(config_binary, binary_prod, ...
    config_full, full_prod, n_top_gap, nfc)

n_oem = length(config_binary);

fc = zeros(n_oem, 1);
prod_fc_binary = cell(n_oem, 1);
prod_fc_full = cell(n_oem, 1);

for no = 1 : n_oem
    n_prod_oem = 0; % # of products of an oem
    
    n_binary = length(config_binary{no});
    
    pfb_no = nan(n_binary, 1);
    for nb = 1 : n_binary
        if config_binary{no}(nb)==1
            n_prod_oem = n_prod_oem + 1;
            fc(no) = fc(no) + binary_prod{no}{nb}.fc(nfc);
            pfb_no(nb) = binary_prod{no}{nb}.fc(nfc);
        end
    end
    
    prod_fc_binary{no} = pfb_no;
    
    
    if ~isempty(full_prod{no})
        pff_no = nan(n_top_gap, 1);
        for ntg = 1 : n_top_gap
            if config_full{no}(ntg)>0
                n_prod_oem = n_prod_oem + 1;
                fc(no) = fc(no) + ...
                    full_prod{no}{config_full{no}(ntg), ntg}.fc(nfc);
                pff_no(ntg) = full_prod{no}{config_full{no}(ntg), ntg}.fc(nfc);
            end            
        end
        prod_fc_full{no} = pff_no;
    end
    
end